/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.rest;

import io.meeds.analytics.api.service.AnalyticsService;
import io.meeds.portal.thumbnail.model.FileContent;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.jcr.AccessDeniedException;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.constant.FileListingType;
import org.exoplatform.documents.model.BreadCrumbItem;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentGroupsSize;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DocumentTimelineFilter;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.model.PublicDocumentAccess;
import org.exoplatform.documents.model.TrashElementNode;
import org.exoplatform.documents.model.TrashElementNodeFilter;
import org.exoplatform.documents.rest.DocumentFileRest;
import org.exoplatform.documents.rest.model.AbstractNodeEntity;
import org.exoplatform.documents.rest.model.BreadCrumbItemEntity;
import org.exoplatform.documents.rest.model.DocumentsUserSettings;
import org.exoplatform.documents.rest.model.FileNodeEntity;
import org.exoplatform.documents.rest.model.FileVersionsEntity;
import org.exoplatform.documents.rest.model.FolderNodeEntity;
import org.exoplatform.documents.rest.model.IdentityEntity;
import org.exoplatform.documents.rest.model.NodeAuditTrailItemEntity;
import org.exoplatform.documents.rest.model.NodeAuditTrailsEntity;
import org.exoplatform.documents.rest.model.NodePermissionEntity;
import org.exoplatform.documents.rest.model.PermissionEntryEntity;
import org.exoplatform.documents.rest.model.PublicDocumentAccessOptionsEntity;
import org.exoplatform.documents.rest.model.TrashElementEntity;
import org.exoplatform.documents.rest.model.Visibility;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.documents.rest.util.RestUtils;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.documents.service.DocumentFileServiceImpl;
import org.exoplatform.documents.service.ExternalDownloadService;
import org.exoplatform.documents.service.PublicDocumentAccessService;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.JCRDeleteFileStorage;
import org.exoplatform.portal.rest.CollectionEntity;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Authenticator;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.thumbnail.ImageThumbnailService;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.MetadataService;
import org.exoplatform.social.metadata.model.Metadata;
import org.exoplatform.social.metadata.model.MetadataItem;
import org.exoplatform.social.metadata.model.MetadataObject;
import org.exoplatform.social.metadata.model.MetadataType;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DocumentFileRestTest {
    private static MockedStatic<RestUtils> REST_UTILS = Mockito.mockStatic(RestUtils.class);
    private static MockedStatic<EntityBuilder> ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
    private DocumentFileStorage documentFileStorage;
    private IdentityManager identityManager;
    private SpaceService spaceService;
    private IdentityRegistry identityRegistry;
    private MetadataService metadataService;
    private Authenticator authenticator;
    private DocumentFileServiceImpl documentFileService;
    private DocumentFileRest documentFileRest;
    private JCRDeleteFileStorage jcrDeleteFileStorage;
    private ListenerService listenerService;
    private SettingService settingService;
    private PublicDocumentAccessService publicDocumentAccessService;
    private ExternalDownloadService externalDownloadService;
    private ImageThumbnailService imageThumbnailService;
    private AnalyticsService analyticsService;

    @Before
    public void setUp() {
        this.spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.identityRegistry = (IdentityRegistry)Mockito.mock(IdentityRegistry.class);
        this.metadataService = (MetadataService)Mockito.mock(MetadataService.class);
        this.authenticator = (Authenticator)Mockito.mock(Authenticator.class);
        this.documentFileStorage = (DocumentFileStorage)Mockito.mock(DocumentFileStorage.class);
        this.jcrDeleteFileStorage = (JCRDeleteFileStorage)Mockito.mock(JCRDeleteFileStorage.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        this.settingService = (SettingService)Mockito.mock(SettingService.class);
        this.publicDocumentAccessService = (PublicDocumentAccessService)Mockito.mock(PublicDocumentAccessService.class);
        this.externalDownloadService = (ExternalDownloadService)Mockito.mock(ExternalDownloadService.class);
        this.imageThumbnailService = (ImageThumbnailService)Mockito.mock(ImageThumbnailService.class);
        this.documentFileService = new DocumentFileServiceImpl(this.documentFileStorage, this.jcrDeleteFileStorage, this.authenticator, this.spaceService, this.identityManager, this.identityRegistry, this.listenerService, this.analyticsService, this.imageThumbnailService);
        this.documentFileRest = new DocumentFileRest((DocumentFileService)this.documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
    }

    @After
    public void teardown() throws Exception {
        if (REST_UTILS != null) {
            REST_UTILS.close();
            REST_UTILS = null;
        }
        if (ENTITY_BUILDER != null) {
            ENTITY_BUILDER.close();
            ENTITY_BUILDER = null;
        }
    }

    @Test
    public void testGetDocumentItems() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        DocumentTimelineFilter filter = null;
        filter = new DocumentTimelineFilter(Long.valueOf(currentIdentity.getId()), null);
        filter.setFavorites(Boolean.valueOf(false));
        filter.setFileTypes("");
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)username))).thenReturn((Object)currentIdentity);
        String spacePrettyName = "spacetest";
        currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        space.setPrettyName(spacePrettyName);
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        FileVersionsEntity fileVersionsEntity = new FileVersionsEntity();
        fileVersionsEntity.setSize(50L);
        fileVersionsEntity.setLimit(0L);
        fileVersionsEntity.setOffset(0L);
        FileNodeEntity fileEntities = new FileNodeEntity();
        fileEntities.setVersions(fileVersionsEntity);
        fileEntities.hashCode();
        ArrayList<FileNodeEntity> nodesEntities = new ArrayList<FileNodeEntity>();
        nodesEntities.add(fileEntities);
        ArrayList<FileNode> files = new ArrayList<FileNode>();
        FileNode file1 = new FileNode();
        file1.setLinkedFileId("1");
        file1.setVersionnedFileId("1");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNode file2 = new FileNode();
        FileNode file3 = new FileNode();
        FileNode file4 = new FileNode();
        files.add(file1);
        files.add(file2);
        files.add(file3);
        files.add(file4);
        Mockito.when((Object)this.documentFileStorage.getFilesTimeline(filter, spaceID, 0, 0)).thenReturn(files);
        Response response1 = this.documentFileRest.getDocumentItems(null, null, null, null, FileListingType.TIMELINE, null, false, null, false, "", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.documentFileRest.getDocumentItems(Long.valueOf(currentOwnerId), null, null, null, null, null, false, null, false, "", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.documentFileRest.getDocumentItems(Long.valueOf(currentOwnerId), null, null, null, FileListingType.TIMELINE, null, false, null, false, "", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response3.getStatus());
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        List files_ = this.documentFileService.getDocumentItems(FileListingType.TIMELINE, (DocumentNodeFilter)filter, 0, 0, Long.valueOf(currentIdentity.getId()).longValue(), false);
        FileNodeEntity nodeEntity = new FileNodeEntity();
        nodeEntity.setLinkedFileId("1");
        nodeEntity.setVersionnedFileId("1");
        nodeEntity.setMimeType(":file");
        nodeEntity.setSize(50L);
        Assert.assertEquals((long)files_.size(), (long)4L);
        ArrayList<MetadataItem> metadataItems = new ArrayList<MetadataItem>();
        MetadataType metadataType = new MetadataType();
        metadataType.setId(1L);
        metadataType.setName("favorites");
        MetadataObject metadataObject = new MetadataObject();
        metadataObject.setId("7694af9cc0a80104095f8da1bf22a7fb");
        metadataObject.setType("file");
        Metadata metadata = new Metadata();
        metadata.setId(1L);
        metadata.setType(metadataType);
        metadata.setName("1");
        metadata.setAudienceId(2L);
        metadata.setCreatorId(2L);
        MetadataItem metadataItem = new MetadataItem();
        metadataItem.setMetadata(metadata);
        metadataItem.setObjectId(metadataObject.getId());
        metadataItem.setCreatorId(2L);
        metadataItems.add(metadataItem);
        Mockito.when((Object)this.metadataService.getMetadataItemsByObject((MetadataObject)Mockito.any())).thenReturn(metadataItems);
        Response response4 = this.documentFileRest.getDocumentItems(Long.valueOf(currentOwnerId), null, null, null, FileListingType.TIMELINE, null, false, null, false, "metadatas", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response4.getStatus());
        List filesNodeEntity = new ArrayList();
        filesNodeEntity = (List)response4.getEntity();
        Assert.assertNotNull(filesNodeEntity);
        Assert.assertNotNull((Object)((FileNodeEntity)filesNodeEntity.get(0)).hashCode());
        Assert.assertNotNull((Object)((FileNodeEntity)filesNodeEntity.get(0)).toString());
        Assert.assertEquals((Object)((FileNodeEntity)filesNodeEntity.get(0)).getMimeType(), (Object)":file");
        Assert.assertEquals((Object)((FileNodeEntity)filesNodeEntity.get(0)).getVersionnedFileId(), (Object)"1");
        Assert.assertEquals((long)((FileNodeEntity)filesNodeEntity.get(0)).getSize(), (long)50L);
        Assert.assertTrue((boolean)((FileNodeEntity)filesNodeEntity.get(0)).isFavorite());
        FileNodeEntity fileNodeEntity = (FileNodeEntity)filesNodeEntity.get(0);
        fileNodeEntity.setMetadatas(null);
        fileNodeEntity.setFavorite(false);
        Assert.assertTrue((boolean)nodeEntity.equals((Object)fileNodeEntity));
    }

    @Test
    public void testGETDocumentGroupsCount() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        DocumentTimelineFilter filter = null;
        filter = new DocumentTimelineFilter(Long.valueOf(currentIdentity.getId()), null);
        filter.setFavorites(Boolean.valueOf(false));
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity((String)Mockito.eq((Object)"organization"), (String)Mockito.eq((Object)username))).thenReturn((Object)currentIdentity);
        String spacePrettyName = "spacetest";
        currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        space.setPrettyName(spacePrettyName);
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName((String)Mockito.eq((Object)spacePrettyName))).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        DocumentGroupsSize documentGroupsSize = new DocumentGroupsSize();
        documentGroupsSize.setThisDay(4L);
        Mockito.when((Object)this.documentFileService.getGroupDocumentsCount(filter, currentOwnerId)).thenReturn((Object)documentGroupsSize);
        Response response1 = this.documentFileRest.getDocumentGroupsCount(null, "", null, false);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        Response response4 = this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response4.getStatus());
        Assert.assertEquals((long)((DocumentGroupsSize)response4.getEntity()).getThisDay(), (long)4L);
        Mockito.when((Object)this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false)).thenThrow(ObjectNotFoundException.class);
        Response response = this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false)).thenThrow(RuntimeException.class);
        response = this.documentFileRest.getDocumentGroupsCount(Long.valueOf(currentOwnerId), "", null, false);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetDocumentFolder() throws Exception {
        String username = "usera";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)currentOwnerId);
        String userbname = "userb";
        long userId = 3L;
        org.exoplatform.social.core.identity.model.Identity userIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        userIdentity.setId(String.valueOf(userId));
        Profile userProfile = new Profile();
        userProfile.setProperty("fullName", (Object)userbname);
        userIdentity.setProfile(userProfile);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(userbname)).thenReturn((Object)userIdentity);
        String spacePrettyName = "spacetest";
        String groupId = "/spaces/spacetest";
        currentIdentity.setRemoteId(spacePrettyName);
        Space space = new Space();
        space.setPrettyName(spacePrettyName);
        Identity spaceID = new Identity(spacePrettyName);
        Mockito.when((Object)this.identityRegistry.getIdentity(spacePrettyName)).thenReturn((Object)spaceID);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName(spacePrettyName)).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(groupId)).thenReturn((Object)space);
        Mockito.when((Object)this.spaceService.hasAccessPermission(space, username)).thenReturn((Object)true);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getIdentity(userId)).thenReturn((Object)userIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(spacePrettyName)).thenReturn((Object)currentIdentity);
        DocumentFolderFilter filter = null;
        filter = new DocumentFolderFilter(null, null, Long.valueOf(currentOwnerId), null);
        filter.setFavorites(Boolean.valueOf(false));
        filter.setSortField(DocumentSortField.NAME);
        filter.setFileTypes("");
        IdentityEntity identity1 = new IdentityEntity();
        IdentityEntity identity2 = new IdentityEntity("3", "userb", "userb", null, "organization", "spacetest");
        identity1.setId("2");
        identity1.setName("usera");
        identity1.setFullname("usera");
        identity1.setAvatar(null);
        identity1.setProviderId("organization");
        identity1.setRemoteId("spacetest");
        NodeAuditTrailItemEntity nodeAuditTrailItemEntity = new NodeAuditTrailItemEntity();
        nodeAuditTrailItemEntity.setId(11L);
        nodeAuditTrailItemEntity.setActionType("actionType");
        nodeAuditTrailItemEntity.setUserIdentity(identity1);
        nodeAuditTrailItemEntity.setTargetIdentity(identity2);
        nodeAuditTrailItemEntity.setDate(1111L);
        nodeAuditTrailItemEntity.hashCode();
        ArrayList<NodeAuditTrailItemEntity> trails = new ArrayList<NodeAuditTrailItemEntity>();
        trails.add(nodeAuditTrailItemEntity);
        NodeAuditTrailsEntity nodeAuditTrailsEntity = new NodeAuditTrailsEntity();
        nodeAuditTrailsEntity.setSize(50L);
        nodeAuditTrailsEntity.setLimit(0L);
        nodeAuditTrailsEntity.setOffset(0L);
        nodeAuditTrailsEntity.setSize(50L);
        nodeAuditTrailsEntity.setTrails(trails);
        nodeAuditTrailsEntity.hashCode();
        AbstractNodeEntity documentEntities = new AbstractNodeEntity(true);
        documentEntities.setId("2");
        documentEntities.setName("document");
        documentEntities.setDescription("description");
        documentEntities.setDatasource("datasource");
        documentEntities.setParentFolderId("1");
        documentEntities.setCreatorIdentity(identity1);
        documentEntities.setModifierIdentity(identity2);
        documentEntities.setCreatedDate(1111L);
        documentEntities.setModifiedDate(2222L);
        documentEntities.setFolder(true);
        documentEntities.setAuditTrails(nodeAuditTrailsEntity);
        ArrayList<AbstractNodeEntity> nodesEntities = new ArrayList<AbstractNodeEntity>();
        nodesEntities.add(documentEntities);
        ArrayList<FolderNode> folder = new ArrayList<FolderNode>();
        FolderNode folder1 = new FolderNode();
        FolderNode folder2 = new FolderNode();
        folder1.setId("2");
        folder1.setName("folder1");
        folder1.setCreatorId(currentOwnerId);
        folder1.setDatasource("datasource");
        folder1.setDescription("description");
        folder1.setCreatedDate(11111L);
        folder1.setParentFolderId("1");
        folder1.setPath("/Groups/spaces/spacetest");
        PermissionEntry permissionEntry1 = new PermissionEntry(currentIdentity, "add_node", PermissionRole.ALL.name());
        PermissionEntry permissionEntry2 = new PermissionEntry(currentIdentity, "set_property", PermissionRole.ALL.name());
        PermissionEntry permissionEntry3 = new PermissionEntry(currentIdentity, "read", PermissionRole.ALL.name());
        PermissionEntry permissionEntry4 = new PermissionEntry(currentIdentity, "remove", PermissionRole.ALL.name());
        PermissionEntry permissionEntry5 = new PermissionEntry(userIdentity, "add_node", PermissionRole.ALL.name());
        PermissionEntry permissionEntry6 = new PermissionEntry(userIdentity, "set_property", PermissionRole.ALL.name());
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        permissionEntries.add(permissionEntry1);
        permissionEntries.add(permissionEntry2);
        permissionEntries.add(permissionEntry3);
        permissionEntries.add(permissionEntry4);
        permissionEntries.add(permissionEntry5);
        permissionEntries.add(permissionEntry6);
        NodePermission nodePermission = new NodePermission(true, true, true, false, permissionEntries, null, null, null);
        folder1.setAcl(nodePermission);
        FolderNodeEntity folderEntity = new FolderNodeEntity();
        folderEntity.setId("2");
        folderEntity.setName("folder1");
        folderEntity.setCreatorIdentity(identity1);
        folderEntity.setDatasource("datasource");
        folderEntity.setDescription("description");
        folderEntity.setCreatedDate(11111L);
        folderEntity.setParentFolderId("1");
        ArrayList<PermissionEntryEntity> collaborators = new ArrayList<PermissionEntryEntity>();
        PermissionEntryEntity permissionEntryEntity = new PermissionEntryEntity();
        PermissionEntryEntity permissionEntryEntity1 = new PermissionEntryEntity(EntityBuilder.toIdentityEntity((IdentityManager)this.identityManager, (SpaceService)this.spaceService, (long)Long.valueOf(userIdentity.getId())), "set_property");
        permissionEntryEntity.setPermission("add_node");
        permissionEntryEntity.setIdentity(EntityBuilder.toIdentityEntity((IdentityManager)this.identityManager, (SpaceService)this.spaceService, (long)Long.valueOf(userIdentity.getId())));
        collaborators.add(permissionEntryEntity1);
        collaborators.add(permissionEntryEntity);
        NodePermissionEntity nodePermissionEntity = new NodePermissionEntity();
        nodePermissionEntity.setCanAccess(true);
        nodePermissionEntity.setCanDelete(true);
        nodePermissionEntity.setCanEdit(true);
        nodePermissionEntity.setAllMembersCanEdit(true);
        nodePermissionEntity.setVisibilityChoice(Visibility.ALL_MEMBERS.name());
        nodePermissionEntity.setCollaborators(collaborators);
        folderEntity.setAcl(nodePermissionEntity);
        String expand = "creator";
        folder.add(folder1);
        folder.add(folder2);
        Mockito.when((Object)this.documentFileStorage.getFolderChildNodes(filter, spaceID, 0, 0)).thenReturn(folder);
        Response response1 = this.documentFileRest.getDocumentItems(null, null, null, null, FileListingType.FOLDER, null, false, null, false, "", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.documentFileRest.getDocumentItems(Long.valueOf(currentOwnerId), "2", null, null, FileListingType.FOLDER, null, false, null, false, "", null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.documentFileRest.getDocumentItems(Long.valueOf(currentOwnerId), null, null, null, FileListingType.FOLDER, null, false, null, false, expand, null, false, 0, 0, false, "", null, null, null, null, null, null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        List foldersNodeEntity = new ArrayList();
        foldersNodeEntity = (List)response3.getEntity();
        Assert.assertNotNull(foldersNodeEntity);
        Assert.assertNotNull((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).hashCode());
        Assert.assertNotNull((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).toString());
        Assert.assertEquals((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).getName(), (Object)"folder1");
        Assert.assertEquals((Object)identity1, (Object)((FolderNodeEntity)foldersNodeEntity.get(0)).getCreatorIdentity());
        Assert.assertEquals((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).getDatasource(), (Object)"datasource");
        Assert.assertEquals((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).getDescription(), (Object)"description");
        Assert.assertEquals((long)((FolderNodeEntity)foldersNodeEntity.get(0)).getCreatedDate(), (long)11111L);
        Assert.assertEquals((Object)((FolderNodeEntity)foldersNodeEntity.get(0)).getParentFolderId(), (Object)"1");
        NodePermissionEntity nodePermissionEntity1 = ((FolderNodeEntity)foldersNodeEntity.get(0)).getAcl();
        Assert.assertEquals((Object)nodePermissionEntity1.getVisibilityChoice(), (Object)Visibility.SPECIFIC_COLLABORATOR.name());
        Assert.assertEquals((Object)nodePermissionEntity1.isAllMembersCanEdit(), (Object)false);
        Assert.assertEquals((Object)nodePermissionEntity1.isCanAccess(), (Object)true);
        Assert.assertEquals((Object)nodePermissionEntity1.isCanDelete(), (Object)true);
        Assert.assertEquals((Object)nodePermissionEntity1.isCanDelete(), (Object)true);
        Assert.assertEquals((long)nodePermissionEntity1.getCollaborators().size(), (long)1L);
        Assert.assertEquals((Object)((PermissionEntryEntity)nodePermissionEntity1.getCollaborators().get(0)).getPermission(), (Object)"edit");
        Assert.assertEquals((Object)((PermissionEntryEntity)nodePermissionEntity1.getCollaborators().get(0)).getIdentity().getId(), (Object)String.valueOf(userId));
    }

    @Test
    public void testGetBreadCrumbs() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        BreadCrumbItem breadCrumbItem1 = new BreadCrumbItem("1", "Folder1", "Folder1", "", false, new HashMap());
        BreadCrumbItem breadCrumbItem2 = new BreadCrumbItem("2", "Folder2", "Folder1", "", false, new HashMap());
        BreadCrumbItem breadCrumbItem3 = new BreadCrumbItem();
        breadCrumbItem3.setId("3");
        breadCrumbItem3.setName("Folder3");
        BreadCrumbItem breadCrumbItem4 = new BreadCrumbItem();
        breadCrumbItem4.setId("4");
        breadCrumbItem4.setName("Folder4");
        ArrayList<BreadCrumbItem> breadCrumbItems = new ArrayList<BreadCrumbItem>();
        breadCrumbItems.add(breadCrumbItem1);
        breadCrumbItems.add(breadCrumbItem2);
        breadCrumbItems.add(breadCrumbItem3);
        breadCrumbItems.add(breadCrumbItem4);
        List breadCrumbItemEntities = new ArrayList();
        Mockito.when((Object)this.documentFileStorage.getBreadcrumb(2L, "Folder1", "", userID)).thenReturn(breadCrumbItems);
        Response response1 = this.documentFileRest.getBreadcrumb(null, null, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.documentFileRest.getBreadcrumb(Long.valueOf(2L), "Folder1", "");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        Response response3 = this.documentFileRest.getBreadcrumb(Long.valueOf(2L), "Folder1", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        breadCrumbItemEntities = (List)response3.getEntity();
        Assert.assertEquals((long)breadCrumbItemEntities.size(), (long)4L);
        Assert.assertEquals((Object)((BreadCrumbItemEntity)breadCrumbItemEntities.get(0)).getId(), (Object)"4");
        Assert.assertEquals((Object)((BreadCrumbItemEntity)breadCrumbItemEntities.get(0)).getName(), (Object)"Folder4");
        Mockito.when((Object)this.documentFileRest.getBreadcrumb(Long.valueOf(1L), "123", "")).thenThrow(ObjectNotFoundException.class);
        Response response = this.documentFileRest.getBreadcrumb(Long.valueOf(1L), "123", "");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.getBreadcrumb(Long.valueOf(1L), "123", "")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.getBreadcrumb(Long.valueOf(1L), "123", "");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDuplicateDocument() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        FileNode file1 = new FileNode();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNode file2 = new FileNode();
        file2.setId("2");
        file2.setName("Copy of oldFile");
        file2.setDatasource("datasource");
        file2.setMimeType(":file");
        file2.setSize(50L);
        Mockito.when((Object)this.documentFileStorage.duplicateDocument(2L, "oldFile", "copy of", userID)).thenReturn((Object)file2);
        Response response1 = this.documentFileRest.duplicateDocument(null, null, "", "copy of", "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        Response response2 = this.documentFileRest.duplicateDocument(Long.valueOf(2L), "oldFile", "", "copy of", "");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response2.getStatus());
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        Response response3 = this.documentFileRest.duplicateDocument(Long.valueOf(2L), "oldFile", "", "copy of", "");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response3.getStatus());
        AbstractNodeEntity fileNode = (AbstractNodeEntity)response3.getEntity();
        Assert.assertEquals((Object)fileNode.getName(), (Object)"Copy of oldFile");
        Assert.assertEquals((Object)fileNode.getId(), (Object)"2");
        Mockito.when((Object)this.documentFileRest.duplicateDocument(Long.valueOf(1L), "oldFile", "", "copy of", "")).thenThrow(ObjectNotFoundException.class);
        Response response = this.documentFileRest.duplicateDocument(Long.valueOf(1L), "oldFile", "", "copy of", "");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.duplicateDocument(Long.valueOf(1L), "oldFile", "", "copy of", "")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.duplicateDocument(Long.valueOf(1L), "oldFile", "", "copy of", "");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testCreateFolder() throws Exception {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)currentOwnerId);
        ArrayList<FullTreeItem> children = new ArrayList<FullTreeItem>();
        FullTreeItem fullTreeItem = new FullTreeItem("11111222", "test", "path", null, false);
        children.add(fullTreeItem);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        Response response = this.documentFileRest.createFolder(null, null, null, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"either_ownerId_or_parentid_is_mandatory", (Object)response.getEntity());
        response = this.documentFileRest.createFolder("11111111", null, null, "");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"Folder Name should not be empty", (Object)response.getEntity());
        FolderNode folder = new FolderNode();
        Mockito.when((Object)this.documentFileStorage.createFolder(2L, "11111111", null, "222", userID)).thenReturn((Object)folder);
        response = this.documentFileRest.createFolder("11111111", null, Long.valueOf(2L), "222");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileStorage.createFolder(2L, "11111111", null, "test", userID)).thenReturn((Object)folder);
        response = this.documentFileRest.createFolder("11111111", null, Long.valueOf(2L), "test");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileStorage.createFolder(2L, "11111111", null, "222", userID)).thenThrow(IllegalAccessException.class);
        response = this.documentFileRest.createFolder("11111111", null, Long.valueOf(2L), "222");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.createFolder("11111111", null, Long.valueOf(2L), "test")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.createFolder("11111111", null, Long.valueOf(2L), "test");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        response = this.documentFileRest.updateDocument("name", null, null, "", "", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"either_ownerId_or_documentID_is_mandatory", (Object)response.getEntity());
        response = this.documentFileRest.updateDocument("name", "11111111", Long.valueOf(2L), "", "", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"Document Name should not be empty", (Object)response.getEntity());
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).renameDocument(2L, "11111111", "renameTest", userID);
        Response response1 = this.documentFileRest.updateDocument("name", "11111111", Long.valueOf(2L), "renameTest", "", null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response1.getStatus());
        Mockito.when((Object)this.documentFileStorage.getFullTreeData(2L, "11111111", "", userID, true, true)).thenReturn(children);
        Response response2 = this.documentFileRest.getFullTreeData(Long.valueOf(2L), "11111111", "", true, true);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response2.getStatus());
        Response response3 = this.documentFileRest.moveDocument(null, null, "/Groups/spaces/test/Documents/test", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response3.getStatus());
        Assert.assertEquals((Object)"either_ownerId_or_documentID_is_mandatory", (Object)response3.getEntity());
        Response response5 = this.documentFileRest.moveDocument("11111111", Long.valueOf(2L), null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response5.getStatus());
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).moveDocument(2L, "11111111", "/Groups/spaces/test/Documents/test", userID, "keepBoth");
        Response response6 = this.documentFileRest.moveDocument("11111111", Long.valueOf(2L), "/Groups/spaces/test/Documents/test", "keepBoth");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response6.getStatus());
        Mockito.when((Object)this.documentFileRest.moveDocument("11111111", Long.valueOf(2L), "/Groups/spaces/test/Documents/test", null)).thenThrow(RuntimeException.class);
        response = this.documentFileRest.moveDocument("11111111", Long.valueOf(2L), "/Groups/spaces/test/Documents/test", null);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDeleteDocument() {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        FileNode file1 = new FileNode();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        Response response = this.documentFileRest.deleteDocument(null, "/document/oldFile", false, 6L);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"document_id_is_mandatory", (Object)response.getEntity());
        ((JCRDeleteFileStorage)Mockito.doNothing().when((Object)this.jcrDeleteFileStorage)).deleteDocument("1", "/document/oldFile", false, true, 6L, root, currentOwnerId);
        response = this.documentFileRest.deleteDocument("1", "/document/oldFile", false, 6L);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDeleteDocuments() throws IllegalAccessException {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)currentOwnerId);
        FileNodeEntity file1 = new FileNodeEntity();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNodeEntity file2 = new FileNodeEntity();
        file2.setId("2");
        file2.setName("oldFile2");
        file2.setPath("/document/oldFile2");
        file2.setDatasource("datasource");
        file2.setMimeType(":file");
        file2.setSize(50L);
        FileNodeEntity file3 = new FileNodeEntity();
        file3.setId("3");
        file3.setName("oldFile3");
        file3.setPath("/document/oldFile3");
        file3.setDatasource("datasource");
        file3.setMimeType(":file");
        file3.setSize(50L);
        ArrayList<FileNodeEntity> nodeEntities = new ArrayList<FileNodeEntity>();
        Response response = this.documentFileRest.bulkDeleteDocuments(123456, nodeEntities);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"documents list is mandatory", (Object)response.getEntity());
        nodeEntities.add(file1);
        nodeEntities.add(file2);
        nodeEntities.add(file3);
        List nodes = EntityBuilder.toAbstractNodes(nodeEntities);
        ((JCRDeleteFileStorage)Mockito.doNothing().when((Object)this.jcrDeleteFileStorage)).deleteDocuments(123456, nodes, userID, currentOwnerId);
        response = this.documentFileRest.bulkDeleteDocuments(123456, nodeEntities);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testDownloadDocuments() {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)currentOwnerId);
        FileNodeEntity file1 = new FileNodeEntity();
        file1.setId("1");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        FileNodeEntity file2 = new FileNodeEntity();
        file2.setId("2");
        file2.setName("oldFile2");
        file2.setPath("/document/oldFile2");
        file2.setDatasource("datasource");
        file2.setMimeType(":file");
        file2.setSize(50L);
        FileNodeEntity file3 = new FileNodeEntity();
        file3.setId("3");
        file3.setName("oldFile3");
        file3.setPath("/document/oldFile3");
        file3.setDatasource("datasource");
        file3.setMimeType(":file");
        file3.setSize(50L);
        ArrayList<FileNodeEntity> nodeEntities = new ArrayList<FileNodeEntity>();
        Response response = this.documentFileRest.downloadDocuments(123456, nodeEntities);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"documents list is mandatory", (Object)response.getEntity());
        nodeEntities.add(file1);
        nodeEntities.add(file2);
        nodeEntities.add(file3);
        List nodes = EntityBuilder.toAbstractNodes(nodeEntities);
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).downloadDocuments(123456, nodes, userID, currentOwnerId);
        response = this.documentFileRest.downloadDocuments(123456, nodeEntities);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetDownloadZip() throws IOException {
        String username = "testuser";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentity((IdentityManager)this.identityManager)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.documentFileStorage.getDownloadZipBytes(123456, username)).thenReturn((Object)new byte[0]);
        Response response = this.documentFileRest.getDownloadZip(123456);
        Assert.assertEquals((long)Response.Status.GONE.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileStorage.getDownloadZipBytes(123456, username)).thenReturn((Object)new byte[10]);
        response = this.documentFileRest.getDownloadZip(123456);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testUndoDeleteDocument() {
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        FileNode file1 = new FileNode();
        file1.setId("2");
        file1.setName("oldFile");
        file1.setPath("/document/oldFile");
        file1.setDatasource("datasource");
        file1.setMimeType(":file");
        file1.setSize(50L);
        Response response = this.documentFileRest.undoDeleteDocument(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"document_id_is_mandatory", (Object)response.getEntity());
        ((JCRDeleteFileStorage)Mockito.doNothing().when((Object)this.jcrDeleteFileStorage)).undoDelete("2", currentOwnerId);
        response = this.documentFileRest.undoDeleteDocument("2");
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testUpdatePermissions() throws Exception {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        FileNodeEntity nodeEntity = new FileNodeEntity();
        NodePermission nodePermission = (NodePermission)Mockito.mock(NodePermission.class);
        NodePermissionEntity nodePermissionEntity = new NodePermissionEntity();
        Response response = documentFileRest1.updatePermissions(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Response response1 = documentFileRest1.updatePermissions(nodeEntity);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response1.getStatus());
        nodeEntity.setAcl(nodePermissionEntity);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        nodeEntity.setId("123");
        this.mockEntityBuilder().when(() -> EntityBuilder.toNodePermission((AbstractNodeEntity)nodeEntity, (DocumentFileService)documentFileService, (SpaceService)this.spaceService, (IdentityManager)this.identityManager)).thenReturn((Object)nodePermission);
        nodeEntity.getAcl().setVisibilityChoice(Visibility.COLLABORATORS_AND_PUBLIC_ACCESS.name());
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService)).updatePermissions("123", nodePermission, 1L);
        ((PublicDocumentAccessService)Mockito.doNothing().when((Object)this.publicDocumentAccessService)).revokeDocumentPublicAccess("123");
        Response response2 = documentFileRest1.updatePermissions(nodeEntity);
        Assert.assertEquals((long)Response.Status.NO_CONTENT.getStatusCode(), (long)response2.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException()}).when((Object)documentFileService)).updatePermissions("123", nodePermission, 1L);
        Response response3 = documentFileRest1.updatePermissions(nodeEntity);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response3.getStatus());
        Mockito.when((Object)this.settingService.get(Context.GLOBAL.id("sharedDocumentStatus"), Scope.APPLICATION.id("sharedDocumentStatus"), "exo:sharedDocumentStatus")).thenReturn((Object)SettingValue.create((String)"true"));
        Response response4 = documentFileRest1.updatePermissions(nodeEntity);
        Assert.assertEquals((long)Response.Status.FORBIDDEN.getStatusCode(), (long)response4.getStatus());
    }

    @Test
    public void testCreateShortcut() throws Exception {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.createShortcut(null, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"Document's id should not be empty", (Object)response.getEntity());
        response = documentFileRest1.createShortcut("11111111", null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"Document destination path should not be empty", (Object)response.getEntity());
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).createShortcut("11111111", "/Groups/spaces/test/Documents/test", "user", null);
        response = this.documentFileRest.createShortcut("11111111", "/Groups/spaces/test/Documents/test", null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.createShortcut("11111111", "/Groups/spaces/test/Documents/test", null)).thenThrow(RuntimeException.class);
        response = this.documentFileRest.createShortcut("11111111", "/Groups/spaces/test/Documents/test", null);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getFileVersions() {
        FileVersion fileVersion = new FileVersion();
        fileVersion.setCurrent(true);
        fileVersion.setTitle("test.docx");
        fileVersion.setVersionNumber(1);
        fileVersion.setId("4ezadazd465az4d");
        fileVersion.setCreatedDate(new Date());
        fileVersion.setAuthorFullName("user user");
        fileVersion.setAuthor("user");
        ArrayList<FileVersion> versions = new ArrayList<FileVersion>();
        versions.add(fileVersion);
        Response response = this.documentFileRest.getFileVersions(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        response = this.documentFileRest.getFileVersions("3654654651");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)this.documentFileService.getFileVersions("655645ezfefzef6z54", "user")).thenReturn(versions);
        response = this.documentFileRest.getFileVersions("qsdqs54dq65sd");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.getFileVersions("qsdqs54dq65sd")).thenThrow(IllegalArgumentException.class);
        response = this.documentFileRest.getFileVersions("qsdqs54dq65sd");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileRest.getFileVersions("qsdqs54dq65sd")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.getFileVersions("qsdqs54dq65sd");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getNewName() throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalAccessException {
        Response response = this.documentFileRest.getNewName(null, "patg", Long.valueOf(1L), null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = this.documentFileRest.getNewName("123", "patg", Long.valueOf(1L), null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = this.documentFileRest.getNewName("123", "patg", Long.valueOf(1L), "125");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileService.getNewName(1L, "123", "path", "test")).thenReturn((Object)"new");
        response = this.documentFileRest.getNewName("123", "path", Long.valueOf(1L), "test");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.documentFileService.getNewName(1L, "123", "path", "test")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.getNewName("123", "path", Long.valueOf(1L), "test");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void updateDocumentDescription() throws IllegalAccessException, RepositoryException {
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService1)).updateDocumentDescription(1L, "123", "hello", 1L);
        Response response = documentFileRest1.updateDocument("description", "123", Long.valueOf(1L), "", "hello", null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new AccessDeniedException()}).when((Object)documentFileService1)).updateDocumentDescription(1L, "123", "hello", 1L);
        response = documentFileRest1.updateDocument("description", "123", Long.valueOf(1L), "", "hello", null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)documentFileService1)).updateDocumentDescription(1L, "123", "hello", 1L);
        response = documentFileRest1.updateDocument("description", "123", Long.valueOf(1L), "", "hello", null);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testUpdateDocumentVisibility() throws ObjectAlreadyExistsException {
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        String username = "testuser";
        Identity root = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        long currentOwnerId = 1L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)currentOwnerId);
        Identity userID = new Identity(username);
        Mockito.when((Object)this.identityRegistry.getIdentity(username)).thenReturn((Object)userID);
        Mockito.when((Object)this.identityManager.getIdentity(currentOwnerId)).thenReturn((Object)currentIdentity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(username)).thenReturn((Object)currentIdentity);
        Response response = this.documentFileRest.updateDocument("visibility", null, null, "", "", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"either_ownerId_or_documentID_is_mandatory", (Object)response.getEntity());
        response = this.documentFileRest.updateDocument("visibility", "11111111", Long.valueOf(1L), "", "", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Assert.assertEquals((Object)"Document hidden value should not be empty", (Object)response.getEntity());
        ((DocumentFileStorage)Mockito.doNothing().when((Object)this.documentFileStorage)).setDocumentVisibility(2L, "11111111", Boolean.valueOf(true), userID);
        response = this.documentFileRest.updateDocument("visibility", "11111111", Long.valueOf(1L), "", "", Boolean.valueOf(true));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getFullTreeData() {
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.getFullTreeData(null, null, "", true, true);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true)).thenThrow(IllegalAccessException.class);
        response = documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true)).thenThrow(ObjectNotFoundException.class);
        response = documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true)).thenThrow(RuntimeException.class);
        response = documentFileRest1.getFullTreeData(Long.valueOf(1L), "123", "", true, true);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void updateVersionSummary() {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put("value", "test");
        FileVersion fileVersion = new FileVersion();
        fileVersion.setCurrent(true);
        fileVersion.setTitle("test.docx");
        fileVersion.setVersionNumber(1);
        fileVersion.setId("4ezadazd465az4d");
        fileVersion.setCreatedDate(new Date());
        fileVersion.setAuthorFullName("user user");
        fileVersion.setAuthor("user");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.updateVersionSummary(summary, null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.updateVersionSummary(summary, "1225", null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        response = documentFileRest1.updateVersionSummary(summary, "123", "123336");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)documentFileService1.updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenReturn((Object)fileVersion);
        response = documentFileRest1.updateVersionSummary(summary, "123", "123336");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)documentFileService1.updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenThrow(IllegalArgumentException.class);
        response = documentFileRest1.updateVersionSummary(summary, "123", "123336");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void shouldThrowServerErrorWhenUpdateSummary() {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        HashMap<String, String> summary = new HashMap<String, String>();
        summary.put("value", "test");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)documentFileService1.updateVersionSummary(Mockito.anyString(), Mockito.anyString(), Mockito.anyString(), Mockito.anyString())).thenThrow(RuntimeException.class);
        Response response = documentFileRest1.updateVersionSummary(summary, "123", "123336");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void restoreVersion() {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        FileVersion fileVersion = new FileVersion();
        fileVersion.setCurrent(true);
        fileVersion.setTitle("test.docx");
        fileVersion.setVersionNumber(1);
        fileVersion.setId("4ezadazd465az4d");
        fileVersion.setCreatedDate(new Date());
        fileVersion.setAuthorFullName("user user");
        fileVersion.setAuthor("user");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.restoreVersion(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        response = documentFileRest1.restoreVersion("123");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)documentFileService1.restoreVersion(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)fileVersion);
        response = documentFileRest1.restoreVersion("123");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)documentFileService1)).restoreVersion(Mockito.anyString(), Mockito.anyString());
        response = documentFileRest1.restoreVersion("123");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testRenameDocumentWithExistTitle() throws Exception {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)2L);
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectAlreadyExistsException((Object)"exist")}).when((Object)documentFileService1)).renameDocument(1L, "123", "test", 2L);
        Response response = documentFileRest1.updateDocument("name", "123", Long.valueOf(1L), "test", "", null);
        Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testMoveWithExistTitle() throws Exception {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)2L);
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectAlreadyExistsException((Object)"exist")}).when((Object)documentFileService1)).moveDocument(1L, "123", "test", 2L, "");
        Response response = documentFileRest1.moveDocument("123", Long.valueOf(1L), "test", "");
        Assert.assertEquals((long)Response.Status.CONFLICT.getStatusCode(), (long)response.getStatus());
    }

    private MockedStatic<RestUtils> mockRestUtils() {
        if (REST_UTILS == null) {
            REST_UTILS = Mockito.mockStatic(RestUtils.class);
        }
        return REST_UTILS;
    }

    private MockedStatic<EntityBuilder> mockEntityBuilder() {
        if (ENTITY_BUILDER == null) {
            ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
        }
        return ENTITY_BUILDER;
    }

    @Test
    public void createNewVersion() {
        this.mockRestUtils().when(() -> RestUtils.getCurrentUser()).thenReturn((Object)"user");
        FileVersion fileVersion = new FileVersion();
        fileVersion.setCurrent(true);
        fileVersion.setTitle("test.docx");
        fileVersion.setVersionNumber(1);
        fileVersion.setId("123");
        fileVersion.setCreatedDate(new Date());
        fileVersion.setAuthorFullName("user user");
        fileVersion.setAuthor("user");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        ByteArrayInputStream newContent = new ByteArrayInputStream("test".getBytes());
        Response response = documentFileRest1.createNewVersion(null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        response = documentFileRest1.createNewVersion((InputStream)newContent, "123");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        Mockito.when((Object)documentFileService1.createNewVersion(Mockito.anyString(), Mockito.anyString(), (InputStream)Mockito.any())).thenReturn((Object)fileVersion);
        response = documentFileRest1.createNewVersion((InputStream)newContent, "123");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)documentFileService1)).createNewVersion(Mockito.anyString(), Mockito.anyString(), (InputStream)Mockito.any());
        response = documentFileRest1.createNewVersion((InputStream)newContent, "123");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void moveDocuments() throws IllegalAccessException {
        this.mockRestUtils().when(RestUtils::getCurrentUser).thenReturn((Object)"user");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        AbstractNodeEntity abstractNodeEntity = (AbstractNodeEntity)Mockito.mock(AbstractNodeEntity.class);
        List<AbstractNodeEntity> documents = List.of(abstractNodeEntity);
        Response response = documentFileRest1.moveDocuments(1, null, new ArrayList(), null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.moveDocuments(1, null, documents, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.moveDocuments(1, Long.valueOf(1L), documents, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L);
        response = documentFileRest1.moveDocuments(1, Long.valueOf(1L), documents, "destPath");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        this.mockEntityBuilder().when(() -> EntityBuilder.toAbstractNodes((List)documents)).thenReturn(new ArrayList());
        response = documentFileRest1.moveDocuments(1, Long.valueOf(1L), documents, "destPath");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)documentFileService1)).moveDocuments(Mockito.anyInt(), Mockito.anyLong(), Mockito.anyList(), Mockito.anyString(), Mockito.anyLong());
        response = documentFileRest1.moveDocuments(1, Long.valueOf(1L), documents, "destPath");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getSize() throws IllegalAccessException, ObjectNotFoundException {
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.getSize(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)documentFileService1.getDocumentsSizeStat(1L, 1L)).thenThrow(new Throwable[]{new RuntimeException()});
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", "username");
        currentIdentity.setId(String.valueOf(currentOwnerId));
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentity((IdentityManager)this.identityManager)).thenReturn((Object)currentIdentity);
        response = documentFileRest1.getSize(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void updateSize() {
        String username = "user";
        long currentOwnerId = 2L;
        org.exoplatform.social.core.identity.model.Identity currentIdentity = new org.exoplatform.social.core.identity.model.Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.addSize(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.addSize(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentity((IdentityManager)this.identityManager)).thenReturn((Object)currentIdentity);
        response = documentFileRest1.addSize(Long.valueOf(1L));
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void createPublicAccessLink() throws IllegalAccessException {
        long expirationDate = new Date().getTime();
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getLocale()).thenReturn((Object)new Locale("en"));
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setPasswordHashKey("hash");
        PublicDocumentAccessOptionsEntity params = new PublicDocumentAccessOptionsEntity();
        params.setPassword("12345678");
        params.setExpirationDate(Long.valueOf(expirationDate));
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L, new Object[]{1L});
        Mockito.when((Object)documentFileService1.hasEditPermissionOnDocument("123", 1L)).thenReturn((Object)false, (Object[])new Boolean[]{true});
        Response response = documentFileRest1.createPublicAccessLink(request, null, params);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        params.setPassword("Password123456");
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.createPublicDocumentAccess(1L, "123", "Password123456", Long.valueOf(expirationDate), false)).thenReturn((Object)publicDocumentAccess);
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.getPublicDocumentAccess("123")).thenReturn(null, (Object[])new PublicDocumentAccess[]{publicDocumentAccess});
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.createPublicDocumentAccess(1L, "123", "Password123456", Long.valueOf(expirationDate), false)).thenThrow(RuntimeException.class);
        response = documentFileRest1.createPublicAccessLink(request, "123", params);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void getPublicAccessLink() {
        PublicDocumentAccess publicDocumentAccess = new PublicDocumentAccess();
        publicDocumentAccess.setNodeId("1233");
        publicDocumentAccess.setExpirationDate(new Date());
        publicDocumentAccess.setPasswordHashKey("100:test:test");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)0L, new Object[]{1L});
        Response response = documentFileRest1.getPublicAccessLink(null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.getPublicAccessLink("1233");
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.getPublicDocumentAccess("1233")).thenReturn(null);
        response = documentFileRest1.getPublicAccessLink("1233");
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.getPublicDocumentAccess("1233")).thenReturn((Object)publicDocumentAccess);
        response = documentFileRest1.getPublicAccessLink("1233");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.getPublicDocumentAccess("1233")).thenThrow(new Throwable[]{new RuntimeException()});
        response = documentFileRest1.getPublicAccessLink("1233");
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void downloadDocument() {
        DownloadItem downloadItem = new DownloadItem();
        downloadItem.setItemName("test.pdf");
        downloadItem.setItemId("123");
        byte[] bytes = "test".getBytes();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(bytes.length);
        outputStream.write(bytes, 0, bytes.length);
        downloadItem.setItemContent(outputStream);
        downloadItem.setMimeType("application/pdf");
        Response response = this.documentFileRest.downloadDocument(null, null);
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.publicDocumentAccessService.isPublicDocumentAccessExpired("123")).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)this.publicDocumentAccessService.isDocumentPublicAccessValid("123", null)).thenReturn((Object)false, (Object[])new Boolean[]{true});
        response = this.documentFileRest.downloadDocument("123", null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        response = this.documentFileRest.downloadDocument("123", null);
        Assert.assertEquals((long)Response.Status.UNAUTHORIZED.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.externalDownloadService.getDocumentDownloadItem("123")).thenReturn(null, (Object[])new DownloadItem[]{downloadItem});
        response = this.documentFileRest.downloadDocument("123", null);
        Assert.assertEquals((long)Response.Status.NOT_FOUND.getStatusCode(), (long)response.getStatus());
        response = this.documentFileRest.downloadDocument("123", null);
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
        Mockito.when((Object)this.externalDownloadService.getDocumentDownloadItem("123")).thenThrow(RuntimeException.class);
        response = this.documentFileRest.downloadDocument("123", null);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void importDocuments() throws Exception {
        String username = "user";
        Identity user = new Identity(username);
        ConversationState.setCurrent((ConversationState)new ConversationState(user));
        this.mockRestUtils().when(RestUtils::getCurrentUser).thenReturn((Object)"user");
        DocumentFileService documentFileService1 = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService1, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest1.importDocuments("1", null, null, null, "ignore");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        response = documentFileRest1.importDocuments(null, "1", null, null, "ignore");
        Assert.assertEquals((long)Response.Status.BAD_REQUEST.getStatusCode(), (long)response.getStatus());
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentityId((IdentityManager)this.identityManager)).thenReturn((Object)1L);
        response = documentFileRest1.importDocuments("1", "1", null, null, "ignore");
        Assert.assertEquals((long)Response.Status.OK.getStatusCode(), (long)response.getStatus());
    }

    @Test
    public void testGetSettings() {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest1 = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        String userName = "user";
        Long ownerId = 1L;
        org.exoplatform.social.core.identity.model.Identity currentUserIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Identity user = new Identity(userName);
        ConversationState.setCurrent((ConversationState)new ConversationState(user));
        this.mockRestUtils().when(() -> RestUtils.getCurrentUserIdentity((IdentityManager)this.identityManager)).thenReturn((Object)currentUserIdentity);
        Mockito.when((Object)documentFileService.canImport(user)).thenReturn((Object)true);
        Response response = documentFileRest1.getSettings(Long.valueOf(1L));
        Assert.assertEquals((long)200L, (long)response.getStatus());
        DocumentsUserSettings documentsUserSettings = (DocumentsUserSettings)response.getEntity();
        Assert.assertEquals((Object)documentsUserSettings.getCanImport(), (Object)true);
    }

    @Test
    public void testGetDeletedDocuments() throws RepositoryException {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest.getDeletedDocuments("name", "asc", -1, 20);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        TrashElementNode trashElementNode = new TrashElementNode();
        String expectedDeletedElementFullPath = trashElementNode.getRestorePath();
        ArrayList<TrashElementNode> trashElementNodes = new ArrayList<TrashElementNode>();
        trashElementNodes.add(trashElementNode);
        Mockito.when((Object)documentFileService.getDeletedDocuments((TrashElementNodeFilter)Mockito.any(TrashElementNodeFilter.class))).thenReturn(trashElementNodes);
        Mockito.when((Object)documentFileService.countDeletedDocuments()).thenReturn((Object)1);
        TrashElementEntity trashElementEntity = (TrashElementEntity)Mockito.mock(TrashElementEntity.class);
        Mockito.when((Object)trashElementEntity.getRestorePath()).thenReturn((Object)expectedDeletedElementFullPath);
        this.mockEntityBuilder().when(() -> EntityBuilder.toTrashElement((TrashElementNode)((TrashElementNode)Mockito.any()))).thenReturn((Object)trashElementEntity);
        response = documentFileRest.getDeletedDocuments("name", "asc", 0, 20);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        CollectionEntity collectionEntity = (CollectionEntity)response.getEntity();
        TrashElementEntity trashElementEntity1 = (TrashElementEntity)collectionEntity.getEntities().get(0);
        Assert.assertEquals((Object)expectedDeletedElementFullPath, (Object)trashElementEntity1.getRestorePath());
        Assert.assertEquals((long)1L, (long)collectionEntity.getSize());
    }

    @Test
    public void testRestoreDocument() throws RepositoryException {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest.restoreDocumentFromTrash(null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        String nodePath = "/Trash/testFileName.text";
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RepositoryException("Error restoring document")}).when((Object)documentFileService)).restoreDocumentFromTrash(nodePath);
        response = documentFileRest.restoreDocumentFromTrash(nodePath);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService)).restoreDocumentFromTrash(nodePath);
        response = documentFileRest.restoreDocumentFromTrash(nodePath);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testDeleteDocumentPermanently() throws RepositoryException, ObjectNotFoundException {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Response response = documentFileRest.deleteDocumentPermanently(null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        String nodePath = "/Trash/testFileName.text";
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new RepositoryException("Error deleting document")}).when((Object)documentFileService)).deleteDocumentPermanently(nodePath);
        response = documentFileRest.deleteDocumentPermanently(nodePath);
        Assert.assertEquals((long)500L, (long)response.getStatus());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new ObjectNotFoundException("Error deleting document")}).when((Object)documentFileService)).deleteDocumentPermanently(nodePath);
        response = documentFileRest.deleteDocumentPermanently(nodePath);
        Assert.assertEquals((long)404L, (long)response.getStatus());
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService)).deleteDocumentPermanently(nodePath);
        response = documentFileRest.deleteDocumentPermanently(nodePath);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testDeleteDocumentsPermanently() throws IllegalAccessException {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        ArrayList<TrashElementEntity> trashElementEntities = new ArrayList<TrashElementEntity>();
        Response response = documentFileRest.deleteDocumentsPermanently(1, trashElementEntities);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        trashElementEntities.add(new TrashElementEntity());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException("Error deleting document")}).when((Object)documentFileService)).deleteDocumentsPermanently(Mockito.anyInt(), Mockito.anyList(), Mockito.anyLong());
        response = documentFileRest.deleteDocumentsPermanently(1, trashElementEntities);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService)).deleteDocumentsPermanently(Mockito.anyInt(), Mockito.anyList(), Mockito.anyLong());
        response = documentFileRest.deleteDocumentsPermanently(1, trashElementEntities);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testRestoreDocuments() throws IllegalAccessException {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        ArrayList<TrashElementEntity> trashElementEntities = new ArrayList<TrashElementEntity>();
        Response response = documentFileRest.restoreDocuments(1, trashElementEntities);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        trashElementEntities.add(new TrashElementEntity());
        ((DocumentFileService)Mockito.doThrow((Throwable[])new Throwable[]{new IllegalAccessException("Error restoring document")}).when((Object)documentFileService)).restoreDocuments(Mockito.anyInt(), Mockito.anyList(), Mockito.anyLong());
        response = documentFileRest.restoreDocuments(1, trashElementEntities);
        Assert.assertEquals((long)401L, (long)response.getStatus());
        ((DocumentFileService)Mockito.doNothing().when((Object)documentFileService)).restoreDocuments(Mockito.anyInt(), Mockito.anyList(), Mockito.anyLong());
        response = documentFileRest.restoreDocuments(1, trashElementEntities);
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }

    @Test
    public void testGetDocumentsThumb() throws Exception {
        DocumentFileService documentFileService = (DocumentFileService)Mockito.mock(DocumentFileService.class);
        DocumentFileRest documentFileRest = new DocumentFileRest(documentFileService, this.spaceService, this.identityManager, this.metadataService, this.settingService, this.publicDocumentAccessService, this.externalDownloadService);
        Request request = (Request)Mockito.mock(Request.class);
        UriInfo uriInfo = (UriInfo)Mockito.mock(UriInfo.class);
        Response response = documentFileRest.getDocumentContent(uriInfo, request, null, "imageThumbnail", null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        documentFileRest.getDocumentContent(uriInfo, request, "docId", null, null, null);
        Assert.assertEquals((long)400L, (long)response.getStatus());
        FileContent fileThumbnail = new FileContent(null, "testThumbnail", "image/mpeg", null, new Date());
        String userName = "user";
        Identity root = new Identity(userName);
        ConversationState.setCurrent((ConversationState)new ConversationState(root));
        Mockito.when((Object)documentFileService.getImageThumbnailContent("imageThumbnail", "docId", userName, 250, 250)).thenReturn((Object)fileThumbnail);
        response = documentFileRest.getDocumentContent(uriInfo, request, "docId", "imageThumbnail", null, "250x250");
        Assert.assertEquals((long)200L, (long)response.getStatus());
        response = documentFileRest.getDocumentContent(uriInfo, request, "docId", "content", null, "250x250");
        Assert.assertEquals((long)404L, (long)response.getStatus());
        Mockito.when((Object)documentFileService.getDocumentContent("docId", userName)).thenReturn((Object)fileThumbnail);
        response = documentFileRest.getDocumentContent(uriInfo, request, "docId", "content", null, "250x250");
        Assert.assertEquals((long)200L, (long)response.getStatus());
    }
}

