/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.filter.DocumentPreviewFilter;
import org.exoplatform.services.listener.ListenerService;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DocumentPreviewFilterTest {
    @Mock
    private ListenerService listenerService;
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);

    @Before
    public void setUp() throws Exception {
        COMMONS_UTILS.when(() -> CommonsUtils.getService(ListenerService.class)).thenReturn((Object)this.listenerService);
    }

    @AfterClass
    public static void afterRunBare() {
        COMMONS_UTILS.close();
    }

    @Test
    public void doFilter() throws Exception {
        DocumentPreviewFilter documentPreviewFilter = new DocumentPreviewFilter();
        ServletResponse servletResponse = (ServletResponse)Mockito.mock(ServletResponse.class);
        FilterChain filterChain = (FilterChain)Mockito.mock(FilterChain.class);
        HttpServletRequest httpServletRequest = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)httpServletRequest.getParameter("documentPreviewId")).thenReturn((Object)"123", (Object[])new String[]{null, null, null});
        Mockito.when((Object)httpServletRequest.getParameter("docId")).thenReturn(null, (Object[])new String[]{"123", null, "123"});
        Mockito.when((Object)httpServletRequest.getParameter("source")).thenReturn(null, (Object[])new String[]{null, "preview"});
        Mockito.when((Object)httpServletRequest.getRemoteUser()).thenReturn((Object)"user");
        documentPreviewFilter.doFilter((ServletRequest)httpServletRequest, servletResponse, filterChain);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("update-document-views-detail", (Object)"user", (Object)"123");
        Mockito.clearInvocations((Object[])new ListenerService[]{this.listenerService});
        documentPreviewFilter.doFilter((ServletRequest)httpServletRequest, servletResponse, filterChain);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)1))).broadcast("update-document-views-detail", (Object)"user", (Object)"123");
        Mockito.clearInvocations((Object[])new ListenerService[]{this.listenerService});
        documentPreviewFilter.doFilter((ServletRequest)httpServletRequest, servletResponse, filterChain);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)0))).broadcast("update-document-views-detail", (Object)"user", (Object)"123");
        ((FilterChain)Mockito.verify((Object)filterChain, (VerificationMode)Mockito.times((int)3))).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
        documentPreviewFilter.doFilter((ServletRequest)httpServletRequest, servletResponse, filterChain);
        ((ListenerService)Mockito.verify((Object)this.listenerService, (VerificationMode)Mockito.times((int)0))).broadcast("update-document-views-detail", (Object)"user", (Object)"123");
        ((FilterChain)Mockito.verify((Object)filterChain, (VerificationMode)Mockito.times((int)4))).doFilter((ServletRequest)Mockito.any(), (ServletResponse)Mockito.any());
    }
}

