/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.filter;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.documents.service.DocumentFileService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.web.filter.Filter;

public class DocumentModeRedirectHandler
implements Filter {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) {
        DocumentFileService documentFileService = (DocumentFileService)ExoContainerContext.getService(DocumentFileService.class);
        IdentityManager identityManager = (IdentityManager)ExoContainerContext.getService(IdentityManager.class);
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        String documentPreviewId = httpServletRequest.getParameter("documentPreviewId");
        String documentEditId = httpServletRequest.getParameter("docId");
        String viewer = httpServletRequest.getRemoteUser();
        String documentId = documentPreviewId != null ? documentPreviewId : documentEditId;
        documentFileService.getDocumentById(documentId);
        Identity authenticatedUserIdentity = identityManager.getOrCreateUserIdentity(viewer);
        boolean canEdit = documentFileService.hasEditPermissionOnDocument(documentId, Long.parseLong(authenticatedUserIdentity.getId()));
        if (!canEdit && httpServletRequest.getParameter("mode") == null) {
            StringBuilder redirectUrl = new StringBuilder(httpServletRequest.getRequestURL());
            String query = httpServletRequest.getQueryString();
            if (query != null && !query.isEmpty()) {
                redirectUrl.append("?").append(query).append("&mode=view");
            } else {
                redirectUrl.append("?mode=view");
            }
            httpServletResponse.sendRedirect(redirectUrl.toString());
            return;
        }
        chain.doFilter(request, response);
    }
}

