/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.notification.utils;

import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.notification.utils.NotificationUtils;
import org.exoplatform.documents.rest.util.EntityBuilder;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.service.LinkProvider;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class NotificationUtilsTest {
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<LinkProvider> LINK_PROVIDER = Mockito.mockStatic(LinkProvider.class);
    private static final MockedStatic<EntityBuilder> ENTITY_BUILDER = Mockito.mockStatic(EntityBuilder.class);
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;

    @AfterClass
    public static void afterRunBare() throws Exception {
        COMMONS_UTILS.close();
        ENTITY_BUILDER.close();
        LINK_PROVIDER.close();
    }

    @Before
    public void setUp() throws Exception {
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentPortalOwner()).thenReturn((Object)"dw");
        COMMONS_UTILS.when(() -> CommonsUtils.getCurrentDomain()).thenReturn((Object)"http://domain");
        LINK_PROVIDER.when(() -> LinkProvider.getPortalName(null)).thenReturn((Object)"portal");
    }

    @Test
    public void getDocumentLink() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Space space = new Space();
        space.setId("1");
        space.setPrettyName("spacex");
        space.setGroupId("/spaces/spacex");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"spacex");
        Node node = (Node)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)((ExtendedNode)node).getIdentifier()).thenReturn((Object)"123");
        Mockito.when((Object)node.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"/Groups/spaces/spacex/Documents/new folder 32");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("spacex")).thenReturn((Object)space);
        ENTITY_BUILDER.when(() -> EntityBuilder.getOwnerIdentityFromNodePath((String)((String)ArgumentMatchers.any()), (IdentityManager)((IdentityManager)ArgumentMatchers.any()), (SpaceService)((SpaceService)ArgumentMatchers.any()))).thenReturn((Object)identity);
        String link = NotificationUtils.getDocumentLink((Node)node, (SpaceService)this.spaceService, (IdentityManager)this.identityManager);
        Assert.assertEquals((Object)"http://domain/portal/s/1/documents?documentPreviewId=123", (Object)link);
    }

    @Test
    public void getSharedDocumentLink() throws RepositoryException {
        Space space = new Space();
        space.setGroupId("/spaces/spacename");
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName("space_name")).thenReturn((Object)space);
        SessionImpl session = (SessionImpl)Mockito.mock(SessionImpl.class);
        Node node = (Node)Mockito.mock(NodeImpl.class);
        Node targetNode = (Node)Mockito.mock(NodeImpl.class);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)((NodeImpl)node).getIdentifier()).thenReturn((Object)"123");
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Mockito.when((Object)node.getProperty("exo:uuid")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"id123");
        Mockito.when((Object)session.getNodeByUUID(ArgumentMatchers.anyString())).thenReturn((Object)targetNode);
        Mockito.when((Object)targetNode.isNodeType("nt:file")).thenReturn((Object)true);
        String link = NotificationUtils.getSharedDocumentLink((Node)node, null, null);
        Assert.assertEquals((Object)"http://domain/portal/dw/documents?documentPreviewId=123", (Object)link);
        link = NotificationUtils.getSharedDocumentLink((Node)node, (SpaceService)this.spaceService, (String)"space_name");
        Assert.assertEquals((Object)"http://domain/portal/g/:spaces:spacename/space_name/documents?documentPreviewId=123", (Object)link);
        Mockito.when((Object)targetNode.isNodeType("nt:file")).thenReturn((Object)false);
        link = NotificationUtils.getSharedDocumentLink((Node)node, null, null);
        Assert.assertEquals((Object)"http://domain/portal/dw/documents?folderId=123", (Object)link);
        link = NotificationUtils.getSharedDocumentLink((Node)node, (SpaceService)this.spaceService, (String)"space_name");
        Assert.assertEquals((Object)"http://domain/portal/g/:spaces:spacename/space_name/documents?folderId=123", (Object)link);
    }

    @Test
    public void getDocumentTitle() throws RepositoryException {
        Node node = (Node)Mockito.mock(Node.class);
        Node contentNode = (Node)Mockito.mock(Node.class);
        Property exoTitleProperty = (Property)Mockito.mock(Property.class);
        Property dcTitleProperty = (Property)Mockito.mock(Property.class);
        Value exoTitle = (Value)Mockito.mock(Value.class);
        Value dcTitle = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)node.getName()).thenReturn((Object)"nodeName");
        Mockito.when((Object)node.getProperty("exo:title")).thenReturn((Object)exoTitleProperty);
        Mockito.when((Object)exoTitleProperty.getValue()).thenReturn((Object)exoTitle);
        Mockito.when((Object)exoTitle.getString()).thenReturn((Object)"exoTitle");
        Mockito.when((Object)contentNode.getProperty("dc:title")).thenReturn((Object)dcTitleProperty);
        Mockito.when((Object)dcTitleProperty.getValue()).thenReturn((Object)dcTitle);
        Mockito.when((Object)dcTitle.getString()).thenReturn((Object)"dcTitle");
        Mockito.when((Object)node.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)contentNode.hasProperty("dc:title")).thenReturn((Object)true);
        Mockito.when((Object)node.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)node.getNode("jcr:content")).thenReturn((Object)contentNode);
        String title = NotificationUtils.getDocumentTitle((Node)node);
        Assert.assertEquals((Object)"exoTitle", (Object)title);
        Mockito.when((Object)exoTitle.getString()).thenReturn(null);
        String title1 = NotificationUtils.getDocumentTitle((Node)node);
        Assert.assertEquals((Object)"dcTitle", (Object)title1);
        Mockito.when((Object)dcTitle.getString()).thenReturn(null);
        String title2 = NotificationUtils.getDocumentTitle((Node)node);
        Assert.assertEquals((Object)"nodeName", (Object)title2);
    }

    @Test
    public void getUserProfile() {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Profile profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "user")).thenReturn((Object)identity);
        Mockito.when((Object)identity.getProfile()).thenReturn((Object)profile);
        Profile userProfile = NotificationUtils.getUserProfile((IdentityManager)this.identityManager, (String)"user");
        Assert.assertEquals((Object)profile, (Object)userProfile);
    }
}

