/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.StringConcatFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.model.AbstractNode;
import org.exoplatform.documents.model.ActionData;
import org.exoplatform.documents.model.ActionType;
import org.exoplatform.documents.model.DocumentFolderFilter;
import org.exoplatform.documents.model.DocumentNodeFilter;
import org.exoplatform.documents.model.DownloadItem;
import org.exoplatform.documents.model.FileNode;
import org.exoplatform.documents.model.FileVersion;
import org.exoplatform.documents.model.FolderNode;
import org.exoplatform.documents.model.FullTreeItem;
import org.exoplatform.documents.model.NodePermission;
import org.exoplatform.documents.model.PermissionEntry;
import org.exoplatform.documents.model.PermissionRole;
import org.exoplatform.documents.storage.DocumentFileStorage;
import org.exoplatform.documents.storage.jcr.JCRDocumentFileStorage;
import org.exoplatform.documents.storage.jcr.bulkactions.BulkStorageActionService;
import org.exoplatform.documents.storage.jcr.search.DocumentSearchServiceConnector;
import org.exoplatform.documents.storage.jcr.util.JCRDocumentsUtil;
import org.exoplatform.documents.storage.jcr.util.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.access.AccessControlList;
import org.exoplatform.services.jcr.access.PermissionType;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.jcr.ext.utils.VersionHistoryUtils;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagName;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class JCRDocumentFileStorageTest {
    private static final MockedStatic<Utils> UTILS = Mockito.mockStatic(Utils.class);
    private static final MockedStatic<JCRDocumentsUtil> JCR_DOCUMENTS_UTIL = Mockito.mockStatic(JCRDocumentsUtil.class);
    private static final MockedStatic<SessionProvider> SESSION_PROVIDER = Mockito.mockStatic(SessionProvider.class);
    private static final MockedStatic<CommonsUtils> COMMONS_UTILS_UTIL = Mockito.mockStatic(CommonsUtils.class);
    private static final MockedStatic<VersionHistoryUtils> VERSION_HISTORY_UTILS = Mockito.mockStatic(VersionHistoryUtils.class);
    @Mock
    private SpaceService spaceService;
    @Mock
    private RepositoryService repositoryService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private NodeHierarchyCreator nodeHierarchyCreator;
    @Mock
    private DocumentSearchServiceConnector documentSearchServiceConnector;
    @Mock
    private ListenerService listenerService;
    @Mock
    private UploadService uploadService;
    @Mock
    private IdentityRegistry identityRegistry;
    @Mock
    private ActivityManager activityManager;
    @Mock
    private TagService tagService;
    @Mock
    private BulkStorageActionService bulkStorageActionService;
    private JCRDocumentFileStorage jcrDocumentFileStorage;

    @AfterClass
    public static void afterRunBare() {
        JCR_DOCUMENTS_UTIL.close();
        UTILS.close();
        SESSION_PROVIDER.close();
        COMMONS_UTILS_UTIL.close();
        VERSION_HISTORY_UTILS.close();
    }

    @Before
    public void setUp() {
        this.jcrDocumentFileStorage = new JCRDocumentFileStorage(this.nodeHierarchyCreator, this.repositoryService, this.documentSearchServiceConnector, this.identityManager, this.spaceService, this.listenerService, this.uploadService, this.identityRegistry, this.activityManager, this.bulkStorageActionService);
    }

    @Test
    public void shareDocument() throws Exception {
        Session systemSession = (Session)Mockito.mock(Session.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        Node rootNode = (Node)Mockito.mock(Node.class);
        Node sharedNode = (Node)Mockito.mock(Node.class);
        Node currentNode = (Node)Mockito.mock(ExtendedNode.class);
        ExtendedNode linkNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Property property = (Property)Mockito.mock(Property.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        Mockito.when((Object)SessionProvider.createSystemProvider()).thenReturn((Object)sessionProvider);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository)).thenReturn((Object)systemSession);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)systemSession, (String)"1")).thenReturn((Object)currentNode);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (org.exoplatform.social.core.identity.model.Identity)identity, (Session)systemSession)).thenReturn((Object)rootNode);
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"USER");
        Mockito.when((Object)rootNode.hasNode("Shared")).thenReturn((Object)false);
        Mockito.when((Object)rootNode.getNode("Documents")).thenReturn((Object)rootNode);
        Mockito.when((Object)rootNode.addNode("Shared")).thenReturn((Object)sharedNode);
        Mockito.when((Object)rootNode.getNode("Shared")).thenReturn((Object)sharedNode);
        Mockito.when((Object)currentNode.isNodeType("exo:symlink")).thenReturn((Object)false);
        Mockito.when((Object)currentNode.getName()).thenReturn((Object)"test");
        Mockito.when((Object)sharedNode.hasNode("test")).thenReturn((Object)false);
        Mockito.when((Object)sharedNode.addNode("test", "exo:symlink")).thenReturn((Object)linkNode);
        Mockito.when((Object)sharedNode.getNode("test")).thenReturn((Object)linkNode);
        Mockito.when((Object)linkNode.canAddMixin("exo:sortable")).thenReturn((Object)true);
        Mockito.when((Object)currentNode.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)currentNode.getProperty("exo:title")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"test");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getMimeType((Node)currentNode)).thenReturn((Object)"testMimeType");
        Mockito.when((Object)currentNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)((ExtendedNode)currentNode).getIdentifier()).thenReturn((Object)"123");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"username");
        AccessControlEntry accessControlEntry = new AccessControlEntry("username", "read");
        AccessControlList acl1 = new AccessControlList("username", Arrays.asList(accessControlEntry));
        Mockito.when((Object)((ExtendedNode)currentNode).getACL()).thenReturn((Object)acl1);
        Mockito.when((Object)linkNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        this.jcrDocumentFileStorage.shareDocument("1", 1L, aclIdentity, false);
        UTILS.verify(() -> Mockito.times((int)1));
        Utils.broadcast((ListenerService)this.listenerService, (String)"share_document_event", (Object)identity, (Object)linkNode);
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
        ((ExtendedNode)Mockito.verify((Object)linkNode)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("username") && Arrays.equals((Object[])map.get("username"), new String[]{"read"})));
        AccessControlEntry accessControlEntry1 = new AccessControlEntry("username", "edit");
        AccessControlList acl = new AccessControlList("username", Arrays.asList(accessControlEntry1));
        Mockito.when((Object)((ExtendedNode)currentNode).getACL()).thenReturn((Object)acl);
        this.jcrDocumentFileStorage.shareDocument("1", 1L, aclIdentity, false);
        ((ExtendedNode)Mockito.verify((Object)linkNode)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("username") && Arrays.equals((Object[])map.get("username"), new String[]{"edit"})));
        boolean notifyMember = true;
        this.jcrDocumentFileStorage.shareDocument("1", 1L, aclIdentity, notifyMember);
        UTILS.verify(() -> Utils.broadcast((ListenerService)this.listenerService, (String)"share_document_event", (Object)identity, (Object)currentNode), Mockito.atLeast((int)1));
        Mockito.when((Object)rootNode.hasNode("Shared")).thenReturn((Object)true);
        Mockito.when((Object)rootNode.getNode("Shared")).thenReturn((Object)sharedNode);
        Mockito.when((Object)sharedNode.hasNode(currentNode.getName())).thenReturn((Object)true);
        Mockito.when((Object)sharedNode.getNode(currentNode.getName())).thenReturn((Object)linkNode);
        Mockito.when((Object)linkNode.getACL()).thenReturn((Object)acl);
        this.jcrDocumentFileStorage.shareDocument("1", 1L, aclIdentity, false);
        UTILS.verify(() -> Utils.broadcast((ListenerService)this.listenerService, (String)"share_document_event", (Object)identity, (Object)linkNode), Mockito.atLeast((int)0));
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.atLeast((int)1))).close();
        this.jcrDocumentFileStorage.shareDocument("1", 1L, aclIdentity, notifyMember);
        UTILS.verify(() -> Utils.broadcast((ListenerService)this.listenerService, (String)"share_document_event", (Object)identity, (Object)currentNode), Mockito.atLeast((int)0));
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.atLeast((int)1))).close();
    }

    @Test
    public void duplicateDocument() throws Exception {
        Session systemSession = (Session)Mockito.mock(Session.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Node rootNode = (Node)Mockito.mock(Node.class);
        NodeImpl currentNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        Property property = (Property)Mockito.mock(Property.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        Identity userID = new Identity("username");
        Mockito.when((Object)SessionProvider.createSystemProvider()).thenReturn((Object)sessionProvider);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository)).thenReturn((Object)systemSession);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)systemSession, (String)"1")).thenReturn((Object)currentNode);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (org.exoplatform.social.core.identity.model.Identity)identity, (Session)systemSession)).thenReturn((Object)rootNode);
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"USER");
        Mockito.when((Object)rootNode.getNode("Documents")).thenReturn((Object)rootNode);
        Mockito.when((Object)currentNode.isNodeType("exo:symlink")).thenReturn((Object)false);
        Mockito.when((Object)currentNode.getName()).thenReturn((Object)"test");
        Mockito.when((Object)currentNode.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)currentNode.getProperty("exo:title")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"test");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getMimeType((Node)currentNode)).thenReturn((Object)"testMimeType");
        Mockito.when((Object)currentNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)currentNode.getUUID()).thenReturn((Object)"123");
        Mockito.when((Object)currentNode.getParent()).thenReturn((Object)currentNode);
        Mockito.when((Object)currentNode.getIdentifier()).thenReturn((Object)"1");
        Mockito.when((Object)currentNode.addNode("copy of test", "nt:file")).thenReturn((Object)currentNode);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"username");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)userID)).thenReturn((Object)sessionProvider);
        this.jcrDocumentFileStorage.duplicateDocument(1L, "1", "copy of", userID);
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void getFolderChildNodes() throws Exception {
        Node parentNode = (Node)Mockito.mock(Node.class);
        Session userSession = (Session)Mockito.mock(Session.class);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        DocumentFolderFilter filter = new DocumentFolderFilter("12e2", null, Long.valueOf(1L), "");
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository)).thenReturn((Object)userSession);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)userSession, (String)filter.getParentFolderId())).thenReturn((Object)parentNode);
        Mockito.when((Object)parentNode.getName()).thenReturn((Object)"documents");
        Mockito.when((Object)parentNode.getNode(filter.getFolderPath())).thenReturn((Object)parentNode);
        filter.setSortField(DocumentSortField.MODIFIED_DATE);
        filter.setAscending(true);
        filter.setIncludeHiddenFiles(false);
        Mockito.when((Object)parentNode.getPath()).thenReturn((Object)"/documents/path");
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        QueryImpl jcrQuery = (QueryImpl)Mockito.mock(QueryImpl.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)userSession.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)jcrQuery);
        Mockito.when((Object)jcrQuery.execute()).thenReturn((Object)queryResult);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator);
        FileNode file = new FileNode();
        file.setName("file1");
        FolderNode folder1 = new FolderNode();
        folder1.setName("folder1");
        FolderNode folder2 = new FolderNode();
        folder2.setName("folder2");
        FolderNode folderWithNumericName = new FolderNode();
        folderWithNumericName.setName("15");
        FolderNode folderWithSpecificName = new FolderNode();
        folderWithSpecificName.setName("15f");
        FolderNode folderWithSpecificName1 = new FolderNode();
        folderWithSpecificName1.setName("16L");
        NodeImpl fileNode = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl folderNode1 = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl folderNode2 = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl folderNode3 = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl folderNode4 = (NodeImpl)Mockito.mock(NodeImpl.class);
        NodeImpl folderNode5 = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)fileNode.isNodeType("nt:file")).thenReturn((Object)true);
        AccessControlList accessControlList = (AccessControlList)Mockito.mock(AccessControlList.class);
        Mockito.when((Object)accessControlList.getPermissionEntries()).thenReturn(new ArrayList());
        Mockito.when((Object)folderNode1.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)folderNode2.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)folderNode3.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)folderNode4.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)folderNode5.getACL()).thenReturn((Object)accessControlList);
        Mockito.when((Object)folderNode1.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderNode2.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderNode3.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderNode4.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderNode5.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)folderNode2, (Object[])new Node[]{folderNode1});
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.computeDocumentAcl((Node)((Node)Mockito.any()), (AbstractNode)((AbstractNode)Mockito.any()), (Identity)((Identity)Mockito.any()), (IdentityManager)((IdentityManager)Mockito.any()), (SpaceService)((SpaceService)Mockito.any()))).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)this.identityManager, (Identity)identity, (Node)folderNode1, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)folder1);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)this.identityManager, (Identity)identity, (Node)folderNode2, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)folder2);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)this.identityManager, (Identity)identity, (Node)folderNode3, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)folderWithNumericName);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)this.identityManager, (Identity)identity, (Node)folderNode4, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)folderWithSpecificName);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)this.identityManager, (Identity)identity, (Node)folderNode5, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)folderWithSpecificName1);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFileNode((IdentityManager)this.identityManager, (Identity)identity, (Node)fileNode, (String)"", (SpaceService)this.spaceService)).thenReturn((Object)file);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toNodes((IdentityManager)this.identityManager, (Session)userSession, (NodeIterator)nodeIterator, (Identity)identity, (SpaceService)this.spaceService, (boolean)false, (DocumentFolderFilter)filter)).thenCallRealMethod();
        List nodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 2);
        Assert.assertEquals((long)2L, (long)nodes.size());
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)folderNode2);
        nodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 2, 4);
        Assert.assertEquals((long)1L, (long)nodes.size());
        filter.setParentFolderId(null);
        Mockito.when((Object)this.identityManager.getIdentity(String.valueOf(filter.getOwnerId()))).thenReturn((Object)ownerIdentity);
        NodeImpl parentNodeImp = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)parentNodeImp.getName()).thenReturn((Object)"documents");
        Mockito.when((Object)parentNodeImp.getNode(filter.getFolderPath())).thenReturn((Object)parentNodeImp);
        Mockito.when((Object)parentNodeImp.getPath()).thenReturn((Object)"/documents/path");
        Mockito.when((Object)parentNodeImp.getIdentifier()).thenReturn((Object)"parentNodeIdentifier");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (String)"user", (org.exoplatform.social.core.identity.model.Identity)ownerIdentity, (SessionProvider)sessionProvider)).thenReturn((Object)parentNodeImp);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (org.exoplatform.social.core.identity.model.Identity)ownerIdentity, (Session)userSession)).thenReturn((Object)parentNodeImp);
        NodeIterator nodeIterator1 = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator1);
        Mockito.when((Object)nodeIterator1.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)nodeIterator1.nextNode()).thenReturn((Object)folderNode2, (Object[])new Node[]{folderNode1});
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toNodes((IdentityManager)this.identityManager, (Session)userSession, (NodeIterator)nodeIterator1, (Identity)identity, (SpaceService)this.spaceService, (boolean)false, (DocumentFolderFilter)filter)).thenCallRealMethod();
        List nodes1 = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 2);
        Assert.assertEquals((long)2L, (long)nodes1.size());
        Mockito.when((Object)nodeIterator1.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator1.nextNode()).thenReturn((Object)folderNode2);
        nodes1 = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 2, 4);
        Assert.assertEquals((long)1L, (long)nodes1.size());
        NodeIterator nodeIterator2 = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)nodeIterator2);
        Mockito.when((Object)nodeIterator2.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)nodeIterator2.nextNode()).thenReturn((Object)folderNode3, (Object[])new Node[]{folderNode4, folderNode5});
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toNodes((IdentityManager)this.identityManager, (Session)userSession, (NodeIterator)nodeIterator2, (Identity)identity, (SpaceService)this.spaceService, (boolean)false, (DocumentFolderFilter)filter)).thenCallRealMethod();
        String folderName = folderWithSpecificName.getName();
        Assert.assertThrows(NumberFormatException.class, () -> Integer.parseInt(folderName));
        List nodes2 = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 3);
        Assert.assertEquals((long)3L, (long)nodes2.size());
        Assert.assertEquals((Object)"15", (Object)((AbstractNode)nodes2.get(0)).getName());
        Assert.assertEquals((Object)"15f", (Object)((AbstractNode)nodes2.get(1)).getName());
        Assert.assertEquals((Object)"16L", (Object)((AbstractNode)nodes2.get(2)).getName());
        filter.setQuery("docum");
        Mockito.when((Object)userSession.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getName()).thenReturn((Object)"collaboration");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getSortField((DocumentNodeFilter)filter, (boolean)false)).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getSortDirection((DocumentNodeFilter)filter)).thenCallRealMethod();
        this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 0);
        ((DocumentSearchServiceConnector)Mockito.verify((Object)this.documentSearchServiceConnector, (VerificationMode)Mockito.times((int)1))).search(identity, "collaboration", "/documents/path", (DocumentNodeFilter)filter, 0, 0, "lastUpdatedDate", "ASC");
    }

    @Test
    public void createShortcut() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session userSession = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)userSession);
        Throwable exception = Assert.assertThrows(IllegalStateException.class, () -> this.jcrDocumentFileStorage.createShortcut(null, null, "user", null));
        Assert.assertEquals((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"Error while creating a shortcut for document's id null to destination pathnull"}), (Object)exception.getMessage());
        Node rootNode = (Node)Mockito.mock(Node.class);
        ExtendedNode currentNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        ExtendedNode linkNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Property property = (Property)Mockito.mock(Property.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        AccessControlList acl = new AccessControlList();
        acl.setOwner("test_root");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)userSession, (String)"11111111")).thenReturn((Object)currentNode);
        Mockito.when((Object)((Node)userSession.getItem("/Groups/spaces/test/Documents/test"))).thenReturn((Object)rootNode);
        Mockito.when((Object)currentNode.isNodeType("exo:symlink")).thenReturn((Object)false);
        Mockito.when((Object)currentNode.getName()).thenReturn((Object)"test");
        Mockito.when((Object)rootNode.hasNode("test")).thenReturn((Object)false);
        Mockito.when((Object)rootNode.addNode("test", "exo:symlink")).thenReturn((Object)linkNode);
        Mockito.when((Object)rootNode.getNode("test")).thenReturn((Object)linkNode);
        Mockito.when((Object)linkNode.canAddMixin("exo:sortable")).thenReturn((Object)true);
        Mockito.when((Object)currentNode.hasProperty("exo:title")).thenReturn((Object)true);
        Mockito.when((Object)currentNode.getProperty("exo:title")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"test");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getMimeType((Node)currentNode)).thenReturn((Object)"testMimeType");
        Mockito.when((Object)currentNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)currentNode.getACL()).thenReturn((Object)acl);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)currentNode.getIdentifier()).thenReturn((Object)"123");
        Mockito.when((Object)linkNode.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        this.jcrDocumentFileStorage.createShortcut("11111111", "/Groups/spaces/test/Documents/test", "user", null);
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)2))).close();
        Mockito.when((Object)rootNode.hasNode("test")).thenReturn((Object)true);
        Mockito.when((Object)rootNode.addNode("test", "exo:symlink")).thenReturn((Object)currentNode);
        Mockito.when((Object)currentNode.getPath()).thenReturn((Object)"/Groups/spaces/test/Documents/test[1]");
        this.jcrDocumentFileStorage.createShortcut("11111111", "/Groups/spaces/test/Documents/test", "user", "keepBoth");
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)3))).close();
    }

    @Test
    public void getFileVersions() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        Version baseVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)node.getBaseVersion()).thenReturn((Object)baseVersion);
        Mockito.when((Object)baseVersion.getName()).thenReturn((Object)"2");
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"123");
        Mockito.when((Object)session.getNodeByUUID("123")).thenReturn((Object)node);
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)node.getVersionHistory()).thenReturn((Object)versionHistory);
        Version rootVersion = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)versionHistory.getRootVersion()).thenReturn((Object)rootVersion);
        VersionIterator versionIterator = (VersionIterator)Mockito.mock(VersionIterator.class);
        Mockito.when((Object)versionHistory.getAllVersions()).thenReturn((Object)versionIterator);
        Mockito.when((Object)versionIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)versionHistory.getVersionLabels(version)).thenReturn((Object)new String[]{"1@label"});
        Mockito.when((Object)version.getName()).thenReturn((Object)"1");
        Mockito.when((Object)version.getUUID()).thenReturn((Object)"111");
        Mockito.when((Object)versionIterator.nextVersion()).thenReturn((Object)version);
        Mockito.when((Object)rootVersion.getUUID()).thenReturn((Object)"333");
        Mockito.when((Object)version.getUUID()).thenReturn((Object)"222");
        Value titleValue = (Value)Mockito.mock(Value.class);
        Value ownerValue = (Value)Mockito.mock(Value.class);
        Property titleProperty = (Property)Mockito.mock(Property.class);
        Property ownerProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)node.getProperty("exo:title")).thenReturn((Object)titleProperty);
        Mockito.when((Object)titleProperty.getValue()).thenReturn((Object)titleValue);
        Mockito.when((Object)titleValue.getString()).thenReturn((Object)"test.docx");
        Node frozenNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)frozenNode.getProperty("exo:lastModifier")).thenReturn((Object)ownerProperty);
        Mockito.when((Object)ownerProperty.getValue()).thenReturn((Object)ownerValue);
        Mockito.when((Object)ownerValue.getString()).thenReturn((Object)"user");
        Profile profile = new Profile();
        profile.setProperty("firstName", (Object)"user");
        profile.setProperty("lastName", (Object)"user");
        org.exoplatform.social.core.identity.model.Identity identity1 = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateIdentity("organization", "user")).thenReturn((Object)identity1);
        Mockito.when((Object)identity1.getProfile()).thenReturn((Object)profile);
        Mockito.when((Object)version.getNode("jcr:frozenNode")).thenReturn((Object)frozenNode);
        Mockito.when((Object)frozenNode.getUUID()).thenReturn((Object)"666");
        Mockito.when((Object)version.getCreated()).thenReturn((Object)Calendar.getInstance());
        List versions = this.jcrDocumentFileStorage.getFileVersions("123", "user");
        Assert.assertNotNull((Object)versions);
        Assert.assertEquals((long)1L, (long)versions.size());
    }

    @Test
    public void updateVersionSummary() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getUUID()).thenReturn((Object)"123");
        Mockito.when((Object)session.getNodeByUUID("123")).thenReturn((Object)node);
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)session.getNodeByUUID("333")).thenReturn((Object)version);
        Node frozen = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)version.getNode("jcr:frozenNode")).thenReturn((Object)frozen);
        Mockito.when((Object)frozen.hasProperty("eoo:commentId")).thenReturn((Object)true);
        Property property = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)frozen.getProperty("eoo:commentId")).thenReturn((Object)property);
        Mockito.when((Object)property.getString()).thenReturn((Object)"comment1");
        ExoSocialActivity activity = (ExoSocialActivity)Mockito.mock(ExoSocialActivity.class);
        Mockito.when((Object)this.activityManager.getActivity("comment1")).thenReturn((Object)activity);
        ((ActivityManager)Mockito.doNothing().when((Object)this.activityManager)).updateActivity(activity);
        String[] oldLabels = new String[]{"1@test", "1:test2"};
        Mockito.when((Object)version.getName()).thenReturn((Object)"1");
        VersionHistory versionHistory = (VersionHistory)Mockito.mock(VersionHistory.class);
        Mockito.when((Object)node.getVersionHistory()).thenReturn((Object)versionHistory);
        ((VersionHistory)Mockito.doNothing().when((Object)versionHistory)).removeVersionLabel(ArgumentMatchers.anyString());
        ((VersionHistory)Mockito.doNothing().when((Object)versionHistory)).addVersionLabel(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean());
        Mockito.when((Object)versionHistory.getVersionLabels(version)).thenReturn((Object)oldLabels);
        this.jcrDocumentFileStorage.updateVersionSummary("123", "333", "summary", "user");
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void restoreVersion() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Version version = (Version)Mockito.mock(Version.class);
        Node frozen = (Node)Mockito.mock(Node.class);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getNodeByUUID("123")).thenReturn((Object)version);
        Mockito.when((Object)version.getNode("jcr:frozenNode")).thenReturn((Object)frozen);
        Mockito.when((Object)frozen.hasProperty("jcr:frozenUuid")).thenReturn((Object)true);
        Mockito.when((Object)Utils.getStringProperty((Node)frozen, (String)"jcr:frozenUuid")).thenReturn((Object)"111");
        Mockito.when((Object)session.getNodeByUUID("111")).thenReturn((Object)node);
        Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)false);
        ((Node)Mockito.doNothing().when((Object)node)).checkout();
        ((Node)Mockito.doNothing().when((Object)node)).restore(version, true);
        Mockito.when((Object)node.isNodeType("exo:modify")).thenReturn((Object)true);
        this.jcrDocumentFileStorage.restoreVersion("123", "user");
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).restore(version, true);
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).checkin();
    }

    @Test
    public void renameDocument() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Throwable exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.jcrDocumentFileStorage.renameDocument(1L, "123", "test:<*?", identity));
        Assert.assertEquals((Object)"document title is not valid", (Object)exception.getMessage());
        exception = Assert.assertThrows(IllegalArgumentException.class, () -> this.jcrDocumentFileStorage.renameDocument(1L, "123", "   ", identity));
        Assert.assertEquals((Object)"document title is not valid", (Object)exception.getMessage());
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.isValidDocumentTitle((String)ArgumentMatchers.anyString())).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.cleanName((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.cleanNameWithAccents((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)node.getName()).thenReturn((Object)"oldName");
        Mockito.when((Object)node.canAddMixin("exo:modify")).thenReturn((Object)true);
        Mockito.when((Object)node.canAddMixin("exo:sortable")).thenReturn((Object)true);
        Mockito.when((Object)node.hasProperty("exo:title")).thenReturn((Object)true);
        Node parentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getParent()).thenReturn((Object)parentNode);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"nodePath");
        Mockito.when((Object)parentNode.getPath()).thenReturn((Object)"parentNodePath");
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        ((Workspace)Mockito.doNothing().when((Object)workspace)).move(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        this.jcrDocumentFileStorage.renameDocument(1L, "123", "test.docx", identity);
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)2))).save();
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
        Node parent = (Node)Mockito.mock(Node.class);
        Node existNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getParent()).thenReturn((Object)parent);
        Mockito.when((Object)parent.hasNode("exist")).thenReturn((Object)true);
        Mockito.when((Object)parent.getNode("exist")).thenReturn((Object)existNode);
        Mockito.when((Object)nodeType.getName()).thenReturn((Object)"nt:file");
        Mockito.when((Object)existNode.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.jcrDocumentFileStorage.renameDocument(1L, "123", "exist", identity));
    }

    @Test
    public void testGetFullTreeData() throws Exception {
        String userName = "Adham";
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)userName);
        long ownerId = 1L;
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        String folderId = "uniqueFolderIdentifier";
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Mockito.when((Object)this.identityManager.getIdentity(String.valueOf(ownerId))).thenReturn((Object)ownerIdentity);
        List fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertTrue((String)"When node is null, return empty list", (boolean)fullTreeItemList.isEmpty());
        Node folderNode = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folderNode.getName()).thenReturn((Object)"myFolder");
        Mockito.when((Object)folderNode.getPath()).thenReturn((Object)"/root/folder");
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)folderNode.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)folderId)).thenReturn((Object)folderNode);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Node hiddenFolder = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)hiddenFolder.isNodeType("exo:hiddenable")).thenReturn((Object)true);
        NodeIterator nodeIteratorFolder = (NodeIterator)Mockito.mock(NodeIterator.class);
        Node childFolder = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)nodeIteratorFolder.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIteratorFolder.nextNode()).thenReturn((Object)childFolder);
        Mockito.when((Object)hiddenFolder.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)hiddenFolder);
        Mockito.when((Object)folderNode.getNodes()).thenReturn((Object)nodeIterator);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Node folderNTFolder = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folderNTFolder.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderNTFolder.getName()).thenReturn((Object)"ntFolderName");
        Mockito.when((Object)folderNTFolder.getPath()).thenReturn((Object)"/root/folder/ntFolderName");
        Mockito.when((Object)((NodeImpl)folderNTFolder).getIdentifier()).thenReturn((Object)"ntFolderIdentifier");
        Mockito.when((Object)folderNTFolder.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Node folderNTUnstructured = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folderNTUnstructured.isNodeType("nt:unstructured")).thenReturn((Object)true);
        Mockito.when((Object)folderNTUnstructured.getName()).thenReturn((Object)"ntUnstructuredFolderName");
        Mockito.when((Object)folderNTUnstructured.getPath()).thenReturn((Object)"/root/folder/ntUnstructuredFolderName");
        Mockito.when((Object)((NodeImpl)folderNTUnstructured).getIdentifier()).thenReturn((Object)"ntUnstructuredFolderIdentifier");
        Mockito.when((Object)folderNTUnstructured.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Node symlinkFolder = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)symlinkFolder.isNodeType("exo:symlink")).thenReturn((Object)true);
        Mockito.when((Object)symlinkFolder.getPath()).thenReturn((Object)"/root/folder/symlinkFolderName.lnk");
        Mockito.when((Object)symlinkFolder.getName()).thenReturn((Object)"symlinkFolderName.lnk");
        Node sourceFolder = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)sourceFolder.isNodeType("nt:unstructured")).thenReturn((Object)true);
        Mockito.when((Object)sourceFolder.getName()).thenReturn((Object)"sourceFolderName");
        Mockito.when((Object)sourceFolder.getPath()).thenReturn((Object)"/root/anotherFolder/sourceFolderName");
        String sourceFolderIdentifier = "sourceFolderIdentifier";
        Mockito.when((Object)((NodeImpl)sourceFolder).getIdentifier()).thenReturn((Object)sourceFolderIdentifier);
        Mockito.when((Object)sourceFolder.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Property symlinkUUID = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)symlinkUUID.getString()).thenReturn((Object)sourceFolderIdentifier);
        Mockito.when((Object)symlinkFolder.getProperty("exo:uuid")).thenReturn((Object)symlinkUUID);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)sourceFolderIdentifier)).thenReturn((Object)sourceFolder);
        Mockito.when((Object)symlinkFolder.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)folderNTFolder, (Object[])new Node[]{folderNTUnstructured, symlinkFolder});
        Mockito.when((Object)folderNode.getNodes()).thenReturn((Object)nodeIterator);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Assert.assertEquals((long)3L, (long)((FullTreeItem)fullTreeItemList.get(0)).getChildren().size());
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, false);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Assert.assertEquals((long)0L, (long)((FullTreeItem)fullTreeItemList.get(0)).getChildren().size());
        Node folder1 = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folder1.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folder1.getName()).thenReturn((Object)"folder1");
        Mockito.when((Object)folder1.getPath()).thenReturn((Object)"/root/folder/folder1");
        Mockito.when((Object)((NodeImpl)folder1).getIdentifier()).thenReturn((Object)"folder1Identifiuer");
        Mockito.when((Object)folder1.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Node folder2 = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folder2.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folder2.getName()).thenReturn((Object)"folder2");
        Mockito.when((Object)folder2.getPath()).thenReturn((Object)"/root/folder/folder2");
        Mockito.when((Object)((NodeImpl)folder2).getIdentifier()).thenReturn((Object)"folder2Identifiuer");
        Mockito.when((Object)folder2.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Node folder10 = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)folder10.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folder10.getName()).thenReturn((Object)"folder10");
        Mockito.when((Object)folder10.getPath()).thenReturn((Object)"/root/folder/folder10");
        Mockito.when((Object)((NodeImpl)folder10).getIdentifier()).thenReturn((Object)"folder10Identifiuer");
        Mockito.when((Object)folder10.getNodes()).thenReturn((Object)nodeIteratorFolder);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)folder1, (Object[])new Node[]{folder10, folder2});
        Mockito.when((Object)folderNode.getNodes()).thenReturn((Object)nodeIterator);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Assert.assertEquals((long)3L, (long)((FullTreeItem)fullTreeItemList.get(0)).getChildren().size());
        Assert.assertEquals((Object)"folder1", (Object)((FullTreeItem)((FullTreeItem)fullTreeItemList.get(0)).getChildren().get(0)).getName());
        Assert.assertEquals((Object)"folder2", (Object)((FullTreeItem)((FullTreeItem)fullTreeItemList.get(0)).getChildren().get(1)).getName());
        Assert.assertEquals((Object)"folder10", (Object)((FullTreeItem)((FullTreeItem)fullTreeItemList.get(0)).getChildren().get(2)).getName());
        Node userHome = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)((NodeImpl)userHome).getIdentifier()).thenReturn((Object)"userHomeFolderIdentifier");
        Mockito.when((Object)userHome.getPath()).thenReturn((Object)"/Users/adham");
        Mockito.when((Object)userHome.getName()).thenReturn((Object)"Home folder of Adham");
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)folderNTFolder, (Object[])new Node[]{folderNTUnstructured});
        Mockito.when((Object)userHome.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.when((Object)JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (String)userName, (org.exoplatform.social.core.identity.model.Identity)ownerIdentity, (SessionProvider)sessionProvider)).thenReturn((Object)userHome);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, null, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Assert.assertEquals((long)2L, (long)((FullTreeItem)fullTreeItemList.get(0)).getChildren().size());
        Mockito.when((Object)symlinkUUID.getString()).thenReturn((Object)folderId);
        Mockito.when((Object)symlinkFolder.getProperty("exo:uuid")).thenReturn((Object)symlinkUUID);
        Mockito.when((Object)nodeIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        Mockito.when((Object)nodeIterator.nextNode()).thenReturn((Object)symlinkFolder);
        Mockito.when((Object)folderNode.getNodes()).thenReturn((Object)nodeIterator);
        fullTreeItemList = this.jcrDocumentFileStorage.getFullTreeData(ownerId, folderId, identity, true);
        Assert.assertEquals((long)1L, (long)fullTreeItemList.size());
        Assert.assertTrue((boolean)((FullTreeItem)fullTreeItemList.get(0)).getChildren().isEmpty());
    }

    @Test
    public void updateDocumentDescription() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.lenient().when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Node contentNode = (Node)Mockito.mock(Node.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        Mockito.lenient().when((Object)node.canAddMixin("exo:modify")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.canAddMixin("dc:elementSet")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasProperty("dc:description")).thenReturn((Object)false);
        Mockito.lenient().when((Object)node.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getNode("jcr:content")).thenReturn((Object)contentNode);
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)session);
        COMMONS_UTILS_UTIL.when(() -> CommonsUtils.getService(TagService.class)).thenReturn((Object)this.tagService);
        HashSet<TagName> tagNames = new HashSet<TagName>();
        tagNames.add(new TagName("test"));
        Mockito.lenient().when((Object)this.tagService.detectTagNames(ArgumentMatchers.anyString())).thenReturn(tagNames);
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)"path");
        org.exoplatform.social.core.identity.model.Identity audienceIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getOwnerIdentityFromNodePath((String)"path", (IdentityManager)this.identityManager, (SpaceService)this.spaceService)).thenReturn((Object)audienceIdentity);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.hasEditPermission((Session)session, (Node)node)).thenReturn((Object)true);
        Mockito.lenient().when((Object)audienceIdentity.getProviderId()).thenReturn((Object)"space");
        Space space = new Space();
        space.setId("1");
        Mockito.lenient().when((Object)audienceIdentity.getRemoteId()).thenReturn((Object)"testSpace");
        Mockito.lenient().when((Object)audienceIdentity.getId()).thenReturn((Object)"1");
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.lenient().when((Object)userIdentity.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)userIdentity);
        Mockito.lenient().when((Object)this.spaceService.getSpaceByPrettyName("testSpace")).thenReturn((Object)space);
        Mockito.lenient().when((Object)node.getIdentifier()).thenReturn((Object)"123");
        this.jcrDocumentFileStorage.updateDocumentDescription(1L, "123", "test description", identity);
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testFoldersThenFilesLoading() throws RepositoryException, ObjectNotFoundException, IllegalAccessException {
        Node parentNode = (Node)Mockito.mock(Node.class);
        Session userSession = (Session)Mockito.mock(Session.class);
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        DocumentFolderFilter filter = new DocumentFolderFilter("12e2", "", Long.valueOf(1L), "");
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)userSession);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)userSession, (String)filter.getParentFolderId())).thenReturn((Object)parentNode);
        Mockito.when((Object)parentNode.getName()).thenReturn((Object)"documents");
        Mockito.when((Object)parentNode.getNode(filter.getFolderPath())).thenReturn((Object)parentNode);
        filter.setSortField(DocumentSortField.MODIFIED_DATE);
        filter.setAscending(true);
        filter.setIncludeHiddenFiles(false);
        Mockito.when((Object)parentNode.getPath()).thenReturn((Object)"/documents/path");
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        QueryManager queryManager = (QueryManager)Mockito.mock(QueryManager.class);
        QueryImpl jcrQuery = (QueryImpl)Mockito.mock(QueryImpl.class);
        NodeIterator subItemsIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)userSession.getWorkspace()).thenReturn((Object)workspace);
        Node folderAbc = this.createFolderMock("Abc", Calendar.getInstance(), userSession);
        Node folderXyz = this.createFolderMock("Xyz", Calendar.getInstance(), userSession);
        Node folderEfg = this.createFolderMock("Efg", Calendar.getInstance(), userSession);
        Node file1 = this.createFileMock("file1", Calendar.getInstance(), userSession);
        Node file2 = this.createFileMock("file2", Calendar.getInstance(), userSession);
        Node symlinkFile2 = this.createSymlinkMock("file2FileIdentifier", "file2");
        Node symlinkFolderEfg = this.createSymlinkMock("EfgIdentifier", "Efg");
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)file1, (Object[])new Node[]{symlinkFile2, folderXyz, folderAbc, symlinkFolderEfg});
        Mockito.when((Object)queryResult.getNodes()).thenReturn((Object)subItemsIterator);
        Mockito.when((Object)workspace.getQueryManager()).thenReturn((Object)queryManager);
        Mockito.when((Object)queryManager.createQuery(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)jcrQuery);
        Mockito.when((Object)jcrQuery.execute()).thenReturn((Object)queryResult);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toNodes((IdentityManager)((IdentityManager)Mockito.any()), (Session)((Session)Mockito.any()), (NodeIterator)((NodeIterator)Mockito.any()), (Identity)((Identity)Mockito.any()), (SpaceService)((SpaceService)Mockito.any()), (boolean)ArgumentMatchers.anyBoolean(), (DocumentFolderFilter)((DocumentFolderFilter)Mockito.any()))).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFolderNode((IdentityManager)((IdentityManager)Mockito.any()), (Identity)((Identity)Mockito.any()), (Node)((Node)Mockito.any()), (String)((String)Mockito.any()), (SpaceService)((SpaceService)Mockito.any()))).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.retrieveFileProperties((IdentityManager)((IdentityManager)Mockito.any()), (Node)((Node)Mockito.any()), (Identity)((Identity)Mockito.any()), (AbstractNode)((AbstractNode)Mockito.any()), (SpaceService)((SpaceService)Mockito.any()))).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFileNode((IdentityManager)((IdentityManager)Mockito.any(IdentityManager.class)), (Identity)((Identity)Mockito.any(Identity.class)), (Node)((Node)Mockito.any(Node.class)), (String)ArgumentMatchers.anyString(), (SpaceService)((SpaceService)Mockito.any(SpaceService.class)))).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFileNode((IdentityManager)((IdentityManager)Mockito.any(IdentityManager.class)), (Identity)((Identity)Mockito.any(Identity.class)), (Node)((Node)Mockito.any(Node.class)), (FileNode)((FileNode)Mockito.any(FileNode.class)), (SpaceService)((SpaceService)Mockito.any(SpaceService.class)))).thenCallRealMethod();
        filter.setSortField(DocumentSortField.CREATED_DATE);
        filter.setAscending(true);
        List fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(2)).getName());
        filter.setAscending(false);
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(2)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        filter.setSortField(DocumentSortField.MODIFIED_DATE);
        filter.setAscending(true);
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(2)).getName());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        filter.setAscending(false);
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(2)).getName());
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        filter.setSortField(DocumentSortField.NAME);
        filter.setAscending(true);
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(2)).getName());
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        filter.setAscending(false);
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)folderXyz, (Object[])new Node[]{folderAbc, symlinkFolderEfg});
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 5);
        Assert.assertEquals((Object)"Abc", (Object)((AbstractNode)fileNodes.get(2)).getName());
        Assert.assertEquals((Object)"Xyz", (Object)((AbstractNode)fileNodes.get(0)).getName());
        Assert.assertEquals((Object)"Efg.lnk", (Object)((AbstractNode)fileNodes.get(1)).getName());
        Node file3 = this.createFileMock("file3", Calendar.getInstance(), userSession);
        Node file4 = this.createFileMock("file4", Calendar.getInstance(), userSession);
        Node file5 = this.createFileMock("file5", Calendar.getInstance(), userSession);
        Node file6 = this.createFileMock("file6", Calendar.getInstance(), userSession);
        Node file7 = this.createFileMock("file7", Calendar.getInstance(), userSession);
        Node file8 = this.createFileMock("file8", Calendar.getInstance(), userSession);
        Node file9 = this.createFileMock("file9", Calendar.getInstance(), userSession);
        Node file10 = this.createFileMock("file10", Calendar.getInstance(), userSession);
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)false, (Object[])new Boolean[]{true, true, true, true, true, true, true, true, true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)file1, (Object[])new Node[]{file2, file3, file4, file5, file6, file7, file8, file9, file10});
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 4);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((long)4L, (long)fileNodes.size());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)false, (Object[])new Boolean[]{true, true, true, true, true, true, true, true, true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)file1, (Object[])new Node[]{file2, file3, file4, file5, file6, file7, file8, file9, file10});
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 8);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((long)8L, (long)fileNodes.size());
        Mockito.when((Object)subItemsIterator.hasNext()).thenReturn((Object)false, (Object[])new Boolean[]{true, true, true, true, true, true, true, true, true, true, false});
        Mockito.when((Object)subItemsIterator.nextNode()).thenReturn((Object)file1, (Object[])new Node[]{file2, file3, file4, file5, file6, file7, file8, file9, file10});
        fileNodes = this.jcrDocumentFileStorage.getFolderChildNodes(filter, identity, 0, 12);
        Assert.assertNotNull((Object)fileNodes);
        Assert.assertEquals((long)10L, (long)fileNodes.size());
    }

    private Node createFolderMock(String name, Calendar createdDate, Session session) throws RepositoryException {
        Node folderMock = (Node)Mockito.mock(NodeImpl.class);
        Property namePropertyXyz = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)namePropertyXyz.getString()).thenReturn((Object)name);
        Mockito.when((Object)folderMock.getProperty("exo:title")).thenReturn((Object)namePropertyXyz);
        Mockito.when((Object)folderMock.getName()).thenReturn((Object)name);
        Mockito.when((Object)folderMock.isNodeType("nt:folder")).thenReturn((Object)true);
        Mockito.when((Object)folderMock.hasProperty("ecd:connected")).thenReturn((Object)false);
        Mockito.when((Object)folderMock.getPath()).thenReturn((Object)("/path/to/" + name));
        Mockito.when((Object)((NodeImpl)folderMock).getIdentifier()).thenReturn((Object)(name + "Identifier"));
        Mockito.when((Object)folderMock.hasProperty("exo:dateCreated")).thenReturn((Object)true);
        Property createdDateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)createdDateProperty.getDate()).thenReturn((Object)createdDate);
        Mockito.when((Object)folderMock.getProperty("exo:dateCreated")).thenReturn((Object)createdDateProperty);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)(name + "Identifier"))).thenReturn((Object)folderMock);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier(null, (String)(name + "Identifier"))).thenReturn((Object)folderMock);
        return folderMock;
    }

    private Node createFileMock(String name, Calendar createdDate, Session session) throws RepositoryException {
        Node fileMock = (Node)Mockito.mock(NodeImpl.class);
        Property nameProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)nameProperty.getString()).thenReturn((Object)name);
        Mockito.when((Object)fileMock.getProperty("exo:title")).thenReturn((Object)nameProperty);
        Mockito.when((Object)fileMock.getName()).thenReturn((Object)name);
        Mockito.when((Object)fileMock.isNodeType("nt:file")).thenReturn((Object)true);
        Mockito.when((Object)fileMock.hasProperty("ecd:connected")).thenReturn((Object)false);
        Mockito.when((Object)fileMock.getPath()).thenReturn((Object)("/path/to/" + name));
        Mockito.when((Object)((NodeImpl)fileMock).getIdentifier()).thenReturn((Object)(name + "FileIdentifier"));
        Mockito.when((Object)fileMock.hasProperty("exo:dateCreated")).thenReturn((Object)true);
        Property createdDateProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)createdDateProperty.getDate()).thenReturn((Object)createdDate);
        Mockito.when((Object)fileMock.getProperty("exo:dateCreated")).thenReturn((Object)createdDateProperty);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)(name + "FileIdentifier"))).thenReturn((Object)fileMock);
        Mockito.when((Object)JCRDocumentsUtil.getNodeByIdentifier(null, (String)(name + "FileIdentifier"))).thenReturn((Object)fileMock);
        return fileMock;
    }

    private Node createSymlinkMock(String nodeIdentifier, String nodeName) throws RepositoryException {
        Node symlink = (Node)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)symlink.isNodeType("exo:symlink")).thenReturn((Object)true);
        Property symlinkUUIDProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)symlinkUUIDProperty.getString()).thenReturn((Object)nodeIdentifier);
        Mockito.when((Object)symlink.getProperty("exo:uuid")).thenReturn((Object)symlinkUUIDProperty);
        Mockito.when((Object)symlink.getName()).thenReturn((Object)(nodeName + ".lnk"));
        Mockito.when((Object)symlink.getPath()).thenReturn((Object)("/path/to/" + nodeName));
        Property createdDate = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)createdDate.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)symlink.getProperty("exo:dateCreated")).thenReturn((Object)createdDate);
        Mockito.when((Object)symlink.hasProperty("exo:dateCreated")).thenReturn((Object)true);
        Mockito.when((Object)((NodeImpl)symlink).getIdentifier()).thenReturn((Object)(nodeName + "LinkIdentifier"));
        return symlink;
    }

    @After
    public void tearDown() throws Exception {
        JCR_DOCUMENTS_UTIL.reset();
    }

    public void countNodeAccessListTest() throws RepositoryException {
        ExtendedNode extendedNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        Mockito.lenient().when((Object)aclIdentity.getUserId()).thenReturn((Object)"john");
        AccessControlEntry accessControlEntry = new AccessControlEntry("*:/spaces/testspace", "read");
        AccessControlList acl1 = new AccessControlList("john", Arrays.asList(accessControlEntry));
        Mockito.lenient().when((Object)aclIdentity.isMemberOf(accessControlEntry.getMembershipEntry())).thenReturn((Object)true);
        Mockito.lenient().when((Object)extendedNode.getACL()).thenReturn((Object)acl1);
        Map accessList = this.jcrDocumentFileStorage.countNodeAccessList((Node)extendedNode, aclIdentity);
        Assert.assertEquals((Object)false, (Object)accessList.isEmpty());
        Assert.assertEquals((Object)true, accessList.get("canAccess"));
        Assert.assertEquals((Object)false, accessList.get("canEdit"));
        Assert.assertEquals((Object)false, accessList.get("canDelete"));
        AccessControlEntry accessControlEntry1 = new AccessControlEntry("*:/spaces/testspace", "set_property");
        AccessControlList acl2 = new AccessControlList("john", Arrays.asList(accessControlEntry, accessControlEntry1));
        Mockito.lenient().when((Object)aclIdentity.isMemberOf(accessControlEntry1.getMembershipEntry())).thenReturn((Object)true);
        Mockito.lenient().when((Object)extendedNode.getACL()).thenReturn((Object)acl2);
        Map accessList1 = this.jcrDocumentFileStorage.countNodeAccessList((Node)extendedNode, aclIdentity);
        Assert.assertEquals((Object)false, (Object)accessList1.isEmpty());
        Assert.assertEquals((Object)true, accessList1.get("canAccess"));
        Assert.assertEquals((Object)true, accessList1.get("canEdit"));
    }

    @Test
    public void createNewVersion() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        Node contentNode = (Node)Mockito.mock(Node.class);
        Version version = (Version)Mockito.mock(Version.class);
        Mockito.when((Object)session.getNodeByUUID("123")).thenReturn((Object)node);
        Mockito.when((Object)node.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)node.getNode("jcr:content")).thenReturn((Object)contentNode);
        Mockito.when((Object)contentNode.hasProperty("jcr:data")).thenReturn((Object)true);
        Mockito.when((Object)node.isNodeType("exo:modify")).thenReturn((Object)true);
        Mockito.when((Object)node.isCheckedOut()).thenReturn((Object)false);
        Mockito.when((Object)node.checkin()).thenReturn((Object)version);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toFileVersion((Version)version, (Node)node, (IdentityManager)this.identityManager)).thenReturn((Object)new FileVersion());
        this.jcrDocumentFileStorage.createNewVersion("123", "user", (InputStream)new ByteArrayInputStream("test".getBytes()));
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)1))).save();
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void moveDocument() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)identity.getUserId()).thenReturn((Object)"user");
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getIdentity(ArgumentMatchers.anyString())).thenReturn((Object)ownerIdentity);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (String)"user", (org.exoplatform.social.core.identity.model.Identity)ownerIdentity, (SessionProvider)sessionProvider)).thenReturn((Object)node);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        Mockito.when((Object)node.canAddMixin("exo:modify")).thenReturn((Object)true);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"path");
        Mockito.when((Object)node.getName()).thenReturn((Object)"test.docx");
        Mockito.when((Object)session.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)false);
        Mockito.when((Object)node.getSession()).thenReturn((Object)session);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)session.getWorkspace()).thenReturn((Object)workspace);
        this.jcrDocumentFileStorage.moveDocument(1L, "123", "destPath", identity, null);
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).move("path", "destPath/test.docx");
        ((Node)Mockito.verify((Object)node, (VerificationMode)Mockito.times((int)2))).save();
        Mockito.clearInvocations((Object[])new Workspace[]{workspace});
        Mockito.when((Object)session.itemExists("destPath/test.docx")).thenReturn((Object)true);
        Node destNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getItem("destPath/test.docx")).thenReturn((Object)destNode);
        Mockito.when((Object)destNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Assert.assertThrows(ObjectAlreadyExistsException.class, () -> this.jcrDocumentFileStorage.moveDocument(1L, "123", "destPath", identity, null));
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)0))).move(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
        Mockito.when((Object)session.itemExists("destPath/test.docx")).thenReturn((Object)true);
        Mockito.when((Object)session.getItem("destPath/test(1).docx")).thenReturn((Object)destNode);
        Mockito.when((Object)destNode.hasProperty("exo:title")).thenReturn((Object)true);
        Property jcrProperty = (Property)Mockito.mock(Property.class);
        Mockito.when((Object)destNode.getProperty("exo:title")).thenReturn((Object)jcrProperty);
        Value jcrValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)jcrProperty.getValue()).thenReturn((Object)jcrValue);
        Mockito.when((Object)jcrValue.getString()).thenReturn((Object)"test.docx");
        Mockito.when((Object)destNode.getSession()).thenReturn((Object)session);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.increaseNameIndex((String)ArgumentMatchers.anyString(), (int)Mockito.anyInt())).thenCallRealMethod();
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNewIndexedName((String)ArgumentMatchers.anyString(), (String)ArgumentMatchers.anyString())).thenCallRealMethod();
        this.jcrDocumentFileStorage.moveDocument(1L, "123", "destPath", identity, "keepBoth");
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).move("path", "destPath/test(1).docx");
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
        Node srcNode = (Node)Mockito.mock(Node.class);
        Node destContentNode = (Node)Mockito.mock(Node.class);
        Node srcContentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)session.getItem("destPath/test.docx")).thenReturn((Object)destNode);
        Mockito.when((Object)session.getItem("path")).thenReturn((Object)srcNode);
        Mockito.when((Object)destNode.isNodeType("mix:versionable")).thenReturn((Object)true);
        Mockito.when((Object)destNode.getNode("jcr:content")).thenReturn((Object)destContentNode);
        Mockito.when((Object)srcNode.getNode("jcr:content")).thenReturn((Object)srcContentNode);
        Mockito.when((Object)srcContentNode.getProperty("jcr:data")).thenReturn((Object)jcrProperty);
        Mockito.when((Object)jcrProperty.getValue()).thenReturn((Object)jcrValue);
        Mockito.when((Object)jcrValue.getStream()).thenReturn((Object)((InputStream)Mockito.mock(InputStream.class)));
        Mockito.when((Object)destNode.isNodeType("exo:modify")).thenReturn((Object)true);
        Mockito.when((Object)destNode.isCheckedOut()).thenReturn((Object)false);
        Mockito.clearInvocations((Object[])new Session[]{session});
        this.jcrDocumentFileStorage.moveDocument(1L, "123", "destPath", identity, "createNewVersion");
        ((Node)Mockito.verify((Object)destNode, (VerificationMode)Mockito.times((int)1))).save();
        ((Node)Mockito.verify((Object)srcNode, (VerificationMode)Mockito.times((int)1))).remove();
        ((Node)Mockito.verify((Object)destNode, (VerificationMode)Mockito.times((int)1))).checkin();
        ((Node)Mockito.verify((Object)destNode, (VerificationMode)Mockito.times((int)2))).checkout();
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
        Mockito.clearInvocations((Object[])new Object[]{workspace, session});
        this.jcrDocumentFileStorage.moveDocument(session, 1L, "123", "destPath", identity, "keepBoth");
        ((Workspace)Mockito.verify((Object)workspace, (VerificationMode)Mockito.times((int)1))).move("path", "destPath/test(1).docx");
        ((Session)Mockito.verify((Object)session, (VerificationMode)Mockito.times((int)1))).save();
    }

    @Test
    public void moveDocuments() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        AbstractNode abstractNode = (AbstractNode)Mockito.mock(AbstractNode.class);
        List<AbstractNode> documents = List.of(abstractNode);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("destPath", "destPath");
        params.put("ownerId", 1L);
        ActionData actionData = new ActionData();
        actionData.setActionType(ActionType.MOVE.name());
        actionData.setActionId("1");
        actionData.setIdentity(identity);
        actionData.setNumberOfItems(1);
        this.jcrDocumentFileStorage.moveDocuments(1, 1L, documents, "destPath", identity, 1L);
        ((BulkStorageActionService)Mockito.verify((Object)this.bulkStorageActionService, (VerificationMode)Mockito.times((int)1))).executeBulkAction(session, (DocumentFileStorage)this.jcrDocumentFileStorage, null, this.listenerService, null, documents, actionData, null, params, 1L);
        ((BulkStorageActionService)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.bulkStorageActionService)).executeBulkAction(session, (DocumentFileStorage)this.jcrDocumentFileStorage, null, this.listenerService, null, documents, actionData, null, params, 1L);
        Assert.assertThrows(Exception.class, () -> this.jcrDocumentFileStorage.moveDocuments(1, 1L, documents, "destPath", identity, 1L));
    }

    @Test
    public void importDocuments() throws Exception {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity ownerIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        UploadResource uploadResource = (UploadResource)Mockito.mock(UploadResource.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        ActionData actionData = new ActionData();
        actionData.setActionType(ActionType.IMPORT_ZIP.name());
        actionData.setActionId("1");
        actionData.setIdentity(identity);
        actionData.setParentFolderName("documents");
        actionData.setTempFolderPath(System.getProperty("java.io.tmpdir") + File.separator + "temp_import1");
        Mockito.when((Object)JCRDocumentsUtil.getFolderLink((Node)((Node)Mockito.any()), (Space)((Space)Mockito.any()))).thenReturn(null);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)ownerIdentity);
        NodeImpl parentNodeImp = (NodeImpl)Mockito.mock(NodeImpl.class);
        Mockito.when((Object)parentNodeImp.getName()).thenReturn((Object)"documents");
        Mockito.when((Object)parentNodeImp.getPath()).thenReturn((Object)"/documents/path");
        Mockito.when((Object)parentNodeImp.getNode((String)Mockito.any())).thenReturn((Object)parentNodeImp);
        Mockito.when((Object)this.uploadService.getUploadResource((String)Mockito.any())).thenReturn((Object)uploadResource);
        Mockito.when((Object)uploadResource.getEstimatedSize()).thenReturn((Object)123456.0);
        actionData.setSize(123456.0);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, null, (org.exoplatform.social.core.identity.model.Identity)ownerIdentity, (SessionProvider)sessionProvider)).thenReturn((Object)parentNodeImp);
        this.jcrDocumentFileStorage.importFiles("1", null, null, null, null, null, identity, "1", 1L);
        ((BulkStorageActionService)Mockito.verify((Object)this.bulkStorageActionService, (VerificationMode)Mockito.times((int)1))).executeBulkAction(session, (DocumentFileStorage)this.jcrDocumentFileStorage, null, this.listenerService, this.uploadService, null, actionData, (Node)parentNodeImp, null, 1L);
    }

    @Test
    public void TestUpdatePermission() throws RepositoryException {
        Identity aclIdentity = (Identity)Mockito.mock(Identity.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        org.exoplatform.social.core.identity.model.Identity identity1 = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        org.exoplatform.social.core.identity.model.Identity spaceIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Space space = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"group");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"/platform/users");
        Mockito.when((Object)identity1.getProviderId()).thenReturn((Object)"user");
        Mockito.when((Object)identity1.getRemoteId()).thenReturn((Object)"John");
        Mockito.when((Object)aclIdentity.getUserId()).thenReturn((Object)"user");
        Mockito.when((Object)spaceIdentity.getProviderId()).thenReturn((Object)"space");
        Mockito.when((Object)spaceIdentity.getRemoteId()).thenReturn((Object)"spaceTest");
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)aclIdentity)).thenReturn((Object)sessionProvider);
        Mockito.lenient().when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        ExtendedNode node = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        Mockito.lenient().when((Object)this.spaceService.getSpaceByPrettyName(spaceIdentity.getRemoteId())).thenReturn((Object)space);
        Mockito.lenient().when((Object)this.spaceService.getSpaceByGroupId(ArgumentMatchers.anyString())).thenReturn((Object)space);
        Mockito.lenient().when((Object)this.identityManager.getOrCreateUserIdentity(ArgumentMatchers.anyString())).thenReturn((Object)identity1);
        Mockito.lenient().when((Object)identity1.getId()).thenReturn((Object)"1");
        Mockito.lenient().when((Object)space.getGroupId()).thenReturn((Object)"/spaces/spaceTest");
        Mockito.lenient().when((Object)space.getId()).thenReturn((Object)"2");
        Mockito.lenient().when((Object)node.canAddMixin("exo:dateModified")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.canAddMixin("exo:lastModifiedDate")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.canAddMixin("exo:privilegeable")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.hasNode("jcr:content")).thenReturn((Object)true);
        NodePermission nodePermission = new NodePermission();
        ArrayList<PermissionEntry> permissionsList = new ArrayList<PermissionEntry>();
        permissionsList.add(new PermissionEntry(identity, "read", null));
        permissionsList.add(new PermissionEntry(identity1, "edit", null));
        permissionsList.add(new PermissionEntry(spaceIdentity, "edit", PermissionRole.MANAGERS_REDACTORS.name()));
        nodePermission.setPermissions(permissionsList);
        Mockito.when((Object)node.getACL()).thenReturn((Object)new AccessControlList("root", new ArrayList()));
        this.jcrDocumentFileStorage.updatePermissions("123", nodePermission, aclIdentity);
        ((ExtendedNode)Mockito.verify((Object)node)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("*:/platform/administrators") && Arrays.equals((Object[])map.get("*:/platform/administrators"), PermissionType.ALL)));
        ((ExtendedNode)Mockito.verify((Object)node)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("*:/platform/users") && Arrays.equals((Object[])map.get("*:/platform/users"), new String[]{"read"})));
        ((ExtendedNode)Mockito.verify((Object)node)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("John") && Arrays.equals((Object[])map.get("John"), PermissionType.ALL)));
        ((ExtendedNode)Mockito.verify((Object)node)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("redactor:/spaces/spaceTest") && Arrays.equals((Object[])map.get("redactor:/spaces/spaceTest"), PermissionType.ALL)));
        ((ExtendedNode)Mockito.verify((Object)node)).setPermissions((Map)Mockito.argThat(map -> map.containsKey("manager:/spaces/spaceTest") && Arrays.equals((Object[])map.get("redactor:/spaces/spaceTest"), PermissionType.ALL)));
        AccessControlList existingAccessList = new AccessControlList("root", new ArrayList());
        existingAccessList.addPermissions("removedUserCollaborator", new String[]{"read"});
        String spaceGroupId = "/spaces/removedSpaceCollaborator";
        existingAccessList.addPermissions("*:" + spaceGroupId, new String[]{"read"});
        Mockito.when((Object)node.getACL()).thenReturn((Object)existingAccessList);
        Mockito.when((Object)this.spaceService.getSpaceByGroupId(spaceGroupId)).thenReturn((Object)space);
        Mockito.when((Object)space.getPrettyName()).thenReturn((Object)"removedSpaceCollaborator");
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity(space.getPrettyName())).thenReturn((Object)spaceIdentity);
        Mockito.when((Object)spaceIdentity.getId()).thenReturn((Object)"3");
        org.exoplatform.social.core.identity.model.Identity userIdentity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("removedUserCollaborator")).thenReturn((Object)userIdentity);
        Mockito.when((Object)userIdentity.getId()).thenReturn((Object)"4");
        this.jcrDocumentFileStorage.updatePermissions("123", nodePermission, aclIdentity);
        Assert.assertEquals((long)2L, (long)nodePermission.getToUnShare().size());
        Assert.assertTrue((boolean)nodePermission.getToUnShare().containsKey(3L));
        Assert.assertTrue((boolean)nodePermission.getToUnShare().containsKey(4L));
    }

    private Session getMockedSession(Identity identity) throws RepositoryException {
        SessionProvider systemSessionprovider = (SessionProvider)Mockito.mock(SessionProvider.class);
        SESSION_PROVIDER.when(SessionProvider::createSystemProvider).thenReturn((Object)systemSessionprovider);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Session session = (Session)Mockito.mock(Session.class);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getUserSessionProvider((RepositoryService)this.repositoryService, (Identity)identity)).thenReturn((Object)sessionProvider);
        Mockito.when((Object)sessionProvider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        Mockito.when((Object)systemSessionprovider.getSession("collaboration", manageableRepository)).thenReturn((Object)session);
        return session;
    }

    @Test
    public void hasEditPermissions() throws RepositoryException {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityRegistry.getIdentity("user")).thenReturn((Object)identity);
        Session session = this.getMockedSession(identity);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getPath()).thenReturn((Object)"path");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.hasEditPermission((Session)session, (Node)node)).thenReturn((Object)true, new Object[]{false});
        Assert.assertTrue((boolean)this.jcrDocumentFileStorage.hasEditPermissions("123", identity));
        Assert.assertFalse((boolean)this.jcrDocumentFileStorage.hasEditPermissions("123", identity));
    }

    @Test
    public void getDocumentDownloadItem() throws RepositoryException {
        Session session = this.getMockedSession(null);
        NodeImpl node = (NodeImpl)Mockito.mock(NodeImpl.class);
        Node contentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.hasNode("jcr:content")).thenReturn((Object)true);
        Mockito.when((Object)node.getNode("jcr:content")).thenReturn((Object)contentNode);
        Mockito.when((Object)contentNode.hasProperty("jcr:data")).thenReturn((Object)true);
        ByteArrayInputStream inputStream = new ByteArrayInputStream("test".getBytes());
        Property dataProperty = (Property)Mockito.mock(Property.class);
        Value dataValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)dataProperty.getValue()).thenReturn((Object)dataValue);
        Property mimeTypeProperty = (Property)Mockito.mock(Property.class);
        Value mimeTypeValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)dataProperty.getValue()).thenReturn((Object)dataValue);
        Mockito.when((Object)dataValue.getStream()).thenReturn((Object)inputStream);
        Mockito.when((Object)mimeTypeProperty.getValue()).thenReturn((Object)mimeTypeValue);
        Mockito.when((Object)mimeTypeValue.getString()).thenReturn((Object)"application/pdf");
        Mockito.when((Object)contentNode.getProperty("jcr:data")).thenReturn((Object)dataProperty);
        Mockito.when((Object)contentNode.getProperty("jcr:mimeType")).thenReturn((Object)mimeTypeProperty);
        Mockito.when((Object)node.getIdentifier()).thenReturn((Object)"123");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.toDownloadItem((Node)node)).thenCallRealMethod();
        DownloadItem downloadItem = this.jcrDocumentFileStorage.getDocumentDownloadItem("123");
        Assert.assertNotNull((Object)downloadItem);
    }

    @Test
    public void downloadFolder() throws RepositoryException {
        Session session = this.getMockedSession(null);
        Node node = (Node)Mockito.mock(Node.class);
        Node parentNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)parentNode.getPath()).thenReturn((Object)"parentPath");
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)session, (String)"123")).thenReturn((Object)node);
        Mockito.when((Object)node.getParent()).thenReturn((Object)parentNode);
        String zipPath = this.jcrDocumentFileStorage.downloadFolder("123");
        Assert.assertNotNull((Object)zipPath);
    }

    @Test
    public void isDocumentSharedWithSamePermissionsTest() throws RepositoryException {
        ExtendedNode currentNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        ExtendedNode linkNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"USER");
        AccessControlEntry accessControlEntry = new AccessControlEntry("john", "edit");
        AccessControlList acl = new AccessControlList("john", Arrays.asList(accessControlEntry));
        Mockito.when((Object)currentNode.getACL()).thenReturn((Object)acl);
        Mockito.when((Object)linkNode.getACL()).thenReturn((Object)acl);
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"john");
        Assert.assertTrue((boolean)this.jcrDocumentFileStorage.isDocumentSharedWithSamePermissions((Node)currentNode, (Node)linkNode, identity));
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"space");
        Mockito.when((Object)identity.getRemoteId()).thenReturn((Object)"spaceTest");
        Space spaceTest = (Space)Mockito.mock(Space.class);
        Mockito.when((Object)this.spaceService.getSpaceByPrettyName(identity.getRemoteId())).thenReturn((Object)spaceTest);
        Mockito.when((Object)spaceTest.getGroupId()).thenReturn((Object)"/space/Test");
        AccessControlEntry accessControlEntry1 = new AccessControlEntry("*:/space/Test", "edit");
        AccessControlList acl1 = new AccessControlList("*:/space/Test", Arrays.asList(accessControlEntry1));
        Mockito.when((Object)currentNode.getACL()).thenReturn((Object)acl1);
        Mockito.when((Object)linkNode.getACL()).thenReturn((Object)acl1);
        Assert.assertTrue((boolean)this.jcrDocumentFileStorage.isDocumentSharedWithSamePermissions((Node)currentNode, (Node)linkNode, identity));
        AccessControlEntry accessControlEntry2 = new AccessControlEntry("*:/space/Test", "read");
        AccessControlList acl2 = new AccessControlList("*:/space/Test", Arrays.asList(accessControlEntry2));
        Mockito.when((Object)currentNode.getACL()).thenReturn((Object)acl1);
        Mockito.when((Object)linkNode.getACL()).thenReturn((Object)acl2);
        Assert.assertFalse((boolean)this.jcrDocumentFileStorage.isDocumentSharedWithSamePermissions((Node)currentNode, (Node)linkNode, identity));
    }

    @Test
    public void unShareDocumetTest() throws RepositoryException {
        Session systemSession = (Session)Mockito.mock(Session.class);
        org.exoplatform.social.core.identity.model.Identity identity = (org.exoplatform.social.core.identity.model.Identity)Mockito.mock(org.exoplatform.social.core.identity.model.Identity.class);
        Node rootNode = (Node)Mockito.mock(Node.class);
        Node sharedNode = (Node)Mockito.mock(Node.class);
        Node currentNode = (Node)Mockito.mock(ExtendedNode.class);
        ExtendedNode linkNode = (ExtendedNode)Mockito.mock(ExtendedNode.class);
        Mockito.when((Object)currentNode.isNodeType("exo:symlink")).thenReturn((Object)false);
        Mockito.when((Object)linkNode.isNodeType("exo:symlink")).thenReturn((Object)true);
        SessionProvider sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        Mockito.when((Object)SessionProvider.createSystemProvider()).thenReturn((Object)sessionProvider);
        ManageableRepository manageableRepository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        RepositoryEntry repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        Mockito.when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)manageableRepository);
        Mockito.when((Object)manageableRepository.getConfiguration()).thenReturn((Object)repositoryEntry);
        Mockito.when((Object)repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)"collaboration");
        Mockito.when((Object)sessionProvider.getSession(manageableRepository.getConfiguration().getDefaultWorkspaceName(), manageableRepository)).thenReturn((Object)systemSession);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getNodeByIdentifier((Session)systemSession, (String)"1")).thenReturn((Object)currentNode);
        JCR_DOCUMENTS_UTIL.when(() -> JCRDocumentsUtil.getIdentityRootNode((SpaceService)this.spaceService, (NodeHierarchyCreator)this.nodeHierarchyCreator, (org.exoplatform.social.core.identity.model.Identity)identity, (Session)systemSession)).thenReturn((Object)rootNode);
        Mockito.when((Object)identity.getProviderId()).thenReturn((Object)"USER");
        Mockito.when((Object)rootNode.getNode("Documents")).thenReturn((Object)rootNode);
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn(null);
        Assert.assertThrows(IllegalStateException.class, () -> this.jcrDocumentFileStorage.unShareDocument("1", 1L));
        Mockito.when((Object)this.identityManager.getIdentity("1")).thenReturn((Object)identity);
        Mockito.when((Object)rootNode.hasNode("Shared")).thenReturn((Object)false);
        ((ExtendedNode)Mockito.verify((Object)linkNode, (VerificationMode)Mockito.times((int)0))).remove();
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.when((Object)rootNode.hasNode("Shared")).thenReturn((Object)true);
        Mockito.when((Object)rootNode.getNode("Shared")).thenReturn((Object)sharedNode);
        Mockito.when((Object)sharedNode.hasNode(currentNode.getName())).thenReturn((Object)true);
        Mockito.when((Object)sharedNode.getNode(currentNode.getName())).thenReturn((Object)linkNode);
        this.jcrDocumentFileStorage.unShareDocument("1", 1L);
        ((ExtendedNode)Mockito.verify((Object)linkNode, (VerificationMode)Mockito.times((int)1))).remove();
        ((SessionProvider)Mockito.verify((Object)sessionProvider, (VerificationMode)Mockito.atLeast((int)1))).close();
    }
}

