/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.Parameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.documents.storage.jcr.TrashStorageImpl;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.WorkspaceImpl;
import org.exoplatform.services.jcr.impl.ext.action.SessionActionInterceptor;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.gatein.pc.api.PortletInvokerException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class TrashStorageImplTest {
    private IdentityManager identityManager;
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private ManageableRepository repository;
    private RepositoryEntry repositoryEntry;
    private SessionProvider sessionProvider;
    private Session session;
    private ListenerService listenerService;
    private TrashStorageImpl trashStorage;

    @Before
    public void setUp() throws PortletInvokerException {
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.listenerService = (ListenerService)Mockito.mock(ListenerService.class);
        this.repositoryService = (RepositoryService)Mockito.mock(RepositoryService.class);
        this.sessionProviderService = (SessionProviderService)Mockito.mock(SessionProviderService.class);
        this.repository = (ManageableRepository)Mockito.mock(ManageableRepository.class);
        this.repositoryEntry = (RepositoryEntry)Mockito.mock(RepositoryEntry.class);
        this.sessionProvider = (SessionProvider)Mockito.mock(SessionProvider.class);
        this.session = (Session)Mockito.mock(Session.class);
        this.trashStorage = new TrashStorageImpl(this.repositoryService, this.sessionProviderService, this.listenerService, this.getParams());
    }

    @Test
    public void testMoveToTrash() throws Exception {
        String username = "testuser";
        String currentRepository = "Collaboration";
        String path = "/document/name123";
        long currentOwnerId = 2L;
        Identity currentIdentity = new Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Node node = (Node)Mockito.mock(NodeImpl.class);
        Workspace workspace = (Workspace)Mockito.mock(WorkspaceImpl.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Mockito.lenient().when((Object)this.identityManager.getIdentity((String)ArgumentMatchers.eq((Object)String.valueOf(currentOwnerId)))).thenReturn((Object)currentIdentity);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository)).thenReturn((Object)this.session);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getWorkspace()).thenReturn((Object)workspace);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getNodes(ArgumentMatchers.anyString())).thenReturn((Object)nodeIterator);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getWorkspace().getName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        Session session1 = (Session)Mockito.mock(SessionImpl.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        SessionActionInterceptor sessionActionInterceptor = (SessionActionInterceptor)Mockito.mock(SessionActionInterceptor.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)path);
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)session1);
        Mockito.lenient().when((Object)node.getSession().getWorkspace()).thenReturn((Object)workspace);
        Mockito.lenient().when((Object)session1.getWorkspace().getName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)node.getParent()).thenReturn((Object)node);
        Mockito.lenient().when((Object)((SessionImpl)node.getSession()).getActionHandler()).thenReturn((Object)sessionActionInterceptor);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Mockito.lenient().when((Object)this.session.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.session.getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.lenient().when((Object)node.isNodeType("exo:symlink")).thenReturn((Object)false);
        Mockito.lenient().when((Object)node.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.lenient().when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.lenient().when((Object)node.getPrimaryNodeType().getName()).thenReturn((Object)"nt:file");
        String trashId = this.trashStorage.moveToTrash(node, this.sessionProvider, 0);
        Assert.assertNotNull((Object)trashId);
    }

    @Test
    public void testRestoreFromTrash() throws Exception {
        String username = "testuser";
        String currentRepository = "Collaboration";
        String path = "/document/name123";
        long currentOwnerId = 2L;
        Identity currentIdentity = new Identity("organization", username);
        currentIdentity.setId(String.valueOf(currentOwnerId));
        Profile currentProfile = new Profile();
        currentProfile.setProperty("fullName", (Object)username);
        currentIdentity.setProfile(currentProfile);
        Node node = (Node)Mockito.mock(NodeImpl.class);
        Workspace workspace = (Workspace)Mockito.mock(WorkspaceImpl.class);
        NodeIterator nodeIterator = (NodeIterator)Mockito.mock(NodeIterator.class);
        Session session1 = (Session)Mockito.mock(SessionImpl.class);
        NodeType nodeType = (NodeType)Mockito.mock(NodeType.class);
        Mockito.lenient().when((Object)this.identityManager.getIdentity((String)ArgumentMatchers.eq((Object)String.valueOf(currentOwnerId)))).thenReturn((Object)currentIdentity);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository)).thenReturn((Object)this.session);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getWorkspace()).thenReturn((Object)workspace);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString()))).thenReturn((Object)node);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getNodes(ArgumentMatchers.anyString())).thenReturn((Object)nodeIterator);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getSession()).thenReturn((Object)session1);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getSession().getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Property property = (Property)Mockito.mock(Property.class);
        Property pathProperty = (Property)Mockito.mock(Property.class);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getProperty("exo:restoreWorkspace")).thenReturn((Object)property);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getProperty("exo:restoreWorkspace").getString()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getProperty("exo:restorePath")).thenReturn((Object)pathProperty);
        Mockito.lenient().when((Object)((Node)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getItem(ArgumentMatchers.anyString())).getProperty("exo:restorePath").getString()).thenReturn((Object)path);
        Mockito.lenient().when((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getWorkspace().getName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)this.sessionProviderService.getSessionProvider(ArgumentMatchers.any())).thenReturn((Object)this.sessionProvider);
        Mockito.lenient().when((Object)this.repositoryService.getCurrentRepository()).thenReturn((Object)this.repository);
        Mockito.lenient().when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.lenient().when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)this.sessionProvider.getSession((String)ArgumentMatchers.any(), (ManageableRepository)ArgumentMatchers.any())).thenReturn((Object)this.session);
        SessionActionInterceptor sessionActionInterceptor = (SessionActionInterceptor)Mockito.mock(SessionActionInterceptor.class);
        Mockito.lenient().when((Object)node.getUUID()).thenReturn((Object)"id123");
        Mockito.lenient().when((Object)node.getName()).thenReturn((Object)"name123");
        Mockito.lenient().when((Object)node.getPath()).thenReturn((Object)path);
        Mockito.lenient().when((Object)node.getSession()).thenReturn((Object)session1);
        Mockito.lenient().when((Object)node.getSession().getWorkspace()).thenReturn((Object)workspace);
        Mockito.lenient().when((Object)session1.getWorkspace().getName()).thenReturn((Object)currentRepository);
        Mockito.lenient().when((Object)node.getParent()).thenReturn((Object)node);
        Mockito.lenient().when((Object)((SessionImpl)node.getSession()).getActionHandler()).thenReturn((Object)sessionActionInterceptor);
        Mockito.lenient().when((Object)this.session.getNodeByUUID((String)ArgumentMatchers.eq((Object)"id123"))).thenReturn((Object)node);
        Mockito.lenient().when((Object)this.session.itemExists(ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.lenient().when((Object)this.session.getItem(ArgumentMatchers.anyString())).thenReturn((Object)node);
        Mockito.lenient().when((Object)node.isNodeType("exo:restoreWorkspace")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.isNodeType("exo:restorePath")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.isNodeType("mix:referenceable")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.isNodeType("exo:restoreLocation")).thenReturn((Object)true);
        Mockito.lenient().when((Object)node.getNodes()).thenReturn((Object)nodeIterator);
        Mockito.lenient().when((Object)node.getPrimaryNodeType()).thenReturn((Object)nodeType);
        Mockito.lenient().when((Object)node.getPrimaryNodeType().getName()).thenReturn((Object)"nt:file");
        this.trashStorage.restoreFromTrash("/trash/document/name123", this.sessionProvider);
        ((Session)Mockito.verify((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository), (VerificationMode)Mockito.times((int)3))).save();
        ((Workspace)Mockito.verify((Object)this.sessionProviderService.getSystemSessionProvider(ArgumentMatchers.any()).getSession("trashWorkspace", this.repository).getWorkspace(), (VerificationMode)Mockito.times((int)1))).move(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    private InitParams getParams() {
        InitParams params = new InitParams();
        PropertiesParam propertiesParam = new PropertiesParam();
        propertiesParam.setName("constructor.params");
        propertiesParam.setProperty("trashWorkspace", "trashWorkspace");
        PropertiesParam propertiesParam1 = new PropertiesParam();
        propertiesParam1.setName("constructor.params");
        propertiesParam1.setProperty("trashHomeNodePath", "trashHomeNodePath");
        ValueParam valueParam = new ValueParam();
        valueParam.setName("trashWorkspace");
        valueParam.setValue("trashWorkspace");
        ValueParam valueParam1 = new ValueParam();
        valueParam1.setName("trashHomeNodePath");
        valueParam1.setValue("trashHomeNodePath");
        params.addParameter((Parameter)propertiesParam);
        params.addParameter((Parameter)propertiesParam1);
        params.addParameter((Parameter)valueParam);
        params.addParameter((Parameter)valueParam1);
        return params;
    }
}

