/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.listener;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class HideFolderListener
extends Listener<Node, Boolean> {
    private static final Log LOG = ExoLogger.getLogger(HideFolderListener.class);

    public void onEvent(Event<Node, Boolean> event) throws RepositoryException {
        Boolean hidden = (Boolean)event.getData();
        Node folder = (Node)event.getSource();
        String statementOfFolders = this.getFolderDocumentsQuery(folder.getPath());
        Query jcrQuery = folder.getSession().getWorkspace().getQueryManager().createQuery(statementOfFolders, "sql");
        QueryResult queryResult = jcrQuery.execute();
        NodeIterator nodeIterator = queryResult.getNodes();
        while (nodeIterator.hasNext()) {
            Node node = nodeIterator.nextNode();
            try {
                boolean isAlreadyHidden = node.isNodeType("exo:hiddenable");
                if (hidden.booleanValue() && !isAlreadyHidden) {
                    node.addMixin("exo:hiddenable");
                    continue;
                }
                if (hidden.booleanValue() || !isAlreadyHidden) break;
                node.removeMixin("exo:hiddenable");
            }
            catch (RepositoryException e) {
                LOG.error((Object)("Cannot hide/unhide documents under folder:" + folder.getPath()), (Throwable)e);
            }
        }
        folder.save();
    }

    private String getFolderDocumentsQuery(String folderPath) {
        return "SELECT * FROM nt:base" + " WHERE jcr:path LIKE '" + folderPath + "/%'" + " AND NOT jcr:path LIKE '" + folderPath + "/%/%' ";
    }
}

