/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr.webdav;

import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.lock.Lock;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import org.exoplatform.documents.storage.jcr.webdav.JcrWebDavService;
import org.exoplatform.documents.storage.jcr.webdav.model.JcrNamespaceContext;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavReadCommandHandler;
import org.exoplatform.documents.storage.jcr.webdav.plugin.WebdavWriteCommandHandler;
import org.exoplatform.documents.webdav.model.WebDavFileDownload;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavLockResponse;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.impl.RepositoryContainer;
import org.exoplatform.services.jcr.impl.RepositoryServiceImpl;
import org.exoplatform.services.jcr.impl.WorkspaceContainer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class JcrWebDavServiceTest {
    private static final String REPOSITORY_NAME = "repository";
    private static final List<String> LOCK_TOKENS = Collections.singletonList("lockToken");
    private static final String USERNAME = "username";
    private static final String BASE_URI = "baseUri";
    private static final Set<QName> REQUESTED_PROPERTY_NAMES = Collections.singleton(PropertyConstants.DISPLAYNAME);
    private static final String PROP_REQUEST_TYPE = "include";
    private static final String QUERY_LANGUAGE = "queryLanguage";
    private static final String QUERY = "query";
    private static final String FILE_VERSION = "v1";
    private static final String WEBDAV_PATH = "/path/to/file";
    private static final String LOCKED = "/locked";
    private static final String WS_NAME = "test";
    @Mock
    private WebdavReadCommandHandler readCommandHandler;
    @Mock
    private WebdavWriteCommandHandler writeCommandHandler;
    @Mock
    private RepositoryServiceImpl repositoryService;
    @Mock
    private UserACL userACL;
    @Mock
    private Session session;
    @Mock
    private NamespaceRegistry nsRegistry;
    @Mock
    private Node node;
    @Mock
    private Lock lock;
    @InjectMocks
    private JcrWebDavService service;
    @Mock
    private ManageableRepository repository;
    @Mock
    private RepositoryContainer repositoryContainer;
    @Mock
    private WorkspaceContainer workspaceContainer;
    @Mock
    private ContainerEntry containerEntry;
    @Mock
    private RepositoryEntry repositoryEntry;
    @Mock
    private WorkspaceEntry workspaceEntry;
    @Mock
    private Workspace workspace;

    @Before
    public void setUp() {
        Mockito.when((Object)this.repositoryService.getDefaultRepository()).thenReturn((Object)this.repository);
        Mockito.when((Object)this.repositoryService.getRepositoryContainer(REPOSITORY_NAME)).thenReturn((Object)this.repositoryContainer);
        Mockito.when((Object)this.repositoryContainer.getWorkspaceContainer(WS_NAME)).thenReturn((Object)this.workspaceContainer);
        Mockito.when((Object)this.repository.getSystemSession(ArgumentMatchers.anyString())).thenReturn((Object)this.session);
        Mockito.when((Object)this.repository.getNamespaceRegistry()).thenReturn((Object)this.nsRegistry);
        Mockito.when((Object)this.nsRegistry.getPrefixes()).thenReturn((Object)new String[]{"pfx"});
        Mockito.when((Object)this.nsRegistry.getURI("pfx")).thenReturn((Object)"uri");
        Mockito.when((Object)this.repository.getConfiguration()).thenReturn((Object)this.repositoryEntry);
        Mockito.when((Object)this.repositoryEntry.getDefaultWorkspaceName()).thenReturn((Object)WS_NAME);
        Mockito.when((Object)this.repository.getSystemSession(WS_NAME)).thenReturn((Object)this.session);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)this.workspace);
        Mockito.when((Object)((WorkspaceEntry)this.workspaceContainer.getComponentInstanceOfType(WorkspaceEntry.class, false))).thenReturn((Object)this.workspaceEntry);
        Mockito.when((Object)this.workspaceEntry.getContainer()).thenReturn((Object)this.containerEntry);
        this.service = (JcrWebDavService)Mockito.spy((Object)this.service);
        ((JcrWebDavService)Mockito.doReturn((Object)this.session).when((Object)this.service)).newSession(ArgumentMatchers.anyString(), (ManageableRepository)ArgumentMatchers.any(), (WorkspaceContainer)ArgumentMatchers.any());
    }

    @Test
    public void testGetDaslValue() {
        Assert.assertEquals((Object)"<DAV:basicsearch><exo:sql xmlns:exo=\"http://exoplatform.com/jcr\"/><exo:xpath xmlns:exo=\"http://exoplatform.com/jcr\"/>", (Object)this.service.getDaslValue());
    }

    @Test
    public void testGetLastModifiedDate() {
        long lastModifiedDate = this.service.getLastModifiedDate(WEBDAV_PATH, FILE_VERSION);
        Assert.assertEquals((long)0L, (long)lastModifiedDate);
        ((WebdavReadCommandHandler)Mockito.verify((Object)this.readCommandHandler)).getLastModifiedDate((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH), (String)ArgumentMatchers.eq((Object)FILE_VERSION));
    }

    @Test
    public void testGet() {
        Mockito.when((Object)this.readCommandHandler.get((Session)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyInt(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn((Object)((WebDavItem)Mockito.mock(WebDavItem.class)));
        WebDavItem webDavItem = this.service.get(WEBDAV_PATH, PROP_REQUEST_TYPE, REQUESTED_PROPERTY_NAMES, true, 3, BASE_URI, USERNAME);
        Assert.assertNotNull((Object)webDavItem);
        ((WebdavReadCommandHandler)Mockito.verify((Object)this.readCommandHandler)).get((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH), (Set)ArgumentMatchers.eq(REQUESTED_PROPERTY_NAMES), ArgumentMatchers.eq((boolean)true), ArgumentMatchers.eq((int)3), (String)ArgumentMatchers.eq((Object)BASE_URI), (String)ArgumentMatchers.eq((Object)USERNAME));
    }

    @Test
    public void testSearch() {
        Mockito.when((Object)this.readCommandHandler.search((Session)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        List webDavItems = this.service.search(WEBDAV_PATH, QUERY_LANGUAGE, QUERY, BASE_URI, USERNAME);
        Assert.assertNotNull((Object)webDavItems);
        ((WebdavReadCommandHandler)Mockito.verify((Object)this.readCommandHandler)).search((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)QUERY_LANGUAGE), (String)ArgumentMatchers.eq((Object)QUERY), (String)ArgumentMatchers.eq((Object)BASE_URI), (String)ArgumentMatchers.eq((Object)USERNAME));
    }

    @Test
    public void testGetVersions() {
        Mockito.when((Object)this.readCommandHandler.getVersions((Session)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(Collections.emptyList());
        List webDavItems = this.service.getVersions(WEBDAV_PATH, REQUESTED_PROPERTY_NAMES, BASE_URI, USERNAME);
        Assert.assertNotNull((Object)webDavItems);
        ((WebdavReadCommandHandler)Mockito.verify((Object)this.readCommandHandler)).getVersions((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH), (Set)ArgumentMatchers.eq(REQUESTED_PROPERTY_NAMES), (String)ArgumentMatchers.eq((Object)BASE_URI));
    }

    @Test
    public void testCheckin() {
        this.service.checkin(WEBDAV_PATH, LOCK_TOKENS, USERNAME);
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).checkin((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH));
    }

    @Test
    public void testCheckout() {
        this.service.checkout(WEBDAV_PATH, LOCK_TOKENS, USERNAME);
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).checkout((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH));
    }

    @Test
    public void testUncheckout() {
        this.service.uncheckout(WEBDAV_PATH, LOCK_TOKENS, USERNAME);
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).uncheckout((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH));
    }

    @Test
    public void testUnlock() {
        this.service.unlock(WEBDAV_PATH, LOCK_TOKENS, USERNAME);
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).unlock((Session)ArgumentMatchers.any(Session.class), (String)ArgumentMatchers.eq((Object)WEBDAV_PATH), (List)ArgumentMatchers.eq(LOCK_TOKENS));
    }

    @Test
    public void testGetNamespaceContextBuildsAndCaches() {
        NamespaceContext ctx1 = this.service.getNamespaceContext();
        NamespaceContext ctx2 = this.service.getNamespaceContext();
        Assert.assertTrue((boolean)(ctx1 instanceof JcrNamespaceContext));
        Assert.assertSame((Object)ctx1, (Object)ctx2);
    }

    @Test
    public void testIsFileDelegatesAndClosesSession() {
        Mockito.when((Object)this.readCommandHandler.isFile(this.session, "/a")).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.service.isFile("/a"));
        ((Session)Mockito.verify((Object)this.session)).logout();
    }

    @Test
    public void testDownloadDelegates() {
        WebDavFileDownload d = new WebDavFileDownload(null, 0L, 0L, null, null);
        Mockito.when((Object)this.readCommandHandler.download(this.session, "/a", FILE_VERSION)).thenReturn((Object)d);
        Assert.assertEquals((Object)d, (Object)this.service.download("/a", FILE_VERSION, "", "user"));
        ((Session)Mockito.verify((Object)this.session)).logout();
    }

    @Test
    public void testCreateFolderChecksLockAndDelegates() {
        this.service.createFolder("/a", "", "", "", Collections.emptyList(), "user");
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).createFolder((Session)ArgumentMatchers.eq((Object)this.session), (String)ArgumentMatchers.eq((Object)"/a"), (List)ArgumentMatchers.any());
    }

    @Test
    public void testSaveFileChecksLockAndDelegates() {
        InputStream is = (InputStream)Mockito.mock(InputStream.class);
        this.service.saveFile("/a", "", "", "", "", is, Collections.emptyList(), "user");
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).saveFile((Session)ArgumentMatchers.eq((Object)this.session), (String)ArgumentMatchers.eq((Object)"/a"), ArgumentMatchers.anyString(), (List)ArgumentMatchers.any(), (InputStream)ArgumentMatchers.eq((Object)is));
    }

    @Test
    public void testDeleteChecksLockAndDelegates() {
        this.service.delete("/a", Collections.emptyList(), "user");
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).delete(this.session, "/a");
    }

    @Test
    public void testMoveChecksLockAndDelegates() {
        Mockito.when((Object)this.writeCommandHandler.move(this.session, "/a", "/b", true)).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.service.move("/a", "/b", true, Collections.emptyList(), "user"));
    }

    @Test
    public void testCopyChecksLockAndDelegates() {
        this.service.copy("/a", "/b", 1, true, true, null, Collections.emptyList(), "user");
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).copy(this.session, "/a", "/b", true, true);
    }

    @Test
    public void testSavePropertiesChecksLockAndDelegates() {
        HashMap result = new HashMap();
        Mockito.when((Object)this.writeCommandHandler.saveProperties(this.session, "/a", null, null)).thenReturn(result);
        Assert.assertEquals(result, (Object)this.service.saveProperties("/a", null, null, Collections.emptyList(), "user"));
    }

    @Test
    public void testEnableVersioningChecksLockAndDelegates() {
        this.service.enableVersioning("/a", Collections.emptyList(), "user");
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler)).enableVersioning(this.session, "/a");
    }

    @Test
    public void testLockChecksLockAndDelegates() {
        WebDavLockResponse resp = new WebDavLockResponse("", "");
        Mockito.when((Object)this.writeCommandHandler.lock(this.session, "/a", 0, 0, true, "user")).thenReturn((Object)resp);
        Assert.assertEquals((Object)resp, (Object)this.service.lock("/a", 0, 0, true, Collections.emptyList(), "user"));
    }

    @Test
    public void testOrderChecksLockAndDelegates() {
        Mockito.when((Object)this.writeCommandHandler.order(this.session, "/a", Collections.emptyList())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.service.order("/a", Collections.emptyList(), Collections.emptyList(), "user"));
    }

    @Test
    public void testUnlockTimedOutNodesWithItems() {
        Mockito.when((Object)this.writeCommandHandler.getOutdatedLockedNodePaths()).thenReturn(Arrays.asList("/p1", "/p2"));
        this.service.unlockTimedOutNodes();
        ((WebdavWriteCommandHandler)Mockito.verify((Object)this.writeCommandHandler, (VerificationMode)Mockito.atLeastOnce())).unlockNode((Session)ArgumentMatchers.eq((Object)this.session), ArgumentMatchers.anyString());
    }

    @Test
    public void testCheckLockThrowsWhenLockedByOther() {
        Mockito.when((Object)this.session.itemExists(LOCKED)).thenReturn((Object)true);
        Mockito.when((Object)this.session.getItem(LOCKED)).thenReturn((Object)this.node);
        Mockito.when((Object)this.node.isLocked()).thenReturn((Object)true);
        Mockito.when((Object)this.node.getLock()).thenReturn((Object)this.lock);
        Mockito.when((Object)this.lock.getLockToken()).thenReturn((Object)"t1");
        Mockito.when((Object)this.lock.getLockOwner()).thenReturn((Object)"owner");
        List<String> tokens = Collections.singletonList("other");
        try {
            this.service.getClass().getDeclaredMethod("checkLock", Session.class, String.class, List.class).setAccessible(true);
            this.service.getClass().getDeclaredMethod("checkLock", Session.class, String.class, List.class).invoke((Object)this.service, this.session, LOCKED, tokens);
            Assert.fail((String)"Expected WebDavException");
        }
        catch (Exception exception) {}
    }
}

