/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.storage.jcr;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.documents.constant.DocumentSortField;
import org.exoplatform.documents.model.TrashElementNodeFilter;
import org.exoplatform.documents.storage.TrashStorage;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.ActivityTypeUtils;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.ItemImpl;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.query.QueryImpl;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferencesInfo;

public class TrashStorageImpl
implements TrashStorage {
    private static final String FILE_EXPLORER_PORTLET = "FileExplorerPortlet";
    private static final String TRASH_WORKSPACE = "trashWorkspace";
    private static final String TRASH_HOME_PATH = "trashHomeNodePath";
    private static final String SELECT_FROM_TRASH_QUERY = "SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL";
    private RepositoryService repositoryService;
    private SessionProviderService sessionProviderService;
    private ListenerService listenerService;
    private String trashWorkspace;
    private String trashHome;
    private static final Log LOG = ExoLogger.getLogger((String)TrashStorageImpl.class.getName());

    public TrashStorageImpl(RepositoryService repositoryService, SessionProviderService sessionProviderService, ListenerService listenerService, InitParams initParams) throws PortletInvokerException {
        this.repositoryService = repositoryService;
        this.sessionProviderService = sessionProviderService;
        this.listenerService = listenerService;
        this.trashWorkspace = initParams.getValueParam(TRASH_WORKSPACE).getValue();
        this.trashHome = initParams.getValueParam(TRASH_HOME_PATH).getValue();
        ExoContainer manager = ExoContainerContext.getCurrentContainer();
        PortletInvoker portletInvoker = (PortletInvoker)manager.getComponentInstance(PortletInvoker.class);
        if (portletInvoker != null) {
            Set portlets = portletInvoker.getPortlets();
            for (Portlet portlet : portlets) {
                PortletInfo info = portlet.getInfo();
                String portletName = info.getName();
                if (!FILE_EXPLORER_PORTLET.equalsIgnoreCase(portletName)) continue;
                PreferencesInfo prefs = info.getPreferences();
                String trashWorkspaceParam = (String)prefs.getPreference(TRASH_WORKSPACE).getDefaultValue().get(0);
                String trashHomeParam = (String)prefs.getPreference(TRASH_HOME_PATH).getDefaultValue().get(0);
                if (trashWorkspaceParam != null && !trashWorkspaceParam.equals(this.trashWorkspace)) {
                    this.trashWorkspace = trashWorkspaceParam;
                }
                if (trashHomeParam == null || trashHomeParam.equals(this.trashHome)) break;
                this.trashHome = trashHomeParam;
                break;
            }
        }
    }

    public String moveToTrash(Node node, SessionProvider sessionProvider) throws RepositoryException {
        return this.moveToTrash(node, sessionProvider, 0);
    }

    public String moveToTrash(Node node, SessionProvider sessionProvider, int deep) throws RepositoryException {
        Session nodeSession;
        String nodeName;
        String trashId;
        block17: {
            ((SessionImpl)node.getSession()).getActionHandler().preRemoveItem((ItemImpl)node);
            trashId = null;
            nodeName = node.getName();
            nodeSession = node.getSession();
            nodeSession.checkPermission(node.getPath(), "remove");
            if (deep == 0 && !node.isNodeType("exo:symlink")) {
                try {
                    this.removeDeadSymlinks(node);
                }
                catch (Exception e) {
                    if (!LOG.isWarnEnabled()) break block17;
                    LOG.warn((Object)e.getMessage());
                }
            }
        }
        try {
            if (node.getPrimaryNodeType().getName().equals("nt:file") || node.isNodeType("exo:symlink")) {
                if (this.isBroadcastNTFileEvents(node)) {
                    this.listenerService.broadcast("FileActivityNotify.event.FileRemoved", null, (Object)node);
                }
            } else {
                this.listenerService.broadcast("FileActivityNotify.event.FileRemoved", null, (Object)node);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
        }
        String nodeWorkspaceName = nodeSession.getWorkspace().getName();
        if (!node.isNodeType("exo:restoreLocation")) {
            String taxonomyLinkWS;
            String restorePath = this.fixRestorePath(node.getPath());
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            Session trashSession = this.sessionProviderService.getSystemSessionProvider(null).getSession(this.trashWorkspace, manageableRepository);
            String actualTrashPath = this.trashHome + (this.trashHome.endsWith("/") ? "" : "/") + this.fixRestorePath(nodeName);
            if (trashSession.getWorkspace().getName().equals(nodeSession.getWorkspace().getName())) {
                trashSession.getWorkspace().move(node.getPath(), actualTrashPath);
            } else {
                trashSession.getWorkspace().clone(nodeWorkspaceName, node.getPath(), actualTrashPath, true);
                node.remove();
            }
            trashId = this.addRestorePathInfo(nodeName, restorePath, nodeWorkspaceName);
            trashSession.save();
            String taxonomyLinkUUID = node.isNodeType("exo:taxonomyLink") ? node.getProperty("exo:uuid").getString() : null;
            String string = taxonomyLinkWS = node.isNodeType("exo:taxonomyLink") ? node.getProperty("exo:workspace").getString() : null;
            if (deep == 0 && taxonomyLinkUUID != null && taxonomyLinkWS != null) {
                Node targetNode;
                block18: {
                    Session targetNodeSession = sessionProvider.getSession(taxonomyLinkWS, manageableRepository);
                    targetNode = null;
                    try {
                        targetNode = targetNodeSession.getNodeByUUID(taxonomyLinkUUID);
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) break block18;
                        LOG.warn((Object)e.getMessage());
                    }
                }
                if (targetNode != null) {
                    List<Node> symlinks = this.getAllLinks(targetNode, "exo:symlink", sessionProvider);
                    boolean found = false;
                    for (Node symlink : symlinks) {
                        if (symlink.isNodeType("exo:restoreLocation")) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.moveToTrash(targetNode, sessionProvider);
                    }
                }
            }
            trashSession.save();
        }
        return trashId;
    }

    public void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider) throws RepositoryException {
        this.restoreFromTrash(trashNodePath, sessionProvider, 0);
    }

    public List<Node> getAllNodeInTrash(SessionProvider sessionProvider) throws RepositoryException {
        StringBuilder query = new StringBuilder(SELECT_FROM_TRASH_QUERY);
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    public List<Node> getAllNodeInTrashByUser(SessionProvider sessionProvider, String userName) throws RepositoryException {
        StringBuilder query = new StringBuilder("SELECT * FROM nt:base WHERE exo:restorePath IS NOT NULL AND exo:lastModifier='").append(userName).append("'");
        return this.selectNodesByQuery(sessionProvider, query.toString(), "sql");
    }

    public void removeRelations(Node node, SessionProvider sessionProvider) throws RepositoryException {
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        String[] workspaces = manageableRepository.getWorkspaceNames();
        String queryString = "SELECT * FROM exo:relationable WHERE exo:relation IS NOT NULL";
        boolean error = false;
        for (String ws : workspaces) {
            Session session = sessionProvider.getSession(ws, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(queryString, "sql");
            QueryResult queryResult = query.execute();
            NodeIterator iter = queryResult.getNodes();
            while (iter.hasNext()) {
                try {
                    iter.nextNode().removeMixin("exo:relationable");
                    session.save();
                }
                catch (Exception e) {
                    error = true;
                }
            }
        }
        if (error) {
            throw new RepositoryException("Can't remove exo:relationable of all related nodes");
        }
    }

    public boolean isInTrash(Node node) throws RepositoryException {
        return node.getPath().startsWith(this.trashHome) && !node.getPath().equals(this.trashHome);
    }

    public Node getTrashHomeNode() {
        try {
            Session session = this.sessionProviderService.getSystemSessionProvider(null).getSession(this.trashWorkspace, this.repositoryService.getCurrentRepository());
            return (Node)session.getItem(this.trashHome);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Node getNodeByTrashId(String trashId) throws RepositoryException {
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.trashWorkspace, this.repositoryService.getCurrentRepository());
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT * from exo:restoreLocation WHERE exo:trashId = '").append(trashId).append("'");
        QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
        query.setLimit(1L);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        if (iter.hasNext()) {
            return iter.nextNode();
        }
        return null;
    }

    public List<Node> getAllLinks(Node targetNode, String linkType, SessionProvider sessionProvider) {
        try {
            ArrayList<Node> result = new ArrayList<Node>();
            if (sessionProvider != null) {
                ManageableRepository repository = this.repositoryService.getCurrentRepository();
                String workspace = targetNode.getSession().getWorkspace().getName();
                Session session = sessionProvider.getSession(workspace, repository);
                String queryString = "SELECT * FROM " + linkType + " WHERE exo:uuid='" + ((ExtendedNode)targetNode).getIdentifier() + "'" + " AND exo:workspace='" + workspace + "'";
                QueryManager queryManager = session.getWorkspace().getQueryManager();
                Query query = queryManager.createQuery(queryString, "sql");
                QueryResult queryResult = query.execute();
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    result.add(iter.nextNode());
                }
            }
            return result;
        }
        catch (RepositoryException e) {
            return new ArrayList<Node>();
        }
    }

    private void removeDeadSymlinksFromTrash(Node node) throws RepositoryException {
        List<Node> symlinks = this.getAllLinks(node, "exo:symlink");
        for (Node symlink : symlinks) {
            symlink.remove();
            try {
                this.listenerService.broadcast("FileActivityNotify.event.FileRemoved", null, (Object)symlink);
            }
            catch (Exception e) {
                LOG.error((Object)e.getMessage());
            }
        }
    }

    public void removeDeadSymlinks(Node node) throws RepositoryException {
        this.removeDeadSymlinks(node, true);
    }

    public List<Node> getTrashElements(TrashElementNodeFilter trashElementNodeFilter) throws RepositoryException {
        String mappedSortField = switch (trashElementNodeFilter.getSortField()) {
            case DocumentSortField.NAME -> "exo:title";
            default -> "exo:dateModified";
        };
        String sortDirection = trashElementNodeFilter.isAscending() ? "ASC" : "DESC";
        StringBuilder sb = new StringBuilder(SELECT_FROM_TRASH_QUERY);
        sb.append(" ORDER BY ").append(mappedSortField).append(" ").append(sortDirection);
        ArrayList<Node> result = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
        Session session = sessionProvider.getSession(this.trashWorkspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        QueryImpl query = (QueryImpl)queryManager.createQuery(sb.toString(), "sql");
        query.setLimit((long)trashElementNodeFilter.getLimit());
        query.setOffset((long)trashElementNodeFilter.getOffset());
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            result.add(iter.nextNode());
        }
        return result;
    }

    public List<Node> getAllLinks(Node targetNode, String linkType) {
        return this.getAllLinks(targetNode, linkType, this.sessionProviderService.getSessionProvider(null));
    }

    public int countDeletedDocuments() {
        try {
            StringBuilder sb = new StringBuilder(SELECT_FROM_TRASH_QUERY);
            ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
            SessionProvider sessionProvider = this.sessionProviderService.getSystemSessionProvider(null);
            Session session = sessionProvider.getSession(this.trashWorkspace, manageableRepository);
            QueryManager queryManager = session.getWorkspace().getQueryManager();
            Query query = queryManager.createQuery(sb.toString(), "sql");
            QueryResult queryResult = query.execute();
            return (int)queryResult.getNodes().getSize();
        }
        catch (Exception e) {
            LOG.error("Error occurred when counting trash elements", new Object[]{e.getMessage()});
            return 0;
        }
    }

    private boolean isDocumentNodeType(Node node) throws RepositoryException {
        return !node.isNodeType("nt:unstructured") && !node.isNodeType("nt:folder");
    }

    private boolean isBroadcastNTFileEvents(Node node) throws RepositoryException {
        boolean result = true;
        while (result && !((NodeImpl)node).isRoot()) {
            try {
                node = node.getParent();
                result = !this.isDocumentNodeType(node);
            }
            catch (AccessDeniedException ex) {
                return result;
            }
            catch (RepositoryException ex) {
                return !this.isDocumentNodeType(node);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDeadSymlinks(Node node, boolean keepInTrash) throws RepositoryException {
        if (this.isInTrash(node)) {
            this.removeDeadSymlinksFromTrash(node);
            return;
        }
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        LinkedList<Node> queue = new LinkedList<Node>();
        queue.add(node);
        try {
            while (!queue.isEmpty()) {
                node = (Node)queue.poll();
                if (node.isNodeType("exo:symlink")) continue;
                this.removeSymlinks(node, keepInTrash, sessionProvider);
                NodeIterator iter = node.getNodes();
                while (iter.hasNext()) {
                    queue.add(iter.nextNode());
                }
            }
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)e.getMessage());
            }
        }
        finally {
            sessionProvider.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeSymlinks(Node node, boolean keepInTrash, SessionProvider sessionProvider) {
        try {
            List<Object> symlinks = this.getAllLinks(node, "exo:symlink", sessionProvider);
            symlinks = symlinks.stream().sorted(this::compare).filter(Objects::nonNull).collect(Collectors.toList());
            Iterator<Object> iterator = symlinks.iterator();
            while (iterator.hasNext()) {
                Node symlink;
                Node node2 = symlink = (Node)iterator.next();
                synchronized (node2) {
                    if (keepInTrash) {
                        this.moveToTrash(symlink, sessionProvider, 1);
                    } else {
                        if (symlink.isNodeType(ActivityTypeUtils.EXO_ACTIVITY_INFO) && node.hasProperty(ActivityTypeUtils.EXO_ACTIVITY_ID)) {
                            this.listenerService.broadcast("FileActivityNotify.event.FileRemoved", null, (Object)symlink);
                        }
                        Session nodeSession = symlink.getSession();
                        symlink.remove();
                        nodeSession.save();
                    }
                }
            }
            return;
        }
        catch (Exception e) {
            if (!LOG.isWarnEnabled()) return;
            LOG.warn((Object)e.getMessage());
        }
    }

    private int compare(Node node1, Node node2) {
        try {
            String name1 = node1.getName();
            String name2 = node2.getName();
            if (name1.equals(name2)) {
                int index1 = node1.getIndex();
                int index2 = node2.getIndex();
                return -1 * Integer.valueOf(index1).compareTo(index2);
            }
            return -1 * name1.compareTo(name2);
        }
        catch (RepositoryException e) {
            return 0;
        }
    }

    private List<Node> selectNodesByQuery(SessionProvider sessionProvider, String queryString, String language) throws RepositoryException {
        ArrayList<Node> ret = new ArrayList<Node>();
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session session = sessionProvider.getSession(this.trashWorkspace, manageableRepository);
        QueryManager queryManager = session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(queryString, language);
        QueryResult queryResult = query.execute();
        NodeIterator iter = queryResult.getNodes();
        while (iter.hasNext()) {
            ret.add(iter.nextNode());
        }
        return ret;
    }

    private String fixRestorePath(String path) {
        int leftBracket = path.lastIndexOf(91);
        int rightBracket = path.lastIndexOf(93);
        if (leftBracket == -1 || rightBracket == -1 || leftBracket >= rightBracket) {
            return path;
        }
        try {
            Integer.parseInt(path.substring(leftBracket + 1, rightBracket));
        }
        catch (Exception ex) {
            return path;
        }
        return path.substring(0, leftBracket);
    }

    private String addRestorePathInfo(String nodeName, String restorePath, String nodeWs) throws RepositoryException {
        String restoreId = UUID.randomUUID().toString();
        NodeIterator nodes = this.getTrashHomeNode().getNodes(nodeName);
        Node node = null;
        while (nodes.hasNext()) {
            Node currentNode = nodes.nextNode();
            if (node == null) {
                node = currentNode;
                continue;
            }
            if (node.getIndex() >= currentNode.getIndex()) continue;
            node = currentNode;
        }
        if (node != null) {
            node.addMixin("exo:restoreLocation");
            node.setProperty("exo:restorePath", restorePath);
            node.setProperty("exo:restoreWorkspace", nodeWs);
            node.setProperty("exo:trashId", restoreId);
            node.save();
        }
        return restoreId;
    }

    private void removeMixinRestoreLocation(Session session, String restorePath) throws RepositoryException {
        Node sameNameNode = (Node)session.getItem(restorePath);
        Node parent = sameNameNode.getParent();
        String name = sameNameNode.getName();
        NodeIterator nodeIter = parent.getNodes(name);
        while (nodeIter.hasNext()) {
            Node node = nodeIter.nextNode();
            if (!node.isNodeType("exo:restoreLocation")) continue;
            node.removeMixin("exo:restoreLocation");
        }
    }

    private void restoreFromTrash(String trashNodePath, SessionProvider sessionProvider, int deep) throws RepositoryException {
        Node trashChild;
        NodeIterator iter;
        boolean found;
        String nodeUUID;
        Node trashHomeNode = this.getTrashHomeNode();
        Session trashNodeSession = trashHomeNode.getSession();
        Node trashNode = (Node)trashNodeSession.getItem(trashNodePath);
        String trashWorkspaceName = trashNodeSession.getWorkspace().getName();
        String restoreWorkspace = trashNode.getProperty("exo:restoreWorkspace").getString();
        String restorePath = trashNode.getProperty("exo:restorePath").getString();
        String string = nodeUUID = trashNode.isNodeType("mix:referenceable") ? trashNode.getUUID() : null;
        if (trashNode.isNodeType("exo:symlink")) {
            nodeUUID = null;
        }
        String taxonomyLinkUUID = trashNode.isNodeType("exo:taxonomyLink") ? trashNode.getProperty("exo:uuid").getString() : null;
        String taxonomyLinkWS = trashNode.isNodeType("exo:taxonomyLink") ? trashNode.getProperty("exo:workspace").getString() : null;
        ManageableRepository manageableRepository = this.repositoryService.getCurrentRepository();
        Session restoreSession = sessionProvider.getSession(restoreWorkspace, manageableRepository);
        if (restoreWorkspace.equals(trashWorkspaceName)) {
            trashNodeSession.getWorkspace().move(trashNodePath, restorePath);
        } else {
            restoreSession.getWorkspace().clone(trashWorkspaceName, trashNodePath, restorePath, true);
            trashNodeSession.getItem(trashNodePath).remove();
        }
        this.removeMixinRestoreLocation(restoreSession, restorePath);
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && nodeUUID != null) {
            block4: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType("exo:taxonomyLink") || !trashChild.hasProperty("exo:uuid") || !trashChild.hasProperty("exo:workspace") || !nodeUUID.equals(trashChild.getProperty("exo:uuid").getString())) continue;
                    try {
                        this.restoreFromTrash(trashChild.getPath(), sessionProvider, deep + 1);
                        found = true;
                        continue block4;
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getMessage());
                    }
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
        if (deep == 0 && taxonomyLinkUUID != null && taxonomyLinkWS != null) {
            block6: do {
                found = false;
                iter = trashHomeNode.getNodes();
                while (iter.hasNext()) {
                    trashChild = iter.nextNode();
                    if (!trashChild.isNodeType("mix:referenceable") || !taxonomyLinkUUID.equals(trashChild.getUUID()) || !taxonomyLinkWS.equals(trashChild.getProperty("exo:restoreWorkspace").getString())) continue;
                    try {
                        this.restoreFromTrash(trashChild.getPath(), sessionProvider, deep + 1);
                        found = true;
                        continue block6;
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getMessage());
                    }
                }
            } while (found);
        }
        trashNodeSession.save();
        restoreSession.save();
    }
}

