/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.exoplatform.commons.api.portlet.GenericDispatchedViewPortlet;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;

public class DocumentPortlet
extends GenericDispatchedViewPortlet {
    private UserACL userAcl;

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        boolean canModifySettings = this.canModifySettings();
        request.setAttribute("canEdit", (Object)canModifySettings);
        super.doView(request, response);
    }

    public void processAction(ActionRequest request, ActionResponse response) throws IOException, PortletException {
        if (!this.canModifySettings()) {
            throw new PortletException("User is not allowed to save settings");
        }
        PortletPreferences preferences = request.getPreferences();
        String settings = request.getParameter("settings");
        preferences.setValue("settings", settings);
        preferences.store();
        response.setPortletMode(PortletMode.VIEW);
    }

    private Identity getCurrentIdentity() {
        return ConversationState.getCurrent() == null ? null : ConversationState.getCurrent().getIdentity();
    }

    private UserACL getUserAcl() {
        if (this.userAcl == null) {
            this.userAcl = (UserACL)ExoContainerContext.getService(UserACL.class);
        }
        return this.userAcl;
    }

    private boolean canModifySettings() {
        Space space = SpaceUtils.getSpaceByContext();
        Identity identity = this.getCurrentIdentity();
        if (identity == null || this.getUserAcl().isAnonymousUser(identity)) {
            return false;
        }
        if (space == null) {
            return this.getUserAcl().isAdministrator(identity);
        }
        return this.getUserAcl().isAdministrator(identity) || this.getUserAcl().hasEditPermission("space", space.getId(), identity);
    }
}

