/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.exoplatform.documents.webdav.util.PropertyWriteUtil;
import org.springframework.stereotype.Component;

@Component
public class ReportWebDavHandler
extends WebDavHttpMethodPlugin {
    public ReportWebDavHandler() {
        super("REPORT");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        String resourcePath = this.getResourcePath(httpRequest);
        WebDavItemProperty body = this.parseRequestBodyAsWebDavItemProperty(httpRequest);
        Set requestPropertyNames = this.getRequestPropertyNames(body);
        List versions = this.documentWebDavService.getVersions(resourcePath, requestPropertyNames, this.getBaseUrl(httpRequest), httpRequest.getRemoteUser());
        this.writeResponse(versions, requestPropertyNames, httpResponse);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeResponse(List<WebDavItem> versions, Set<QName> requestPropertyNames, HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "text/xml");
        httpResponse.setStatus(207);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();
             XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)outputStream, DEFAULT_XML_ENCODING);){
            xmlStreamWriter.setNamespaceContext(this.documentWebDavService.getNamespaceContext());
            xmlStreamWriter.writeStartDocument();
            xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
            xmlStreamWriter.writeNamespace("D", "DAV:");
            xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
            for (WebDavItem version : versions) {
                xmlStreamWriter.writeStartElement("DAV:", "response");
                xmlStreamWriter.writeStartElement("DAV:", "href");
                xmlStreamWriter.writeCharacters(version.getIdentifier().toASCIIString());
                xmlStreamWriter.writeEndElement();
                PropertyWriteUtil.writePropStats((XMLStreamWriter)xmlStreamWriter, (Map)this.getRequestedPropertyStats(version, requestPropertyNames));
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
        }
    }
}

