/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItemOrder;
import org.exoplatform.documents.webdav.model.WebDavItemProperty;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.springframework.stereotype.Component;

@Component
public class OrderPatchWebDavHandler
extends WebDavHttpMethodPlugin {
    public OrderPatchWebDavHandler() {
        super("ORDERPATCH");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        WebDavItemProperty body;
        List members;
        String resourcePath = this.getResourcePath(httpRequest);
        if (this.documentWebDavService.order(resourcePath, members = this.getMembers(body = this.parseRequestBodyAsWebDavItemProperty(httpRequest)), this.getLockTokens(httpRequest), httpRequest.getRemoteUser())) {
            httpResponse.setStatus(204);
        } else {
            this.writeResponse(resourcePath, members, httpRequest, httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponse(String resourcePath, List<WebDavItemOrder> members, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        httpResponse.setHeader("Content-Type", "text/xml");
        httpResponse.setStatus(207);
        try (ServletOutputStream outputStream = httpResponse.getOutputStream();){
            URI uri = this.getResourceUri(httpRequest);
            try (XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter((OutputStream)outputStream, DEFAULT_XML_ENCODING);){
                xmlStreamWriter.setNamespaceContext(this.documentWebDavService.getNamespaceContext());
                xmlStreamWriter.writeStartDocument();
                xmlStreamWriter.writeStartElement("D", "multistatus", "DAV:");
                xmlStreamWriter.writeNamespace("D", "DAV:");
                xmlStreamWriter.writeAttribute("xmlns:b", "urn:uuid:c2f41010-65b3-11d1-a29f-00aa00c14882/");
                for (int i = 0; i < members.size(); ++i) {
                    WebDavItemOrder member = members.get(i);
                    xmlStreamWriter.writeStartElement("DAV:", "response");
                    xmlStreamWriter.writeStartElement("DAV:", "href");
                    String href = String.format("%s/%s", uri.toASCIIString(), member.getSegment());
                    xmlStreamWriter.writeCharacters(href);
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeStartElement("DAV:", "status");
                    xmlStreamWriter.writeCharacters(PropertyConstants.getStatusDescription((int)member.getStatus()));
                    xmlStreamWriter.writeEndElement();
                    xmlStreamWriter.writeEndElement();
                }
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndDocument();
            }
        }
    }

    private List<WebDavItemOrder> getMembers(WebDavItemProperty body) {
        ArrayList<WebDavItemOrder> members = new ArrayList<WebDavItemOrder>();
        List childs = body.getChildren();
        for (int i = 0; i < childs.size(); ++i) {
            WebDavItemOrder member = new WebDavItemOrder((WebDavItemProperty)childs.get(i));
            members.add(member);
        }
        return members;
    }
}

