/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.documents.webdav.plugin.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.exoplatform.documents.webdav.model.WebDavException;
import org.exoplatform.documents.webdav.model.WebDavItem;
import org.exoplatform.documents.webdav.model.constant.PropertyConstants;
import org.exoplatform.documents.webdav.plugin.WebDavHttpMethodPlugin;
import org.springframework.stereotype.Component;

@Component
public class HeadWebDavHandler
extends WebDavHttpMethodPlugin {
    private static final Set<QName> REQUESTED_PROPERTIES = new HashSet();

    public HeadWebDavHandler() {
        super("HEAD");
    }

    public void handle(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws WebDavException {
        String resourcePath = this.getResourcePath(httpRequest);
        WebDavItem resource = this.documentWebDavService.get(resourcePath, "include", REQUESTED_PROPERTIES, false, 0, this.getBaseUrl(httpRequest), httpRequest.getRemoteUser());
        httpResponse.setHeader("Last-Modified", resource.getProperty(PropertyConstants.GETLASTMODIFIED).getValue());
        httpResponse.setHeader("Content-Type", resource.getProperty(PropertyConstants.GETCONTENTTYPE).getValue());
        httpResponse.setHeader("Content-Length", resource.getProperty(PropertyConstants.GETCONTENTLENGTH).getValue());
        httpResponse.setStatus(204);
    }

    static {
        REQUESTED_PROPERTIES.add(PropertyConstants.GETLASTMODIFIED);
        REQUESTED_PROPERTIES.add(PropertyConstants.GETCONTENTTYPE);
        REQUESTED_PROPERTIES.add(PropertyConstants.GETCONTENTLENGTH);
    }
}

