/*
 * Decompiled with CFR 0.152.
 */
package hero.hook;

import hero.hook.NodeHookI;
import hero.interfaces.BnNodeLocal;
import hero.interfaces.ProjectSessionLocal;
import hero.interfaces.ProjectSessionLocalHome;
import hero.interfaces.ProjectSessionUtil;
import hero.util.HeroHookException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;

public class ContentValidationPublicationHook
implements NodeHookI {
    public String getMetadata() {
        return "beforeTerminate";
    }

    public void beforeStart(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void afterStart(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTerminate(Object obj, BnNodeLocal node) throws HeroHookException {
        ProjectSessionLocal projectSession = null;
        boolean portalContainerSet = false;
        try {
            ProjectSessionLocalHome projectSessionHome = ProjectSessionUtil.getLocalHome();
            projectSession = projectSessionHome.create();
            projectSession.initProject(node.getBnProject().getName());
            if (PortalContainer.getInstance() == null) {
                String containerName = projectSession.getProperty("containername").getTheValue();
                PortalContainer container = RootContainer.getInstance().getPortalContainer(containerName);
                PortalContainer.setInstance((PortalContainer)container);
                portalContainerSet = true;
            }
            String actionName = projectSession.getProperty("actionName").getTheValue();
            String nodePath = projectSession.getProperty("nodePath").getTheValue();
            String srcPath = projectSession.getProperty("srcPath").getTheValue();
            String srcWorkspace = projectSession.getProperty("srcWorkspace").getTheValue();
            String repository = projectSession.getProperty("repository").getTheValue();
            Date startDate = new Date(Long.parseLong(projectSession.getNodeProperty(node.getName(), "startDate").getTheValue()));
            Date endDate = new Date(Long.parseLong(projectSession.getNodeProperty(node.getName(), "endDate").getTheValue()));
            PortalContainer container = PortalContainer.getInstance();
            RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
            ActionServiceContainer actionServiceContainer = (ActionServiceContainer)container.getComponentInstanceOfType(ActionServiceContainer.class);
            CmsService cmsService = (CmsService)container.getComponentInstanceOfType(CmsService.class);
            Session session = repositoryService.getRepository(repository).getSystemSession(srcWorkspace);
            Node actionableNode = (Node)session.getItem(srcPath);
            if (!actionableNode.isNodeType("exo:actionable")) {
                actionableNode = (Node)session.getItem(nodePath);
            }
            Node actionNode = actionServiceContainer.getAction(actionableNode, actionName);
            String destWorkspace = actionNode.getProperty("exo:destWorkspace").getString();
            String destPath = actionNode.getProperty("exo:destPath").getString();
            Node srcNode = (Node)session.getItem(nodePath);
            srcNode.addMixin("exo:published");
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(startDate);
            srcNode.setProperty("exo:startPublication", (Calendar)calendar);
            if (endDate != null) {
                calendar = new GregorianCalendar();
                calendar.setTime(endDate);
                srcNode.setProperty("exo:endPublication", (Calendar)calendar);
            }
            srcNode.save();
            String relPath = nodePath.substring(srcPath.length() + 1);
            if (!relPath.startsWith("/")) {
                relPath = "/" + relPath;
            }
            relPath = relPath.replaceAll("\\[\\d*\\]", "");
            cmsService.moveNode(nodePath, srcWorkspace, destWorkspace, destPath + relPath, repository);
            session.logout();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (portalContainerSet) {
                    PortalContainer.setInstance(null);
                }
                projectSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    public void afterTerminate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void anticipate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onCancel(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onDeadline(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onReady(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }
}

