/*
 * Decompiled with CFR 0.152.
 */
package hero.hook;

import hero.hook.NodeHookI;
import hero.interfaces.BnNodeLocal;
import hero.interfaces.ProjectSessionLocal;
import hero.interfaces.ProjectSessionLocalHome;
import hero.interfaces.ProjectSessionUtil;
import hero.util.HeroHookException;
import java.util.ArrayList;
import java.util.Date;
import org.exoplatform.container.PortalContainer;

public class ContentValidationWaitSwitchHook
implements NodeHookI {
    public static final String CONTAINER_PROPERTY_NAME = "containername";
    public static final String DATE_PROPERTY_NAME = "startDate";
    public static final String WAIT_ACTIVITY_NAME = "wait";
    public static final String WAIT_PROPERTY_NAME = "wait";

    public String getMetadata() {
        return "beforeTerminate";
    }

    public void beforeStart(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void afterStart(Object obj, BnNodeLocal node) throws HeroHookException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeTerminate(Object obj, BnNodeLocal node) throws HeroHookException {
        ProjectSessionLocal projectSession = null;
        try {
            String projectName = node.getBnProject().getName();
            ProjectSessionLocalHome projectSessionHome = ProjectSessionUtil.getLocalHome();
            projectSession = projectSessionHome.create();
            projectSession.initProject(projectName);
            String nodeName = node.getName();
            long relativeDeadline = Long.parseLong(projectSession.getNodeProperty(nodeName, DATE_PROPERTY_NAME).getTheValue()) - new Date().getTime();
            if (relativeDeadline > 0L) {
                projectSession.setNodeProperty(nodeName, "wait", "true", false);
                ArrayList<Long> deadlines = new ArrayList<Long>();
                deadlines.add(relativeDeadline);
                projectSession.setNodeRelativeDeadlines("wait", deadlines);
                projectSession.setProperty(CONTAINER_PROPERTY_NAME, PortalContainer.getInstance().getPortalContainerInfo().getContainerName());
            } else {
                projectSession.setNodeProperty(nodeName, "wait", "false", false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                projectSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    public void afterTerminate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void anticipate(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onCancel(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onDeadline(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }

    public void onReady(Object arg0, BnNodeLocal arg1) throws HeroHookException {
    }
}

