/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.contentbackup;

import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class BackupNodeActionHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        try {
            if (this.executed) {
                return;
            }
            this.executed = true;
            this.backupNode(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            context.getToken().signal("backup-done");
            context.getSchedulerInstance().cancel("backupTimer", context.getToken());
        }
    }

    protected void backupNode(ExecutionContext context) throws Exception {
        String actionName = (String)context.getVariable("actionName");
        String nodePath = (String)context.getVariable("nodePath");
        String srcPath = (String)context.getVariable("srcPath");
        String srcWorkspace = (String)context.getVariable("srcWorkspace");
        String repository = (String)context.getVariable("repository");
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        CmsService cmsService = (CmsService)container.getComponentInstanceOfType(CmsService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)container.getComponentInstanceOfType(ActionServiceContainer.class);
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        Session session = repositoryService.getRepository(repository).getSystemSession(srcWorkspace);
        Node actionnableNode = (Node)session.getItem(srcPath);
        Node actionNode = actionServiceContainer.getAction(actionnableNode, actionName);
        String destWorkspace = actionNode.getProperty("exo:destWorkspace").getString();
        String destPath = actionNode.getProperty("exo:destPath").getString();
        String relPath = nodePath.substring(srcPath.length() + 1);
        if (!relPath.startsWith("/")) {
            relPath = "/" + relPath;
        }
        relPath = relPath.replaceAll("\\[\\d*\\]", "");
        cmsService.moveNode(nodePath, srcWorkspace, destWorkspace, destPath + relPath, repository);
        session.logout();
    }
}

