/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.cms.CmsService;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class TrashMovementActionHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        try {
            if (this.executed) {
                return;
            }
            this.executed = true;
            this.moveTrash(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            context.getToken().signal("move-done");
        }
    }

    private void moveTrash(ExecutionContext context) {
        String[] location = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = location[0];
        String currentWorkspace = location[1];
        String currentPath = location[2];
        String trashWorkspace = (String)context.getVariable("exo:trashWorkspace");
        String trashPath = (String)context.getVariable("exo:trashPath");
        String destPath = ProcessUtil.computeDestinationPath((String)currentPath, (String)trashPath);
        CmsService cmsService = (CmsService)ProcessUtil.getService(CmsService.class);
        cmsService.moveNode(currentPath, currentWorkspace, trashWorkspace, destPath, repository);
        ProcessUtil.setCurrentLocation((ExecutionContext)context, (String)trashWorkspace, (String)destPath);
        ProcessUtil.moveTrash((ExecutionContext)context);
    }
}

