/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.log.ExoLogger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.exe.ExecutionContext;

public class ManagePublicationActionHandler
implements ActionHandler {
    private static final long serialVersionUID = 1L;
    private boolean executed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ExecutionContext context) {
        try {
            if (this.executed) {
                return;
            }
            this.executed = true;
            this.publishContent(context);
        }
        catch (Exception e) {
            e.printStackTrace();
            ExoLogger.getLogger(this.getClass()).error((Object)e);
        }
        finally {
            context.getSchedulerInstance().cancel("publicationTimer", context.getToken());
            context.getToken().signal("publication-done");
        }
    }

    protected void publishContent(ExecutionContext context) throws Exception {
        String[] currentLocation = ProcessUtil.getCurrentLocation((ExecutionContext)context);
        String repository = currentLocation[0];
        String currentWorkspace = currentLocation[1];
        String currentPath = currentLocation[2];
        String publishWorkspace = (String)context.getVariable("exo:publishWorkspace");
        String publishPath = (String)context.getVariable("exo:publishPath");
        String realPublishPath = ProcessUtil.computeDestinationPath((String)currentPath, (String)publishPath);
        CmsService cmsService = (CmsService)ProcessUtil.getService(CmsService.class);
        cmsService.moveNode(currentPath, currentWorkspace, publishWorkspace, realPublishPath, repository);
        context.setVariable(ProcessUtil.CURRENT_STATE, (Object)ProcessUtil.LIVE);
        ProcessUtil.setCurrentLocation((ExecutionContext)context, (String)publishWorkspace, (String)realPublishPath);
        ProcessUtil.publish((ExecutionContext)context);
    }
}

