/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.processes.publishing;

import java.util.Date;
import org.exoplatform.processes.publishing.BackupContentActionHandler;
import org.exoplatform.processes.publishing.ProcessUtil;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.workflow.impl.jbpm.WorkflowServiceContainerImpl;
import org.jbpm.db.JbpmSession;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.instantiation.Delegation;
import org.jbpm.scheduler.exe.Timer;

public class ScheduleBackupTimerActionHandler
extends BackupContentActionHandler {
    private static final long serialVersionUID = 1L;

    public void execute(ExecutionContext context) {
        try {
            Date currentDate = new Date();
            Date endDate = null;
            if (context.getVariable("endDate") instanceof Date) {
                endDate = (Date)context.getVariable("endDate");
            }
            if (endDate != null) {
                if (endDate.after(currentDate)) {
                    Delegation delegation = new Delegation();
                    delegation.setClassName("org.exoplatform.processes.publishing.BackupContentActionHandler");
                    delegation.setProcessDefinition(context.getProcessDefinition());
                    Action backupAction = new Action();
                    backupAction.setName("backupAction");
                    backupAction.setActionDelegation(delegation);
                    backupAction.setProcessDefinition(context.getProcessDefinition());
                    context.getProcessDefinition().addAction(backupAction);
                    Timer timer = new Timer(context.getToken());
                    timer.setName("backupTimer");
                    timer.setDueDate(endDate);
                    timer.setGraphElement(context.getEventSource());
                    timer.setTaskInstance(context.getTaskInstance());
                    timer.setAction(backupAction);
                    timer.setTransitionName("end");
                    context.getSchedulerInstance().schedule(timer);
                    WorkflowServiceContainerImpl containerImpl = (WorkflowServiceContainerImpl)ProcessUtil.getService(WorkflowServiceContainerImpl.class);
                    JbpmSession session = containerImpl.openSession();
                    session.beginTransaction();
                    session.getGraphSession().saveProcessInstance(context.getProcessInstance());
                    session.commitTransaction();
                } else {
                    this.backupContent(context);
                    context.getToken().signal("backup-done");
                }
            }
        }
        catch (Exception ex) {
            ExoLogger.getLogger(this.getClass()).equals(ex);
            ex.printStackTrace();
        }
    }
}

