/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.picocontainer.Startable;

public abstract class BaseResourceLoaderService
implements Startable {
    protected NodeHierarchyCreator nodeHierarchyCreator_;
    protected RepositoryService repositoryService_;
    protected ConfigurationManager cservice_;
    protected ExoCache resourceCache_;

    public BaseResourceLoaderService(ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, RepositoryService repositoryService, CacheService cacheService) throws Exception {
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
        this.repositoryService_ = repositoryService;
        this.cservice_ = cservice;
        this.resourceCache_ = cacheService.getCacheInstance(this.getClass().getName());
    }

    protected abstract String getBasePath();

    protected abstract void removeFromCache(String var1);

    public void start() {
    }

    public void stop() {
    }

    protected void init(Session session, ResourceConfig resourceConfig, String location) throws Exception {
        this.addScripts(session, resourceConfig.getRessources(), location);
    }

    protected void addScripts(Session session, List resources, String location) throws Exception {
        String resourcesPath = this.getBasePath();
        if (resources.size() == 0) {
            return;
        }
        try {
            String firstResourceName = ((ResourceConfig.Resource)resources.get(0)).getName();
            session.getItem(resourcesPath + "/" + firstResourceName);
            return;
        }
        catch (PathNotFoundException e) {
            Node root = session.getRootNode();
            Node resourcesHome = (Node)session.getItem(resourcesPath);
            String warPath = location + resourcesPath.substring(resourcesPath.lastIndexOf("/"));
            for (ResourceConfig.Resource resource : resources) {
                String name = resource.getName();
                String path = warPath + "/" + name;
                InputStream in = this.cservice_.getInputStream(path);
                this.addResource(resourcesHome, name, in);
            }
            root.save();
            return;
        }
    }

    public void addResource(Node resourcesHome, String resourceName, InputStream in) throws Exception {
        Node contentNode = null;
        if (resourceName.lastIndexOf("/") > -1) {
            Node parentResource;
            String realParenPath = StringUtils.substringBeforeLast((String)resourceName, (String)"/");
            resourcesHome = parentResource = resourcesHome.getNode(realParenPath);
            resourceName = StringUtils.substringAfterLast((String)resourceName, (String)"/");
        }
        try {
            contentNode = resourcesHome.getNode(resourceName);
            if (!contentNode.isCheckedOut()) {
                contentNode.checkout();
            }
        }
        catch (PathNotFoundException e) {
            contentNode = resourcesHome.addNode(resourceName, "nt:resource");
            contentNode.setProperty("jcr:encoding", "UTF-8");
            contentNode.setProperty("jcr:mimeType", "text/xml");
        }
        contentNode.setProperty("jcr:data", in);
        contentNode.setProperty("jcr:lastModified", (Calendar)new GregorianCalendar());
        resourcesHome.save();
    }

    protected Node getResourcesHome(String repository, SessionProvider sessionProvider) throws Exception {
        ManageableRepository manageableRepository = null;
        manageableRepository = repository == null ? this.repositoryService_.getDefaultRepository() : this.repositoryService_.getRepository(repository);
        String workpsace = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        Session session = sessionProvider.getSession(workpsace, manageableRepository);
        String resourcesPath = this.getBasePath();
        return (Node)session.getItem(resourcesPath);
    }

    public String getResourceAsText(String resourceName, String repository) throws Exception {
        SessionProvider sessionProvider = SessionProvider.createSystemProvider();
        Node resourcesHome = this.getResourcesHome(repository, sessionProvider);
        Node resourceNode = resourcesHome.getNode(resourceName);
        String text = resourceNode.getProperty("jcr:data").getString();
        sessionProvider.close();
        return text;
    }

    public NodeIterator getResources(String repository, SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(repository, sessionProvider);
        return resourcesHome.getNodes();
    }

    public boolean hasResources(String repository, SessionProvider sessionProvider) throws Exception {
        Node resourcesHome = this.getResourcesHome(repository, sessionProvider);
        return resourcesHome.hasNodes();
    }

    public void addResource(String name, String text, String repository, SessionProvider provider) throws Exception {
        Node resourcesHome = this.getResourcesHome(repository, provider);
        ByteArrayInputStream in = new ByteArrayInputStream(text.getBytes());
        this.addResource(resourcesHome, name, in);
        resourcesHome.save();
    }

    public void removeResource(String resourceName, String repository, SessionProvider provider) throws Exception {
        this.removeFromCache(resourceName);
        Node resourcesHome = this.getResourcesHome(repository, provider);
        Node resource2remove = resourcesHome.getNode(resourceName);
        resource2remove.remove();
        resourcesHome.save();
    }
}

