/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.core.nodetype.ExtendedItemDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmsServiceImpl
implements CmsService {
    private RepositoryService jcrService;
    private IDGeneratorService idGeneratorService;
    private static final String MIX_REFERENCEABLE = "mix:referenceable";

    public CmsServiceImpl(RepositoryService jcrService, IDGeneratorService idGeneratorService) {
        this.idGeneratorService = idGeneratorService;
        this.jcrService = jcrService;
    }

    @Override
    public String storeNode(String workspace, String nodeTypeName, String storePath, Map mappings, String repository) throws Exception {
        Session session = this.jcrService.getRepository(repository).login(workspace);
        Node storeHomeNode = (Node)session.getItem(storePath);
        String path = this.storeNode(nodeTypeName, storeHomeNode, mappings, true, repository);
        storeHomeNode.save();
        session.save();
        session.logout();
        return path;
    }

    @Override
    public String storeNode(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew, String repository) throws Exception {
        String primaryType;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        if ((primaryType = relRootProp.getNodetype()) == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (isAddNew) {
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            if (!currentNode.isNodeType(MIX_REFERENCEABLE)) {
                currentNode.addMixin(MIX_REFERENCEABLE);
            }
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
        }
        return currentNode.getPath();
    }

    @Override
    public String storeNodeByUUID(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew, String repository) throws Exception {
        String primaryType;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        if ((primaryType = relRootProp.getNodetype()) == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (isAddNew) {
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
        }
        if (!currentNode.isNodeType(MIX_REFERENCEABLE)) {
            currentNode.addMixin(MIX_REFERENCEABLE);
        }
        return currentNode.getUUID();
    }

    private void updateNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(false, path, currentNode, currentNodeType, jcrVariables);
    }

    private void createNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(true, path, currentNode, currentNodeType, jcrVariables);
    }

    private void processAddEditProperty(boolean create, Node currentNode, String path, NodeType currentNodeType, Map jcrVariables) throws Exception {
        if (create) {
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition propertyDef = propertyDefs[i];
                if (propertyDef.isAutoCreated() || propertyDef.isProtected()) continue;
                String propertyName = propertyDef.getName();
                int requiredtype = propertyDef.getRequiredType();
                String currentPath = path + "/" + propertyName;
                JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                Object value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null && !propertyDef.isMandatory()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDef.isMultiple());
            }
        }
    }

    private void processNodeRecursively(boolean create, String itemPath, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        if (create) {
            this.processAddEditProperty(true, currentNode, itemPath, currentNodeType, jcrVariables);
        } else {
            ArrayList<String> keyList = new ArrayList<String>();
            for (Object key : jcrVariables.keySet()) {
                keyList.add(key.toString().substring(key.toString().lastIndexOf("/") + 1));
            }
            ArrayList<String> currentListPropertyName = new ArrayList<String>();
            PropertyIterator pi = currentNode.getProperties();
            while (pi.hasNext()) {
                Property property = pi.nextProperty();
                currentListPropertyName.add(property.getName());
            }
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition propertyDef = propertyDefs[i];
                String string = propertyDef.getName();
                Object value = null;
                String currentPath = itemPath + "/" + string;
                JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (currentListPropertyName.contains(string)) {
                    Property property = currentNode.getProperty(string);
                    int requiredtype = property.getType();
                    if (!keyList.contains(string) || propertyDef.isProtected()) continue;
                    this.processProperty(property, currentNode, requiredtype, value, propertyDef.isMultiple());
                    continue;
                }
                if (propertyDef.isAutoCreated() || propertyDef.isProtected()) continue;
                int requiredtype = propertyDef.getRequiredType();
                if (value == null && !propertyDef.isMandatory()) continue;
                this.processProperty(string, currentNode, requiredtype, value, propertyDef.isMultiple());
            }
        }
        int itemLevel = StringUtils.countMatches((String)itemPath, (String)"/");
        List<JcrInputProperty> childNodeInputs = this.extractNodeInputs(jcrVariables, itemLevel + 1);
        NodeTypeManager nodeTypeManger = currentNode.getSession().getWorkspace().getNodeTypeManager();
        ArrayList<Object> childs = new ArrayList<Object>();
        if (create) {
            for (NodeDefinition childNodeDef : currentNodeType.getChildNodeDefinitions()) {
                childs.add(childNodeDef);
            }
        } else {
            NodeIterator iterator = currentNode.getNodes();
            while (iterator.hasNext()) {
                childs.add(iterator.nextNode());
            }
        }
        for (Object e : childs) {
            Node childNode;
            NodeDefinition nodeDef = e instanceof Node ? ((Node)e).getDefinition() : (NodeDefinition)e;
            if (nodeDef.isAutoCreated() || nodeDef.isProtected()) continue;
            if (((ExtendedItemDefinition)nodeDef).isResidualSet()) {
                for (JcrInputProperty input : childNodeInputs) {
                    String primaryNodeType;
                    NodeType nodeType;
                    String childItemPath = itemPath + "/" + input.getValue();
                    if (!childItemPath.equals(input.getJcrPath()) || !this.canAddNode(nodeDef, nodeType = nodeTypeManger.getNodeType(primaryNodeType = input.getNodetype()))) continue;
                    String[] mixinTypes = null;
                    if (input.getMixintype() != null) {
                        mixinTypes = input.getMixintype().split(",");
                    }
                    childNode = this.doAddNode(currentNode, (String)input.getValue(), nodeType.getName(), mixinTypes);
                    this.processNodeRecursively(create, childItemPath, childNode, childNode.getPrimaryNodeType(), jcrVariables);
                }
                continue;
            }
            String childNodeName = null;
            childNodeName = e instanceof Node ? ((Node)e).getName() : ((NodeDefinition)e).getName();
            String newItemPath = itemPath + "/" + childNodeName;
            JcrInputProperty jcrInputVariable = (JcrInputProperty)jcrVariables.get(newItemPath);
            if (jcrInputVariable == null) continue;
            String nodeTypeName = jcrInputVariable.getNodetype();
            String[] mixinTypes = null;
            if (jcrInputVariable.getMixintype() != null) {
                mixinTypes = jcrInputVariable.getMixintype().split(",");
            }
            NodeType nodeType = null;
            nodeType = e instanceof Node ? ((Node)e).getPrimaryNodeType() : (nodeTypeName == null || nodeTypeName.length() == 0 ? nodeDef.getRequiredPrimaryTypes()[0] : nodeTypeManger.getNodeType(nodeTypeName));
            childNode = this.doAddNode(currentNode, childNodeName, nodeType.getName(), mixinTypes);
            this.processNodeRecursively(create, newItemPath, childNode, childNode.getPrimaryNodeType(), jcrVariables);
        }
    }

    private void processProperty(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof InputStream) {
                    node.setProperty(propertyName, (InputStream)value);
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String)value).getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    if (isMultiple) {
                        if (value instanceof String) {
                            node.setProperty(propertyName, "");
                        } else if (value instanceof String[]) {
                            node.setProperty(propertyName, new String[0]);
                        }
                    } else {
                        node.setProperty(propertyName, "");
                    }
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (value instanceof String) {
                    String referenceWorksapce = null;
                    String referenceNodeName = null;
                    Session session = node.getSession();
                    String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                    if (((String)value).indexOf(":/") > -1) {
                        referenceWorksapce = ((String)value).split(":/")[0];
                        referenceNodeName = ((String)value).split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            Value value2add = session2.getValueFactory().createValue(referenceNode);
                            node.setProperty(propertyName, value2add);
                            break;
                        }
                        node.setProperty(propertyName, session2.getValueFactory().createValue((String)value));
                        break;
                    }
                    Node referenceNode = null;
                    try {
                        referenceNode = (Node)session.getItem((String)value);
                    }
                    catch (PathNotFoundException e) {
                        referenceNode = session.getRootNode().getNode(value.toString());
                    }
                    if (referenceNode != null) {
                        Value value2add = session.getValueFactory().createValue(referenceNode);
                        node.setProperty(propertyName, value2add);
                        break;
                    }
                    node.setProperty(propertyName, session.getValueFactory().createValue(value.toString()));
                    break;
                }
                if (!(value instanceof String[])) break;
                String[] values = (String[])value;
                String referenceWorksapce = null;
                String referenceNodeName = null;
                Session session = node.getSession();
                String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                ArrayList<Value> list = new ArrayList<Value>();
                for (String v : values) {
                    Value valueObj = null;
                    if (v.indexOf(":/") > 0) {
                        referenceWorksapce = v.split(":/")[0];
                        referenceNodeName = v.split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            valueObj = session2.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session2.getValueFactory().createValue(v);
                        }
                    } else if (session.getRootNode().hasNode(v)) {
                        Node referenceNode = session.getRootNode().getNode(v);
                        valueObj = session.getValueFactory().createValue(referenceNode);
                    } else {
                        valueObj = session.getValueFactory().createValue(v);
                    }
                    list.add(valueObj);
                }
                node.setProperty(propertyName, list.toArray(new Value[list.size()]));
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private void processProperty(Property property, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        String propertyName = property.getName();
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        if (property.getValues().equals(value)) break;
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[]) || property.getValues().equals(value)) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                if (property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof InputStream) {
                    if (property.getValue().getStream().equals(value)) break;
                    node.setProperty(propertyName, (InputStream)value);
                    break;
                }
                if (value instanceof byte[]) {
                    if (property.getValue().getStream().equals(new ByteArrayInputStream((byte[])value))) break;
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getStream().equals(new ByteArrayInputStream(((String)value).getBytes()))) break;
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String)value).getBytes()));
                    break;
                }
                if (!(value instanceof String[]) || property.getValue().getStream().equals(new ByteArrayInputStream(((String[])value).toString().getBytes()))) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getBoolean() == new Boolean((String)value).booleanValue()) break;
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (!(value instanceof String[]) || property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getLong() == new Long((String)value).longValue()) break;
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (!(value instanceof String[]) || property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getDouble() == new Double((String)value).doubleValue()) break;
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (!(value instanceof String[]) || property.getValue().getString().equals(value)) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        if (property.getValues().equals(new Value[]{value2add})) break;
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    if (property.getValues().equals(convertedCalendarValues)) break;
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    if (property.getValue().getString().equals(ISO8601.parse((String)((String)value)))) break;
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar) || property.getValue().getDate().equals(value)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    if (isMultiple) {
                        if (value instanceof String) {
                            node.setProperty(propertyName, "");
                        } else if (value instanceof String[]) {
                            node.setProperty(propertyName, new String[0]);
                        }
                    } else {
                        node.setProperty(propertyName, "");
                    }
                }
                if (value instanceof Value[]) {
                    if (property.getValues().equals(value)) break;
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (value instanceof String) {
                    String referenceWorksapce = null;
                    String referenceNodeName = null;
                    Session session = node.getSession();
                    String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                    if (((String)value).indexOf(":/") > -1) {
                        referenceWorksapce = ((String)value).split(":/")[0];
                        referenceNodeName = ((String)value).split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            Value value2add = session2.getValueFactory().createValue(referenceNode);
                            if (property.getValue().getString().equals(value2add)) break;
                            node.setProperty(propertyName, value2add);
                            break;
                        }
                        if (property.getValue().getString().equals(session2.getValueFactory().createValue((String)value))) break;
                        node.setProperty(propertyName, session2.getValueFactory().createValue((String)value));
                        break;
                    }
                    Node referenceNode = null;
                    try {
                        referenceNode = (Node)session.getItem((String)value);
                    }
                    catch (PathNotFoundException e) {
                        referenceNode = session.getRootNode().getNode(value.toString());
                    }
                    if (referenceNode != null) {
                        Value value2add = session.getValueFactory().createValue(referenceNode);
                        if (property.getValue().getString().equals(value2add)) break;
                        node.setProperty(propertyName, value2add);
                        break;
                    }
                    if (property.getValue().getString().equals(session.getValueFactory().createValue(value.toString()))) break;
                    node.setProperty(propertyName, session.getValueFactory().createValue(value.toString()));
                    break;
                }
                if (!(value instanceof String[])) break;
                String[] values = (String[])value;
                String referenceWorksapce = null;
                String referenceNodeName = null;
                Session session = node.getSession();
                String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                ArrayList<Value> list = new ArrayList<Value>();
                for (String v : values) {
                    Value valueObj = null;
                    if (v.indexOf(":/") > 0) {
                        referenceWorksapce = v.split(":/")[0];
                        referenceNodeName = v.split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            valueObj = session2.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session2.getValueFactory().createValue(v);
                        }
                    } else if (session.getRootNode().hasNode(v)) {
                        Node referenceNode = session.getRootNode().getNode(v);
                        valueObj = session.getValueFactory().createValue(referenceNode);
                    } else {
                        valueObj = session.getValueFactory().createValue(v);
                    }
                    list.add(valueObj);
                }
                if (property.getValues().equals(list.toArray(new Value[list.size()]))) break;
                node.setProperty(propertyName, list.toArray(new Value[list.size()]));
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private String extractNodeName(Set keys) {
        for (String key : keys) {
            if (!key.endsWith("/node")) continue;
            return key;
        }
        return null;
    }

    @Override
    public void moveNode(String nodePath, String srcWorkspace, String destWorkspace, String destPath, String repository) {
        block11: {
            Session srcSession = null;
            Session destSession = null;
            if (!srcWorkspace.equals(destWorkspace)) {
                try {
                    srcSession = this.jcrService.getRepository(repository).getSystemSession(srcWorkspace);
                    destSession = this.jcrService.getRepository(repository).getSystemSession(destWorkspace);
                    Workspace workspace = destSession.getWorkspace();
                    Node srcNode = (Node)srcSession.getItem(nodePath);
                    try {
                        destSession.getItem(destPath);
                    }
                    catch (PathNotFoundException e) {
                        this.createNode(destSession, destPath);
                    }
                    workspace.clone(srcWorkspace, nodePath, destPath, true);
                    srcNode.remove();
                    srcSession.save();
                    destSession.save();
                    srcSession.logout();
                    destSession.logout();
                }
                catch (Exception e) {
                    if (srcSession != null) {
                        srcSession.logout();
                    }
                    if (destSession != null) {
                        destSession.logout();
                    }
                    break block11;
                }
            }
            Session session = null;
            try {
                session = this.jcrService.getRepository(repository).getSystemSession(srcWorkspace);
                Workspace workspace = session.getWorkspace();
                try {
                    session.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    this.createNode(session, destPath);
                    session.refresh(false);
                }
                workspace.move(nodePath, destPath);
                session.logout();
            }
            catch (Exception e) {
                if (session == null || !session.isLive()) break block11;
                session.logout();
            }
        }
    }

    private void createNode(Session session, String uri) throws RepositoryException {
        String[] splittedName = StringUtils.split((String)uri, (String)"/");
        Node rootNode = session.getRootNode();
        for (int i = 0; i < splittedName.length - 1; ++i) {
            try {
                rootNode.getNode(splittedName[i]);
            }
            catch (PathNotFoundException exc) {
                rootNode.addNode(splittedName[i], "nt:unstructured");
                rootNode.save();
            }
            rootNode = rootNode.getNode(splittedName[i]);
        }
        session.save();
    }

    private List<JcrInputProperty> extractNodeInputs(Map<String, JcrInputProperty> map, int itemLevel) {
        ArrayList<JcrInputProperty> list = new ArrayList<JcrInputProperty>();
        for (String jcrPath : map.keySet()) {
            JcrInputProperty input;
            if (itemLevel != StringUtils.countMatches((String)jcrPath, (String)"/") || (input = map.get(jcrPath)).getType() != 1) continue;
            list.add(input);
        }
        return list;
    }

    private boolean canAddNode(NodeDefinition nodeDef, NodeType nodeType) {
        for (NodeType type : nodeDef.getRequiredPrimaryTypes()) {
            if (!nodeType.isNodeType(type.getName())) continue;
            return true;
        }
        return false;
    }

    private Node doAddNode(Node currentNode, String nodeName, String nodeType, String[] mixinTypes) throws Exception {
        Node childNode = null;
        try {
            childNode = currentNode.getNode(nodeName);
        }
        catch (PathNotFoundException pe) {
            childNode = currentNode.addNode(nodeName, nodeType);
        }
        if (mixinTypes != null && mixinTypes.length > 0) {
            for (String mixinName : mixinTypes) {
                if (childNode.isNodeType(mixinName)) continue;
                childNode.addMixin(mixinName);
            }
        }
        return childNode;
    }
}

