/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.scripts.impl;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.codehaus.groovy.control.CompilationFailedException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cms.BasePath;
import org.exoplatform.services.cms.impl.BaseResourceLoaderService;
import org.exoplatform.services.cms.impl.ResourceConfig;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.scripts.impl.ScriptPlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptServiceImpl
extends BaseResourceLoaderService
implements ScriptService,
EventListener {
    private GroovyClassLoader groovyClassLoader_;
    private RepositoryService repositoryService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;
    List<ScriptPlugin> plugins_ = new ArrayList<ScriptPlugin>();

    public ScriptServiceImpl(RepositoryService repositoryService, ConfigurationManager cservice, NodeHierarchyCreator nodeHierarchyCreator, CacheService cacheService) throws Exception {
        super(cservice, nodeHierarchyCreator, repositoryService, cacheService);
        this.groovyClassLoader_ = this.createGroovyClassLoader();
        this.repositoryService_ = repositoryService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    @Override
    public void start() {
        try {
            this.initPlugins();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addScriptPlugin(ComponentPlugin plugin) {
        if (plugin instanceof ScriptPlugin) {
            this.plugins_.add((ScriptPlugin)plugin);
        }
    }

    private void initPlugins() throws Exception {
        Session session = null;
        String scriptsPath = this.getBasePath();
        for (ScriptPlugin plugin : this.plugins_) {
            String repository;
            String scriptsLocation = plugin.getPredefineScriptsLocation();
            if (plugin.getAutoCreateInNewRepository()) {
                List repositories = this.repositoryService_.getConfig().getRepositoryConfigurations();
                for (RepositoryEntry repo : repositories) {
                    session = this.repositoryService_.getRepository(repo.getName()).getSystemSession(repo.getSystemWorkspaceName());
                    Iterator<ObjectParameter> iter = plugin.getScriptIterator();
                    while (iter.hasNext()) {
                        this.init(session, (ResourceConfig)iter.next().getObject(), scriptsLocation);
                    }
                    ObservationManager obsManager = session.getWorkspace().getObservationManager();
                    obsManager.addEventListener((EventListener)this, 16, scriptsPath, true, null, null, true);
                    session.save();
                    session.logout();
                }
            }
            if ((repository = plugin.getInitRepository()) == null) {
                repository = this.repositoryService_.getDefaultRepository().getConfiguration().getName();
            }
            ManageableRepository mRepository = this.repositoryService_.getRepository(repository);
            session = mRepository.getSystemSession(mRepository.getConfiguration().getSystemWorkspaceName());
            Iterator<ObjectParameter> iter = plugin.getScriptIterator();
            while (iter.hasNext()) {
                this.init(session, (ResourceConfig)iter.next().getObject(), scriptsLocation);
            }
            ObservationManager obsManager = session.getWorkspace().getObservationManager();
            obsManager.addEventListener((EventListener)this, 16, scriptsPath, true, null, null, true);
            session.save();
            session.logout();
        }
    }

    @Override
    protected String getBasePath() {
        return this.nodeHierarchyCreator_.getJcrPath(BasePath.CMS_SCRIPTS_PATH);
    }

    @Override
    public void initRepo(String repository) throws Exception {
        ManageableRepository mRepository = this.repositoryService_.getRepository(repository);
        String scriptsPath = this.getBasePath();
        Session session = mRepository.getSystemSession(mRepository.getConfiguration().getSystemWorkspaceName());
        for (ScriptPlugin plugin : this.plugins_) {
            if (!plugin.getAutoCreateInNewRepository()) continue;
            String scriptsLocation = plugin.getPredefineScriptsLocation();
            Iterator<ObjectParameter> iter = plugin.getScriptIterator();
            while (iter.hasNext()) {
                this.init(session, (ResourceConfig)iter.next().getObject(), scriptsLocation);
            }
            ObservationManager obsManager = session.getWorkspace().getObservationManager();
            obsManager.addEventListener((EventListener)this, 16, scriptsPath, true, null, null, true);
        }
        session.save();
        session.logout();
    }

    @Override
    public Node getECMScriptHome(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return this.getNodeByAlias(BasePath.ECM_EXPLORER_SCRIPTS, session);
    }

    @Override
    public Node getCBScriptHome(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return this.getNodeByAlias(BasePath.CONTENT_BROWSER_SCRIPTS, session);
    }

    public List<Node> getCBScripts(String repository, SessionProvider provider) throws Exception {
        ArrayList<Node> scriptList = new ArrayList<Node>();
        Node cbScriptHome = this.getCBScriptHome(repository, provider);
        NodeIterator iter = cbScriptHome.getNodes();
        while (iter.hasNext()) {
            scriptList.add(iter.nextNode());
        }
        return scriptList;
    }

    @Override
    public List<Node> getECMActionScripts(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return this.getScriptList(BasePath.ECM_ACTION_SCRIPTS, session);
    }

    @Override
    public List<Node> getECMInterceptorScripts(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return this.getScriptList(BasePath.ECM_INTERCEPTOR_SCRIPTS, session);
    }

    @Override
    public List<Node> getECMWidgetScripts(String repository, SessionProvider provider) throws Exception {
        Session session = this.getSession(repository, provider);
        return this.getScriptList(BasePath.ECM_WIDGET_SCRIPTS, session);
    }

    @Override
    public String getBaseScriptPath() throws Exception {
        return this.getBasePath();
    }

    public String[] getECMCategoriesPath() throws Exception {
        String[] categoriesPath = new String[]{this.nodeHierarchyCreator_.getJcrPath(BasePath.ECM_ACTION_SCRIPTS), this.nodeHierarchyCreator_.getJcrPath(BasePath.ECM_INTERCEPTOR_SCRIPTS), this.nodeHierarchyCreator_.getJcrPath(BasePath.ECM_WIDGET_SCRIPTS)};
        return categoriesPath;
    }

    public String[] getCBCategoriesPath() throws Exception {
        String[] categoriesPath = new String[]{this.nodeHierarchyCreator_.getJcrPath(BasePath.CONTENT_BROWSER_SCRIPTS)};
        return categoriesPath;
    }

    @Override
    public String getScriptAsText(String scriptName, String repository) throws Exception {
        return this.getResourceAsText(scriptName, repository);
    }

    @Override
    public CmsScript getScript(String scriptName, String repository) throws Exception {
        CmsScript scriptObject = (CmsScript)this.resourceCache_.get((Serializable)((Object)scriptName));
        if (scriptObject != null) {
            return scriptObject;
        }
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        scriptObject = (CmsScript)container.getComponentInstance((Object)scriptName);
        if (scriptObject != null) {
            this.resourceCache_.put((Serializable)((Object)scriptName), (Object)scriptObject);
            return scriptObject;
        }
        this.groovyClassLoader_ = this.createGroovyClassLoader();
        Class scriptClass = this.groovyClassLoader_.loadClass(scriptName);
        container.registerComponentImplementation((Object)scriptName, scriptClass);
        scriptObject = (CmsScript)container.getComponentInstance((Object)scriptName);
        this.resourceCache_.put((Serializable)((Object)scriptName), (Object)scriptObject);
        return scriptObject;
    }

    @Override
    public void addScript(String name, String text, String repository, SessionProvider provider) throws Exception {
        this.addResource(name, text, repository, provider);
        this.removeFromCache(name);
    }

    @Override
    public void removeScript(String scriptName, String repository, SessionProvider provider) throws Exception {
        this.removeResource(scriptName, repository, provider);
        this.removeFromCache(scriptName);
    }

    private Node getScriptHome(String scriptAlias, Session session) throws Exception {
        String path = this.nodeHierarchyCreator_.getJcrPath(scriptAlias);
        return (Node)session.getItem(path);
    }

    private List<Node> getScriptList(String scriptAlias, Session session) throws Exception {
        ArrayList<Node> scriptList = new ArrayList<Node>();
        Node scriptHome = this.getScriptHome(scriptAlias, session);
        NodeIterator iter = scriptHome.getNodes();
        while (iter.hasNext()) {
            scriptList.add(iter.nextNode());
        }
        return scriptList;
    }

    @Override
    protected void removeFromCache(String scriptName) {
        try {
            Object cachedobject = this.resourceCache_.get((Serializable)((Object)scriptName));
            if (cachedobject != null) {
                this.resourceCache_.remove((Serializable)((Object)scriptName));
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                container.unregisterComponent((Object)scriptName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onEvent(EventIterator events) {
        while (events.hasNext()) {
            Event event = events.nextEvent();
            String path = null;
            Session jcrSession = null;
            try {
                path = event.getPath();
                List repositories = this.repositoryService_.getConfig().getRepositoryConfigurations();
                for (RepositoryEntry repo : repositories) {
                    try {
                        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repo.getName());
                        jcrSession = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getSystemWorkspaceName());
                        Property property = (Property)jcrSession.getItem(path);
                        if ("jcr:data".equals(property.getName())) {
                            Node node = property.getParent();
                            this.removeFromCache(node.getName());
                        }
                        jcrSession.logout();
                    }
                    catch (Exception e) {
                        jcrSession.logout();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private GroovyClassLoader createGroovyClassLoader() {
        ClassLoader parentLoader = Thread.currentThread().getContextClassLoader();
        return new GroovyClassLoader(parentLoader){

            protected Class findClass(String className) throws ClassNotFoundException {
                String repository = null;
                String filename = null;
                String nodeName = null;
                if (className.indexOf(":") > -1) {
                    String[] array = className.split(":");
                    repository = array[0];
                    nodeName = array[1];
                    filename = array[1].replace('.', File.separatorChar) + ".groovy";
                } else {
                    nodeName = className;
                    filename = className.replace('.', File.separatorChar) + ".groovy";
                }
                InputStream in = null;
                SessionProvider provider = SessionProvider.createSystemProvider();
                try {
                    Node scriptsHome = ScriptServiceImpl.this.getResourcesHome(repository, provider);
                    Node scriptNode = scriptsHome.getNode(nodeName);
                    in = scriptNode.getProperty("jcr:data").getStream();
                    provider.close();
                }
                catch (Exception e) {
                    provider.close();
                    throw new ClassNotFoundException("Could not read " + nodeName + ": " + e);
                }
                try {
                    return this.parseClass(in, filename);
                }
                catch (CompilationFailedException e2) {
                    throw new ClassNotFoundException("Syntax error in " + filename + ": " + (Object)((Object)e2));
                }
            }
        };
    }

    @Override
    public Node getScriptNode(String scriptName, String repository, SessionProvider provider) throws Exception {
        try {
            Node scriptHome = this.getResourcesHome(repository, provider);
            return scriptHome.getNode(scriptName);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Session getSession(String repository, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String systemWokspace = manageableRepository.getConfiguration().getSystemWorkspaceName();
        return provider.getSession(systemWokspace, manageableRepository);
    }

    private Node getNodeByAlias(String alias, Session session) throws Exception {
        String path = this.nodeHierarchyCreator_.getJcrPath(alias);
        return (Node)session.getItem(path);
    }
}

