/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.watch.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Value;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.watch.WatchDocumentService;
import org.exoplatform.services.cms.watch.impl.MessageConfig;
import org.exoplatform.services.cms.watch.impl.WatchDocumentServiceImpl;
import org.exoplatform.services.mail.MailService;
import org.exoplatform.services.mail.Message;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmailNotifyListener
implements EventListener {
    private Node observedNode_;
    public static final String EMAIL_WATCHERS_PROP = "exo:emailWatcher".intern();

    public EmailNotifyListener(Node oNode) {
        this.observedNode_ = oNode;
    }

    public void onEvent(EventIterator arg0) {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        MailService mailService = (MailService)container.getComponentInstanceOfType(MailService.class);
        WatchDocumentServiceImpl watchService = (WatchDocumentServiceImpl)container.getComponentInstanceOfType(WatchDocumentService.class);
        MessageConfig messageConfig = watchService.getMessageConfig();
        List<String> emailList = this.getEmailList(this.observedNode_);
        for (String receiver : emailList) {
            Message message = this.createMessage(receiver, messageConfig);
            try {
                mailService.sendMessage(message);
            }
            catch (Exception e) {
                System.out.println("===> Exeption when send message to: " + message.getTo());
                e.printStackTrace();
            }
        }
    }

    private Message createMessage(String receiver, MessageConfig messageConfig) {
        Message message = new Message();
        message.setFrom(messageConfig.getSender());
        message.setTo(receiver);
        message.setSubject(messageConfig.getSubject());
        message.setBody(messageConfig.getContent());
        message.setMimeType(messageConfig.getMimeType());
        return message;
    }

    private List<String> getEmailList(Node observedNode) {
        ArrayList<String> emailList = new ArrayList<String>();
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        OrganizationService orgService = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
        try {
            if (observedNode.hasProperty(EMAIL_WATCHERS_PROP)) {
                Value[] watcherNames;
                for (Value value : watcherNames = observedNode.getProperty(EMAIL_WATCHERS_PROP).getValues()) {
                    String userName = value.getString();
                    User user = orgService.getUserHandler().findUserByName(userName);
                    if (user == null) continue;
                    emailList.add(user.getEmail());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return emailList;
    }
}

