/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.resolver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.resolver.ResourceResolver;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JCRResourceResolver
extends ResourceResolver {
    protected String repository;
    protected String workspace;
    protected String propertyName;

    public JCRResourceResolver(String repository, String workspace, String propertyName) {
        this.repository = repository;
        this.workspace = workspace;
        this.propertyName = propertyName;
    }

    public URL getResource(String url) throws Exception {
        throw new Exception("This method is not  supported");
    }

    public InputStream getInputStream(String url) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)container.getComponentInstanceOfType(RepositoryService.class);
        ManageableRepository manageableRepository = repositoryService.getRepository(this.repository);
        TemplateService templateService = (TemplateService)container.getComponentInstanceOfType(TemplateService.class);
        SessionProvider provider = SessionProviderFactory.createSystemProvider();
        Session session = provider.getSession(this.workspace, manageableRepository);
        Node node = (Node)session.getItem(this.removeScheme(url));
        String locale = ((UIPortalApplication)Util.getUIPortal().getAncestorOfType(UIPortalApplication.class)).getLocale().getLanguage();
        return new ByteArrayInputStream(templateService.getTemplateData(node, locale, this.propertyName, this.repository).getBytes());
    }

    public List<URL> getResources(String url) throws Exception {
        throw new Exception("This method is not  supported");
    }

    public List<InputStream> getInputStreams(String url) throws Exception {
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>(1);
        inputStreams.add(this.getInputStream(url));
        return inputStreams;
    }

    public boolean isModified(String url, long lastAccess) {
        return false;
    }

    public String createResourceId(String url) {
        return url;
    }

    public String getResourceScheme() {
        return "jcr:";
    }
}

