/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.comparator;

import java.util.Comparator;
import javax.jcr.Node;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.ext.audit.AuditHistory;
import org.exoplatform.services.jcr.ext.audit.AuditService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringComparator
implements Comparator<Node> {
    public static final String ASCENDING_ORDER = "Ascending";
    public static final String DESCENDING_ORDER = "Descending";
    private String order_;
    private String type_;

    public StringComparator(String order, String type) {
        this.order_ = order;
        this.type_ = type;
    }

    private String getVersionName(Node node) throws Exception {
        return node.getBaseVersion().getName();
    }

    private String versionName(Node node) throws Exception {
        String returnString = "";
        returnString = String.valueOf(Utils.isVersionable(node));
        if (Utils.isVersionable(node) && !this.getVersionName(node).equals("jcr:rootVersion")) {
            returnString = "(" + this.getVersionName(node) + ")";
        }
        return returnString;
    }

    private boolean hasAuditHistory(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        AuditService auServ = (AuditService)container.getComponentInstanceOfType(AuditService.class);
        return auServ.hasHistory(node);
    }

    private int getNumAuditHistory(Node node) throws Exception {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        AuditService auServ = (AuditService)container.getComponentInstanceOfType(AuditService.class);
        if (auServ.hasHistory(node)) {
            AuditHistory auHistory = auServ.getHistory(node);
            return auHistory.getAuditRecords().size();
        }
        return 0;
    }

    private String getAuditing(Node node) throws Exception {
        String returnString = "";
        returnString = String.valueOf(Utils.isAuditable(node));
        if (Utils.isAuditable(node) && this.hasAuditHistory(node)) {
            returnString = "(" + this.getNumAuditHistory(node) + ")";
        }
        return returnString;
    }

    @Override
    private int compare(String s1, String s2) {
        if (ASCENDING_ORDER.equals(this.order_)) {
            return s1.compareTo(s2);
        }
        return s2.compareTo(s1);
    }

    @Override
    public int compare(Node node1, Node node2) {
        int returnCompare = 0;
        try {
            if (this.type_.equals("Owner")) {
                if (node1.hasProperty("exo:owner") && node2.hasProperty("exo:owner")) {
                    String owner1 = node1.getProperty("exo:owner").getString();
                    String owner2 = node2.getProperty("exo:owner").getString();
                    returnCompare = this.compare(owner1, owner2);
                }
            } else if (this.type_.equals("Versionable")) {
                String versionNode1 = this.versionName(node1);
                String versionNode2 = this.versionName(node2);
                returnCompare = this.compare(versionNode1, versionNode2);
            } else if (this.type_.equals("Auditing")) {
                String auditing1 = this.getAuditing(node1);
                String auditing2 = this.getAuditing(node2);
                returnCompare = this.compare(auditing1, auditing2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnCompare;
    }
}

