/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.form;

import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.ecm.resolver.JCRResourceResolver;
import org.exoplatform.ecm.webui.form.field.UIFormActionField;
import org.exoplatform.ecm.webui.form.field.UIFormCalendarField;
import org.exoplatform.ecm.webui.form.field.UIFormHiddenField;
import org.exoplatform.ecm.webui.form.field.UIFormSelectBoxField;
import org.exoplatform.ecm.webui.form.field.UIFormTextAreaField;
import org.exoplatform.ecm.webui.form.field.UIFormTextField;
import org.exoplatform.ecm.webui.form.field.UIFormUploadField;
import org.exoplatform.ecm.webui.form.field.UIFormWYSIWYGField;
import org.exoplatform.ecm.webui.form.field.UIMixinField;
import org.exoplatform.ecm.webui.utils.DialogFormUtil;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.fckconfig.FCKConfigService;
import org.exoplatform.services.ecm.fckconfig.FCKEditorContext;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.wysiwyg.FCKEditorConfig;
import org.exoplatform.webui.form.wysiwyg.UIFormWYSIWYGInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIDialogForm
extends UIForm {
    private final String REPOSITORY = "repository";
    protected static final String CANCEL_ACTION = "Cancel".intern();
    protected static final String SAVE_ACTION = "Save".intern();
    protected static final String[] ACTIONS = new String[]{SAVE_ACTION, CANCEL_ACTION};
    protected Map<String, Map<String, String>> componentSelectors = new HashMap<String, Map<String, String>>();
    protected Map<String, String> fieldNames = new HashMap<String, String>();
    protected Map<String, String> propertiesName = new HashMap<String, String>();
    protected String contentType;
    protected boolean isAddNew = true;
    protected boolean isRemovePreference = false;
    protected boolean isShowingComponent = false;
    protected boolean isUpdateSelect = false;
    protected Map<String, JcrInputProperty> properties = new HashMap<String, JcrInputProperty>();
    protected String repositoryName = null;
    protected JCRResourceResolver resourceResolver;
    private String childPath;
    private boolean isNotEditNode = false;
    private boolean dataRemoved_ = false;
    private boolean isNTFile = false;
    private boolean isOnchange = false;
    private boolean isResetForm = false;
    private boolean isResetMultiField = false;
    protected String nodePath;
    private List<String> postScriptInterceptor = new ArrayList<String>();
    private List<String> prevScriptInterceptor = new ArrayList<String>();
    private String storedPath = null;
    protected String workspaceName = null;
    protected boolean isReference = false;
    private static final String TAXONOMIES_ALIAS = "exoTaxonomiesPath";
    private String SEPARATOR_VALUE = "::";

    public boolean isEditing() {
        return !this.isAddNew;
    }

    public boolean isAddNew() {
        return this.isAddNew;
    }

    public void addNew(boolean b) {
        this.isAddNew = b;
    }

    public void setStoredLocation(String repository, String workspace, String storedPath) {
        this.repositoryName = repository;
        this.workspaceName = workspace;
        this.storedPath = storedPath;
    }

    public void addActionField(String name, String label, String[] arguments) throws Exception {
        UIFormActionField formActionField = new UIFormActionField(name, label, arguments);
        if (formActionField.useSelector()) {
            this.componentSelectors.put(name, formActionField.getSelectorInfo());
        }
        String jcrPath = formActionField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        this.isReference = formActionField.isReference();
        if (formActionField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormStringInput.class, name, label);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = (UIFormStringInput)formActionField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiInput);
        }
        String propertyName = this.getPropertyName(jcrPath);
        uiInput.setEditable(formActionField.isEditable());
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        if (node != null && !this.isShowingComponent && !this.isRemovePreference) {
            if (jcrPath.equals("/node") && (!formActionField.isEditable() || formActionField.isEditableIfNull())) {
                uiInput.setValue((Object)node.getName());
                uiInput.setEditable(false);
            } else if (node.hasProperty(propertyName) && !this.isUpdateSelect) {
                String relPath = "";
                String itemRelPath = "";
                if (node.getProperty(propertyName).getDefinition().getRequiredType() == 9) {
                    if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                        Value[] values;
                        StringBuffer buffer = new StringBuffer();
                        for (Value value : values = node.getProperty(propertyName).getValues()) {
                            buffer.append(value).append(",");
                        }
                        if (buffer.toString().endsWith(",")) {
                            buffer.deleteCharAt(buffer.length() - 1);
                        }
                        uiInput.setValue((Object)buffer.toString());
                    } else {
                        String path = this.getNodePathByUUID(node.getProperty(propertyName).getValue().getString());
                        uiInput.setValue((Object)path);
                    }
                } else if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                    Value[] values = node.getProperty(propertyName).getValues();
                    StringBuffer buffer = new StringBuffer();
                    for (Value value : values) {
                        buffer.append(value).append(",");
                    }
                    if (buffer.toString().endsWith(",")) {
                        buffer.deleteCharAt(buffer.length() - 1);
                    }
                    uiInput.setValue((Object)buffer.toString());
                } else {
                    uiInput.setValue((Object)node.getProperty(propertyName).getValue().getString());
                }
            }
        }
        Node childNode = this.getChildNode();
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            if (childNode != null) {
                uiInput.setValue((Object)propertyName);
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiInput.setValue((Object)node.getName());
            } else {
                uiInput.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addActionField(String name, String[] arguments) throws Exception {
        this.addActionField(name, null, arguments);
    }

    public void addCalendarField(String name, String label, String[] arguments) throws Exception {
        UIFormCalendarField calendarField = new UIFormCalendarField(name, label, arguments);
        String jcrPath = calendarField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        if (calendarField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormDateTimeInput.class, name, label);
            return;
        }
        UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)this.findComponentById(name);
        if (uiDateTime == null) {
            uiDateTime = (UIFormDateTimeInput)calendarField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiDateTime);
        }
        uiDateTime.setDisplayTime(calendarField.isDisplayTime());
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        if (node != null && node.hasProperty(propertyName) && !this.isShowingComponent && !this.isRemovePreference) {
            uiDateTime.setCalendar(node.getProperty(propertyName).getDate());
        }
        Node childNode = this.getChildNode();
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            if (childNode != null) {
                if (childNode.hasProperty(propertyName)) {
                    if (childNode.getProperty(propertyName).getDefinition().isMultiple()) {
                        Value[] values;
                        for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                            uiDateTime.setCalendar(value.getDate());
                        }
                    } else {
                        uiDateTime.setCalendar(childNode.getProperty(propertyName).getValue().getDate());
                    }
                }
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiDateTime.setCalendar(node.getProperty(propertyName).getDate());
            } else {
                uiDateTime.setCalendar((Calendar)new GregorianCalendar());
            }
        }
        if (calendarField.isVisible()) {
            this.renderField(name);
        }
    }

    public void addCalendarField(String name, String[] arguments) throws Exception {
        this.addCalendarField(name, null, arguments);
    }

    public void addHiddenField(String name, String[] arguments) throws Exception {
        UIFormHiddenField formHiddenField = new UIFormHiddenField(name, null, arguments);
        String jcrPath = formHiddenField.getJcrPath();
        JcrInputProperty inputProperty = formHiddenField.createJcrInputProperty();
        this.setInputProperty(name, inputProperty);
    }

    public void addInterceptor(String scriptPath, String type) {
        if (scriptPath.length() > 0 && type.length() > 0) {
            if (type.equals("prev")) {
                this.prevScriptInterceptor.add(scriptPath);
            } else if (type.equals("post")) {
                this.postScriptInterceptor.add(scriptPath);
            }
        }
    }

    public void addMixinField(String name, String label, String[] arguments) throws Exception {
        UIMixinField mixinField = new UIMixinField(name, label, arguments);
        String jcrPath = mixinField.getJcrPath();
        String nodetype = mixinField.getNodeType();
        String mixintype = mixinField.getMixinTypes();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, inputProperty);
        Node node = this.getNode();
        if (node != null && mixinField.isVisibleIfNotNull()) {
            UIFormStringInput uiMixin = (UIFormStringInput)this.findComponentById(name);
            if (uiMixin == null) {
                uiMixin = (UIFormStringInput)mixinField.createUIFormInput();
                this.addUIFormInput((UIFormInput)uiMixin);
            }
            uiMixin.setValue((Object)node.getName());
            uiMixin.setEditable(false);
            this.renderField(name);
        }
    }

    public void addMixinField(String name, String[] arguments) throws Exception {
        this.addMixinField(name, null, arguments);
    }

    public void addSelectBoxField(String name, String label, String[] arguments) throws Exception {
        Node child;
        UIFormSelectBoxField formSelectBoxField = new UIFormSelectBoxField(name, label, arguments);
        String jcrPath = formSelectBoxField.getJcrPath();
        String editable = formSelectBoxField.getEditable();
        String onchange = formSelectBoxField.getOnchange();
        String defaultValue = formSelectBoxField.getDefaultValue();
        String options = formSelectBoxField.getOptions();
        String script = formSelectBoxField.getGroovyScript();
        if (editable == null) {
            formSelectBoxField.setEditable("true");
        }
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox == null || this.isResetForm) {
            uiSelectBox = new UIFormSelectBox(name, name, null);
            this.addUIFormInput((UIFormInput)uiSelectBox);
            if (script != null) {
                try {
                    String[] scriptParams = formSelectBoxField.getScriptParams();
                    if ("repository".equals(scriptParams[0])) {
                        scriptParams[0] = this.repositoryName;
                    }
                    this.executeScript(script, uiSelectBox, scriptParams);
                }
                catch (Exception e) {
                    uiSelectBox.setOptions(optionsList);
                }
            } else if (options != null && options.length() > 0) {
                String[] array = options.split(",");
                for (int i = 0; i < array.length; ++i) {
                    ArrayList<String> listValue = new ArrayList<String>();
                    String[] arrayChild = array[i].trim().split(this.SEPARATOR_VALUE);
                    for (int j = 0; j < arrayChild.length; ++j) {
                        if (arrayChild[j].trim().equals("")) continue;
                        listValue.add(arrayChild[j].trim());
                    }
                    if (listValue.size() > 1) {
                        optionsList.add(new SelectItemOption((String)listValue.get(0), listValue.get(1)));
                        continue;
                    }
                    optionsList.add(new SelectItemOption((String)listValue.get(0), listValue.get(0)));
                }
                uiSelectBox.setOptions(optionsList);
            } else {
                uiSelectBox.setOptions(optionsList);
            }
            if (defaultValue != null) {
                uiSelectBox.setValue(defaultValue);
            }
        }
        this.propertiesName.put(name, this.getPropertyName(jcrPath));
        this.fieldNames.put(this.getPropertyName(jcrPath), name);
        String[] arrNodes = jcrPath.split("/");
        Node childNode = null;
        Node node = this.getNode();
        String propertyName = this.getPropertyName(jcrPath);
        if (node != null && arrNodes.length == 4) {
            childNode = node.getNode(arrNodes[2]);
        }
        if (formSelectBoxField.isMultiValues()) {
            ArrayList valueList;
            uiSelectBox.setMultiple(true);
            StringBuffer buffer = new StringBuffer();
            if (childNode != null) {
                Value[] values;
                valueList = new ArrayList();
                for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                    buffer.append(value.getString()).append(",");
                }
                uiSelectBox.setSelectedValues(StringUtils.split((String)buffer.toString(), (String)","));
            } else if (node != null && node.hasProperty(propertyName)) {
                valueList = new ArrayList();
                if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value value : values = node.getProperty(propertyName).getValues()) {
                        buffer.append(value.getString()).append(",");
                    }
                } else if (onchange.equals("true") && this.isOnchange) {
                    String values = (String)uiSelectBox.getValue();
                    buffer.append(values).append(",");
                } else {
                    Value[] values;
                    for (Value value : values = node.getProperty(propertyName).getValues()) {
                        buffer.append(value.getString()).append(",");
                    }
                }
                uiSelectBox.setSelectedValues(StringUtils.split((String)buffer.toString(), (String)","));
            }
        } else if (childNode != null) {
            uiSelectBox.setValue(childNode.getProperty(propertyName).getValue().getString());
        } else if (node != null && node.hasProperty(propertyName)) {
            if (node.getProperty(propertyName).getDefinition().isMultiple()) {
                uiSelectBox.setValue(node.getProperty(propertyName).getValues().toString());
            } else if (formSelectBoxField.isOnchange() && this.isOnchange) {
                uiSelectBox.setValue((String)uiSelectBox.getValue());
            } else {
                uiSelectBox.setValue(node.getProperty(propertyName).getValue().getString());
            }
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        uiSelectBox.setEditable(formSelectBoxField.isEditable());
        this.addUIFormInput((UIFormInput)uiSelectBox);
        if (this.isNotEditNode && (child = this.getChildNode()) != null) {
            uiSelectBox.setValue(DialogFormUtil.getPropertyValueAsString(child, propertyName));
        }
        if (formSelectBoxField.isOnchange()) {
            uiSelectBox.setOnChange("Onchange");
        }
        this.renderField(name);
    }

    public void addSelectBoxField(String name, String[] arguments) throws Exception {
        this.addSelectBoxField(name, null, arguments);
    }

    public void addTextAreaField(String name, String label, String[] arguments) throws Exception {
        Node jcrContentNode;
        UIFormTextAreaField formTextAreaField = new UIFormTextAreaField(name, label, arguments);
        if (formTextAreaField.useSelector()) {
            this.componentSelectors.put(name, formTextAreaField.getSelectorInfo());
        }
        String jcrPath = formTextAreaField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        if (formTextAreaField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormDateTimeInput.class, name, label);
            return;
        }
        UIFormTextAreaInput uiTextArea = (UIFormTextAreaInput)this.findComponentById(name);
        if (uiTextArea == null) {
            uiTextArea = (UIFormTextAreaInput)formTextAreaField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiTextArea);
        }
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        if (node != null && !this.isShowingComponent && !this.isRemovePreference) {
            String value = null;
            if (node.hasProperty(propertyName)) {
                value = node.getProperty(propertyName).getValue().getString();
            } else if (node.isNodeType("nt:file") && (jcrContentNode = node.getNode("jcr:content")).hasProperty(propertyName)) {
                if (jcrContentNode.getProperty(propertyName).getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value v : values = jcrContentNode.getProperty(propertyName).getValues()) {
                        value = value + v.getString();
                    }
                } else {
                    value = jcrContentNode.getProperty(propertyName).getValue().getString();
                }
            }
            uiTextArea.setValue((Object)value);
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            Node childNode = this.getChildNode();
            if (node != null && node.hasNode("jcr:content") && childNode != null) {
                jcrContentNode = node.getNode("jcr:content");
                uiTextArea.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (childNode != null) {
                uiTextArea.setValue((Object)propertyName);
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiTextArea.setValue((Object)node.getName());
            } else {
                uiTextArea.setValue(null);
            }
        }
        if (uiTextArea.getValue() == null) {
            if (formTextAreaField.getDefaultValue() != null) {
                uiTextArea.setValue((Object)formTextAreaField.getDefaultValue());
            } else {
                uiTextArea.setValue((Object)"");
            }
        }
        uiTextArea.setEditable(formTextAreaField.isEditable());
        this.renderField(name);
    }

    public void addTextAreaField(String name, String[] arguments) throws Exception {
        this.addTextAreaField(name, null, arguments);
    }

    public String getPathTaxonomy() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        Session session = this.getSesssion();
        return ((Node)session.getItem(nodeHierarchyCreator.getJcrPath(TAXONOMIES_ALIAS))).getPath();
    }

    /*
     * WARNING - void declaration
     */
    public void addTextField(String name, String label, String[] arguments) throws Exception {
        String pathTaxonomy = this.getPathTaxonomy() + "/";
        UIFormTextField formTextField = new UIFormTextField(name, label, arguments);
        String jcrPath = formTextField.getJcrPath();
        String mixintype = formTextField.getMixinTypes();
        String nodetype = formTextField.getNodeType();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        if (mixintype != null) {
            inputProperty.setMixintype(mixintype);
        }
        if (jcrPath.equals("/node") && nodetype != null) {
            inputProperty.setNodetype(nodetype);
        }
        this.properties.put(name, inputProperty);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        Node childNode = this.getChildNode();
        if (!this.isReference) {
            this.isReference = formTextField.isReference();
        }
        if (formTextField.isMultiValues()) {
            String[] validatorList;
            String validateType;
            UIFormMultiValueInputSet uiMulti;
            if (node == null && childNode == null) {
                uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
                if (uiMulti == null) {
                    uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                    uiMulti.setId(name);
                    uiMulti.setName(name);
                    uiMulti.setType(UIFormStringInput.class);
                    if (formTextField.validateType != null) {
                        validateType = formTextField.validateType;
                        validatorList = null;
                        validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                        for (String string : validatorList) {
                            uiMulti.addValidator(DialogFormUtil.getValidator(string.trim()), new Object[0]);
                        }
                    }
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            } else {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormStringInput.class);
                if (formTextField.validateType != null) {
                    validateType = formTextField.validateType;
                    validatorList = null;
                    validatorList = validateType.indexOf(44) > -1 ? validateType.split(",") : new String[]{validateType};
                    for (String string : validatorList) {
                        uiMulti.addValidator(DialogFormUtil.getValidator(string.trim()), new Object[0]);
                    }
                }
                this.addUIFormInput((UIFormInput)uiMulti);
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (childNode != null && childNode.hasProperty(propertyName)) {
                Value[] values;
                for (Value value : values = childNode.getProperty(propertyName).getValues()) {
                    if (propertyName.equals("exo:category")) {
                        String categoryPath = node.getSession().getNodeByUUID(value.getString()).getPath().replaceAll(pathTaxonomy, "");
                        valueList.add(categoryPath);
                        continue;
                    }
                    valueList.add(value.getString());
                }
                uiMulti.setValue(valueList);
            }
            if (node != null && !this.isShowingComponent && !this.isRemovePreference) {
                String propertyPath = jcrPath.substring("/node/".length());
                if (node.hasProperty(propertyPath)) {
                    void var19_34;
                    Value[] valueArray;
                    Value[] arr$ = valueArray = node.getProperty(propertyPath).getValues();
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var19_34 < len$) {
                        Value vl = arr$[var19_34];
                        if (vl != null) {
                            if (propertyPath.equals("exo:category")) {
                                String categoryPath = node.getSession().getNodeByUUID(vl.getString()).getPath().replaceAll(pathTaxonomy, "");
                                valueList.add(categoryPath);
                            } else {
                                valueList.add(vl.getString());
                            }
                        }
                        ++var19_34;
                    }
                }
                uiMulti.setValue(valueList);
            }
            if (this.isResetMultiField) {
                uiMulti.setValue(new ArrayList());
            }
            this.renderField(name);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = (UIFormStringInput)formTextField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiInput);
        }
        if (uiInput.getValue() == null) {
            uiInput.setValue((Object)formTextField.getDefaultValue());
        } else {
            uiInput.setEditable(true);
        }
        if (this.getNode() != null && !this.isShowingComponent && !this.isRemovePreference) {
            if (jcrPath.equals("/node") && (!formTextField.isEditable() || formTextField.isEditableIfNull())) {
                Node parentNode = node.getParent();
                if (parentNode != null && parentNode.getName().equals("languages")) {
                    uiInput.setValue((Object)node.getParent().getParent().getName());
                } else {
                    String nameValue = node.getPath().substring(node.getPath().lastIndexOf("/") + 1);
                    uiInput.setValue((Object)nameValue);
                }
                uiInput.setEditable(false);
            } else if (node.hasProperty(propertyName)) {
                uiInput.setValue((Object)node.getProperty(propertyName).getValue().getString());
            }
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            if (childNode != null) {
                if (childNode.hasProperty(propertyName)) {
                    uiInput.setValue((Object)childNode.getProperty(propertyName).getValue().getString());
                } else {
                    uiInput.setValue((Object)propertyName);
                }
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                uiInput.setValue((Object)node.getName());
            } else {
                uiInput.setValue((Object)formTextField.getDefaultValue());
            }
        }
        this.renderField(name);
    }

    public void addTextField(String name, String[] arguments) throws Exception {
        this.addTextField(name, null, arguments);
    }

    public void addUploadField(String name, String label, String[] arguments) throws Exception {
        UIFormUploadField formUploadField = new UIFormUploadField(name, label, arguments);
        String jcrPath = formUploadField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        this.setMultiPart(true);
        if (formUploadField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormUploadInput.class, name, label);
            return;
        }
        UIFormUploadInput uiInputUpload = (UIFormUploadInput)this.findComponentById(name);
        if (uiInputUpload == null) {
            uiInputUpload = (UIFormUploadInput)formUploadField.createUIFormInput();
            this.addUIFormInput((UIFormInput)uiInputUpload);
        }
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        this.renderField(name);
    }

    public void addUploadField(String name, String[] arguments) throws Exception {
        this.addUploadField(name, null, arguments);
    }

    public void addWYSIWYGField(String name, String label, String[] arguments) throws Exception {
        UIFormWYSIWYGField formWYSIWYGField = new UIFormWYSIWYGField(name, label, arguments);
        String jcrPath = formWYSIWYGField.getJcrPath();
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, inputProperty);
        if (formWYSIWYGField.isMultiValues()) {
            this.renderMultiValuesInput(UIFormWYSIWYGInput.class, name, label);
            return;
        }
        UIFormWYSIWYGInput wysiwyg = (UIFormWYSIWYGInput)this.findComponentById(name);
        if (wysiwyg == null) {
            wysiwyg = (UIFormWYSIWYGInput)formWYSIWYGField.createUIFormInput();
        }
        FCKEditorConfig config = new FCKEditorConfig();
        FCKEditorContext editorContext = new FCKEditorContext();
        if (this.repositoryName != null) {
            config.put((Object)"repositoryName", (Object)this.repositoryName);
            editorContext.setRepository(this.repositoryName);
        }
        if (this.workspaceName != null) {
            config.put((Object)"workspaceName", (Object)this.workspaceName);
            editorContext.setWorkspace(this.workspaceName);
        }
        if (this.nodePath != null) {
            config.put((Object)"jcrPath", (Object)this.nodePath);
            editorContext.setCurrentNodePath(this.nodePath);
        } else {
            config.put((Object)"jcrPath", (Object)this.storedPath);
            editorContext.setCurrentNodePath(this.storedPath);
        }
        FCKConfigService fckConfigService = (FCKConfigService)this.getApplicationComponent(FCKConfigService.class);
        editorContext.setPortalName(Util.getUIPortal().getName());
        editorContext.setSkinName(Util.getUIPortalApplication().getSkin());
        fckConfigService.processFCKEditorConfig(config, editorContext);
        wysiwyg.setFCKConfig(config);
        this.addUIFormInput((UIFormInput)wysiwyg);
        if (wysiwyg.getValue() == null) {
            wysiwyg.setValue((Object)formWYSIWYGField.getDefaultValue());
        }
        String propertyName = this.getPropertyName(jcrPath);
        this.propertiesName.put(name, propertyName);
        this.fieldNames.put(propertyName, name);
        Node node = this.getNode();
        if (!this.isShowingComponent && !this.isRemovePreference) {
            if (node != null && (node.isNodeType("nt:file") || this.isNTFile)) {
                Node jcrContentNode = node.getNode("jcr:content");
                wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (node != null && node.hasProperty(propertyName)) {
                wysiwyg.setValue((Object)node.getProperty(propertyName).getValue().getString());
            }
        }
        if (this.isNotEditNode && !this.isShowingComponent && !this.isRemovePreference) {
            Node childNode = this.getChildNode();
            if (node != null && node.hasNode("jcr:content") && childNode != null) {
                Node jcrContentNode = node.getNode("jcr:content");
                wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (childNode != null) {
                wysiwyg.setValue((Object)propertyName);
            } else if (childNode == null && jcrPath.equals("/node") && node != null) {
                wysiwyg.setValue((Object)node.getName());
            } else {
                wysiwyg.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addWYSIWYGField(String name, String[] arguments) throws Exception {
        this.addWYSIWYGField(name, null, arguments);
    }

    public Node getChildNode() throws Exception {
        if (this.childPath == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.childPath);
    }

    public String getContentType() {
        return this.contentType;
    }

    public Map<String, JcrInputProperty> getInputProperties() {
        return this.properties;
    }

    public JcrInputProperty getInputProperty(String name) {
        return this.properties.get(name);
    }

    public JCRResourceResolver getJCRResourceResolver() {
        return this.resourceResolver;
    }

    public Node getNode() throws Exception {
        if (this.nodePath == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.nodePath);
    }

    public String getPropertyName(String jcrPath) {
        return jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
    }

    public String getSelectBoxFieldValue(String name) {
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox != null) {
            return (String)uiSelectBox.getValue();
        }
        return null;
    }

    public Session getSesssion() throws Exception {
        return SessionProviderFactory.createSessionProvider().getSession(this.workspaceName, this.getRepository());
    }

    public String getTemplate() {
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String userName = Util.getPortalRequestContext().getRemoteUser();
        try {
            return templateService.getTemplatePathByUser(true, this.contentType, userName, this.repositoryName);
        }
        catch (Exception e) {
            UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
            Object[] arg = new Object[]{this.contentType};
            uiApp.addMessage(new ApplicationMessage("UIDialogForm.msg.not-support-contenttype", arg, 0));
            return null;
        }
    }

    public boolean isResetForm() {
        return this.isResetForm;
    }

    public void onchange(Event event) throws Exception {
    }

    public void processAction(WebuiRequestContext context) throws Exception {
        String action = context.getRequestParameter("formOp");
        if (SAVE_ACTION.equalsIgnoreCase(action)) {
            this.executePreSaveEventInterceptor();
            super.processAction(context);
            String nodePath = (String)context.getAttribute("nodePath");
            if (nodePath != null) {
                this.executePostSaveEventInterceptor(nodePath);
            }
            this.prevScriptInterceptor.clear();
            this.postScriptInterceptor.clear();
        } else {
            super.processAction(context);
        }
    }

    public void removeComponent(String name) {
        if (!this.properties.isEmpty() && this.properties.containsKey(name)) {
            this.properties.remove(name);
            String jcrPath = this.propertiesName.get(name);
            this.propertiesName.remove(name);
            this.fieldNames.remove(jcrPath);
            this.removeChildById(name);
        }
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Writer w = context.getWriter();
        uiInput.processRender(context);
        if (this.componentSelectors.get(name) != null) {
            Map<String, String> fieldPropertiesMap = this.componentSelectors.get(name);
            String fieldName = fieldPropertiesMap.get("returnField");
            String iconClass = "Add16x16Icon";
            if (fieldPropertiesMap.get("selectorIcon") != null) {
                iconClass = fieldPropertiesMap.get("selectorIcon");
            }
            if (name.equals(fieldName)) {
                w.write("<a style=\"cursor:pointer;\" onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + this.getId() + "','ShowComponent','&objectId=" + fieldName + "' )\"><img class='ActionIcon " + iconClass + "' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
                w.write("<a style=\"cursor:pointer;\" onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + this.getId() + "','RemoveReference','&objectId=" + fieldName + "' )\"><img class='ActionIcon Remove16x16Icon' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
            }
        }
    }

    public String getImage(Node node, String nodeTypeName) throws Exception {
        DownloadService dservice = (DownloadService)this.getApplicationComponent(DownloadService.class);
        Node imageNode = node.getNode(nodeTypeName);
        InputStream input = imageNode.getProperty("jcr:data").getStream();
        InputStreamDownloadResource dresource = new InputStreamDownloadResource(input, "image");
        dresource.setDownloadName(node.getName());
        return dservice.getDownloadLink(dservice.addDownloadResource((DownloadResource)dresource));
    }

    public boolean dataRemoved() {
        return this.dataRemoved_;
    }

    public void setDataRemoved(boolean dataRemoved) {
        this.dataRemoved_ = dataRemoved;
    }

    public void resetProperties() {
        this.properties.clear();
    }

    public void setChildPath(String childPath) {
        this.childPath = childPath;
    }

    public void setContentType(String type) {
        this.contentType = type;
    }

    public void setInputProperty(String name, JcrInputProperty value) {
        this.properties.put(name, value);
    }

    public void setIsNotEditNode(boolean isNotEditNode) {
        this.isNotEditNode = isNotEditNode;
    }

    public void setIsNTFile(boolean isNTFile) {
        this.isNTFile = isNTFile;
    }

    public void setIsOnchange(boolean isOnchange) {
        this.isOnchange = isOnchange;
    }

    public void setIsResetForm(boolean isResetForm) {
        this.isResetForm = isResetForm;
    }

    public void setIsResetMultiField(boolean isResetMultiField) {
        this.isResetMultiField = isResetMultiField;
    }

    public void setIsUpdateSelect(boolean isUpdateSelect) {
        this.isUpdateSelect = isUpdateSelect;
    }

    public void setJCRResourceResolver(JCRResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
    }

    public void setNodePath(String nodePath) {
        this.nodePath = nodePath;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public void setStoredPath(String storedPath) {
        this.storedPath = storedPath;
    }

    public String getStoredPath() {
        return this.storedPath;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName = workspace;
    }

    private void executePostSaveEventInterceptor(String nodePath) throws Exception {
        if (this.postScriptInterceptor.size() > 0) {
            String path = nodePath + "&workspaceName=" + this.workspaceName + "&repository=" + this.repositoryName;
            for (String interceptor : this.postScriptInterceptor) {
                this.executeScript(interceptor, path, null);
            }
        }
    }

    private void executePreSaveEventInterceptor() throws Exception {
        if (this.prevScriptInterceptor.size() > 0) {
            Map<String, JcrInputProperty> maps = DialogFormUtil.prepareMap(this.getChildren(), this.getInputProperties());
            for (String interceptor : this.prevScriptInterceptor) {
                this.executeScript(interceptor, maps, null);
            }
        }
    }

    private void executeScript(String script, Object o, String[] params) throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        try {
            CmsScript dialogScript = scriptService.getScript(script, this.repositoryName);
            if (params != null) {
                if (params.equals("repository")) {
                    params = new String[]{this.repositoryName};
                }
                dialogScript.setParams(params);
            }
            dialogScript.execute(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getNodePathByUUID(String uuid) throws Exception {
        String[] workspaces = this.getRepository().getWorkspaceNames();
        Node node = null;
        for (String ws : workspaces) {
            try {
                node = SessionProviderFactory.createSystemProvider().getSession(ws, this.getRepository()).getNodeByUUID(uuid);
                return ws + ":" + node.getPath();
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(this.repositoryName);
    }

    private void renderMultiValuesInput(Class type, String name, String label) throws Exception {
        UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
        uiMulti.setId(name);
        uiMulti.setName(name);
        uiMulti.setType(type);
        this.addUIFormInput((UIFormInput)uiMulti);
        if (label != null) {
            uiMulti.setLabel(label);
        }
        this.renderField(name);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OnchangeActionListener
    extends EventListener<UIDialogForm> {
        public void execute(Event<UIDialogForm> event) throws Exception {
            ((UIDialogForm)((Object)event.getSource())).isOnchange = true;
            ((UIDialogForm)((Object)event.getSource())).onchange(event);
        }
    }
}

