/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.tree.selectone;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.nodetype.NodeType;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.tree.UIBaseNodeTreeSelector;
import org.exoplatform.ecm.webui.tree.selectone.UIOneNodePathSelector;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/ecm/webui/tree/selectone/UISelectPathPanel.gtmpl", events={@EventConfig(listeners={SelectActionListener.class})})
public class UISelectPathPanel
extends UIContainer {
    private UIPageIterator uiPageIterator_;
    public String[] acceptedMimeTypes = new String[0];
    protected Node parentNode;
    private String[] acceptedNodeTypes = new String[0];
    private boolean allowPublish = false;
    private PublicationService publicationService_ = null;
    private List<String> templates_ = null;

    public UISelectPathPanel() throws Exception {
        this.uiPageIterator_ = (UIPageIterator)this.addChild(UIPageIterator.class, null, "UISelectPathIterate");
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public boolean isAllowPublish() {
        return this.allowPublish;
    }

    public void setAllowPublish(boolean allowPublish, PublicationService publicationService, List<String> templates) {
        this.allowPublish = allowPublish;
        this.publicationService_ = publicationService;
        this.templates_ = templates;
    }

    private void addNodePublish(List<Node> listNode, Node node, PublicationService publicationService) throws Exception {
        if (this.isAllowPublish()) {
            NodeType nt = node.getPrimaryNodeType();
            if (this.templates_.contains(nt.getName())) {
                Node nodecheck = publicationService.getNodePublish(node, null);
                if (nodecheck != null) {
                    listNode.add(nodecheck);
                }
            } else {
                listNode.add(node);
            }
        } else {
            listNode.add(node);
        }
    }

    public void setParentNode(Node node) {
        this.parentNode = node;
    }

    public Node getParentNode() {
        return this.parentNode;
    }

    public String[] getAcceptedNodeTypes() {
        return this.acceptedNodeTypes;
    }

    public void setAcceptedNodeTypes(String[] acceptedNodeTypes) {
        this.acceptedNodeTypes = acceptedNodeTypes;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    public void setAcceptedMimeTypes(String[] acceptedMimeTypes) {
        this.acceptedMimeTypes = acceptedMimeTypes;
    }

    public List getSelectableNodes() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public void updateGrid() throws Exception {
        ObjectPageList objPageList = new ObjectPageList(this.getListSelectableNodes(), 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public List<Node> getListSelectableNodes() throws Exception {
        ArrayList<Node> list = new ArrayList<Node>();
        if (this.parentNode == null) {
            return list;
        }
        NodeIterator iterator = this.parentNode.getNodes();
        while (iterator.hasNext()) {
            Node child = iterator.nextNode();
            if (child.isNodeType("exo:hiddenable") || !this.matchMimeType(child) || !this.matchNodeType(child)) continue;
            list.add(child);
        }
        ArrayList<Node> listNodeCheck = new ArrayList<Node>();
        for (Node node : list) {
            this.addNodePublish(listNodeCheck, node, this.publicationService_);
        }
        return listNodeCheck;
    }

    protected boolean matchNodeType(Node node) throws Exception {
        if (this.acceptedNodeTypes == null || this.acceptedNodeTypes.length == 0) {
            return true;
        }
        for (String nodeType : this.acceptedNodeTypes) {
            if (!node.isNodeType(nodeType)) continue;
            return true;
        }
        return false;
    }

    protected boolean matchMimeType(Node node) throws Exception {
        if (this.acceptedMimeTypes == null || this.acceptedMimeTypes.length == 0) {
            return true;
        }
        if (!node.isNodeType("nt:file")) {
            return true;
        }
        String mimeType = node.getNode("jcr:content").getProperty("jcr:mimeType").getString();
        for (String type : this.acceptedMimeTypes) {
            if (!type.equalsIgnoreCase(mimeType)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectActionListener
    extends EventListener<UISelectPathPanel> {
        public void execute(Event<UISelectPathPanel> event) throws Exception {
            UISelectPathPanel uiDefault = (UISelectPathPanel)((Object)event.getSource());
            String value = event.getRequestContext().getRequestParameter("objectId");
            UIContainer uiTreeSelector = (UIContainer)uiDefault.getParent();
            if (uiTreeSelector instanceof UIOneNodePathSelector && !((UIOneNodePathSelector)uiTreeSelector).isDisable()) {
                value = ((UIOneNodePathSelector)uiTreeSelector).getWorkspaceName() + ":" + value;
            }
            String returnField = ((UIBaseNodeTreeSelector)uiTreeSelector).getReturnFieldName();
            ((UISelectable)((UIBaseNodeTreeSelector)uiTreeSelector).getSourceComponent()).doSelect(returnField, value);
            UIComponent uiOneNodePathSelector = uiDefault.getParent();
            if (uiOneNodePathSelector instanceof UIOneNodePathSelector) {
                UIComponent component;
                UIComponent uiComponent = uiOneNodePathSelector.getParent();
                if (uiComponent instanceof UIPopupWindow) {
                    ((UIPopupWindow)uiComponent).setShow(false);
                    ((UIPopupWindow)uiComponent).setRendered(false);
                    event.getRequestContext().addUIComponentToUpdateByAjax(uiComponent);
                }
                if ((component = ((UIOneNodePathSelector)uiOneNodePathSelector).getSourceComponent().getParent()) != null) {
                    event.getRequestContext().addUIComponentToUpdateByAjax(component);
                }
            }
        }
    }
}

