/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.ISO8601;
import org.exoplatform.services.cms.CmsService;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.idgenerator.IDGeneratorService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;

public class CmsServiceImpl
implements CmsService {
    private RepositoryService jcrService;
    private IDGeneratorService idGeneratorService;
    private static final String MIX_REFERENCEABLE = "mix:referenceable";

    public CmsServiceImpl(RepositoryService jcrService, IDGeneratorService idGeneratorService) {
        this.idGeneratorService = idGeneratorService;
        this.jcrService = jcrService;
    }

    public String storeNode(String workspace, String nodeTypeName, String storePath, Map mappings, String repository) throws Exception {
        Session session = this.jcrService.getRepository(repository).login(workspace);
        Node storeHomeNode = (Node)session.getItem(storePath);
        String path = this.storeNode(nodeTypeName, storeHomeNode, mappings, true, repository);
        storeHomeNode.save();
        session.save();
        session.logout();
        return path;
    }

    public String storeNode(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew, String repository) throws Exception {
        String primaryType;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        if ((primaryType = relRootProp.getNodetype()) == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (isAddNew) {
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
        }
        return currentNode.getPath();
    }

    public String storeNodeByUUID(String nodeTypeName, Node storeHomeNode, Map mappings, boolean isAddNew, String repository) throws Exception {
        String primaryType;
        Set keys = mappings.keySet();
        String nodePath = this.extractNodeName(keys);
        JcrInputProperty relRootProp = (JcrInputProperty)mappings.get(nodePath);
        String nodeName = (String)relRootProp.getValue();
        if (nodeName == null || nodeName.length() == 0) {
            nodeName = this.idGeneratorService.generateStringID((Object)nodeTypeName);
        }
        if ((primaryType = relRootProp.getNodetype()) == null || primaryType.length() == 0) {
            primaryType = nodeTypeName;
        }
        Session session = storeHomeNode.getSession();
        NodeTypeManager nodetypeManager = session.getWorkspace().getNodeTypeManager();
        NodeType nodeType = nodetypeManager.getNodeType(primaryType);
        Node currentNode = null;
        String[] mixinTypes = null;
        String mixintypeName = relRootProp.getMixintype();
        if (mixintypeName != null && mixintypeName.trim().length() > 0) {
            mixinTypes = mixintypeName.indexOf(",") > -1 ? mixintypeName.split(",") : new String[]{mixintypeName};
        }
        if (isAddNew) {
            currentNode = storeHomeNode.addNode(nodeName, primaryType);
            if (mixinTypes != null) {
                for (String type : mixinTypes) {
                    if (!currentNode.isNodeType(type)) {
                        currentNode.addMixin(type);
                    }
                    NodeType mixinType = nodetypeManager.getNodeType(type);
                    this.createNodeRecursively("/node", currentNode, mixinType, mappings);
                }
            }
            this.createNodeRecursively("/node", currentNode, nodeType, mappings);
        } else {
            currentNode = storeHomeNode.getNode(nodeName);
            this.updateNodeRecursively("/node", currentNode, nodeType, mappings);
            if (currentNode.isNodeType("exo:datetime")) {
                currentNode.setProperty("exo:dateModified", (Calendar)new GregorianCalendar());
            }
        }
        if (!currentNode.isNodeType(MIX_REFERENCEABLE)) {
            currentNode.addMixin(MIX_REFERENCEABLE);
        }
        return currentNode.getUUID();
    }

    private void updateNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(false, path, currentNode, currentNodeType, jcrVariables);
    }

    private void createNodeRecursively(String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        this.processNodeRecursively(true, path, currentNode, currentNodeType, jcrVariables);
    }

    private void processAddEditProperty(boolean create, Node currentNode, String path, NodeType currentNodeType, Map jcrVariables) throws Exception {
        if (create || path.equals("/node")) {
            PropertyDefinition[] propertyDefs = currentNodeType.getPropertyDefinitions();
            for (int i = 0; i < propertyDefs.length; ++i) {
                PropertyDefinition propertyDef = propertyDefs[i];
                if (propertyDef.isAutoCreated() || propertyDef.isProtected()) continue;
                String propertyName = propertyDef.getName();
                int requiredtype = propertyDef.getRequiredType();
                String currentPath = path + "/" + propertyName;
                JcrInputProperty inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                Object value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null && !propertyDef.isMandatory()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDef.isMultiple());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processNodeRecursively(boolean create, String path, Node currentNode, NodeType currentNodeType, Map jcrVariables) throws Exception {
        JcrInputProperty inputVariable;
        String currentPath;
        if (create) {
            this.processAddEditProperty(true, currentNode, path, currentNodeType, jcrVariables);
        } else {
            PropertyIterator pi = currentNode.getProperties();
            while (pi.hasNext()) {
                Property property = pi.nextProperty();
                PropertyDefinition propertyDefinition = property.getDefinition();
                String propertyName = property.getName();
                int requiredtype = property.getType();
                currentPath = path + "/" + propertyName;
                inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                Object value = null;
                if (inputVariable != null) {
                    value = inputVariable.getValue();
                }
                if (value == null || propertyDefinition.isProtected()) continue;
                this.processProperty(propertyName, currentNode, requiredtype, value, propertyDefinition.isMultiple());
            }
            this.processAddEditProperty(false, currentNode, path, currentNodeType, jcrVariables);
        }
        ArrayList<Object> childs = new ArrayList<Object>();
        if (create) {
            void var8_10;
            NodeDefinition[] childNodeDefs = currentNodeType.getChildNodeDefinitions();
            boolean bl = false;
            while (var8_10 < childNodeDefs.length) {
                childs.add(childNodeDefs[var8_10]);
                ++var8_10;
            }
        } else {
            NodeIterator nodes = currentNode.getNodes();
            while (nodes.hasNext()) {
                childs.add(nodes.next());
            }
        }
        for (Object e : childs) {
            Node childNode;
            NodeType nodeType;
            String nodeName;
            block17: {
                NodeDefinition nodeDef;
                if (e instanceof Node) {
                    nodeDef = ((Node)e).getDefinition();
                    nodeName = ((Node)e).getName();
                } else {
                    nodeDef = (NodeDefinition)e;
                    nodeName = ((NodeDefinition)e).getName();
                }
                if (nodeDef.isAutoCreated() || nodeDef.isProtected() || "*".equals(nodeDef.getName()) && e instanceof NodeDefinition) continue;
                currentPath = path + "/" + nodeName;
                inputVariable = (JcrInputProperty)jcrVariables.get(currentPath);
                String nodetypeName = null;
                String mixintypeName = null;
                if (inputVariable != null) {
                    nodetypeName = inputVariable.getNodetype();
                    mixintypeName = inputVariable.getMixintype();
                }
                NodeTypeManager nodetypeManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
                nodeType = null;
                nodeType = e instanceof Node ? ((Node)e).getPrimaryNodeType() : (nodetypeName == null || "".equals(nodetypeName) ? nodeDef.getRequiredPrimaryTypes()[0] : nodetypeManager.getNodeType(nodetypeName));
                childNode = null;
                if (create) {
                    childNode = currentNode.addNode(nodeName, nodeType.getName());
                    if (mixintypeName != null) {
                        childNode.addMixin(mixintypeName);
                        NodeType mixinType = nodetypeManager.getNodeType(mixintypeName);
                        this.processNodeRecursively(create, path + "/" + nodeName, childNode, mixinType, jcrVariables);
                    }
                } else {
                    try {
                        childNode = currentNode.getNode(nodeName);
                    }
                    catch (PathNotFoundException e2) {
                        childNode = currentNode.addNode(nodeName, nodeType.getName());
                        if (mixintypeName == null) break block17;
                        childNode.addMixin(mixintypeName);
                        NodeType mixinType = nodetypeManager.getNodeType(mixintypeName);
                        this.processNodeRecursively(create, path + "/" + nodeName, childNode, mixinType, jcrVariables);
                    }
                }
            }
            this.processNodeRecursively(create, path + "/" + nodeName, childNode, nodeType, jcrVariables);
        }
    }

    private void processProperty(String propertyName, Node node, int requiredtype, Object value, boolean isMultiple) throws Exception {
        switch (requiredtype) {
            case 1: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (isMultiple) {
                    if (value instanceof String) {
                        node.setProperty(propertyName, new String[]{(String)value});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    node.setProperty(propertyName, (String[])value);
                    break;
                }
                node.setProperty(propertyName, (String)value);
                break;
            }
            case 2: {
                if (value == null) {
                    node.setProperty(propertyName, "");
                    break;
                }
                if (value instanceof byte[]) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream((byte[])value));
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String)value).getBytes()));
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (InputStream)new ByteArrayInputStream(((String[])value).toString().getBytes()));
                break;
            }
            case 6: {
                if (value == null) {
                    node.setProperty(propertyName, false);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Boolean((String)value).booleanValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 3: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Long((String)value).longValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 4: {
                if (value == null || "".equals(value)) {
                    node.setProperty(propertyName, 0L);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, new Double((String)value).doubleValue());
                    break;
                }
                if (!(value instanceof String[])) break;
                node.setProperty(propertyName, (String[])value);
                break;
            }
            case 5: {
                if (value == null) {
                    node.setProperty(propertyName, (Calendar)new GregorianCalendar());
                    break;
                }
                if (isMultiple) {
                    Session session = node.getSession();
                    if (value instanceof String) {
                        Value value2add = session.getValueFactory().createValue(ISO8601.parse((String)((String)value)));
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    if (!(value instanceof String[])) break;
                    String[] values = (String[])value;
                    Value[] convertedCalendarValues = new Value[values.length];
                    int i = 0;
                    for (String stringValue : values) {
                        Value value2add;
                        convertedCalendarValues[i] = value2add = session.getValueFactory().createValue(ISO8601.parse((String)stringValue));
                        ++i;
                    }
                    node.setProperty(propertyName, convertedCalendarValues);
                    break;
                }
                if (value instanceof String) {
                    node.setProperty(propertyName, ISO8601.parse((String)((String)value)));
                    break;
                }
                if (!(value instanceof GregorianCalendar)) break;
                node.setProperty(propertyName, (Calendar)((GregorianCalendar)value));
                break;
            }
            case 9: {
                if (value == null) {
                    throw new RepositoryException("null value for a reference " + requiredtype);
                }
                if (value instanceof Value[]) {
                    node.setProperty(propertyName, (Value[])value);
                    break;
                }
                if (value instanceof String) {
                    String referenceWorksapce = null;
                    String referenceNodeName = null;
                    Session session = node.getSession();
                    String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                    if (((String)value).indexOf(":/") > -1) {
                        referenceWorksapce = ((String)value).split(":/")[0];
                        referenceNodeName = ((String)value).split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            Value value2add = session2.getValueFactory().createValue(referenceNode);
                            node.setProperty(propertyName, new Value[]{value2add});
                            break;
                        }
                        node.setProperty(propertyName, session2.getValueFactory().createValue((String)value));
                        break;
                    }
                    if (session.getRootNode().hasNode((String)value)) {
                        Node referenceNode = session.getRootNode().getNode(referenceNodeName);
                        Value value2add = session.getValueFactory().createValue(referenceNode);
                        node.setProperty(propertyName, new Value[]{value2add});
                        break;
                    }
                    node.setProperty(propertyName, session.getValueFactory().createValue((String)value));
                    break;
                }
                if (!(value instanceof String[])) break;
                String[] values = (String[])value;
                String referenceWorksapce = null;
                String referenceNodeName = null;
                Session session = node.getSession();
                String repositoty = ((ManageableRepository)session.getRepository()).getConfiguration().getName();
                ArrayList<Value> list = new ArrayList<Value>();
                for (String v : values) {
                    Value valueObj = null;
                    if (v.indexOf(":/") > 0) {
                        referenceWorksapce = v.split(":/")[0];
                        referenceNodeName = v.split(":/")[1];
                        Session session2 = this.jcrService.getRepository(repositoty).getSystemSession(referenceWorksapce);
                        if (session2.getRootNode().hasNode(referenceNodeName)) {
                            Node referenceNode = session2.getRootNode().getNode(referenceNodeName);
                            valueObj = session2.getValueFactory().createValue(referenceNode);
                        } else {
                            valueObj = session2.getValueFactory().createValue(v);
                        }
                    } else if (session.getRootNode().hasNode(v)) {
                        Node referenceNode = session.getRootNode().getNode(v);
                        valueObj = session.getValueFactory().createValue(referenceNode);
                    } else {
                        valueObj = session.getValueFactory().createValue(v);
                    }
                    list.add(valueObj);
                }
                node.setProperty(propertyName, list.toArray(new Value[list.size()]));
                break;
            }
            default: {
                throw new RepositoryException("unknown type " + requiredtype);
            }
        }
    }

    private String extractNodeName(Set keys) {
        for (String key : keys) {
            if (!key.endsWith("/node")) continue;
            return key;
        }
        return null;
    }

    public void moveNode(String nodePath, String srcWorkspace, String destWorkspace, String destPath, String repository) {
        block11: {
            Session srcSession = null;
            Session destSession = null;
            if (!srcWorkspace.equals(destWorkspace)) {
                try {
                    srcSession = this.jcrService.getRepository(repository).getSystemSession(srcWorkspace);
                    destSession = this.jcrService.getRepository(repository).getSystemSession(destWorkspace);
                    Workspace workspace = destSession.getWorkspace();
                    Node srcNode = (Node)srcSession.getItem(nodePath);
                    try {
                        destSession.getItem(destPath);
                    }
                    catch (PathNotFoundException e) {
                        this.createNode(destSession, destPath);
                    }
                    workspace.clone(srcWorkspace, nodePath, destPath, true);
                    srcNode.remove();
                    srcSession.save();
                    destSession.save();
                    srcSession.logout();
                    destSession.logout();
                }
                catch (Exception e) {
                    if (srcSession != null) {
                        srcSession.logout();
                    }
                    if (destSession != null) {
                        destSession.logout();
                    }
                    break block11;
                }
            }
            Session session = null;
            try {
                session = this.jcrService.getRepository(repository).getSystemSession(srcWorkspace);
                Workspace workspace = session.getWorkspace();
                try {
                    session.getItem(destPath);
                }
                catch (PathNotFoundException e) {
                    this.createNode(session, destPath);
                    session.refresh(false);
                }
                workspace.move(nodePath, destPath);
                session.logout();
            }
            catch (Exception e) {
                if (session == null || !session.isLive()) break block11;
                session.logout();
            }
        }
    }

    private void createNode(Session session, String uri) throws RepositoryException {
        String[] splittedName = StringUtils.split((String)uri, (String)"/");
        Node rootNode = session.getRootNode();
        for (int i = 0; i < splittedName.length - 1; ++i) {
            try {
                rootNode.getNode(splittedName[i]);
            }
            catch (PathNotFoundException exc) {
                rootNode.addNode(splittedName[i], "nt:unstructured");
                rootNode.save();
            }
            rootNode = rootNode.getNode(splittedName[i]);
        }
        session.save();
    }
}

