/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.templates.impl;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.Value;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.cms.templates.impl.TemplatePlugin;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.security.SecurityService;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateServiceImpl
implements TemplateService,
Startable {
    private RepositoryService repositoryService_;
    private SecurityService securityService_;
    private String cmsTemplatesBasePath_;
    private List<TemplatePlugin> plugins_ = new ArrayList<TemplatePlugin>();

    public TemplateServiceImpl(RepositoryService jcrService, NodeHierarchyCreator nodeHierarchyCreator, SecurityService securityService) throws Exception {
        this.securityService_ = securityService;
        this.repositoryService_ = jcrService;
        this.cmsTemplatesBasePath_ = nodeHierarchyCreator.getJcrPath("templatesPath");
    }

    public void start() {
        try {
            for (TemplatePlugin plugin : this.plugins_) {
                plugin.init();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
    }

    public void addTemplates(ComponentPlugin plugin) {
        if (plugin instanceof TemplatePlugin) {
            this.plugins_.add((TemplatePlugin)plugin);
        }
    }

    @Override
    public void init(String repository) throws Exception {
        for (TemplatePlugin plugin : this.plugins_) {
            plugin.init(repository);
        }
    }

    @Override
    public Node getTemplatesHome(String repository, SessionProvider provider) throws Exception {
        try {
            Session session = this.getSession(repository, provider);
            return (Node)session.getItem(this.cmsTemplatesBasePath_);
        }
        catch (AccessDeniedException ace) {
            return null;
        }
    }

    @Override
    public boolean isManagedNodeType(String nodeTypeName, String repository) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Session session = this.getSession(repository, provider);
        Node systemTemplatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        boolean b = false;
        if (systemTemplatesHome.hasNode(nodeTypeName)) {
            b = true;
        }
        provider.close();
        return b;
    }

    @Override
    public String getTemplatePath(Node node, boolean isDialog) throws Exception {
        String userId = node.getSession().getUserID();
        String repository = ((ManageableRepository)node.getSession().getRepository()).getConfiguration().getName();
        String templateType = null;
        templateType = node.isNodeType("exo:presentationable") ? node.getProperty("exo:presentationType").getString() : node.getPrimaryNodeType().getName();
        if (this.isManagedNodeType(templateType, repository)) {
            return this.getTemplatePathByUser(isDialog, templateType, userId, repository);
        }
        return null;
    }

    @Override
    public NodeIterator getAllTemplatesOfNodeType(boolean isDialog, String nodeTypeName, String repository, SessionProvider provider) throws Exception {
        Node nodeTypeHome = this.getTemplatesHome(repository, provider).getNode(nodeTypeName);
        if (isDialog) {
            return nodeTypeHome.getNode(DIALOGS).getNodes();
        }
        return nodeTypeHome.getNode(VIEWS).getNodes();
    }

    @Override
    public String getDefaultTemplatePath(boolean isDialog, String nodeTypeName) {
        if (isDialog) {
            return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_DIALOGS_PATH;
        }
        return this.cmsTemplatesBasePath_ + "/" + nodeTypeName + DEFAULT_VIEWS_PATH;
    }

    @Override
    public Node getTemplateNode(boolean isDialog, String nodeTypeName, String templateName, String repository, SessionProvider provider) throws Exception {
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node nodeTypeNode = this.getTemplatesHome(repository, provider).getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    @Override
    public String getTemplatePathByUser(boolean isDialog, String nodeTypeName, String userName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateHomeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node nodeTypeNode = templateHomeNode.getNode(nodeTypeName);
        NodeIterator templateIter = nodeTypeNode.getNode(type).getNodes();
        while (templateIter.hasNext()) {
            Node node = templateIter.nextNode();
            Value[] roles = node.getProperty(EXO_ROLES_PROP).getValues();
            for (int i = 0; i < roles.length; ++i) {
                String templateRole = roles[i].getString();
                if ("*".equals(templateRole)) {
                    session.logout();
                    return node.getPath();
                }
                if (SystemIdentity.SYSTEM.equals(userName)) {
                    session.logout();
                    return node.getPath();
                }
                if (userName != null && userName.equals(templateRole)) {
                    session.logout();
                    return node.getPath();
                }
                if (userName == null || !this.securityService_.hasMembershipInGroup(userName, templateRole)) continue;
                session.logout();
                return node.getPath();
            }
        }
        session.logout();
        return null;
    }

    @Override
    public String getTemplatePath(boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateNode = this.getTemplateNode(session, isDialog, nodeTypeName, templateName, repository);
        String path = templateNode.getPath();
        session.logout();
        return path;
    }

    @Override
    public String getTemplateLabel(String nodeTypeName, String repository) throws Exception {
        SessionProvider provider = SessionProvider.createSystemProvider();
        Node templateHome = this.getTemplatesHome(repository, provider);
        Node nodeType = templateHome.getNode(nodeTypeName);
        String label = "";
        if (nodeType.hasProperty("label")) {
            label = nodeType.getProperty("label").getString();
        }
        provider.close();
        return label;
    }

    @Override
    public String getTemplate(boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateNode = this.getTemplateNode(session, isDialog, nodeTypeName, templateName, repository);
        String template = templateNode.getProperty(EXO_TEMPLATE_FILE_PROP).getString();
        session.logout();
        return template;
    }

    @Override
    public String getTemplateRoles(boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templateNode = this.getTemplateNode(session, isDialog, nodeTypeName, templateName, repository);
        Value[] values = templateNode.getProperty(EXO_ROLES_PROP).getValues();
        StringBuffer roles = new StringBuffer();
        for (int i = 0; i < values.length; ++i) {
            if (roles.length() > 0) {
                roles.append("; ");
            }
            roles.append(values[i].getString());
        }
        session.logout();
        return roles.toString();
    }

    private Node getTemplateNode(Session session, boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        String type = DIALOGS;
        if (!isDialog) {
            type = VIEWS;
        }
        Node homeNode = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeNode = homeNode.getNode(nodeTypeName);
        return nodeTypeNode.getNode(type).getNode(templateName);
    }

    @Override
    public void removeTemplate(boolean isDialog, String nodeTypeName, String templateName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeHome = templatesHome.getNode(nodeTypeName);
        Node specifiedTemplatesHome = null;
        specifiedTemplatesHome = isDialog ? nodeTypeHome.getNode(DIALOGS) : nodeTypeHome.getNode(VIEWS);
        Node contentNode = specifiedTemplatesHome.getNode(templateName);
        contentNode.remove();
        nodeTypeHome.save();
        session.save();
        session.logout();
    }

    @Override
    public void removeManagedNodeType(String nodeTypeName, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node managedNodeType = templatesHome.getNode(nodeTypeName);
        managedNodeType.remove();
        templatesHome.save();
        session.save();
        session.logout();
    }

    @Override
    public String addTemplate(boolean isDialog, String nodeTypeName, String label, boolean isDocumentTemplate, String templateName, String[] roles, String templateFile, String repository) throws Exception {
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        Node nodeTypeHome = null;
        if (!templatesHome.hasNode(nodeTypeName)) {
            nodeTypeHome = Utils.makePath(templatesHome, nodeTypeName, NT_UNSTRUCTURED);
            if (isDocumentTemplate) {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, true);
            } else {
                nodeTypeHome.setProperty(DOCUMENT_TEMPLATE_PROP, false);
            }
            nodeTypeHome.setProperty(TEMPLATE_LABEL, label);
        } else {
            nodeTypeHome = templatesHome.getNode(nodeTypeName);
        }
        Node specifiedTemplatesHome = null;
        specifiedTemplatesHome = isDialog ? (!nodeTypeHome.hasNode(DIALOGS) ? Utils.makePath(nodeTypeHome, DIALOGS, NT_UNSTRUCTURED) : nodeTypeHome.getNode(DIALOGS)) : (!nodeTypeHome.hasNode(VIEWS) ? Utils.makePath(nodeTypeHome, VIEWS, NT_UNSTRUCTURED) : nodeTypeHome.getNode(VIEWS));
        Node contentNode = null;
        contentNode = specifiedTemplatesHome.hasNode(templateName) ? specifiedTemplatesHome.getNode(templateName) : specifiedTemplatesHome.addNode(templateName, EXO_TEMPLATE);
        contentNode.setProperty(EXO_ROLES_PROP, roles);
        contentNode.setProperty(EXO_TEMPLATE_FILE_PROP, templateFile);
        templatesHome.save();
        session.save();
        session.logout();
        return contentNode.getPath();
    }

    @Override
    public List<String> getDocumentTemplates(String repository) throws Exception {
        ArrayList<String> templates = new ArrayList<String>();
        Session session = this.getSession(repository);
        Node templatesHome = (Node)session.getItem(this.cmsTemplatesBasePath_);
        NodeIterator templateIter = templatesHome.getNodes();
        while (templateIter.hasNext()) {
            Node template = templateIter.nextNode();
            if (!template.getProperty(DOCUMENT_TEMPLATE_PROP).getBoolean()) continue;
            templates.add(template.getName());
        }
        session.logout();
        return templates;
    }

    private Session getSession(String repository) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String systemWorksapce = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return manageableRepository.getSystemSession(systemWorksapce);
    }

    private Session getSession(String repository, SessionProvider provider) throws Exception {
        ManageableRepository manageableRepository = this.repositoryService_.getRepository(repository);
        String systemWorksapce = manageableRepository.getConfiguration().getDefaultWorkspaceName();
        return provider.getSession(systemWorksapce, manageableRepository);
    }
}

