/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.folksonomy.impl;

import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.services.cms.folksonomy.impl.TagStyleConfig;
import org.exoplatform.services.cms.impl.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;

public class TagStylePlugin
extends BaseComponentPlugin {
    private static final String EXO_TAG_STYLE = "exo:tagStyle".intern();
    private static final String TAG_RATE_PROP = "exo:styleRange".intern();
    private static final String HTML_STYLE_PROP = "exo:htmlStyle".intern();
    private InitParams params_;
    private RepositoryService repoService_;
    private NodeHierarchyCreator nodeHierarchyCreator_;

    public TagStylePlugin(InitParams params, RepositoryService repoService, NodeHierarchyCreator nodeHierarchyCreator) throws Exception {
        this.params_ = params;
        this.repoService_ = repoService;
        this.nodeHierarchyCreator_ = nodeHierarchyCreator;
    }

    public void init() throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        Session session = null;
        while (it.hasNext()) {
            TagStyleConfig tagConfig = (TagStyleConfig)((ObjectParameter)it.next()).getObject();
            if (tagConfig.getAutoCreatedInNewRepository()) {
                List repositories = this.repoService_.getConfig().getRepositoryConfigurations();
                for (RepositoryEntry repo : repositories) {
                    ManageableRepository manageableRepository = this.repoService_.getRepository(repo.getName());
                    session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getSystemWorkspaceName());
                    this.addTag(session, tagConfig);
                    session.logout();
                }
                continue;
            }
            session = this.repoService_.getRepository(tagConfig.getRepository()).getSystemSession(this.repoService_.getRepository(tagConfig.getRepository()).getConfiguration().getSystemWorkspaceName());
            this.addTag(session, tagConfig);
            session.logout();
        }
    }

    public void init(String repository) throws Exception {
        Iterator it = this.params_.getObjectParamIterator();
        ManageableRepository manageableRepository = this.repoService_.getRepository(repository);
        while (it.hasNext()) {
            TagStyleConfig tagConfig = (TagStyleConfig)((ObjectParameter)it.next()).getObject();
            if (!tagConfig.getAutoCreatedInNewRepository() && !repository.equals(tagConfig.getRepository())) continue;
            Session session = manageableRepository.getSystemSession(manageableRepository.getConfiguration().getSystemWorkspaceName());
            this.addTag(session, tagConfig);
            session.logout();
        }
    }

    private void addTag(Session session, TagStyleConfig tagConfig) throws Exception {
        String exoTagStylePath = this.nodeHierarchyCreator_.getJcrPath("exoTagStylePath");
        Node exoTagStyleHomeNode = (Node)session.getItem(exoTagStylePath);
        List<TagStyleConfig.HtmlTagStyle> htmlStyle4Tag = tagConfig.getTagStyleList();
        for (TagStyleConfig.HtmlTagStyle style : htmlStyle4Tag) {
            Node tagStyleNode = Utils.makePath(exoTagStyleHomeNode, "/" + style.getName(), EXO_TAG_STYLE);
            tagStyleNode.setProperty(TAG_RATE_PROP, style.getTagRate());
            tagStyleNode.setProperty(HTML_STYLE_PROP, style.getHtmlStyle());
        }
        exoTagStyleHomeNode.save();
        session.save();
    }
}

