/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.thumbnail.impl;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.thumbnail.ThumbnailService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.app.SessionProviderService;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.impl.core.NodeImpl;
import org.exoplatform.services.rest.HTTPMethod;
import org.exoplatform.services.rest.InputTransformer;
import org.exoplatform.services.rest.OutputTransformer;
import org.exoplatform.services.rest.QueryTemplate;
import org.exoplatform.services.rest.Response;
import org.exoplatform.services.rest.URIParam;
import org.exoplatform.services.rest.URITemplate;
import org.exoplatform.services.rest.container.ResourceContainer;
import org.exoplatform.services.rest.transformer.PassthroughInputTransformer;
import org.exoplatform.services.rest.transformer.PassthroughOutputTransformer;

@URITemplate(value="/thumbnailImage/{repoName}/{workspaceName}/{nodePath}/")
public class ThumbnailRESTService
implements ResourceContainer {
    private static final String LASTMODIFIED = "Last-Modified";
    private RepositoryService repositoryService_;
    private ThumbnailService thumbnailService_;

    public ThumbnailRESTService(RepositoryService repositoryService, ThumbnailService thumbnailService) {
        this.repositoryService_ = repositoryService;
        this.thumbnailService_ = thumbnailService;
    }

    @QueryTemplate(value="size=medium")
    @HTTPMethod(value="GET")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getThumbnailImage(@URIParam(value="repoName") String repoName, @URIParam(value="workspaceName") String wsName, @URIParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.MEDIUM_SIZE);
    }

    @QueryTemplate(value="size=big")
    @HTTPMethod(value="GET")
    @InputTransformer(value=PassthroughInputTransformer.class)
    @OutputTransformer(value=PassthroughOutputTransformer.class)
    public Response getCoverImage(@URIParam(value="repoName") String repoName, @URIParam(value="workspaceName") String wsName, @URIParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.BIG_SIZE);
    }

    @QueryTemplate(value="size=small")
    @HTTPMethod(value="GET")
    public Response getSmallImage(@URIParam(value="repoName") String repoName, @URIParam(value="workspaceName") String wsName, @URIParam(value="nodePath") String nodePath) throws Exception {
        return this.getThumbnailByType(repoName, wsName, nodePath, ThumbnailService.SMALL_SIZE);
    }

    private Response getThumbnailByType(String repoName, String wsName, String nodePath, String propertyName) throws Exception {
        Node content;
        if (!this.thumbnailService_.isEnableThumbnail()) {
            return Response.Builder.ok().build();
        }
        Node showingNode = this.getShowingNode(repoName, wsName, nodePath);
        Node parentNode = showingNode.getParent();
        String identifier = ((NodeImpl)showingNode).getInternalIdentifier();
        if (showingNode.getPrimaryNodeType().getName().equals("nt:file") && (content = showingNode.getNode("jcr:content")).getProperty("jcr:mimeType").getString().startsWith("image")) {
            Node thumbnailFolder = null;
            try {
                thumbnailFolder = parentNode.getNode(ThumbnailService.EXO_THUMBNAILS_FOLDER);
            }
            catch (PathNotFoundException e) {
                thumbnailFolder = parentNode.addNode(ThumbnailService.EXO_THUMBNAILS_FOLDER, ThumbnailService.EXO_THUNBNAILS);
                parentNode.save();
                if (thumbnailFolder.canAddMixin("exo:hiddenable")) {
                    thumbnailFolder.addMixin("exo:hiddenable");
                }
                thumbnailFolder.save();
            }
            Node thumbnailNode = null;
            try {
                thumbnailNode = thumbnailFolder.getNode(identifier);
            }
            catch (PathNotFoundException path) {
                thumbnailNode = thumbnailFolder.addNode(identifier, ThumbnailService.EXO_THUMBNAIL);
                thumbnailFolder.save();
            }
            if (!thumbnailNode.hasProperty(propertyName)) {
                BufferedImage image = ImageIO.read(content.getProperty("jcr:data").getStream());
                this.thumbnailService_.addThumbnailImage(thumbnailNode, image, propertyName);
            }
            String lastModified = null;
            if (thumbnailNode.hasProperty(ThumbnailService.THUMBNAIL_LAST_MODIFIED)) {
                lastModified = thumbnailNode.getProperty(ThumbnailService.THUMBNAIL_LAST_MODIFIED).getString();
            }
            InputStream inputStream = null;
            if (thumbnailNode.hasProperty(propertyName)) {
                inputStream = thumbnailNode.getProperty(propertyName).getStream();
            }
            showingNode.getSession().save();
            return Response.Builder.ok().header(LASTMODIFIED, lastModified).entity((Object)inputStream, "image").build();
        }
        return this.getThumbnailRes(parentNode, identifier, propertyName);
    }

    private Response getThumbnailRes(Node parentNode, String identifier, String propertyName) throws Exception {
        Node thumbnailNode;
        Node thumbnailFolder;
        if (parentNode.hasNode(ThumbnailService.EXO_THUMBNAILS_FOLDER) && (thumbnailFolder = parentNode.getNode(ThumbnailService.EXO_THUMBNAILS_FOLDER)).hasNode(identifier) && (thumbnailNode = thumbnailFolder.getNode(identifier)).hasProperty(propertyName)) {
            InputStream inputStream = thumbnailNode.getProperty(propertyName).getStream();
            return Response.Builder.ok().entity((Object)inputStream, "image").build();
        }
        return Response.Builder.ok().build();
    }

    private Node getShowingNode(String repoName, String wsName, String nodePath) throws Exception {
        ManageableRepository reposiotry = this.repositoryService_.getRepository(repoName);
        Session session = this.getSystemProvider().getSession(wsName, reposiotry);
        Node showingNode = null;
        showingNode = nodePath.equals("/") ? session.getRootNode() : (Node)session.getItem("/" + nodePath);
        return showingNode;
    }

    private SessionProvider getSystemProvider() {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        SessionProviderService service = (SessionProviderService)container.getComponentInstanceOfType(SessionProviderService.class);
        return service.getSystemSessionProvider(null);
    }
}

