/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.cms.comments.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.exoplatform.services.cms.comments.CommentsService;
import org.exoplatform.services.cms.i18n.MultiLanguageService;
import org.exoplatform.services.jcr.core.ManageableRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentsServiceImpl
implements CommentsService {
    private static final String COMMENTS = "comments".intern();
    private static final String COMMENTABLE = "mix:commentable".intern();
    private static final String EXO_COMMENTS = "exo:comments".intern();
    private static final String NT_UNSTRUCTURE = "nt:unstructured".intern();
    private static final String MESSAGE = "exo:commentContent".intern();
    private static final String COMMENTOR = "exo:commentor".intern();
    private static final String COMMENTOR_EMAIL = "exo:commentorEmail".intern();
    private static final String COMMENTOR_SITE = "exo:commentorSite".intern();
    private static final String CREATED_DATE = "exo:commentDate".intern();
    private static final String LANGUAGES = "languages".intern();
    private static final String ANONYMOUS = "anonymous".intern();
    private ExoCache commentsCache_;
    private MultiLanguageService multiLangService_;

    public CommentsServiceImpl(CacheService cacheService, MultiLanguageService multiLangService) throws Exception {
        this.commentsCache_ = cacheService.getCacheInstance(CommentsService.class.getName());
        this.multiLangService_ = multiLangService;
    }

    @Override
    public void addComment(Node node, String commentor, String email, String site, String comment, String language) throws Exception {
        Session session = node.getSession();
        ManageableRepository repository = (ManageableRepository)session.getRepository();
        Session systemSession = repository.getSystemSession(session.getWorkspace().getName());
        Node document = (Node)systemSession.getItem(node.getPath());
        if (!document.isNodeType(COMMENTABLE)) {
            if (document.canAddMixin(COMMENTABLE)) {
                document.addMixin(COMMENTABLE);
            } else {
                throw new Exception("This node does not support comments.");
            }
        }
        Node multiLanguages = null;
        Node languageNode = null;
        Node commentNode = null;
        if (!document.hasNode(LANGUAGES) || language.equals(this.multiLangService_.getDefault(document))) {
            if (document.hasNode(COMMENTS)) {
                commentNode = document.getNode(COMMENTS);
            } else {
                commentNode = document.addNode(COMMENTS, NT_UNSTRUCTURE);
                commentNode.addMixin("exo:hiddenable");
            }
        } else {
            multiLanguages = document.getNode(LANGUAGES);
            languageNode = multiLanguages.hasNode(language) ? multiLanguages.getNode(language) : multiLanguages.addNode(language);
            if (languageNode.hasNode(COMMENTS)) {
                commentNode = languageNode.getNode(COMMENTS);
            } else {
                commentNode = languageNode.addNode(COMMENTS, NT_UNSTRUCTURE);
                commentNode.addMixin("exo:hiddenable");
            }
        }
        if (commentor == null || commentor.length() == 0) {
            commentor = ANONYMOUS;
        }
        GregorianCalendar commentDate = new GregorianCalendar();
        String name = Long.toString(commentDate.getTimeInMillis());
        Node newComment = commentNode.addNode(name, EXO_COMMENTS);
        newComment.setProperty(COMMENTOR, commentor);
        newComment.setProperty(CREATED_DATE, (Calendar)commentDate);
        newComment.setProperty(MESSAGE, comment);
        if (email != null && email.length() > 0) {
            newComment.setProperty(COMMENTOR_EMAIL, email);
        }
        if (site != null && site.length() > 0) {
            newComment.setProperty(COMMENTOR_SITE, site);
        }
        document.save();
        systemSession.save();
        systemSession.logout();
        this.commentsCache_.remove((Serializable)((Object)commentNode.getPath()));
    }

    @Override
    public List<Node> getComments(Node document, String language) throws Exception {
        Node commentsNode = null;
        Node languagesNode = null;
        Node languageNode = null;
        if (!this.isSupportedLocalize(document, language) && document.hasProperty("exo:language")) {
            language = document.getProperty("exo:language").getString();
        }
        if (document.hasNode(LANGUAGES)) {
            languagesNode = document.getNode(LANGUAGES);
            if (languagesNode.hasNode(language)) {
                languageNode = languagesNode.getNode(language);
                if (languageNode.hasNode(COMMENTS)) {
                    commentsNode = languageNode.getNode(COMMENTS);
                }
            } else if (language.equals(this.multiLangService_.getDefault(document))) {
                languageNode = document;
            }
        } else {
            languageNode = document;
        }
        if (!languageNode.hasNode(COMMENTS)) {
            return new ArrayList<Node>();
        }
        Session session = document.getSession();
        ManageableRepository repository = (ManageableRepository)session.getRepository();
        Session systemSession = repository.getSystemSession(session.getWorkspace().getName());
        commentsNode = (Node)systemSession.getItem(languageNode.getPath() + "/" + COMMENTS);
        String cacheKey = document.getPath().concat(commentsNode.getPath());
        Object comments = this.commentsCache_.get((Serializable)((Object)cacheKey));
        if (comments != null) {
            return (List)comments;
        }
        ArrayList<Node> list = new ArrayList<Node>();
        NodeIterator iter = commentsNode.getNodes();
        while (iter.hasNext()) {
            list.add(iter.nextNode());
        }
        Collections.sort(list, new DateComparator());
        this.commentsCache_.put((Serializable)((Object)commentsNode.getPath()), list);
        return list;
    }

    private boolean isSupportedLocalize(Node document, String language) throws Exception {
        List<String> locales = this.multiLangService_.getSupportedLanguages(document);
        return Collections.frequency(locales, language) > 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DateComparator
    implements Comparator<Node> {
        private DateComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            try {
                Date date1 = node1.getProperty(CREATED_DATE).getDate().getTime();
                Date date2 = node2.getProperty(CREATED_DATE).getDate().getTime();
                return date2.compareTo(date1);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }
}

