/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.impl.bonita.ProcessData;

public class SpecifiedFormImpl
implements Form {
    private String customizedView = null;
    private byte[] icon = null;
    private boolean isDelegatedView = false;
    private ResourceBundle resourceBundle = null;
    private String stateName = null;
    private List<Map<String, Object>> submitButtons;
    private List<Map<String, Object>> variables;

    public String getCustomizedView() {
        return this.customizedView;
    }

    public String getIconURL() {
        String url = this.icon != null ? this.publishImage(this.icon) : "";
        return url;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public String getStateImageURL() {
        return "";
    }

    public String getStateName() {
        return this.stateName;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    private String publishImage(byte[] image) {
        DownloadService dS = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
        ByteArrayInputStream iS = new ByteArrayInputStream(image);
        String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
        return dS.getDownloadLink(id);
    }

    public List getVariables() {
        return this.variables;
    }

    public boolean isCustomizedView() {
        return this.customizedView != null && !"".equals(this.customizedView);
    }

    public boolean isDelegatedView() {
        return this.isDelegatedView;
    }

    public SpecifiedFormImpl(FileDefinition fileDefinition, String stateName, Locale locale) {
        this.customizedView = fileDefinition.getCustomizedView(stateName);
        this.isDelegatedView = fileDefinition.isDelegatedView(stateName);
        this.resourceBundle = fileDefinition.getResourceBundle(stateName, locale);
        this.stateName = stateName;
        this.variables = fileDefinition.getVariables(stateName);
        try {
            this.icon = fileDefinition.getEntry(this.stateName + "-icon.gif");
        }
        catch (Exception e) {
            this.icon = null;
        }
        this.submitButtons = new ArrayList<Map<String, Object>>();
        if (!ProcessData.START_STATE_NAME.equals(stateName)) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("name", "submit");
            attributes.put("transition", "");
            this.submitButtons.add(attributes);
        }
    }
}

