/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import hero.interfaces.BnNodeLocal;
import hero.interfaces.BnNodeLocalHome;
import hero.interfaces.BnNodePK;
import hero.interfaces.BnNodePropertyLocal;
import hero.interfaces.BnNodeUtil;
import hero.interfaces.BnNodeValue;
import hero.interfaces.BnProjectLightValue;
import hero.interfaces.BnProjectLocal;
import hero.interfaces.BnProjectLocalHome;
import hero.interfaces.BnProjectPK;
import hero.interfaces.BnProjectPropertyLocal;
import hero.interfaces.BnProjectPropertyValue;
import hero.interfaces.BnProjectUtil;
import hero.interfaces.BnProjectValue;
import hero.interfaces.DeadlineEjbTimerSessionLocal;
import hero.interfaces.DeadlineEjbTimerSessionLocalHome;
import hero.interfaces.DeadlineEjbTimerSessionUtil;
import hero.interfaces.ProjectSessionLocal;
import hero.interfaces.ProjectSessionLocalHome;
import hero.interfaces.ProjectSessionUtil;
import hero.interfaces.UserSessionLocal;
import hero.interfaces.UserSessionLocalHome;
import hero.interfaces.UserSessionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.ComponentPlugin;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.security.jaas.BasicCallbackHandler;
import org.exoplatform.services.workflow.FileDefinition;
import org.exoplatform.services.workflow.Form;
import org.exoplatform.services.workflow.PredefinedProcessesPlugin;
import org.exoplatform.services.workflow.Process;
import org.exoplatform.services.workflow.ProcessInstance;
import org.exoplatform.services.workflow.ProcessesConfig;
import org.exoplatform.services.workflow.Task;
import org.exoplatform.services.workflow.Timer;
import org.exoplatform.services.workflow.WorkflowFileDefinitionService;
import org.exoplatform.services.workflow.WorkflowFormsService;
import org.exoplatform.services.workflow.WorkflowServiceContainer;
import org.exoplatform.services.workflow.impl.bonita.ProcessData;
import org.exoplatform.services.workflow.impl.bonita.ProcessInstanceData;
import org.exoplatform.services.workflow.impl.bonita.TaskData;
import org.exoplatform.services.workflow.impl.bonita.TimerData;
import org.exoplatform.services.workflow.impl.bonita.WorkflowServiceContainerHelper;
import org.exoplatform.services.workflow.impl.bonita.XPDLFileDefinition;
import org.picocontainer.Startable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkflowServiceContainerImpl
implements WorkflowServiceContainer,
Startable {
    public static ThreadLocal<Map<String, Object>> InitialVariables = new ThreadLocal();
    private ArrayList<ProcessesConfig> configurations;
    private ConfigurationManager configurationManager = null;
    private WorkflowFileDefinitionService fileDefinitionService = null;
    private WorkflowFormsService formsService = null;
    private OrganizationService organizationService = null;
    private PortalContainer portalContainer = null;
    private String superUser_ = "root";
    private String jaasLoginContext_ = "tomcat";

    public WorkflowServiceContainerImpl(WorkflowFileDefinitionService fileDefinitionService, WorkflowFormsService formsService, OrganizationService organizationService, ConfigurationManager configurationManager, PortalContainer portalContainer, InitParams params) {
        this.fileDefinitionService = fileDefinitionService;
        this.formsService = formsService;
        this.organizationService = organizationService;
        this.configurationManager = configurationManager;
        this.portalContainer = portalContainer;
        this.configurations = new ArrayList();
        if (params != null) {
            ValueParam jaasLoginContextParam;
            ValueParam superUserParam = params.getValueParam("super.user");
            if (superUserParam != null && superUserParam.getValue().length() > 0) {
                this.superUser_ = superUserParam.getValue();
            }
            if ((jaasLoginContextParam = params.getValueParam("jaas.login.context")) != null && jaasLoginContextParam.getValue().length() > 0) {
                this.jaasLoginContext_ = jaasLoginContextParam.getValue();
            }
        }
    }

    public void addPlugin(ComponentPlugin plugin) throws Exception {
        if (!(plugin instanceof PredefinedProcessesPlugin)) {
            throw new RuntimeException(plugin.getClass().getName() + " is an unknown plugin type.");
        }
        this.configurations.add(((PredefinedProcessesPlugin)plugin).getProcessesConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcess(String processId) {
        UserSessionLocal userSession = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processId));
            String processName = project.getName();
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            Collection processInstances = userSession.getProjectInstances(processName);
            for (BnProjectValue projectValue : processInstances) {
                userSession.removeProject(projectValue.getName());
            }
            userSession.removeProject(processName);
            this.formsService.removeForms(processId);
            this.fileDefinitionService.remove(processId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteProcessInstance(String processInstanceId) {
        UserSessionLocal userSession = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processInstanceId));
            String processInstanceName = project.getName();
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            userSession.removeProject(processInstanceName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception exception) {}
        }
    }

    public void deployProcess(InputStream jarInputStream) throws IOException {
        XPDLFileDefinition fileDefinition = new XPDLFileDefinition(jarInputStream);
        try {
            fileDefinition.deploy();
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByName(fileDefinition.getProcessModelName());
            String processId = project.getId();
            this.fileDefinitionService.store((FileDefinition)fileDefinition, processId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endTask(String taskId, Map variables) {
        UserSessionLocal userSession = null;
        try {
            BnNodeLocalHome nodeHome = BnNodeUtil.getLocalHome();
            BnNodeLocal node = nodeHome.findByPrimaryKey(new BnNodePK(taskId));
            String projectName = node.getBnProject().getName();
            String processInstanceId = node.getBnProject().getId();
            String nodeName = node.getName();
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            userSession.startActivity(projectName, nodeName);
            this.setVariables(processInstanceId, taskId, variables);
            userSession.terminateActivity(projectName, nodeName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    public void endTask(String taskId, Map variables, String transition) {
        this.endTask(taskId, variables);
    }

    public List<Task> getAllTasks(String user) throws Exception {
        ArrayList<Task> allTasks = new ArrayList<Task>();
        allTasks.addAll(this.getUserTaskList(user));
        allTasks.addAll(this.getGroupTaskList(user));
        return allTasks;
    }

    public WorkflowFileDefinitionService getFileDefinitionService() {
        return this.fileDefinitionService;
    }

    public List<Task> getGroupTaskList(String user) throws Exception {
        return new ArrayList<Task>();
    }

    public Process getProcess(String processId) {
        ProcessData process = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processId));
            process = new ProcessData(project.getBnProjectLightValue());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return process;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Process> getProcesses() {
        UserSessionLocal userSession = null;
        ArrayList<Process> processes = new ArrayList<Process>();
        try {
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            Collection projects = userSession.getModels();
            for (BnProjectLightValue project : projects) {
                processes.add(new ProcessData(project));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception exception) {}
        }
        return processes;
    }

    public ProcessInstance getProcessInstance(String processInstanceId) {
        ProcessInstanceData processInstance = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processInstanceId));
            processInstance = new ProcessInstanceData(project.getBnProjectValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return processInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ProcessInstance> getProcessInstances(String processId) {
        UserSessionLocal userSession = null;
        ArrayList<ProcessInstance> processInstances = new ArrayList<ProcessInstance>();
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processId));
            String processName = project.getName();
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            Collection instances = userSession.getProjectInstances(processName);
            for (BnProjectValue instance : instances) {
                processInstances.add(new ProcessInstanceData(instance));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception ignore) {}
        }
        return processInstances;
    }

    public Task getTask(String taskId) {
        TaskData task = null;
        try {
            BnNodeLocalHome nodeHome = BnNodeUtil.getLocalHome();
            BnNodeLocal node = nodeHome.findByPrimaryKey(new BnNodePK(taskId));
            task = new TaskData(node.getBnNodeValue());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return task;
    }

    public List<Task> getTasks(String processInstanceId) {
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processInstanceId));
            Collection nodes = project.getBnNodes();
            for (BnNodeLocal node : nodes) {
                if (node.getState() == 0) continue;
                tasks.add(new TaskData(node.getBnNodeValue()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tasks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Timer> getTimers() {
        DeadlineEjbTimerSessionLocal deadlineSession = null;
        ArrayList<Timer> timers = new ArrayList<Timer>();
        try {
            DeadlineEjbTimerSessionLocalHome deadlineHome = DeadlineEjbTimerSessionUtil.getLocalHome();
            deadlineSession = deadlineHome.create();
            Collection deadlines = deadlineSession.getTimers();
            for (hero.util.TimerData timerData : deadlines) {
                timers.add(new TimerData(timerData));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                deadlineSession.remove();
            }
            catch (Exception exception) {}
        }
        return timers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getUserTaskList(String user) {
        UserSessionLocal userSession = null;
        ArrayList<Task> tasks = new ArrayList<Task>();
        try {
            UserSessionLocalHome userSessionHome = UserSessionUtil.getLocalHome();
            userSession = userSessionHome.create();
            Collection nodes = userSession.getToDoListAllInstances();
            for (BnNodeValue node : nodes) {
                tasks.add(new TaskData(node));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                userSession.remove();
            }
            catch (Exception ignore) {}
        }
        return tasks;
    }

    public Map getVariables(String processInstanceId, String taskId) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        try {
            BnNodeLocalHome nodeHome = BnNodeUtil.getLocalHome();
            BnNodeLocal node = nodeHome.findByPrimaryKey(new BnNodePK(taskId));
            Collection nodeProperties = node.getBnProperties();
            for (BnNodePropertyLocal property : nodeProperties) {
                variables.put(property.getTheKey(), property.getTheValue());
            }
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processInstanceId));
            Collection projectProperties = project.getBnProperties();
            for (BnProjectPropertyLocal property : projectProperties) {
                variables.put(property.getTheKey(), property.getTheValue());
            }
            String processModelName = WorkflowServiceContainerHelper.getModelName(project.getName());
            String processModelId = projectHome.findByName(processModelName).getId();
            Form form = this.formsService.getForm(processModelId, node.getName(), Locale.getDefault());
            List formVariables = form.getVariables();
            for (Map formVariable : formVariables) {
                String key = (String)formVariable.get("name");
                String component = (String)formVariable.get("component");
                variables.put(key, WorkflowServiceContainerHelper.stringToObject((String)variables.get(key), component));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return variables;
    }

    public boolean hasStartTask(String processId) {
        Form form = this.formsService.getForm(processId, ProcessData.START_STATE_NAME, Locale.getDefault());
        return !form.getVariables().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVariables(String processInstanceId, String taskId, Map variables) {
        ProjectSessionLocal projectSession = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processInstanceId));
            String processInstanceName = project.getName();
            String processModelName = WorkflowServiceContainerHelper.getModelName(processInstanceName);
            project = projectHome.findByName(processModelName);
            String processModelId = project.getId();
            ProjectSessionLocalHome projectSessionHome = ProjectSessionUtil.getLocalHome();
            projectSession = projectSessionHome.create();
            projectSession.initProject(processInstanceName);
            String taskName = null;
            if (taskId != null) {
                BnNodeLocalHome nodeHome = BnNodeUtil.getLocalHome();
                BnNodeLocal node = nodeHome.findByPrimaryKey(new BnNodePK(taskId));
                taskName = node.getName();
            } else {
                taskName = ProcessData.START_STATE_NAME;
            }
            Form form = this.formsService.getForm(processModelId, taskName, Locale.getDefault());
            List formVariableList = form.getVariables();
            HashMap<String, Map> formVariables = new HashMap<String, Map>();
            for (Map formVariable : formVariableList) {
                formVariables.put((String)formVariable.get("name"), formVariable);
            }
            Collection projectPropertyValues = projectSession.getProperties();
            ArrayList<String> projectPropertyKeys = new ArrayList<String>();
            for (BnProjectPropertyValue projectPropertyValue : projectPropertyValues) {
                projectPropertyKeys.add(projectPropertyValue.getTheKey());
            }
            for (Object keyObject : variables.keySet()) {
                String key = (String)keyObject;
                Map formVariable = (Map)formVariables.get(key);
                String componentName = null;
                if (formVariable != null) {
                    componentName = (String)formVariable.get("component");
                }
                if (componentName == null) {
                    componentName = "text";
                }
                String value = WorkflowServiceContainerHelper.objectToString(variables.get(keyObject), componentName);
                if (projectPropertyKeys.contains(key) || ProcessData.START_STATE_NAME.equals(taskName)) {
                    projectSession.setProperty(key, value);
                    continue;
                }
                projectSession.setNodeProperty(taskName, key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                projectSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        LoginContext lc = null;
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            Collection projects = projectHome.findAll();
            if (projects.isEmpty()) {
                UserHandler userHandler = this.organizationService.getUserHandler();
                User user = userHandler.findUserByName(this.superUser_);
                char[] password = user.getPassword().toCharArray();
                BasicCallbackHandler handler = new BasicCallbackHandler(this.superUser_, password);
                lc = new LoginContext(this.jaasLoginContext_, (CallbackHandler)handler);
                lc.login();
                for (ProcessesConfig processConfig : this.configurations) {
                    HashSet predefinedProcesses = processConfig.getPredefinedProcess();
                    String processLoc = processConfig.getProcessLocation();
                    for (String parFile : predefinedProcesses) {
                        try {
                            InputStream iS = this.configurationManager.getInputStream(processLoc + parFile);
                            this.deployProcess(iS);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                lc.logout();
            }
            catch (Exception exception) {}
        }
    }

    public void startProcess(String processId) {
        this.startProcess(null, processId, new HashMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess(String remoteUser, String processId, Map variables) {
        ProjectSessionLocal projectSession = null;
        try {
            ProjectSessionLocalHome projectSessionHome = ProjectSessionUtil.getLocalHome();
            projectSession = projectSessionHome.create();
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByPrimaryKey(new BnProjectPK(processId));
            String modelName = project.getName();
            String instanceName = projectSession.instantiateProject(modelName);
            project = projectHome.findByName(instanceName);
            String instanceId = project.getId();
            this.setVariables(instanceId, null, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                projectSession.remove();
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcessFromName(String remoteUser, String processName, Map variables) {
        try {
            BnProjectLocalHome projectHome = BnProjectUtil.getLocalHome();
            BnProjectLocal project = projectHome.findByName(processName);
            String processId = project.getId();
            InitialVariables.set(variables);
            this.startProcess(remoteUser, processId, variables);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                InitialVariables.remove();
            }
            catch (Exception ignore) {}
        }
    }

    public void stop() {
    }
}

