/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.bonita;

import hero.user.ImmutableException;
import hero.user.UserBase;
import hero.user.UserBaseException;
import hero.util.BonitaConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.RootContainer;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;

public class ExoUserBase
implements UserBase {
    public static final String EXO_PORTALNAME = "exo.Portalname";
    private String url;
    private String user;
    private String password;
    private String driver;

    public String getUserName(String userId) throws UserBaseException {
        return userId;
    }

    public Map getUserInfos(String userId) throws UserBaseException {
        try {
            Hashtable<String, String> uinfos = new Hashtable<String, String>();
            boolean checkpoint = false;
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = null;
            if (container == null) {
                BonitaConfig instance = BonitaConfig.getInstance();
                String portalName = instance.getProperty(EXO_PORTALNAME);
                container = RootContainer.getInstance().getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            UserHandler userHandler_ = organization.getUserHandler();
            User user = userHandler_.findUserByName(userId);
            uinfos.put("name", userId);
            if (user.getPassword() != null) {
                uinfos.put("password", user.getPassword());
            }
            if (user.getEmail() != null) {
                uinfos.put("email", user.getEmail());
            }
            uinfos.put("jabber", "TODO");
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
            Hashtable<String, String> hashtable = uinfos;
            return hashtable;
        }
        catch (Exception ne) {
            throw new UserBaseException(ne.getMessage());
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }

    public Collection getUsers() throws UserBaseException {
        try {
            ArrayList allUsers = new ArrayList();
            boolean checkpoint = false;
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = null;
            if (container == null) {
                BonitaConfig instance = BonitaConfig.getInstance();
                String portalName = instance.getProperty(EXO_PORTALNAME);
                container = RootContainer.getInstance().getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            UserHandler userHandler_ = organization.getUserHandler();
            Query query = new Query();
            PageList users = userHandler_.findUsers(query);
            List list = users.getPage(1);
            for (Object ele : list) {
                Hashtable<String, String> uinfos = new Hashtable<String, String>();
                User u = (User)ele;
                uinfos.put("name", u.getUserName());
                allUsers.add(uinfos);
            }
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
            ArrayList arrayList = allUsers;
            return arrayList;
        }
        catch (Exception ne) {
            throw new UserBaseException(ne.getMessage());
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }

    public boolean handle(String userId) throws UserBaseException {
        return false;
    }

    public boolean isMutable() {
        return true;
    }

    public void create(String userId, String password, String userName, String userEmail, Map userInfos) throws UserBaseException, ImmutableException {
        try {
            boolean checkpoint = false;
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = null;
            if (container == null) {
                BonitaConfig instance = BonitaConfig.getInstance();
                String portalName = instance.getProperty(EXO_PORTALNAME);
                container = RootContainer.getInstance().getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            UserHandler userHandler_ = organization.getUserHandler();
            User user = organization.getUserHandler().createUserInstance();
            user.setUserName(userId);
            user.setPassword(password);
            user.setFirstName(userName);
            user.setLastName(userEmail);
            user.setEmail(userEmail);
            organization.getUserHandler().createUser(user, true);
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
        }
        catch (Exception ne) {
            throw new UserBaseException(ne.getMessage());
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }

    public void edit(String userId, String password, String userName, String userEmail, Map userInfos) throws UserBaseException, ImmutableException {
        try {
            boolean checkpoint = false;
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = null;
            if (container == null) {
                BonitaConfig instance = BonitaConfig.getInstance();
                String portalName = instance.getProperty(EXO_PORTALNAME);
                container = RootContainer.getInstance().getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            UserHandler userHandler_ = organization.getUserHandler();
            User user = userHandler_.findUserByName(userId);
            user.setUserName(userId);
            user.setPassword(password);
            user.setFirstName(userName);
            user.setLastName(userEmail);
            user.setEmail(userEmail);
            organization.getUserHandler().saveUser(user, true);
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
        }
        catch (Exception ne) {
            throw new UserBaseException(ne.getMessage());
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }

    public void deleteUser(String userId) throws UserBaseException, ImmutableException {
        try {
            boolean checkpoint = false;
            PortalContainer container = PortalContainer.getInstance();
            OrganizationService organization = null;
            if (container == null) {
                BonitaConfig instance = BonitaConfig.getInstance();
                String portalName = instance.getProperty(EXO_PORTALNAME);
                container = RootContainer.getInstance().getPortalContainer(portalName);
                PortalContainer.setInstance((PortalContainer)container);
                checkpoint = true;
            }
            organization = (OrganizationService)container.getComponentInstanceOfType(OrganizationService.class);
            organization.getUserHandler().removeUser(userId, true);
            if (checkpoint) {
                PortalContainer.setInstance(null);
                checkpoint = false;
            }
        }
        catch (Exception ne) {
            throw new UserBaseException(ne.getMessage());
        }
        finally {
            PortalContainer.setInstance(null);
        }
    }
}

