/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.db;

import java.sql.Connection;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.jbpm.db.ContextSession;
import org.jbpm.db.GraphSession;
import org.jbpm.db.JbpmSessionFactory;
import org.jbpm.db.LoggingSession;
import org.jbpm.db.SchedulerSession;
import org.jbpm.db.TaskMgmtSession;

public class JbpmSession {
    static ThreadLocal currentJbpmSessionStack = new ThreadLocal();
    private JbpmSessionFactory jbpmSessionFactory = null;
    private Session session = null;
    private Transaction transaction = null;
    private GraphSession graphSession = null;
    private ContextSession contextSession = null;
    private TaskMgmtSession taskMgmtSession = null;
    private LoggingSession loggingSession = null;
    private SchedulerSession schedulerSession = null;
    private static final Log log = LogFactory.getLog(JbpmSession.class);

    public JbpmSession(JbpmSessionFactory jbpmSessionFactory, Session session) {
        this.jbpmSessionFactory = jbpmSessionFactory;
        this.session = session;
        this.graphSession = new GraphSession(this);
        this.contextSession = new ContextSession(this);
        this.taskMgmtSession = new TaskMgmtSession(this);
        this.loggingSession = new LoggingSession(this);
        this.schedulerSession = new SchedulerSession(this);
        this.pushCurrentSession();
    }

    public JbpmSessionFactory getJbpmSessionFactory() {
        return this.jbpmSessionFactory;
    }

    public Connection getConnection() {
        try {
            return this.session.connection();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException();
            throw new RuntimeException("couldn't get the jdbc connection from hibernate", e);
        }
    }

    public Session getSession() {
        return this.session;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void beginTransaction() {
        try {
            this.transaction = this.session.beginTransaction();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException();
            throw new RuntimeException("couldn't begin a transaction", e);
        }
    }

    public void commitTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("can't commit : no transaction started");
        }
        try {
            this.session.flush();
            this.transaction.commit();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException();
            throw new RuntimeException("couldn't commit transaction", e);
        }
        finally {
            this.transaction = null;
        }
    }

    public void rollbackTransaction() {
        if (this.transaction == null) {
            throw new RuntimeException("can't rollback : no transaction started");
        }
        try {
            this.transaction.rollback();
        }
        catch (Exception e) {
            log.error((Object)e);
            this.handleException();
            throw new RuntimeException("couldn't rollback transaction", e);
        }
        finally {
            this.transaction = null;
        }
    }

    public void commitTransactionAndClose() {
        try {
            this.commitTransaction();
            this.close();
        }
        catch (Throwable t) {
            this.rollbackTransaction();
        }
    }

    public void rollbackTransactionAndClose() {
        try {
            this.rollbackTransaction();
            this.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.close();
        }
    }

    public GraphSession getGraphSession() {
        return this.graphSession;
    }

    public ContextSession getContextSession() {
        return this.contextSession;
    }

    public TaskMgmtSession getTaskMgmtSession() {
        return this.taskMgmtSession;
    }

    public LoggingSession getLoggingSession() {
        return this.loggingSession;
    }

    public SchedulerSession getSchedulerSession() {
        return this.schedulerSession;
    }

    public void close() {
        try {
            if (this.session != null && this.session.isOpen()) {
                this.session.close();
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new RuntimeException("couldn't close the hibernate connection", e);
        }
        finally {
            this.popCurrentSession();
            this.session = null;
        }
    }

    void handleException() {
        if (this.transaction != null) {
            try {
                this.transaction.rollback();
            }
            catch (HibernateException e) {
                log.error((Object)"couldn't rollback hibernate transaction", (Throwable)e);
            }
            this.close();
        }
    }

    private void pushCurrentSession() {
        LinkedList<JbpmSession> stack = (LinkedList<JbpmSession>)currentJbpmSessionStack.get();
        if (stack == null) {
            stack = new LinkedList<JbpmSession>();
            currentJbpmSessionStack.set(stack);
        }
        stack.addFirst(this);
    }

    public static JbpmSession getCurrentJbpmSession() {
        JbpmSession jbpmSession = null;
        LinkedList stack = (LinkedList)currentJbpmSessionStack.get();
        if (stack != null && !stack.isEmpty()) {
            jbpmSession = (JbpmSession)stack.getFirst();
        }
        return jbpmSession;
    }

    private void popCurrentSession() {
        LinkedList stack = (LinkedList)currentJbpmSessionStack.get();
        if (stack == null || stack.isEmpty() || stack.getFirst() != this) {
            log.warn((Object)"can't pop current session: are you calling JbpmSession.close() multiple times ?");
        } else {
            stack.removeFirst();
        }
    }
}

