/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.node;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.EndState;
import org.jbpm.graph.node.Fork;
import org.jbpm.graph.node.InterleaveEnd;
import org.jbpm.graph.node.InterleaveStart;
import org.jbpm.graph.node.Join;
import org.jbpm.graph.node.Merge;
import org.jbpm.graph.node.MilestoneNode;
import org.jbpm.graph.node.ProcessState;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.State;
import org.jbpm.graph.node.TaskNode;

public class NodeTypes {
    private static Map nodeTypes = NodeTypes.initialiseNodeTypes();
    private static Map nodeNames = NodeTypes.createInverseMapping(nodeTypes);

    public static Set getNodeTypes() {
        return nodeNames.keySet();
    }

    public static Set getNodeNames() {
        return nodeTypes.keySet();
    }

    public static Class getNodeType(String name) {
        return (Class)nodeTypes.get(name);
    }

    public static String getNodeName(Class type) {
        return (String)nodeNames.get(type);
    }

    private static Map initialiseNodeTypes() {
        HashMap<String, Class> types = new HashMap<String, Class>();
        types.put("start-state", StartState.class);
        types.put("end-state", EndState.class);
        types.put("node", Node.class);
        types.put("state", State.class);
        types.put("task-node", TaskNode.class);
        types.put("fork", Fork.class);
        types.put("join", Join.class);
        types.put("decision", Decision.class);
        types.put("process-state", ProcessState.class);
        types.put("super-state", SuperState.class);
        types.put("merge", Merge.class);
        types.put("milestone-node", MilestoneNode.class);
        types.put("interleave-start", InterleaveStart.class);
        types.put("interleave-end", InterleaveEnd.class);
        return types;
    }

    public static Map createInverseMapping(Map map) {
        HashMap names = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            names.put(entry.getValue(), entry.getKey());
        }
        return names;
    }
}

