/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.jpdl.par;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.jpdl.JpdlException;
import org.jbpm.jpdl.par.ProcessArchive;
import org.jbpm.jpdl.par.ProcessArchiveParser;
import org.jbpm.jpdl.xml.JpdlXmlReader;

public class JpdlArchiveParser
implements ProcessArchiveParser {
    public ProcessDefinition readFromArchive(ProcessArchive processArchive, ProcessDefinition processDefinition) {
        try {
            byte[] processBytes = processArchive.removeEntry("processdefinition.xml");
            if (processBytes == null) {
                throw new JpdlException("no processdefinition.xml inside process archive");
            }
            ByteArrayInputStream processInputStream = new ByteArrayInputStream(processBytes);
            InputStreamReader processReader = new InputStreamReader(processInputStream);
            JpdlXmlReader jpdlReader = new JpdlXmlReader(processReader);
            try {
                processDefinition = jpdlReader.readProcessDefinition();
            }
            catch (JpdlException e) {
                e.printStackTrace();
                processArchive.getProblems().addAll(e.getProblems());
            }
            jpdlReader.close();
            ((Reader)processReader).close();
            ((InputStream)processInputStream).close();
        }
        catch (IOException e) {
            processArchive.addWarning("io problem while reading processdefinition.xml: " + e.getMessage());
        }
        return processDefinition;
    }
}

