/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.security.filter;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.jbpm.security.Authentication;

public class JbpmAuthenticationFilter
implements Filter {
    public void init(FilterConfig filterConfig) throws ServletException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        Principal userPrincipal;
        String actorId = null;
        if (servletRequest instanceof HttpServletRequest && (userPrincipal = (httpServletRequest = (HttpServletRequest)servletRequest).getUserPrincipal()) != null) {
            actorId = userPrincipal.getName();
        }
        if (actorId != null) {
            Authentication.pushAuthenticatedActorId(actorId);
            try {
                filterChain.doFilter(servletRequest, servletResponse);
            }
            finally {
                Authentication.popAuthenticatedActorId();
            }
        } else {
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    public void destroy() {
    }
}

