/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.workflow.impl.jbpm;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.log.LogService;
import org.exoplatform.services.workflow.Form;
import org.jbpm.file.def.FileDefinition;

public class FormImpl
implements Form {
    private String stateName;
    private List variables;
    private List submitButtons;
    private ResourceBundle resourceBundle;
    private Log log = ((LogService)PortalContainer.getInstance().getComponentInstanceOfType(LogService.class)).getLog("org.exoplatform.services.workflow");
    private boolean customizedView;
    private boolean delegatedView;
    private String customizedViewString;
    private byte[] iconBytes;
    private byte[] stateImageBytes;

    public FormImpl(FileDefinition fileDefinition, Element element, Locale locale) {
        Element childElement = element.element("resource-bundle");
        String formFileName = "";
        if (childElement != null) {
            formFileName = childElement.getText();
        }
        String localisedFileName = this.getLocalisedString(formFileName, locale);
        this.log.debug((Object)("Try to find localised resource : " + localisedFileName));
        byte[] bytes = null;
        try {
            bytes = fileDefinition.getBytes(localisedFileName);
        }
        catch (Exception e) {
            this.log.debug((Object)("Try to find default resource : " + formFileName + ".properties"));
            try {
                bytes = fileDefinition.getBytes(formFileName + ".properties");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (bytes != null) {
            this.log.debug((Object)"resource bundle found true");
            try {
                this.resourceBundle = new PropertyResourceBundle(new ByteArrayInputStream(bytes));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.log.debug((Object)"resource bundle not found");
        }
        childElement = element.element("state-name");
        if (childElement != null) {
            this.stateName = childElement.getText();
        }
        this.initializeVariables(element);
        this.initializeSubmitButtons(element);
        childElement = element.element("customized-view");
        if (childElement != null) {
            this.customizedViewString = childElement.getText();
        }
        if (this.customizedViewString != null && !"".equals(this.customizedViewString)) {
            this.customizedView = true;
        }
        childElement = element.element("delegated-view");
        String delegatedViewString = "";
        if (childElement != null) {
            delegatedViewString = childElement.getText();
        }
        if ("true".equals(delegatedViewString)) {
            this.delegatedView = true;
        }
        this.iconBytes = this.getBytes(fileDefinition, this.stateName + "-icon.gif");
        this.stateImageBytes = this.getBytes(fileDefinition, this.stateName + "-state.gif");
    }

    private String getLocalisedString(String fileName, Locale locale) {
        return fileName + "_" + locale.getLanguage() + ".properties";
    }

    private void initializeVariables(Element element) {
        this.variables = new ArrayList();
        HashMap<String, String> attributes = null;
        for (Element variableElement : element.elements("variable")) {
            attributes = new HashMap<String, String>();
            String variableName = variableElement.attributeValue("name");
            attributes.put("name", variableName);
            String componentName = variableElement.attributeValue("component");
            attributes.put("component", componentName);
            String editable = variableElement.attributeValue("editable");
            attributes.put("editable", editable);
            String mandatory = variableElement.attributeValue("mandatory");
            attributes.put("mandatory", mandatory);
            this.variables.add(attributes);
        }
    }

    private void initializeSubmitButtons(Element element) {
        this.submitButtons = new ArrayList();
        HashMap<String, String> attributes = null;
        for (Element submitButtonElement : element.elements("submitbutton")) {
            attributes = new HashMap<String, String>();
            String value = submitButtonElement.attributeValue("name");
            attributes.put("name", value);
            String transitionName = submitButtonElement.attributeValue("transition-name");
            attributes.put("transition", transitionName);
            this.submitButtons.add(attributes);
        }
    }

    public List getVariables() {
        return this.variables;
    }

    public List getSubmitButtons() {
        return this.submitButtons;
    }

    public String getStateName() {
        return this.stateName;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public boolean isCustomizedView() {
        return this.customizedView;
    }

    public String getCustomizedView() {
        return this.customizedViewString;
    }

    public boolean isDelegatedView() {
        return this.delegatedView;
    }

    public String getIconURL() {
        return this.getURL(this.iconBytes);
    }

    public String getStateImageURL() {
        return this.getURL(this.stateImageBytes);
    }

    public byte[] getBytes(FileDefinition fileDefinition, String file) {
        try {
            return fileDefinition.getBytes(file);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getURL(byte[] bytes) {
        DownloadService dS = (DownloadService)PortalContainer.getInstance().getComponentInstanceOfType(DownloadService.class);
        ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
        String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
        return dS.getDownloadLink(id);
    }
}

