/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.queries;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.Value;
import org.exoplatform.ecm.jcr.ECMNameValidator;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesForm;
import org.exoplatform.ecm.webui.component.admin.queries.UIQueriesManager;
import org.exoplatform.services.cms.queries.QueryService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={CancelActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={ChangeQueryTypeActionListener.class}), @EventConfig(phase=Event.Phase.DECODE, listeners={AddPermissionActionListener.class})})
public class UIQueriesForm
extends UIForm
implements UISelector {
    public static final String QUERY_NAME = "name";
    public static final String QUERY_TYPE = "type";
    public static final String STATEMENT = "statement";
    public static final String PERMISSIONS = "permissions";
    public static final String CACHE_RESULT = "cache";
    public static final String[] ACTIONS = new String[]{"Save", "Cancel"};
    public static final String SQL_QUERY = "select * from exo:article where jcr:path like '/Documents/Live/%'";
    public static final String XPATH_QUERY = "/jcr:root/Documents/Live//element(*, exo:article)";
    public static final String[] REG_EXPRESSION = new String[]{"[", "]", ":", "&"};
    private boolean isAddNew_ = false;

    public UIQueriesForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(QUERY_NAME, QUERY_NAME, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ECMNameValidator.class, new Object[0]));
        ArrayList<SelectItemOption> ls = new ArrayList<SelectItemOption>();
        ls.add(new SelectItemOption("xPath", (Object)"xpath"));
        ls.add(new SelectItemOption("SQL", (Object)"sql"));
        UIFormSelectBox uiSelectBox = new UIFormSelectBox(QUERY_TYPE, QUERY_TYPE, ls);
        uiSelectBox.setOnChange("ChangeQueryType");
        this.addUIFormInput((UIFormInput)uiSelectBox);
        UIFormTextAreaInput uiStatement = new UIFormTextAreaInput(STATEMENT, STATEMENT, null);
        uiStatement.setValue((Object)XPATH_QUERY);
        uiStatement.addValidator(MandatoryValidator.class, new Object[0]);
        this.addUIFormInput((UIFormInput)uiStatement);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(CACHE_RESULT, CACHE_RESULT, null));
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction("PermissionButton");
        uiInputAct.addUIFormInput((UIFormInput)new UIFormStringInput(PERMISSIONS, PERMISSIONS, null).setEditable(false));
        uiInputAct.setActionInfo(PERMISSIONS, new String[]{"AddPermission"});
        this.addUIComponentInput((UIComponent)uiInputAct);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public void updateSelect(String selectField, String value) {
        this.getUIStringInput(selectField).setValue((Object)value);
        UIQueriesManager uiManager = (UIQueriesManager)this.getAncestorOfType(UIQueriesManager.class);
        UIPopupWindow uiPopup = (UIPopupWindow)uiManager.getChildById("PermissionPopup");
        uiPopup.setRendered(false);
        uiPopup.setShow(false);
    }

    public void setIsAddNew(boolean isAddNew) {
        this.isAddNew_ = isAddNew;
    }

    public void update(String queryName) throws Exception {
        this.isAddNew_ = false;
        QueryService queryService = (QueryService)this.getApplicationComponent(QueryService.class);
        if (queryName == null) {
            this.isAddNew_ = true;
            this.reset();
            return;
        }
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        Node query = queryService.getSharedQuery(queryName, repository, SessionsUtils.getSystemProvider());
        this.getUIStringInput(QUERY_NAME).setValue((Object)queryName);
        this.getUIStringInput(QUERY_NAME).setEditable(false);
        if (query.hasProperty("exo:cachedResult")) {
            this.getUIFormCheckBoxInput(CACHE_RESULT).setChecked(query.getProperty("exo:cachedResult").getBoolean());
        } else {
            this.getUIFormCheckBoxInput(CACHE_RESULT).setChecked(false);
        }
        if (query.hasProperty("jcr:statement")) {
            this.getUIFormTextAreaInput(STATEMENT).setValue((Object)query.getProperty("jcr:statement").getString());
        }
        if (query.hasProperty("jcr:language")) {
            this.getUIFormSelectBox(QUERY_TYPE).setValue(query.getProperty("jcr:language").getString());
        }
        if (query.hasProperty("exo:permissions")) {
            Value[] values = query.getProperty("exo:permissions").getValues();
            StringBuilder strValues = new StringBuilder();
            for (int i = 0; i < values.length; ++i) {
                if (strValues.length() > 0) {
                    strValues = strValues.append(",");
                }
                strValues = strValues.append(values[i].getString());
            }
            this.getUIStringInput(PERMISSIONS).setValue((Object)strValues.toString());
        }
    }

    static /* synthetic */ boolean access$000(UIQueriesForm x0) {
        return x0.isAddNew_;
    }
}

