/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.script;

import java.util.Collections;
import java.util.List;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.script.UICBScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIECMFilterForm;
import org.exoplatform.ecm.webui.component.admin.script.UIECMScripts;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptList;
import org.exoplatform.ecm.webui.component.admin.script.UIScriptManager;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIComponentDecorator;
import org.exoplatform.webui.core.UIPageIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="app:/groovy/webui/component/admin/script/UIScriptList.gtmpl", events={@EventConfig(listeners={EditActionListener.class}), @EventConfig(listeners={DeleteActionListener.class}, confirm="UIScriptList.msg.confirm-delete"), @EventConfig(listeners={AddNewActionListener.class})})
public class UIScriptList
extends UIComponentDecorator {
    private UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "ScriptListIterator");

    public UIScriptList() throws Exception {
        this.setUIComponent((UIComponent)this.uiPageIterator_);
    }

    public void updateGrid(List<ScriptData> scriptData) throws Exception {
        Collections.sort(scriptData, new ScriptComparator());
        ObjectPageList objPageList = new ObjectPageList(scriptData, 10);
        this.uiPageIterator_.setPageList((PageList)objPageList);
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public List getScriptList() throws Exception {
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String getScriptCategory() throws Exception {
        UIComponent parent = this.getParent();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node script = null;
        if (parent instanceof UIECMScripts) {
            UIECMFilterForm filterForm = (UIECMFilterForm)parent.findFirstComponentOfType(UIECMFilterForm.class);
            String categoryName = (String)filterForm.getUIFormSelectBox("selectScript").getValue();
            script = scriptService.getECMScriptHome(repository, SessionsUtils.getSystemProvider()).getNode(categoryName);
        } else {
            script = scriptService.getCBScriptHome(repository, SessionsUtils.getSystemProvider());
        }
        String basePath = scriptService.getBaseScriptPath() + "/";
        return script.getPath().substring(basePath.length());
    }

    public void refresh() throws Exception {
        UIScriptManager sManager = (UIScriptManager)this.getAncestorOfType(UIScriptManager.class);
        UIComponent parent = this.getParent();
        if (parent instanceof UICBScripts) {
            ((UICBScripts)sManager.getChild(UICBScripts.class)).refresh();
        } else {
            ((UIECMScripts)sManager.getChild(UIECMScripts.class)).refresh();
        }
    }

    public String[] getActions() {
        return new String[]{"AddNew"};
    }

    public Node getScriptNode(String nodeName) throws Exception {
        UIComponent parent = this.getParent();
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        Node script = null;
        if (parent instanceof UIECMScripts) {
            UIECMFilterForm filterForm = (UIECMFilterForm)parent.findFirstComponentOfType(UIECMFilterForm.class);
            String categoryName = (String)filterForm.getUIFormSelectBox("selectScript").getValue();
            Node category = scriptService.getECMScriptHome(repository, SessionsUtils.getSessionProvider()).getNode(categoryName);
            script = category.getNode(nodeName);
        } else {
            Node cbScript = scriptService.getCBScriptHome(repository, SessionsUtils.getSystemProvider());
            script = cbScript.getNode(nodeName);
        }
        return script;
    }
}

