/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.browsecontent;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.browsecontent.UIBrowseContainer;
import org.exoplatform.ecm.webui.component.browsecontent.UICBSearchForm;
import org.exoplatform.ecm.webui.component.browsecontent.UICBSearchResults;
import org.exoplatform.ecm.webui.component.browsecontent.UISearchController;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/browse/UICBSearchForm.gtmpl", events={@EventConfig(listeners={SearchActionListener.class}), @EventConfig(listeners={ChangeTypeActionListener.class})})
public class UICBSearchForm
extends UIForm {
    public static final String FIELD_SEARCHVALUE = "inputValue";
    public static final String FIELD_OPTION = "option";
    public static final String FIELD_CB_REF = "referencesDoc";
    public static final String FIELD_CB_CHILD = "childDoc";
    public static final String CATEGORY_SEARCH = "Category";
    public static final String DOCUMENT_SEARCH = "Content";
    public static final String CATEGORY_QUERY = "select * from $0 where jcr:path like '%/$1[%]' ";
    public static final String DOCUMENT_QUERY = "select * from $0 where contains(*, '$1') AND jcr:path like '$2[%]/%' ";
    public boolean isDocumentType = true;
    protected long duration_ = 0L;

    public UICBSearchForm() {
        UIFormSelectBox selectType = new UIFormSelectBox(FIELD_OPTION, FIELD_OPTION, this.getOptions());
        selectType.setOnChange("ChangeType");
        selectType.setValue(DOCUMENT_SEARCH);
        this.addChild((UIComponent)new UIFormStringInput(FIELD_SEARCHVALUE, FIELD_SEARCHVALUE, null));
        this.addChild((UIComponent)selectType);
        UIFormCheckBoxInput cbRef = new UIFormCheckBoxInput(FIELD_CB_REF, FIELD_CB_REF, null);
        UIFormCheckBoxInput cbRel = new UIFormCheckBoxInput(FIELD_CB_CHILD, FIELD_CB_CHILD, null);
        this.addChild(cbRef.setRendered(this.isDocumentType));
        this.addChild(cbRel.setRendered(this.isDocumentType));
    }

    public List<SelectItemOption<String>> getOptions() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        options.add(new SelectItemOption(DOCUMENT_SEARCH, (Object)DOCUMENT_SEARCH));
        options.add(new SelectItemOption(CATEGORY_SEARCH, (Object)CATEGORY_SEARCH));
        return options;
    }

    public Node getNode() throws Exception {
        return ((UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class)).getCurrentNode();
    }

    public long searchTime() {
        return this.duration_;
    }

    public List<UICBSearchResults.ResultData> searchByCategory(String keyword, Node currentNode) throws Exception {
        ArrayList<UICBSearchResults.ResultData> resultList = new ArrayList<UICBSearchResults.ResultData>();
        UIBrowseContainer uiContainer = (UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class);
        QueryManager queryManager = null;
        try {
            queryManager = currentNode.getSession().getWorkspace().getQueryManager();
        }
        catch (Exception e) {
            return resultList;
        }
        this.duration_ = 0L;
        String statement = StringUtils.replace((String)CATEGORY_QUERY, (String)"$1", (String)keyword);
        for (String type : Utils.CATEGORY_NODE_TYPES) {
            String queryStatement = StringUtils.replace((String)statement, (String)"$0", (String)type);
            long beforeTime = System.currentTimeMillis();
            try {
                Query query = queryManager.createQuery(queryStatement, "sql");
                QueryResult queryResult = query.execute();
                long searchTime = System.currentTimeMillis() - beforeTime;
                this.duration_ += searchTime;
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    Node node = iter.nextNode();
                    if (!node.getPath().startsWith(currentNode.getPath())) continue;
                    UICBSearchResults.ResultData result = new UICBSearchResults.ResultData(node.getName(), node.getPath());
                    resultList.add(result);
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        UISearchController uiController = (UISearchController)uiContainer.getChild(UISearchController.class);
        uiController.setSearchTime(this.duration_);
        uiController.setResultRecord(resultList.size());
        return resultList;
    }

    public List<UICBSearchResults.ResultData> searchDocument(String keyword, boolean reference, boolean relation, Node currentNode) throws Exception {
        String nodePath = currentNode.getPath();
        if (nodePath.equals("/")) {
            nodePath = "";
        }
        ArrayList<UICBSearchResults.ResultData> resultList = new ArrayList<UICBSearchResults.ResultData>();
        HashMap<String, UICBSearchResults.ResultData> temp = new HashMap<String, UICBSearchResults.ResultData>();
        QueryManager queryManager = null;
        try {
            queryManager = currentNode.getSession().getWorkspace().getQueryManager();
        }
        catch (Exception e) {
            e.printStackTrace();
            return resultList;
        }
        String statement = StringUtils.replace((String)DOCUMENT_QUERY, (String)"$1", (String)keyword);
        statement = StringUtils.replace((String)statement, (String)"$2", (String)nodePath);
        UIBrowseContainer uiContainer = (UIBrowseContainer)this.getAncestorOfType(UIBrowseContainer.class);
        this.duration_ = 0L;
        TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
        String repository = uiContainer.getRepository();
        List documentNodeTypes = templateService.getDocumentTemplates(repository);
        documentNodeTypes.add("nt:resource");
        for (String ntDocument : documentNodeTypes) {
            String queryStatement = StringUtils.replace((String)statement, (String)"$0", (String)ntDocument);
            long beforeTime = System.currentTimeMillis();
            try {
                Query query = queryManager.createQuery(queryStatement, "sql");
                QueryResult queryResult = query.execute();
                long searchTime = System.currentTimeMillis() - beforeTime;
                this.duration_ += searchTime;
                NodeIterator iter = queryResult.getNodes();
                while (iter.hasNext()) {
                    UICBSearchResults.ResultData result;
                    Node node = iter.nextNode();
                    if (ntDocument.equals("nt:resource")) {
                        Node paNode = node.getParent();
                        if (!documentNodeTypes.contains(paNode.getPrimaryNodeType().getName())) continue;
                        String path = paNode.getPath();
                        String name = path.substring(path.lastIndexOf("/") + 1);
                        result = new UICBSearchResults.ResultData(name, path);
                        temp.put(path, result);
                        continue;
                    }
                    String path = node.getPath();
                    String name = path.substring(path.lastIndexOf("/") + 1);
                    result = new UICBSearchResults.ResultData(name, path);
                    temp.put(path, result);
                }
            }
            catch (Exception e) {
                return resultList;
            }
        }
        UISearchController uiController = (UISearchController)uiContainer.getChild(UISearchController.class);
        for (String s : temp.keySet()) {
            resultList.add((UICBSearchResults.ResultData)temp.get(s));
        }
        uiController.setSearchTime(this.duration_);
        uiController.setResultRecord(resultList.size());
        return resultList;
    }

    public void reset() {
        this.getUIStringInput(FIELD_SEARCHVALUE).setValue((Object)"");
        this.getUIFormSelectBox(FIELD_OPTION).setOptions(this.getOptions());
        this.getUIFormCheckBoxInput(FIELD_CB_REF).setRendered(this.isDocumentType);
        this.getUIFormCheckBoxInput(FIELD_CB_CHILD).setRendered(this.isDocumentType);
    }
}

