/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.sidebar;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeNode {
    private boolean isExpanded_;
    private Node node_;
    private List<TreeNode> children_ = new ArrayList();

    public TreeNode(Node node, List<Node> children) throws Exception {
        this.node_ = node;
        this.isExpanded_ = true;
        this.setChildren(children);
    }

    public TreeNode(Node node) {
        this.node_ = node;
        this.isExpanded_ = false;
    }

    public int getLevel() throws RepositoryException {
        return this.node_.getDepth();
    }

    public boolean isExpanded() {
        return this.isExpanded_;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded_ = isExpanded;
    }

    public String getName() throws RepositoryException {
        String path = this.node_.getPath();
        return path.substring(path.lastIndexOf("/") + 1, path.length());
    }

    public String getPath() throws RepositoryException {
        return this.node_.getPath();
    }

    public Node getNode() {
        return this.node_;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public List<TreeNode> getChildren() {
        return this.children_;
    }

    public int getChildrenSize() {
        return this.children_.size();
    }

    public TreeNode getChild(String relPath) throws RepositoryException {
        for (TreeNode child : this.children_) {
            if (!child.getNode().getPath().equals(relPath)) continue;
            return child;
        }
        return null;
    }

    public void setChildren(List<Node> children) throws Exception {
        this.setExpanded(true);
        for (Node child : children) {
            this.children_.add(new TreeNode(child));
        }
    }
}

