/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.fastcontentcreator;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeManager;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import org.exoplatform.ecm.jcr.UISelector;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.fastcontentcreator.UIEditModeConfiguration;
import org.exoplatform.ecm.webui.component.fastcontentcreator.UIFastContentCreatorPortlet;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={SelectPathActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeWorkspaceActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeRepositoryActionListener.class}, phase=Event.Phase.DECODE)})
public class UIEditModeConfiguration
extends UIForm
implements UISelector {
    public static final String FIELD_SELECT = "selectTemplate";
    public static final String FIELD_SAVEDPATH = "savedPath";
    public static final String ACTION_INPUT = "actionInput";
    public static final String WORKSPACE_NAME = "workspaceName";
    public static final String REPOSITORY_NAME = "repositoryName";
    public static final String DEFAULT_REPOSITORY = "repository";

    public UIEditModeConfiguration() throws Exception {
        ArrayList options = new ArrayList();
        UIFormSelectBox uiRepositoryList = new UIFormSelectBox(REPOSITORY_NAME, REPOSITORY_NAME, options);
        uiRepositoryList.setOnChange("ChangeRepository");
        this.addUIFormInput((UIFormInput)uiRepositoryList);
        UIFormSelectBox uiWorkspaceList = new UIFormSelectBox(WORKSPACE_NAME, WORKSPACE_NAME, options);
        uiWorkspaceList.setOnChange("ChangeWorkspace");
        this.addUIFormInput((UIFormInput)uiWorkspaceList);
        UIFormInputSetWithAction uiInputAct = new UIFormInputSetWithAction(ACTION_INPUT);
        uiInputAct.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_SAVEDPATH, FIELD_SAVEDPATH, null).setEditable(false));
        uiInputAct.setActionInfo(FIELD_SAVEDPATH, new String[]{"SelectPath"});
        this.addUIComponentInput((UIComponent)uiInputAct);
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_SELECT, FIELD_SELECT, options));
        this.setActions(new String[]{"Save"});
    }

    public void initEditMode() throws Exception {
        PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletRequest request = context.getRequest();
        PortletPreferences preferences = request.getPreferences();
        String repoName = preferences.getValue(Utils.REPOSITORY, "");
        boolean isDefaultWs = false;
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        ArrayList<SelectItemOption> repositories = new ArrayList<SelectItemOption>();
        for (RepositoryEntry re : rService.getConfig().getRepositoryConfigurations()) {
            repositories.add(new SelectItemOption(re.getName(), (Object)re.getName()));
        }
        UIFormSelectBox uiRepositoryList = this.getUIFormSelectBox(REPOSITORY_NAME);
        uiRepositoryList.setOptions(repositories);
        uiRepositoryList.setValue(repoName);
        try {
            ManageableRepository manaRepoService = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repoName);
            String[] wsNames = manaRepoService.getWorkspaceNames();
            String systemWsName = manaRepoService.getConfiguration().getSystemWorkspaceName();
            ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
            String prefWs = preferences.getValue("workspace", "");
            this.setTemplateOptions(preferences.getValue("path", ""), repoName, prefWs);
            for (String wsName : wsNames) {
                if (wsName.equals(systemWsName)) continue;
                if (wsName.equals(prefWs)) {
                    isDefaultWs = true;
                }
                workspace.add(new SelectItemOption(wsName, (Object)wsName));
            }
            UIFormSelectBox uiWorkspaceList = this.getUIFormSelectBox(WORKSPACE_NAME);
            uiWorkspaceList.setOptions(workspace);
            if (isDefaultWs) {
                uiWorkspaceList.setValue(prefWs);
            } else if (workspace.size() > 0) {
                uiWorkspaceList.setValue((String)((SelectItemOption)workspace.get(0)).getValue());
            }
            this.getUIStringInput(FIELD_SAVEDPATH).setValue((Object)preferences.getValue("path", ""));
        }
        catch (RepositoryException repo) {
            ResourceBundle res = context.getApplicationResourceBundle();
            String label = res.getString(this.getId() + ".label.select-repository");
            repositories.add(new SelectItemOption(label, (Object)""));
            uiRepositoryList.setValue("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTemplateOptions(String nodePath, String repoName, String wsName) throws Exception {
        try {
            Session session = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repoName).getSystemSession(wsName);
            Node currentNode = null;
            UIFormSelectBox uiSelectTemplate = this.getUIFormSelectBox(FIELD_SELECT);
            ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
            boolean hasDefaultDoc = false;
            PortletRequestContext context = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
            PortletRequest request = context.getRequest();
            PortletPreferences preferences = request.getPreferences();
            String defaultValue = preferences.getValue("type", "");
            try {
                currentNode = (Node)session.getItem(nodePath);
            }
            catch (PathNotFoundException ex) {
                UIApplication uiApp = (UIApplication)this.getAncestorOfType(UIApplication.class);
                uiApp.addMessage(new ApplicationMessage("UIEditModeConfiguration.msg.item-not-found", null, 1));
                return;
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
            NodeTypeManager ntManager = currentNode.getSession().getWorkspace().getNodeTypeManager();
            NodeType currentNodeType = currentNode.getPrimaryNodeType();
            NodeDefinition[] childDefs = currentNodeType.getChildNodeDefinitions();
            TemplateService templateService = (TemplateService)this.getApplicationComponent(TemplateService.class);
            List templates = templateService.getDocumentTemplates(repoName);
            ArrayList<String> labels = new ArrayList<String>();
            try {
                block9: for (int i = 0; i < templates.size(); ++i) {
                    String nodeTypeName = templates.get(i).toString();
                    NodeType nodeType = ntManager.getNodeType(nodeTypeName);
                    NodeType[] superTypes = nodeType.getSupertypes();
                    boolean isCanCreateDocument = false;
                    for (NodeDefinition nodeDefinition : childDefs) {
                        String label;
                        NodeType[] requiredChilds;
                        for (NodeType requiredChild : requiredChilds = nodeDefinition.getRequiredPrimaryTypes()) {
                            if (!nodeTypeName.equals(requiredChild.getName())) continue;
                            isCanCreateDocument = true;
                            break;
                        }
                        if (!nodeTypeName.equals(nodeDefinition.getName()) && !isCanCreateDocument) continue;
                        if (!hasDefaultDoc && nodeTypeName.equals(defaultValue)) {
                            hasDefaultDoc = true;
                        }
                        if (!labels.contains(label = templateService.getTemplateLabel(nodeTypeName, repoName))) {
                            options.add(new SelectItemOption(label, (Object)nodeTypeName));
                        }
                        labels.add(label);
                        isCanCreateDocument = true;
                    }
                    if (isCanCreateDocument) continue;
                    for (NodeDefinition nodeDefinition : superTypes) {
                        for (NodeDefinition childDef : childDefs) {
                            for (NodeType requiredType : childDef.getRequiredPrimaryTypes()) {
                                String label;
                                if (!nodeDefinition.getName().equals(requiredType.getName())) continue;
                                if (!hasDefaultDoc && nodeTypeName.equals(defaultValue)) {
                                    hasDefaultDoc = true;
                                }
                                if (!labels.contains(label = templateService.getTemplateLabel(nodeTypeName, repoName))) {
                                    options.add(new SelectItemOption(label, (Object)nodeTypeName));
                                }
                                labels.add(label);
                                isCanCreateDocument = true;
                                break;
                            }
                            if (isCanCreateDocument) break;
                        }
                        if (isCanCreateDocument) continue block9;
                    }
                }
                uiSelectTemplate.setOptions(options);
                if (hasDefaultDoc) {
                    uiSelectTemplate.setValue(defaultValue);
                } else if (options.size() > 0) {
                    defaultValue = (String)((SelectItemOption)options.get(0)).getValue();
                    uiSelectTemplate.setValue(defaultValue);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            session.logout();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateSelect(String selectField, String value) {
        this.getUIStringInput(selectField).setValue((Object)value);
        String repoName = (String)this.getUIFormSelectBox(REPOSITORY_NAME).getValue();
        String wsName = (String)this.getUIFormSelectBox(WORKSPACE_NAME).getValue();
        try {
            this.setTemplateOptions(value, repoName, wsName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        UIFastContentCreatorPortlet uiDialog = (UIFastContentCreatorPortlet)this.getParent();
        UIPopupWindow uiPopup = (UIPopupWindow)uiDialog.getChild(UIPopupWindow.class);
        uiPopup.setRendered(false);
        uiPopup.setShow(false);
    }

    static /* synthetic */ void access$000(UIEditModeConfiguration x0, String x1, String x2, String x3) throws Exception {
        x0.setTemplateOptions(x1, x2, x3);
    }
}

