/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component;

import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.jcr.CronExpressionValidator;
import org.exoplatform.ecm.jcr.ECMNameValidator;
import org.exoplatform.ecm.jcr.RepeatCountValidator;
import org.exoplatform.ecm.jcr.RepeatIntervalValidator;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.services.cms.JcrInputProperty;
import org.exoplatform.services.cms.scripts.CmsScript;
import org.exoplatform.services.cms.scripts.ScriptService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormMultiValueInputSet;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;
import org.exoplatform.webui.form.UIFormUploadInput;
import org.exoplatform.webui.form.UIFormWYSIWYGInput;
import org.exoplatform.webui.form.validator.DateTimeValidator;
import org.exoplatform.webui.form.validator.EmailAddressValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.NumberFormatValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogFormFields
extends UIForm {
    public Map<String, Map> components = new HashMap();
    public Map<String, String> propertiesName_ = new HashMap();
    public Map<String, String> fieldNames_ = new HashMap();
    private boolean isNotEditNode_ = false;
    private boolean isNTFile_ = false;
    private boolean isResetMultiField_ = false;
    private boolean isOnchange_ = false;
    protected boolean isUpdateSelect_ = false;
    private boolean isResetForm_ = false;
    protected boolean isRemovePreference_ = false;
    private String workspaceName_ = null;
    private String storedPath_ = null;
    protected String repositoryName_ = null;
    private String nodePath_;
    private String childPath_;
    private String rootPath_;
    protected boolean isShowingComponent_ = false;
    private List<String> prevScriptInterceptor_ = new ArrayList();
    private List<String> postScriptInterceptor_ = new ArrayList();
    private static final String SEPARATOR = "=";
    private static final String JCR_PATH = "jcrPath=";
    private static final String EDITABLE = "editable=";
    private static final String ONCHANGE = "onchange=";
    private static final String OPTIONS = "options=";
    private static final String TYPE = "type=";
    private static final String VISIBLE = "visible=";
    private static final String NODETYPE = "nodetype=";
    private static final String MIXINTYPE = "mixintype=";
    private static final String VALIDATE = "validate=";
    private static final String SELECTOR_ACTION = "selectorAction=";
    private static final String SELECTOR_CLASS = "selectorClass=";
    private static final String SELECTOR_ICON = "selectorIcon=";
    private static final String SELECTOR_PARAMS = "selectorParams=";
    private static final String WORKSPACE_FIELD = "workspaceField=";
    private static final String SCRIPT = "script=";
    private static final String SCRIPT_PARAMS = "scriptParams=";
    private static final String MULTI_VALUES = "multiValues=";
    private static final String REPOSITORY = "repository";
    private static final String ROOTPATH = "rootPath=";
    public static final String[] ACTIONS = new String[]{"Save", "Cancel"};
    protected Map<String, Object> properties = new HashMap();

    public Node getNode() throws Exception {
        if (this.nodePath_ == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.nodePath_);
    }

    public void setNodePath(String nodePath) {
        this.nodePath_ = nodePath;
    }

    public Session getSesssion() throws Exception {
        return SessionsUtils.getSessionProvider().getSession(this.workspaceName_, this.getRepository());
    }

    private ManageableRepository getRepository() throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(this.repositoryName_);
    }

    public void setRootPath(String rootPath) {
        this.rootPath_ = rootPath;
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setChildPath(String childPath) {
        this.childPath_ = childPath;
    }

    public Node getChildNode() throws Exception {
        if (this.childPath_ == null) {
            return null;
        }
        return (Node)this.getSesssion().getItem(this.childPath_);
    }

    public void setInputProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    public Object getInputProperty(String name) {
        return this.properties.get(name);
    }

    public Map<String, Object> getInputProperties() {
        return this.properties;
    }

    public void resetProperties() {
        this.properties.clear();
    }

    public void setIsResetMultiField(boolean isResetMultiField) {
        this.isResetMultiField_ = isResetMultiField;
    }

    public void setIsResetForm(boolean isResetForm) {
        this.isResetForm_ = isResetForm;
    }

    public boolean isResetForm() {
        return this.isResetForm_;
    }

    public void setIsUpdateSelect(boolean isUpdateSelect) {
        this.isUpdateSelect_ = isUpdateSelect;
    }

    public void setIsOnchange(boolean isOnchange) {
        this.isOnchange_ = isOnchange;
    }

    public void setIsNotEditNode(boolean isNotEditNode) {
        this.isNotEditNode_ = isNotEditNode;
    }

    public void setIsNTFile(boolean isNTFile) {
        this.isNTFile_ = isNTFile;
    }

    public void setWorkspace(String workspace) {
        this.workspaceName_ = workspace;
    }

    public void setStoredPath(String storedPath) {
        this.storedPath_ = storedPath;
    }

    public String getPropertyName(String jcrPath) {
        return jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName_ = repositoryName;
    }

    public void resetScriptInterceptor() {
        this.prevScriptInterceptor_.clear();
        this.postScriptInterceptor_.clear();
    }

    private String getPropertyValue(String jcrPath) throws Exception {
        if (jcrPath.equals("/node") && this.getNode() != null) {
            return this.getNode().getName();
        }
        if (this.getChildNode().hasProperty(this.getPropertyName(jcrPath))) {
            int valueType = this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getType();
            switch (valueType) {
                case 1: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getString();
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return Long.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getLong());
                }
                case 4: {
                    return Double.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getDouble());
                }
                case 5: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getDate().getTime().toString();
                }
                case 6: {
                    return Boolean.toString(this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getBoolean());
                }
                case 7: {
                    return this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getName();
                }
                case 0: 
                case 8: 
                case 9: {
                    return "";
                }
            }
        }
        return "";
    }

    private List<String> getPropertyValues(String jcrPath, Node node) throws Exception {
        String propertyName = this.getPropertyName(jcrPath);
        if (node == null || !node.hasProperty(propertyName)) {
            return null;
        }
        Property property = node.getProperty(propertyName);
        int valueType = property.getType();
        boolean isMultiple = property.getDefinition().isMultiple();
        if (!isMultiple) {
            return null;
        }
        Value[] values = property.getValues();
        ArrayList<String> convertedValues = new ArrayList<String>();
        switch (valueType) {
            case 1: {
                for (Value value : values) {
                    convertedValues.add(value.getString());
                }
                break;
            }
            case 3: {
                for (Value value : values) {
                    convertedValues.add(Long.toString(value.getLong()));
                }
                break;
            }
            case 4: {
                for (Value value : values) {
                    convertedValues.add(Double.toString(value.getDouble()));
                }
                break;
            }
            case 5: {
                for (Value value : values) {
                    convertedValues.add(value.getDate().toString());
                }
                break;
            }
            case 6: {
                for (Value value : values) {
                    convertedValues.add(Boolean.toString(value.getBoolean()));
                }
                break;
            }
            case 9: {
                Session session = node.getSession();
                for (Value value : values) {
                    try {
                        String nodePath = session.getNodeByUUID(value.getString()).getPath();
                        convertedValues.add(nodePath.substring(1));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                break;
            }
        }
        return convertedValues;
    }

    private String getNodePathByUUID(String uuid) throws Exception {
        String[] workspaces = this.getRepository().getWorkspaceNames();
        Node node = null;
        for (String ws : workspaces) {
            try {
                node = SessionsUtils.getSystemProvider().getSession(ws, this.getRepository()).getNodeByUUID(uuid);
                return ws + ":" + node.getPath();
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public void addActionField(String name, String[] arguments) throws Exception {
        this.addActionField(name, null, arguments);
    }

    public void addActionField(String name, String label, String[] arguments) throws Exception {
        String editable = "true";
        String defaultValue = "";
        String jcrPath = null;
        String selectorAction = null;
        String selectorClass = null;
        String[] selectorParams = null;
        String workspaceField = null;
        String selectorIcon = null;
        String multiValues = null;
        String validateType = null;
        String params = null;
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_ACTION)) {
                selectorAction = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_CLASS)) {
                selectorClass = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_ICON)) {
                selectorIcon = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_PARAMS)) {
                params = argument.substring(argument.indexOf(SEPARATOR) + 1);
                selectorParams = StringUtils.split((String)params, (String)",");
                continue;
            }
            if (argument.startsWith(WORKSPACE_FIELD)) {
                workspaceField = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VALIDATE)) {
                validateType = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        if (selectorClass != null) {
            HashMap<String, String> fieldPropertiesMap = new HashMap<String, String>();
            fieldPropertiesMap.put("selectorClass", selectorClass);
            fieldPropertiesMap.put("returnField", name);
            fieldPropertiesMap.put("selectorIcon", selectorIcon);
            fieldPropertiesMap.put("workspaceField", workspaceField);
            if (rootPath != null) {
                fieldPropertiesMap.put("rootPath", rootPath);
            }
            if (params != null) {
                fieldPropertiesMap.put("selectorParams", params);
            }
            this.components.put(name, fieldPropertiesMap);
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormStringInput.class);
            List values = this.getPropertyValues(jcrPath, this.getNode());
            if (values != null) {
                uiMulti.setValue(values);
            }
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = new UIFormStringInput(name, name, defaultValue);
            if (validateType != null) {
                if (validateType.equals("name")) {
                    uiInput.addValidator(ECMNameValidator.class, new Object[0]);
                } else if (validateType.equals("email")) {
                    uiInput.addValidator(EmailAddressValidator.class, new Object[0]);
                } else if (validateType.equals("number")) {
                    uiInput.addValidator(NumberFormatValidator.class, new Object[0]);
                } else if (validateType.equals("empty")) {
                    uiInput.addValidator(MandatoryValidator.class, new Object[0]);
                }
            }
            if (label != null && label.length() != 0) {
                uiInput.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiInput);
        }
        if (editable.equals("false")) {
            uiInput.setEditable(false);
        } else {
            uiInput.setEditable(true);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.properties.put(name, inputProperty);
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null && !this.isRemovePreference_) {
            if (jcrPath.equals("/node") && (editable.equals("false") || editable.equals("if-null"))) {
                uiInput.setValue((Object)this.getNode().getName());
                uiInput.setEditable(false);
            } else if (this.getNode().hasProperty(this.getPropertyName(jcrPath)) && !this.isUpdateSelect_) {
                if (this.getNode().getProperty(this.getPropertyName(jcrPath)).getDefinition().getRequiredType() == 9) {
                    String path = this.getNodePathByUUID(this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
                    uiInput.setValue((Object)path);
                } else {
                    uiInput.setValue((Object)this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
                }
            }
        }
        if (this.isNotEditNode_ && !this.isRemovePreference_) {
            if (this.getChildNode() != null) {
                uiInput.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiInput.setValue((Object)this.getNode().getName());
            } else {
                uiInput.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addTextField(String name, String[] arguments) throws Exception {
        this.addTextField(name, null, arguments);
    }

    public void addTextField(String name, String label, String[] arguments) throws Exception {
        String editable = "true";
        String type = "text";
        String defaultValue = "";
        String jcrPath = null;
        String mixintype = null;
        String multiValues = null;
        String validateType = null;
        String nodetype = null;
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(TYPE)) {
                type = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MIXINTYPE)) {
                mixintype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VALIDATE)) {
                validateType = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(NODETYPE)) {
                nodetype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        String propertyName = this.getPropertyName(jcrPath);
        if (mixintype != null) {
            inputProperty.setMixintype(mixintype);
        }
        if (jcrPath.equals("/node") && nodetype != null) {
            inputProperty.setNodetype(nodetype);
        }
        this.properties.put(name, inputProperty);
        this.propertiesName_.put(name, propertyName);
        this.fieldNames_.put(propertyName, name);
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti;
            if (this.getNode() == null && this.getChildNode() == null) {
                uiMulti = (UIFormMultiValueInputSet)this.findComponentById(name);
                if (uiMulti == null) {
                    uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                    uiMulti.setId(name);
                    uiMulti.setName(name);
                    uiMulti.setType(UIFormStringInput.class);
                    uiMulti.setValue(new ArrayList());
                    this.addUIFormInput((UIFormInput)uiMulti);
                }
            } else {
                uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
                uiMulti.setId(name);
                uiMulti.setName(name);
                uiMulti.setType(UIFormStringInput.class);
                this.addUIFormInput((UIFormInput)uiMulti);
            }
            ArrayList<String> valueList = new ArrayList<String>();
            if (this.getChildNode() != null && this.getChildNode().hasProperty(this.getPropertyName(jcrPath))) {
                Value[] values;
                for (Value value : values = this.getChildNode().getProperty(this.getPropertyName(jcrPath)).getValues()) {
                    valueList.add(value.getString());
                }
                uiMulti.setValue(valueList);
            }
            if (this.getNode() != null) {
                String propertyPath = jcrPath.substring("/node/".length());
                if (this.getNode().hasProperty(propertyPath)) {
                    Value[] values;
                    for (Value vl : values = this.getNode().getProperty(propertyPath).getValues()) {
                        if (vl == null) continue;
                        valueList.add(vl.getString());
                    }
                }
                uiMulti.setValue(valueList);
            }
            if (this.isResetMultiField_) {
                uiMulti.setValue(new ArrayList());
            }
            this.renderField(name);
            return;
        }
        UIFormStringInput uiInput = (UIFormStringInput)this.findComponentById(name);
        if (uiInput == null) {
            uiInput = new UIFormStringInput(name, name, defaultValue);
            if (validateType != null) {
                if (validateType.equals("name")) {
                    uiInput.addValidator(ECMNameValidator.class, new Object[0]);
                } else if (validateType.equals("email")) {
                    uiInput.addValidator(EmailAddressValidator.class, new Object[0]);
                } else if (validateType.equals("number")) {
                    uiInput.addValidator(NumberFormatValidator.class, new Object[0]);
                } else if (validateType.equals("empty")) {
                    uiInput.addValidator(MandatoryValidator.class, new Object[0]);
                } else if (validateType.equals("cronExpressionValidator")) {
                    uiInput.addValidator(CronExpressionValidator.class, new Object[0]);
                } else if (validateType.equals("repeatCountValidator")) {
                    uiInput.addValidator(RepeatCountValidator.class, new Object[0]);
                } else if (validateType.equals("repeatIntervalValidator")) {
                    uiInput.addValidator(RepeatIntervalValidator.class, new Object[0]);
                }
            }
            if (label != null && label.length() != 0) {
                uiInput.setLabel(label);
            }
            this.addUIFormInput((UIFormInput)uiInput);
        }
        if (uiInput.getValue() == null) {
            uiInput.setValue((Object)defaultValue);
        }
        if (type.equals("password")) {
            uiInput.setType((short)1);
        }
        if (editable.equals("false")) {
            uiInput.setEditable(false);
        } else {
            uiInput.setEditable(true);
        }
        if (this.getNode() != null && !this.isShowingComponent_ && !this.isRemovePreference_) {
            String[] arrNodes = jcrPath.split("/");
            if (arrNodes.length == 4) {
                Node childNode = null;
                childNode = this.getNode().getNode(arrNodes[2]);
                if (childNode != null) {
                    uiInput.setValue((Object)childNode.getProperty(propertyName).getValue().getString());
                }
            } else if (jcrPath.equals("/node") && (editable.equals("false") || editable.equals("if-null"))) {
                Node parentNode = this.getNode().getParent();
                if (parentNode != null && parentNode.getName().equals("languages")) {
                    uiInput.setValue((Object)this.getNode().getParent().getParent().getName());
                } else {
                    String nameValue = this.getNode().getPath().substring(this.getNode().getPath().lastIndexOf("/") + 1);
                    uiInput.setValue((Object)nameValue);
                }
                uiInput.setEditable(false);
            } else if (this.getNode().hasProperty(propertyName)) {
                uiInput.setValue((Object)this.getNode().getProperty(propertyName).getValue().getString());
            }
        }
        if (this.isNotEditNode_ && !this.isShowingComponent_ && !this.isRemovePreference_) {
            if (this.getChildNode() != null) {
                uiInput.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiInput.setValue((Object)this.getNode().getName());
            } else {
                uiInput.setValue((Object)defaultValue);
            }
        }
        this.renderField(name);
    }

    public void addTextAreaField(String name, String[] arguments) throws Exception {
        this.addTextAreaField(name, null, arguments);
    }

    public void addTextAreaField(String name, String label, String[] arguments) throws Exception {
        String editable = "true";
        String defaultValue = "";
        String jcrPath = null;
        String selectorAction = null;
        String selectorClass = null;
        String multiValues = null;
        String validateType = null;
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_ACTION)) {
                selectorAction = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SELECTOR_CLASS)) {
                selectorClass = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VALIDATE)) {
                validateType = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        if (selectorClass != null) {
            HashMap<String, String> fieldPropertiesMap = new HashMap<String, String>();
            fieldPropertiesMap.put("selectorClass", selectorClass);
            fieldPropertiesMap.put("returnField", name);
            this.components.put(name, fieldPropertiesMap);
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormTextAreaInput.class);
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        UIFormTextAreaInput uiTextArea = (UIFormTextAreaInput)this.findComponentById(name);
        if (uiTextArea == null) {
            uiTextArea = new UIFormTextAreaInput(name, name, defaultValue);
            if (validateType != null && validateType.equals("empty")) {
                uiTextArea.addValidator(MandatoryValidator.class, new Object[0]);
            }
            this.addUIFormInput((UIFormInput)uiTextArea);
        }
        if (uiTextArea.getValue() == null) {
            uiTextArea.setValue((Object)defaultValue);
        }
        if (editable.equals("false")) {
            uiTextArea.setEditable(false);
        } else {
            uiTextArea.setEditable(true);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null && !this.isShowingComponent_ && !this.isRemovePreference_) {
            Node jcrContentNode;
            String value = "";
            if (this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
                value = this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString();
            } else if (this.getNode().isNodeType("nt:file") && (jcrContentNode = this.getNode().getNode("jcr:content")).hasProperty(this.getPropertyName(jcrPath))) {
                if (jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getDefinition().isMultiple()) {
                    Value[] values;
                    for (Value v : values = jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getValues()) {
                        value = value + v.getString();
                    }
                } else {
                    value = jcrContentNode.getProperty(this.getPropertyName(jcrPath)).getValue().getString();
                }
            }
            uiTextArea.setValue((Object)value);
        }
        if (this.isNotEditNode_ && !this.isShowingComponent_ && !this.isRemovePreference_) {
            if (this.getChildNode() != null) {
                uiTextArea.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiTextArea.setValue((Object)this.getNode().getName());
            } else {
                uiTextArea.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addWYSIWYGField(String name, String[] arguments) throws Exception {
        this.addWYSIWYGField(name, null, arguments);
    }

    public void addWYSIWYGField(String name, String label, String[] arguments) throws Exception {
        Node jcrContentNode;
        UIFormWYSIWYGInput wysiwyg;
        String options = null;
        String defaultValue = "";
        String jcrPath = null;
        boolean isBasic = false;
        String multiValues = null;
        String validateType = null;
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(OPTIONS)) {
                options = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VALIDATE)) {
                validateType = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormWYSIWYGInput.class);
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        if (options != null) {
            isBasic = options.equals("basic");
        }
        if ((wysiwyg = (UIFormWYSIWYGInput)this.findComponentById(name)) == null) {
            wysiwyg = new UIFormWYSIWYGInput(name, name, defaultValue, isBasic);
            if (validateType != null && validateType.equals("empty")) {
                wysiwyg.addValidator(MandatoryValidator.class, new Object[0]);
            }
            this.addUIFormInput((UIFormInput)wysiwyg);
        }
        if (wysiwyg.getValue() == null) {
            wysiwyg.setValue((Object)defaultValue);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (!this.isShowingComponent_ && !this.isRemovePreference_) {
            if (this.getNode() != null && (this.getNode().isNodeType("nt:file") || this.isNTFile_)) {
                jcrContentNode = this.getNode().getNode("jcr:content");
                wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
                wysiwyg.setValue((Object)this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
            }
        }
        if (this.isNotEditNode_ && !this.isShowingComponent_ && !this.isRemovePreference_) {
            if (this.getNode() != null && this.getNode().hasNode("jcr:content") && this.getChildNode() != null) {
                jcrContentNode = this.getNode().getNode("jcr:content");
                wysiwyg.setValue((Object)jcrContentNode.getProperty("jcr:data").getValue().getString());
            } else if (this.getChildNode() != null) {
                wysiwyg.setValue((Object)this.getPropertyValue(jcrPath));
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                wysiwyg.setValue((Object)this.getNode().getName());
            } else {
                wysiwyg.setValue(null);
            }
        }
        this.renderField(name);
    }

    public void addSelectBoxField(String name, String[] arguments) throws Exception {
        String jcrPath = null;
        String editable = "true";
        String onchange = "false";
        String defaultValue = "";
        String options = null;
        String script = null;
        String[] scriptParams = null;
        String multiValues = null;
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(OPTIONS)) {
                options = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SCRIPT)) {
                script = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(SCRIPT_PARAMS)) {
                String params = argument.substring(argument.indexOf(SEPARATOR) + 1);
                scriptParams = StringUtils.split((String)params, (String)",");
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ONCHANGE)) {
                onchange = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormSelectBox.class);
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        ArrayList<SelectItemOption> optionsList = new ArrayList<SelectItemOption>();
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox == null || this.isResetForm_) {
            uiSelectBox = new UIFormSelectBox(name, name, null);
            this.addUIFormInput((UIFormInput)uiSelectBox);
            if (script != null) {
                try {
                    if (scriptParams[0].equals(REPOSITORY)) {
                        scriptParams[0] = this.repositoryName_;
                    }
                    this.executeScript(script, (Object)uiSelectBox, scriptParams);
                }
                catch (Exception e) {
                    uiSelectBox.setOptions(optionsList);
                }
            } else if (options != null && options.length() > 0) {
                String[] array = options.split(",");
                for (int i = 0; i < array.length; ++i) {
                    optionsList.add(new SelectItemOption(array[i].trim(), (Object)array[i].trim()));
                }
                uiSelectBox.setOptions(optionsList);
            } else {
                uiSelectBox.setOptions(optionsList);
            }
            if (defaultValue != null) {
                uiSelectBox.setValue(defaultValue);
            }
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        String[] arrNodes = jcrPath.split("/");
        Node childNode = null;
        if (this.getNode() != null && arrNodes.length == 4) {
            childNode = this.getNode().getNode(arrNodes[2]);
        }
        if (childNode != null) {
            uiSelectBox.setValue(childNode.getProperty(this.getPropertyName(jcrPath)).getValue().getString());
        } else if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath))) {
            if (this.getNode().getProperty(this.getPropertyName(jcrPath)).getDefinition().isMultiple()) {
                uiSelectBox.setValue(this.getNode().getProperty(this.getPropertyName(jcrPath)).getValues().toString());
            } else if (onchange.equals("true") && this.isOnchange_) {
                uiSelectBox.setValue((String)uiSelectBox.getValue());
            } else {
                uiSelectBox.setValue(this.getNode().getProperty(this.getPropertyName(jcrPath)).getValue().getString());
            }
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        if (editable.equals("false")) {
            uiSelectBox.setDisabled(false);
        } else {
            uiSelectBox.setEditable(true);
        }
        this.addUIFormInput((UIFormInput)uiSelectBox);
        if (this.isNotEditNode_ && this.getChildNode() != null) {
            uiSelectBox.setValue(this.getPropertyValue(jcrPath));
        }
        if (onchange.equals("true")) {
            uiSelectBox.setOnChange("Onchange");
        }
        this.renderField(name);
    }

    public String getSelectBoxFieldValue(String name) {
        UIFormSelectBox uiSelectBox = (UIFormSelectBox)this.findComponentById(name);
        if (uiSelectBox != null) {
            return (String)uiSelectBox.getValue();
        }
        return null;
    }

    public void addUploadField(String name, String[] arguments) throws Exception {
        String jcrPath = null;
        String multiValues = null;
        for (String argument : arguments) {
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (!argument.startsWith(MULTI_VALUES)) continue;
            multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        this.setMultiPart(true);
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormUploadInput.class);
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        UIFormUploadInput uiInputUpload = (UIFormUploadInput)this.findComponentById(name);
        if (uiInputUpload == null) {
            uiInputUpload = new UIFormUploadInput(name, name);
            this.addUIFormInput((UIFormInput)uiInputUpload);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        this.renderField(name);
    }

    public void addMixinField(String name, String[] arguments) throws Exception {
        String jcrPath = null;
        String nodetype = null;
        String mixintype = null;
        String defaultValue = "";
        String editable = "true";
        String visible = "true";
        String rootPath = null;
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(NODETYPE)) {
                nodetype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MIXINTYPE)) {
                mixintype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VISIBLE)) {
                visible = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, (Object)inputProperty);
        if (this.getNode() != null && visible.equals("if-not-null")) {
            UIFormStringInput uiMixin = (UIFormStringInput)this.findComponentById(name);
            if (uiMixin == null) {
                uiMixin = new UIFormStringInput(name, name, defaultValue);
                this.addUIFormInput((UIFormInput)uiMixin);
            }
            uiMixin.setValue((Object)this.getNode().getName());
            uiMixin.setEditable(false);
            this.renderField(name);
        }
    }

    public void addCalendarField(String name, String[] arguments) throws Exception {
        String jcrPath = null;
        String options = null;
        String defaultValue = "";
        String[] arrDate = null;
        String multiValues = null;
        String visible = "true";
        String validateType = null;
        String rootPath = null;
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        for (int i = 0; i < arguments.length; ++i) {
            String argument = arguments[i];
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(OPTIONS)) {
                options = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VISIBLE)) {
                visible = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MULTI_VALUES)) {
                multiValues = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VALIDATE)) {
                validateType = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        this.setInputProperty(name, (Object)inputProperty);
        Date date = new Date();
        if (options == null) {
            formatter = new SimpleDateFormat("MM/dd/yyyy");
        }
        if (defaultValue.length() > 0) {
            try {
                date = formatter.parse(defaultValue);
                if (defaultValue.indexOf("/") > -1) {
                    arrDate = defaultValue.split("/");
                }
                String[] arrDf = formatter.format(date).split("/");
                if (Integer.parseInt(arrDate[0]) != Integer.parseInt(arrDf[0])) {
                    date = new Date();
                }
            }
            catch (Exception e) {
                date = new Date();
            }
        }
        if (multiValues != null && multiValues.equals("true")) {
            UIFormMultiValueInputSet uiMulti = (UIFormMultiValueInputSet)this.createUIComponent(UIFormMultiValueInputSet.class, null, null);
            uiMulti.setId(name);
            uiMulti.setName(name);
            uiMulti.setType(UIFormDateTimeInput.class);
            this.addUIFormInput((UIFormInput)uiMulti);
            this.renderField(name);
            return;
        }
        UIFormDateTimeInput uiDateTime = (UIFormDateTimeInput)this.findComponentById(name);
        if (uiDateTime == null) {
            uiDateTime = options != null && options.equals("displaytime") ? new UIFormDateTimeInput(name, name, date) : new UIFormDateTimeInput(name, name, date, false);
            this.addUIFormInput((UIFormInput)uiDateTime);
        }
        if (options != null && options.equals("displaytime")) {
            uiDateTime.setDisplayTime(true);
        } else {
            uiDateTime.setDisplayTime(false);
        }
        if (validateType != null && validateType.equals("datetime")) {
            uiDateTime.addValidator(DateTimeValidator.class, new Object[0]);
        }
        this.propertiesName_.put(name, this.getPropertyName(jcrPath));
        this.fieldNames_.put(this.getPropertyName(jcrPath), name);
        if (this.getNode() != null && this.getNode().hasProperty(this.getPropertyName(jcrPath)) && !this.isShowingComponent_ && !this.isRemovePreference_) {
            uiDateTime.setCalendar(this.getNode().getProperty(this.getPropertyName(jcrPath)).getDate());
        }
        if (this.isNotEditNode_ && !this.isShowingComponent_ && !this.isRemovePreference_) {
            if (this.getChildNode() != null) {
                String propertyName = jcrPath.substring(jcrPath.lastIndexOf("/") + 1);
                if (this.getChildNode().hasProperty(propertyName)) {
                    if (this.getChildNode().getProperty(propertyName).getDefinition().isMultiple()) {
                        Value[] values;
                        for (Value value : values = this.getChildNode().getProperty(propertyName).getValues()) {
                            uiDateTime.setCalendar(value.getDate());
                        }
                    } else {
                        uiDateTime.setCalendar(this.getChildNode().getProperty(propertyName).getValue().getDate());
                    }
                }
            } else if (this.getChildNode() == null && jcrPath.equals("/node") && this.getNode() != null) {
                uiDateTime.setCalendar(this.getNode().getProperty(this.getPropertyName(jcrPath)).getDate());
            } else {
                uiDateTime.setCalendar((Calendar)new GregorianCalendar());
            }
        }
        if (!visible.equals("false")) {
            this.renderField(name);
        }
    }

    public void addHiddenField(String name, String[] arguments) throws Exception {
        String jcrPath = null;
        String nodetype = null;
        String mixintype = null;
        String defaultValue = "";
        String editable = "true";
        String visible = "true";
        String rootPath = null;
        for (String argument : arguments) {
            if (argument.startsWith(JCR_PATH)) {
                jcrPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(NODETYPE)) {
                nodetype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(MIXINTYPE)) {
                mixintype = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(VISIBLE)) {
                visible = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(EDITABLE)) {
                editable = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            if (argument.startsWith(ROOTPATH)) {
                rootPath = argument.substring(argument.indexOf(SEPARATOR) + 1);
                continue;
            }
            defaultValue = argument;
        }
        JcrInputProperty inputProperty = new JcrInputProperty();
        inputProperty.setJcrPath(jcrPath);
        if (defaultValue.length() > 0) {
            inputProperty.setValue((Object)defaultValue);
        }
        if (nodetype != null || mixintype != null) {
            inputProperty.setType(1);
            if (nodetype != null) {
                inputProperty.setNodetype(nodetype);
            }
            if (mixintype != null) {
                inputProperty.setMixintype(mixintype);
            }
        }
        this.setInputProperty(name, (Object)inputProperty);
    }

    public void addInterceptor(String scriptPath, String type) {
        if (scriptPath.length() > 0 && type.length() > 0) {
            if (type.equals("prev")) {
                this.prevScriptInterceptor_.add(scriptPath + ";" + type);
            } else if (type.equals("post")) {
                this.postScriptInterceptor_.add(scriptPath + ";" + type);
            }
        }
    }

    private void executeScript(String script, Object o, String[] params) throws Exception {
        ScriptService scriptService = (ScriptService)this.getApplicationComponent(ScriptService.class);
        try {
            CmsScript dialogScript = scriptService.getScript(script, this.repositoryName_);
            if (params != null) {
                if (params.equals(REPOSITORY)) {
                    params = new String[]{this.repositoryName_};
                }
                dialogScript.setParams(params);
            }
            dialogScript.execute(o);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void renderField(String name) throws Exception {
        UIComponent uiInput = this.findComponentById(name);
        WebuiRequestContext context = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        Writer w = context.getWriter();
        uiInput.processRender(context);
        if (this.components.get(name) != null) {
            Map fieldPropertiesMap = (Map)this.components.get(name);
            String fieldName = (String)fieldPropertiesMap.get("returnField");
            String iconClass = "Add16x16Icon";
            if (fieldPropertiesMap.get("selectorIcon") != null) {
                iconClass = (String)fieldPropertiesMap.get("selectorIcon");
            }
            if (name.equals(fieldName)) {
                w.write("<a style=\"cursor:pointer;\" onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + this.getId() + "','ShowComponent','&objectId=" + fieldName + "' )\"><img class='ActionIcon " + iconClass + "' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
                w.write("<a style=\"cursor:pointer;\" onclick=\"javascript:eXo.webui.UIForm.submitEvent('" + this.getId() + "','RemoveReference','&objectId=" + fieldName + "' )\"><img class='ActionIcon Remove16x16Icon' src=\"/eXoResources/skin/DefaultSkin/background/Blank.gif\" /></a>");
            }
        }
    }

    public Node storeValue(Event event) throws Exception {
        return null;
    }

    public void onchange(Event event) throws Exception {
    }

    public void removeComponent(String name) {
        if (!this.properties.isEmpty() && this.properties.containsKey(name)) {
            this.properties.remove(name);
            String jcrPath = (String)this.propertiesName_.get(name);
            this.propertiesName_.remove(name);
            this.fieldNames_.remove(jcrPath);
            this.removeChildById(name);
        }
    }

    static /* synthetic */ String access$000(DialogFormFields x0) {
        return x0.storedPath_;
    }

    static /* synthetic */ String access$100(DialogFormFields x0) {
        return x0.workspaceName_;
    }

    static /* synthetic */ List access$200(DialogFormFields x0) {
        return x0.prevScriptInterceptor_;
    }

    static /* synthetic */ void access$300(DialogFormFields x0, String x1, Object x2, String[] x3) throws Exception {
        x0.executeScript(x1, x2, x3);
    }

    static /* synthetic */ List access$400(DialogFormFields x0) {
        return x0.postScriptInterceptor_;
    }

    static /* synthetic */ boolean access$502(DialogFormFields x0, boolean x1) {
        x0.isOnchange_ = x1;
        return x0.isOnchange_;
    }
}

