/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component;

import java.util.ArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.ecm.utils.SessionsUtils;
import org.exoplatform.ecm.utils.Utils;
import org.exoplatform.ecm.webui.component.UIJCRBrowser;
import org.exoplatform.ecm.webui.component.UITreeJCRExplorer;
import org.exoplatform.ecm.webui.component.UITreeList;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UITree;

@ComponentConfig(template="app:/groovy/webui/component/UITreeJCRExplorer.gtmpl", events={@EventConfig(listeners={ChangeNodeActionListener.class})})
public class UITreeJCRExplorer
extends UIContainer {
    private Node currentNode_;
    private Node rootNode_ = null;
    private boolean isTab_ = false;
    private String rootPath_;

    public UITreeJCRExplorer() throws Exception {
        UITree tree = (UITree)this.addChild(UITree.class, null, null);
        tree.setBeanLabelField("name");
        tree.setBeanIdField("path");
        tree.setIcon("nt_unstructured16x16Icon");
        tree.setSelectedIcon("nt_unstructured16x16Icon");
    }

    public void setRootNode(Node rootNode) {
        this.rootNode_ = rootNode;
    }

    public void buildTree() throws Exception {
        UIJCRBrowser uiJCRBrowser = (UIJCRBrowser)this.getParent();
        String workspace = uiJCRBrowser.getWorkspace();
        String repositoryName = uiJCRBrowser.getRepository();
        Session session = SessionsUtils.getSessionProvider().getSession(workspace, this.getRepository(repositoryName));
        NodeIterator sibbling = null;
        NodeIterator children = null;
        if (this.rootNode_ == null) {
            this.currentNode_ = this.rootNode_ = session.getRootNode();
            children = this.rootNode_.getNodes();
            this.changeNode(this.rootNode_);
        }
        UITree tree = (UITree)this.getChild(UITree.class);
        Node nodeSelected = this.getSelectedNode();
        if (!this.rootNode_.getPath().equals("/") && nodeSelected.getPath().equals(this.rootNode_.getParent().getPath())) {
            nodeSelected = this.rootNode_;
        }
        if (nodeSelected.getPath().equals("/")) {
            nodeSelected = session.getRootNode();
            children = nodeSelected.getNodes();
        }
        tree.setSelected((Object)nodeSelected);
        if (nodeSelected.getDepth() > 0) {
            tree.setParentSelected((Object)nodeSelected.getParent());
            sibbling = nodeSelected.getParent().getNodes();
            children = nodeSelected.getNodes();
        } else {
            tree.setParentSelected((Object)nodeSelected);
            sibbling = nodeSelected.getNodes();
        }
        ArrayList<Node> sibblingList = new ArrayList<Node>();
        ArrayList<Node> childrenList = new ArrayList<Node>();
        while (sibbling.hasNext()) {
            Node sibblingNode = (Node)sibbling.next();
            if (!Utils.isReadAuthorized((Node)sibblingNode) || sibblingNode.isNodeType("exo:hiddenable")) continue;
            sibblingList.add(sibblingNode);
        }
        if (children != null) {
            while (children.hasNext()) {
                Node childrenNode = (Node)children.next();
                if (!Utils.isReadAuthorized((Node)childrenNode) || childrenNode.isNodeType("exo:hiddenable")) continue;
                childrenList.add(childrenNode);
            }
        }
        if (nodeSelected.getPath().equals(this.rootNode_.getPath())) {
            tree.setSibbling(childrenList);
        } else {
            tree.setSibbling(sibblingList);
        }
        tree.setChildren(childrenList);
    }

    public void renderChildren() throws Exception {
        this.buildTree();
        super.renderChildren();
    }

    public void setRootPath(String path) throws Exception {
        this.rootPath_ = path;
        UIJCRBrowser uiJCRBrowser = (UIJCRBrowser)this.getParent();
        String workspace = uiJCRBrowser.getWorkspace();
        String repositoryName = uiJCRBrowser.getRepository();
        ManageableRepository repository = this.getRepository(repositoryName);
        if (workspace == null) {
            workspace = repository.getConfiguration().getDefaultWorkspaceName();
        }
        Session session = SessionsUtils.getSessionProvider().getSession(workspace, repository);
        this.currentNode_ = this.rootNode_ = (Node)session.getItem(path);
        this.changeNode(this.rootNode_);
    }

    public String getRootPath() {
        return this.rootPath_;
    }

    public void setNodeSelect(String path) throws Exception {
        UIJCRBrowser uiJCRBrowser = (UIJCRBrowser)this.getParent();
        String workspace = uiJCRBrowser.getWorkspace();
        String repositoryName = uiJCRBrowser.getRepository();
        Session session = SessionsUtils.getSessionProvider().getSession(workspace, this.getRepository(repositoryName));
        this.currentNode_ = (Node)session.getItem(path);
        if (!this.rootNode_.getPath().equals("/") && this.currentNode_.getPath().equals(this.rootNode_.getParent().getPath())) {
            this.currentNode_ = this.rootNode_;
        }
        if (this.currentNode_.getPath().equals("/")) {
            this.currentNode_ = this.rootNode_;
        }
        this.changeNode(this.currentNode_);
    }

    public void setIsTab(boolean isTab) {
        this.isTab_ = isTab;
    }

    public void changeNode(Node nodeSelected) throws Exception {
        ArrayList<Node> nodes = new ArrayList<Node>();
        NodeIterator nodeIter = nodeSelected.getNodes();
        while (nodeIter.hasNext()) {
            nodes.add(nodeIter.nextNode());
        }
        UIContainer uiParent = (UIContainer)this.getParent();
        UITreeList uiTreeList = (UITreeList)uiParent.getChild(UITreeList.class);
        uiTreeList.setNodeList(nodes);
        if (this.isTab_) {
            UIContainer uiRoot = (UIContainer)uiParent.getParent();
            uiRoot.setRenderedChild(uiParent.getId());
        }
    }

    public Node getSelectedNode() {
        return this.currentNode_;
    }

    public ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(repositoryName);
    }
}

