/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.drives;

import java.util.ArrayList;
import java.util.ResourceBundle;
import org.exoplatform.ecm.webui.component.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.services.cms.drives.DriveData;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.form.UIFormCheckBoxInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormRadioBoxInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.MandatoryValidator;

@ComponentConfig(template="app:/groovy/webui/component/UIFormInputSetWithAction.gtmpl")
public class UIDriveInputSet
extends UIFormInputSetWithAction {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_WORKSPACE = "workspace";
    public static final String FIELD_HOMEPATH = "homePath";
    public static final String FIELD_WORKSPACEICON = "icon";
    public static final String FIELD_PERMISSION = "permissions";
    public static final String FIELD_VIEWPREFERENCESDOC = "viewPreferences";
    public static final String FIELD_VIEWNONDOC = "viewNonDocument";
    public static final String FIELD_VIEWSIDEBAR = "viewSideBar";
    public static final String FIELD_FOLDER_ONLY = "Folder";
    public static final String FIELD_BOTH = "Both";
    public static final String FIELD_UNSTRUCTURED_ONLY = "Unstructured folder";
    public static final String ALLOW_CREATE_FOLDER = "allowCreateFolder";
    public static final String SHOW_HIDDEN_NODE = "showHiddenNode";
    public String bothLabel_;

    public UIDriveInputSet(String name) throws Exception {
        super(name);
        this.setComponentConfig(this.getClass(), null);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_NAME, FIELD_NAME, null).addValidator(MandatoryValidator.class, new Object[0]));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(FIELD_WORKSPACE, FIELD_WORKSPACE, null));
        UIFormStringInput homePathField = new UIFormStringInput(FIELD_HOMEPATH, FIELD_HOMEPATH, null);
        homePathField.setValue((Object)"/");
        homePathField.setEditable(false);
        this.addUIFormInput((UIFormInput)homePathField);
        this.addUIFormInput((UIFormInput)new UIFormStringInput(FIELD_WORKSPACEICON, FIELD_WORKSPACEICON, null).setEditable(false));
        UIFormStringInput permissonSelectField = new UIFormStringInput(FIELD_PERMISSION, FIELD_PERMISSION, null);
        permissonSelectField.addValidator(MandatoryValidator.class, new Object[0]);
        permissonSelectField.setEditable(false);
        this.addUIFormInput((UIFormInput)permissonSelectField);
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWPREFERENCESDOC, FIELD_VIEWPREFERENCESDOC, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWNONDOC, FIELD_VIEWNONDOC, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(FIELD_VIEWSIDEBAR, FIELD_VIEWSIDEBAR, null));
        this.addUIFormInput((UIFormInput)new UIFormCheckBoxInput(SHOW_HIDDEN_NODE, SHOW_HIDDEN_NODE, null));
        ArrayList<SelectItemOption> folderOptions = new ArrayList<SelectItemOption>();
        folderOptions.add(new SelectItemOption(FIELD_FOLDER_ONLY, (Object)"nt:folder"));
        RequestContext context = RequestContext.getCurrentInstance();
        ResourceBundle res = context.getApplicationResourceBundle();
        this.bothLabel_ = res.getString(this.getId() + ".label.both");
        folderOptions.add(new SelectItemOption(FIELD_UNSTRUCTURED_ONLY, (Object)"nt:unstructured"));
        folderOptions.add(new SelectItemOption(this.bothLabel_, (Object)FIELD_BOTH));
        this.addUIFormInput((UIFormInput)new UIFormRadioBoxInput(ALLOW_CREATE_FOLDER, ALLOW_CREATE_FOLDER, folderOptions).setAlign(UIFormRadioBoxInput.VERTICAL_ALIGN));
        this.setActionInfo(FIELD_PERMISSION, new String[]{"AddPermission"});
        this.setActionInfo(FIELD_HOMEPATH, new String[]{"AddPath"});
        this.setActionInfo(FIELD_WORKSPACEICON, new String[]{"AddIcon"});
    }

    public void update(DriveData drive) throws Exception {
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        String[] wsNames = ((RepositoryService)this.getApplicationComponent(RepositoryService.class)).getRepository(repository).getWorkspaceNames();
        ArrayList<SelectItemOption> workspace = new ArrayList<SelectItemOption>();
        for (String wsName : wsNames) {
            workspace.add(new SelectItemOption(wsName, (Object)wsName));
        }
        this.getUIFormSelectBox(FIELD_WORKSPACE).setOptions(workspace);
        if (drive != null) {
            this.invokeGetBindingField((Object)drive);
            this.getUIStringInput(FIELD_NAME).setEditable(false);
            return;
        }
        this.getUIStringInput(FIELD_NAME).setEditable(true);
        this.reset();
        this.getUIFormCheckBoxInput(FIELD_VIEWPREFERENCESDOC).setChecked(false);
        this.getUIFormCheckBoxInput(FIELD_VIEWNONDOC).setChecked(false);
        this.getUIFormCheckBoxInput(FIELD_VIEWSIDEBAR).setChecked(false);
        this.getUIFormCheckBoxInput(SHOW_HIDDEN_NODE).setChecked(false);
    }
}

