/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import javax.jcr.Node;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleForm;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTextAreaInput;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="system:/groovy/webui/form/UIForm.gtmpl", events={@EventConfig(listeners={UpdateStyleActionListener.class}), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE)})
public class UITagStyleForm
extends UIForm {
    public static final String STYLE_NAME = "styleName";
    public static final String DOCUMENT_RANGE = "documentRange";
    public static final String STYLE_HTML = "styleHTML";
    private Node selectedTagStyle_;

    public UITagStyleForm() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(STYLE_NAME, STYLE_NAME, null));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(DOCUMENT_RANGE, DOCUMENT_RANGE, null));
        this.addUIFormInput((UIFormInput)new UIFormTextAreaInput(STYLE_HTML, STYLE_HTML, null));
    }

    public Node getTagStyle() {
        return this.selectedTagStyle_;
    }

    public void setTagStyle(Node selectedTagStyle) throws Exception {
        this.selectedTagStyle_ = selectedTagStyle;
        this.getUIStringInput(STYLE_NAME).setValue((Object)this.selectedTagStyle_.getName());
        this.getUIStringInput(STYLE_NAME).setEditable(false);
        String range = this.selectedTagStyle_.getProperty("exo:styleRange").getValue().getString();
        this.getUIStringInput(DOCUMENT_RANGE).setValue((Object)range);
        String htmlStyle = this.selectedTagStyle_.getProperty("exo:htmlStyle").getValue().getString();
        this.getUIFormTextAreaInput(STYLE_HTML).setValue((Object)htmlStyle);
    }

    private boolean validateRange(String range) {
        String[] vars = null;
        try {
            vars = StringUtils.split((String)range, (String)"..");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        if (vars == null || vars.length != 2) {
            return false;
        }
        String minRange = vars[0];
        String maxRange = vars[1];
        if (!StringUtils.isNumeric((String)minRange)) {
            return false;
        }
        try {
            int min = Integer.parseInt(vars[0]);
            if (min < 0) {
                return false;
            }
            if (!StringUtils.isNumeric((String)maxRange) ? !maxRange.equals("*") : Integer.parseInt(maxRange) <= 0) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean access$000(UITagStyleForm x0, String x1) {
        return x0.validateRange(x1);
    }
}

