/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.folksonomy;

import java.util.ArrayList;
import javax.jcr.Node;
import org.exoplatform.commons.utils.ObjectPageList;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.folksonomy.UITagStyleList;
import org.exoplatform.services.cms.folksonomy.FolksonomyService;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIGrid;

@ComponentConfig(template="system:/groovy/webui/core/UIGrid.gtmpl")
public class UITagStyleList
extends UIGrid {
    static final String RANGE_PROP = "exo:styleRange";
    static final String HTML_STYLE_PROP = "exo:htmlStyle";
    private static String[] BEAN_FIELD = new String[]{"name", "documentRange", "tagHTML"};
    private static String[] ACTIONS = new String[]{"EditStyle"};

    public UITagStyleList() throws Exception {
        this.getUIPageIterator().setId("TagStyleIterator");
        this.configure("name", BEAN_FIELD, ACTIONS);
    }

    public void updateGrid() throws Exception {
        ArrayList<TagStyleData> tagStyleList = new ArrayList<TagStyleData>();
        FolksonomyService folksonomyService = (FolksonomyService)this.getApplicationComponent(FolksonomyService.class);
        String repository = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        TagStyleData tagStyleData = null;
        for (Node node : folksonomyService.getAllTagStyle(repository)) {
            tagStyleData = new TagStyleData(node.getName(), this.getRangeOfStyle(node), this.getHtmlStyleOfStyle(node));
            tagStyleList.add(tagStyleData);
        }
        ObjectPageList objPageList = new ObjectPageList(tagStyleList, 10);
        this.getUIPageIterator().setPageList((PageList)objPageList);
    }

    public String getRangeOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(RANGE_PROP).getValue().getString();
    }

    public String getHtmlStyleOfStyle(Node tagStyle) throws Exception {
        return tagStyle.getProperty(HTML_STYLE_PROP).getValue().getString();
    }
}

